<?php
/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/
Route::get('/', function () {
    return view('auth/login');
});
Auth::routes();
Route::get('/home', 'HomeController@index')->name('home');

// MAP LINK 
Route::get('map_link/{encrypted}', 'depots\DepotsController@linkView');

Route::group(['middleware' => ['checkuser']], function () {

        Route::get('/agent', 'agents\AgentController@index')->middleware('is-agent');
        Route::get('/newagent', 'agents\AgentController@new_agent')->middleware('is-agent');
        Route::post('/addagent', 'agents\AgentController@insert_agent')->middleware('is-agent');
        Route::get('/delete_agent/{id}', 'agents\AgentController@delete_agent')->middleware('is-agent');
        Route::get('/edit_agent/{id}', 'agents\AgentController@edit_agent')->middleware('is-agent');
        Route::post('/editscript', 'agents\AgentController@editscript_agent');
        // Route::get('/resources', 'items\ItemController@index');
        Route::get('/newresources', 'items\ItemController@new_item');
        Route::post('/addresources', 'items\ItemController@insert_item');
        Route::get('/res_types', 'items\ItemController@res_types');
        Route::get('/new_type', 'items\ItemController@new_type');
        Route::get('/deletetype/{id}', 'items\ItemController@deletetype');
        Route::post('/insert_res_type', 'items\ItemController@insert_res_type');
        Route::get('/edittype/{id}', 'items\ItemController@edittype');
        Route::post('/edit_type_script', 'items\ItemController@edit_type_script');

        Route::get('/res_variations', 'items\ItemController@res_variations');
        Route::get('/new_variations', 'items\ItemController@new_variations');
        Route::get('/edit_variations/{id}', 'items\ItemController@edit_variations');
        Route::post('/editvariations', 'items\ItemController@editvariations');
        Route::post('/addvariation', 'items\ItemController@insert_variation');
        Route::get('/deletevariation/{id}', 'items\ItemController@deletevariation');

        Route::get('/res_resources', 'items\ItemController@res_resources');
        Route::get('/new_resources', 'items\ItemController@new_resources');
 
        Route::get('/depots', 'depots\DepotsController@index');
        Route::get('/newdepot', 'depots\DepotsController@new_depot');
        Route::post('/adddepot', 'depots\DepotsController@insert_depot');
        Route::get('/delete_depot/{id}', 'depots\DepotsController@delete_depot');
        Route::get('/edit_depot/{id}', 'depots\DepotsController@edit_depot');
        Route::post('/editdepotscript', 'depots\DepotsController@editscript_depot');
        Route::get('/customers', 'customer\CustomerController@index')->middleware('is-agent');
        Route::get('/active_customer', 'customer\CustomerController@active_customer')->middleware('is-agent');
        Route::get('/de_active_customer', 'customer\CustomerController@de_active_customer')->middleware('is-agent');
        Route::get('cus_status/{rowId}/{value}', 'customer\CustomerController@status');


        Route::get('/view_profile', 'UserControllerAPI@view_profile');
        Route::post('/update_profile', 'UserControllerAPI@update_profile');
        Route::post('/change_password', 'UserControllerAPI@change_password');

        // **************************  zaid **************************************

        Route::get('setprice/{id}', 'items\ItemController@setprice');
        Route::post('insert_reso_price', 'items\ItemController@insert_reso_price');
        Route::post('update_reso_price', 'items\ItemController@update_reso_price');
     // Route::get('delete_reso_price/{id}', 'items\ItemController@delete_reso_price');

        Route::get('additional_resource', 'items\ItemController@additional_resource');
        Route::get('additionalres_setprice/{id}', 'items\ItemController@additional_resource_setprice');
        Route::post('insert_additionalreso_price', 'items\ItemController@insert_additionalreso_price');
        Route::post('update_additionalreso_price', 'items\ItemController@update_additionalreso_price');

        


        Route::get('add_addit_res', 'Admin\AttitionalResourceController@addAdditRes');
        Route::post('additionalStore', 'Admin\AttitionalResourceController@additionalStore'); 
        Route::get('editadditionalres/{id}', 'Admin\AttitionalResourceController@additionalResEdit');
         Route::post('updateAdditional', 'Admin\AttitionalResourceController@updateAdditional');
         Route::get('deleteadditionalres/{id}', 
            'Admin\AttitionalResourceController@deleteadditionalres');

        
        Route::get('all_orders', 'Orders\OrderController@all_orders');
        Route::get('completeOrder', 'Orders\OrderController@completeOrder');
        Route::get('pendingOrder', 'Orders\OrderController@pendingOrder');
        Route::get('inprocessOrder', 'Orders\OrderController@inprocessOrder');
        Route::get('cancelledOrder', 'Orders\OrderController@cancelledOrder');
        Route::get('status/{rowId}/{value}', 'Orders\OrderController@status');
        Route::get('view_detail/{orderId}', 'Orders\OrderController@view_detail');


                    /////////////////MAKE RESERVATION ROUTE///////////

        // Route::get('/all_resvation', 'reservation\ReservationController@all_resvation');
        Route::get('/add_resvation', 'reservation\ReservationController@add_resvation');

        Route::post('/city', 'reservation\ReservationController@city');
        Route::get('/get_depot_resource', 'reservation\ReservationController@get_depot_resource');
        Route::get('/get_depot_addit_resource', 
                                 'reservation\ReservationController@get_depot_addit_resource');

        Route::post('/insert_cart_data', 'reservation\ReservationController@insert_cart_data');  
        Route::get('/check_cart_resources', 'reservation\ReservationController@check_cart_resources'); 
        Route::get('/get_cart_data', 'reservation\ReservationController@get_cart_data');  
        Route::get('/delete_cart_row', 'reservation\ReservationController@delete_cart_row');  
        Route::get('/delete_cart', 'reservation\ReservationController@delete_cart');  
        Route::post('/make_reservation', 'reservation\ReservationController@make_reservation');
        Route::get('/path', function(){
          
//$context = stream_context_create($context);
                $src = 'https://maps.googleapis.com/maps/api/staticmap?center=Brooklyn+Bridge,New+York,NY&zoom=12&size=600x400';
    $time = time();
    $desFolder = url('/').'/uploads/';
    $imageName = 'google-map_'.$time.'.PNG';
    $imagePath = $desFolder.$imageName;
    file_put_contents($imagePath,file_get_contents($src));
        }); 

                 ///////////////////////// PASSOWRD /////////////////////////////


        Route::get('/changePassword', 'items\ItemController@changePassword');  
        Route::post('/submit_password', 'items\ItemController@submit_password');  
        Route::get('/agent_change_password/{agent_id}', 'agents\AgentController@agent_change_password');  
        Route::post('/submit_agent_password', 'agents\AgentController@submit_agent_password');  


 
                ///////////////////////COUPANS//////////////////////////

         Route::get('/coupons', 'coupon\CouponController@coupons');  
         Route::get('/add_coupons', 'coupon\CouponController@add_coupons');  
         Route::post('/save_coupon', 'coupon\CouponController@save_coupon');  
         Route::get('/edit_coupon/{coupon_id}', 'coupon\CouponController@edit_coupon'); 
         Route::post('/update_coupon', 'coupon\CouponController@update_coupon'); 
         Route::get('/delete_coupon/{coupon_id}', 'coupon\CouponController@delete_coupon');  
         
         
         ///////////////////////Price Km////////////////////////// 

        Route::get('/price_km','items\ItemController@price_km');  
        Route::post('/update_price_km','items\ItemController@update_price_km');  
        
        Route::get('/empty_cart','items\ItemController@emptyCart');
        Route::get('/calendar','items\ItemController@calendar');
        Route::post('/get_details','items\ItemController@get_details');
        Route::post('/update_resource_quantity','items\ItemController@update_resource_quantity');

        
        // ***********************************************************************





    Route::group(['as' => 'admin.', 'namespace' => 'Admin'], function () {
        Route::get('quantity_uid', ['as' => 'quantity.uuid', 'uses' => 'ResourceController@addQuantity']);
        Route::get('get_attributes', ['as' => 'attributes.get', 'uses' => 'ResourceController@getAttributes']);
        Route::post('resources/datatable', 'ResourceController@datatable');
        
        Route::resource('resources', 'ResourceController');
    });




});