<?php

use Illuminate\Http\Request;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

 Route::post('signup','UserControllerAPI@sign_up');
 Route::post('/search_depots', 'ApiController@search_depots');

 Route::post('/resources', 'ApiController@resources');
 Route::post('/payment_stripe', 'ApiController@payment_stripe');

// ******************************* zaid *********************************************

 Route::post('/resource_detail', 'ApiController@resource_detail' );
 Route::post('/customer_info','ApiController@customer_info');
 Route::post('countries', 'ApiController@countries');
 Route::post('get_addit_resource', 'ApiController@get_addit_resource');
 Route::post('resource_pricing', 'ApiController@resource_pricing');
 Route::post('insert_cart', 'ApiController@insert_cart');
 Route::post('get_cart_data', 'ApiController@get_cart_data');
 Route::post('booking_order', 'ApiController@booking_order');
 Route::post('saveTransaction', 'ApiController@saveTransaction');
 Route::post('city', 'ApiController@city');
 Route::post('remove_cart', 'ApiController@remove_cart');
 Route::post('remove_cart_row', 'ApiController@remove_cart_row');
 Route::post('coupon', 'ApiController@coupon');
 Route::post('app_setting', 'ApiController@app_setting');
 Route::post('get_data_by_email', 'ApiController@get_data_by_email');
 Route::post('cancel_reservation', 'ApiController@cancel_reservation');
 Route::get('cancel_reservation_cron', 'ApiController@cancel_reservation_cron');
 Route::post('/customer_info_update','ApiController@customer_info_update');
 Route::post('/search_address','ApiController@search_address');
 
Route::middleware('auth:api')->get('/user', function (Request $request) {
    return $request->user();
});




