@extends('layouts.app')
@section('content')
<div class="page-content-wrapper">
    <!-- BEGIN CONTENT BODY -->
    <div class="page-content">
        <!-- BEGIN PAGE BAR -->
        <div class="page-bar">
            <ul class="page-breadcrumb">
                <li>
                    <a href="{{url('home')}}">Home</a>
                    <i class="fa fa-circle"></i>
                </li>
                <li>
                    <a href="{{url('resources')}}">Resources</a>
                    <i class="fa fa-circle"></i>
                </li>
                <li>
                    <span>New Resource</span>
                </li>
            </ul>
            <div class="page-toolbar">
                <div id="dashboard-report-range" class="pull-right tooltips btn btn-sm" data-container="body" data-placement="bottom" data-original-title="Change dashboard date range">
                    <i class="icon-calendar"></i>&nbsp;
                    <span class="thin uppercase hidden-xs"></span>&nbsp;
                    <i class="fa fa-angle-down"></i>
                </div>
            </div>
        </div>
        <!-- END PAGE BAR -->
        <!-- BEGIN PAGE TITLE-->

        <br>
        @if(Session::has('message'))
        <div class="alert alert-success">
            <button class="close" data-close="alert"></button><?php echo Session::get('message');?> 
        </div>
        @endif
        <br>
        <div class="clearfix"></div>

         {!! Form::model($resource,['route' => $resource ? ['admin.resources.update','id'=>$resource->id] : 'admin.resources.store','method'=> $resource ? 'PUT' : 'POST', 'id'=>'form_resources', 'class'=>'form-horizontal', 'enctype'=>'multipart/form-data']) !!}

            <input type="hidden" value="{{$currentUser->name}}" name="created_by" />
            <?php if($add_resource=='id'){?>
            <input type="hidden" id="id" value="{{$id}}" name="id" />
            <?php } ?>
            <div class="form-group">
                <label class="col-md-3 control-label">Resource ID</label>
                <div class="col-md-4">
                    {!! Form::text('res_id',$resource ? $resource->res_id : $preloaded_data['res_id'] , ['class' => 'form-control', 'placeholder'=>'Resource ID', 'readonly']) !!}
                </div>
                <div class="col-md-5">
                    <span class="help-block help-block-error">{!!$errors->first('resource_id')!!}</span>
                </div>
            </div>

            <div class="form-group">
                <label class="col-md-3 control-label">Select Type</label>
                <div class="col-md-4">
                	{!! Form::select('res_type',['' => 'Select Type']+$preloaded_data['resource_types'], null, ['class' => 'form-control selectbox', 'id' => 'resource_type_select', 'required']) !!}
                </div>
            </div>

            <div class="form-group">
                <label class="col-md-3 control-label">Resource Name</label>
                <div class="col-md-4">
                    {!! Form::text('res_name', null, ['class' => 'form-control', 'placeholder'=>'Resource Name', 'required']) !!}
                </div>
                <div class="col-md-5">
                    <span class="help-block help-block-error">{!!$errors->first('resource_name')!!}</span>
                </div>
            </div>

            <div class="form-group">
                <label class="col-md-3 control-label">Select Depot</label>
                <div class="col-md-4">
                	{!! Form::select('res_depot',['' => 'Select Depot']+$preloaded_data['depots'], null, ['class' => 'form-control selectbox', 'id' => 'depot_select', 'required']) !!}
                </div>
            </div>
            @if($currentUser -> type == 2)
            <input type="hidden" value="{{$currentUser->id}}" name="res_agent" />
            @else
            <div class="form-group">
                <label class="col-md-3 control-label">Select Agent</label>
                <div class="col-md-4">
                	{!! Form::select('res_agent',['' => 'Select Agent']+$preloaded_data['agents'], null, ['class' => 'form-control selectbox', 'id' => 'agent_select', 'required']) !!}
                </div>
            </div>
            @endif
            <div class="form-group">
                <label class="col-md-3 control-label">Resource Description</label>
                <div class="col-md-4">
                    {!! Form::textarea('res_details', null, ['class' => 'form-control','id'=>'res_description','rows'=>5, 'required']) !!}
                </div>
            </div>

            <div class="form-group mb-2">
                <label class="col-md-3 control-label">Featured Image</label>
                <div class="col-md-4">
                	<img id="img" src="{{ $resource && $resource->res_img ? asset($resource->res_img) : 'https://via.placeholder.com/150' }}" style="width: 150px; border: 1px solid; padding: 5px; border-radius: 5px;"/>
                	<br>
                    <a href="javascript:void(0)" class="btn remove_picture {{ $resource && $resource->res_img ? '' : 'hidden' }}" style="padding-left: 0px;display:inline-block;">Remove</a>
                	{!! Form::file('res_img', ['class' => '','id'=>'featured_img', 'onchange'=>'readURL(this)', 'style'=>'display:inline-block;']) !!}
                    <input type="hidden" name="remove_res_img" id="res_img_input" style="display:inline-block;">
                </div>
            </div>

            <div class="form-group mb-2">
                <label class="col-md-3 control-label">Slide Images</label>
                <div class="col-md-4">
                    {!! Form::file('slide_images[]', ['class' => '','id'=>'slide_images', 'multiple']) !!}
                    <div class="resource-silde-img-list">
                        @if($resource && $resource->images)
                            @foreach ($resource->images as $image)
                                <div class="resource-silde-img-show mt-1 mb-1"><img src="{{ asset($image->image) }}" /> <button href="#" class="resource-img-del" data-id="{{ $image->id }}" style="margin-top: 5px;"><span><i class="fa fa-minus-square"></i></span></button></div>
                            @endforeach
                        @endif
                    </div>
                </div>
            </div>

            <div class="form-group mb-2">
                <label class="col-md-3 control-label">Quantity</label>
                <div class="col-md-4">
                    {!! Form::text('res_quantity',null , ['class' => 'form-control qty_remove', 'id'=>'quantity' ,'placeholder'=>'Quantity', 'required']) !!}
                     <?php if($add_resource=='id'){?>
                    {!! Form::text('res_quantity',null , ['class' => 'form-control qty_removes', 'id'=>'quantitys' ,'placeholder'=>'Quantity', 'required']) !!}
                     <?php } ?>
                    <div class="add-uid-fields">
                    	@if($resource)
                            <?php $c = 0; ?>
                            @foreach($resource->quantities as $quantity)
                                <?php echo View::make('admin.resources.partials._quantity',['u_id'=>$quantity->uid, 'call_count'=>$c, 'count'=>$c+1])->render(); ?>
                                <?php $c += 1; ?>
                            @endforeach
                        @endif 
                    </div>
                </div>
            </div>
            
            @php
            $url = request()->segment(count(request()->segments()));
            $fixurl = "create";
            @endphp

            <div class="form-group">
                <label class="col-md-3 control-label">Attributes:</label>
                <div class="col-md-4">
                @if($url == $fixurl)
                    {!! Form::select('',['' => 'Select Attribute']+$preloaded_data['variations'], null, ['class' => 'form-control selectbox', 'id' => 'variation_select', 'style'=>'width:87%; display:inline-block;margin-right:3px;','required' ]) !!}
                @else
                    {!! Form::select('',['' => 'Select Attribute']+$preloaded_data['variations'], null, ['class' => 'form-control selectbox', 'id' => 'variation_select', 'style'=>'width:87%; display:inline-block;margin-right:3px;']) !!}
                @endif
                	<a class="btn blue" id="add_attribute_btn">Add</a>
                	<div id="attribute_value_fields">
                		@if($resource)
                            <?php $c = 0; ?>
                            @foreach($resource->variations as $resources_variations)
                            	<?php
                            		$attribute = $resources_variations->variation;
                            		$values = $resources_variations->variation_values->pluck('v_value','id')->toArray();
                            	?>
                            	<script type="text/javascript">
                            		$('#variation_select option[value=' + '{{ $attribute->id }}' + ']').prop('disabled', true);
                            	</script>
                                <?php echo View::make('admin.resources.partials._attribute',['values'=>$values, 'attribute'=>$attribute,'removeable'=>true,'call_count'=>mt_rand(1000000, 9999999),'resources_variations'=>$resources_variations])->render()?>
                                <?php $c += 1; ?>
                            @endforeach
                        @endif 
                	</div>
                </div>
                <div class="col-md-5">
                        <span class="help-block help-block-error">{!!$errors->first('attr_values')!!}</span>
                </div>
            </div>
            <input type="hidden" name="remove_slider_images" id="remove_slider_images">
            <hr>
            <div class="form-group">
                <div class="col-md-offset-3 col-md-9">
                	{!! Html::linkRoute('admin.resources.index','Cancel', [], ['class'=>'btn btn-default'])!!}
                    {{Form::submit('Save', ['class'=>'btn blue save_quan'])}}
                </div>
            </div>

         {!! Form::close() !!}
    </div>
</div>
<script type="text/javascript">
    $('#item').addClass("active open");
    $('#item ul li:nth-child(3)').addClass("active open");
    
    jQuery(document).ready(function ($) {
        $('#quantitys').hide();
        if('{{ request()->segment(count(request()->segments())) }}' == 'create'){
         $("#quantity").on('change', function(){
        var quantity = parseInt($('#quantity').val());
        var check="create";
        $('.add-uid-fields').html('');

          $.ajax({beforeSend: function(){},
          method: "Get",url: "{{ URL::route('admin.quantity.uuid') }}",data: { quantity: quantity,check:check}})
          .done(function( result ){
            if(result){
              var uid_data = JSON.parse(result);
              $('.add-uid-fields').append(uid_data);
              console.log(uid_data);
            }
         });
       });
        $('.qty_remove').val('');
        
        }
        else{
            $("#quantity").on('change', function(){
        var quantity = parseInt($('#quantity').val());
        var quantitys = parseInt($('#quantitys').val());
        var id = parseInt($('#id').val());
        var check="edit";
        $('#quantitys').removeAttr('name');
        $('#quantitys').attr('name','res_quantitys');
        // $('.add-uid-fields').html('');

          $.ajax({beforeSend: function(){},
          method: "Get",url: "{{ URL::route('admin.quantity.uuid') }}",data: { quantity: quantity,quantitys:quantitys,check:check}})
          .done(function( result ){
            if(result){
                var uid_data = JSON.parse(result);
              $('.add-uid-fields').append(uid_data);
              console.log(uid_data);
            }
         });
       });
        }
    });
</script> 

@include('admin.resources.partials._scripts')
@endsection