@extends('layouts.app')

@section('content')


                <!-- BEGIN CONTENT -->
                <div class="page-content-wrapper">
                    <!-- BEGIN CONTENT BODY -->
                    <div class="page-content">
                       
                        <!-- BEGIN PAGE BAR -->
                        <div class="page-bar">
                            <ul class="page-breadcrumb">
                                <li>
                                    <a href="{{url('home')}}">Home</a>
                                    <i class="fa fa-circle"></i>
                                </li>  
                                 <li>
                                    <a href="{{url('all_orders')}}">All Order</a>
                                    <i class="fa fa-circle"></i>
                                </li>  
                                <li>
                                    <span>Order Detail</span>
                                  
                                </li>  
                            </ul>
                            <div class="page-toolbar">
                                <div id="dashboard-report-range" class="pull-right tooltips btn btn-sm" data-container="body" data-placement="bottom" data-original-title="Change dashboard date range">
                                    <i class="icon-calendar"></i>&nbsp;
                                    <span class="thin uppercase hidden-xs"></span>&nbsp;
                                    <i class="fa fa-angle-down"></i>
                                </div>
                            </div>
                        </div>
                        <!-- END PAGE BAR -->
                        <!-- BEGIN PAGE TITLE-->
                       <br>

                         @if(Session::has('message'))
                        <div class="alert alert-success">
                          	<button class="close" data-close="alert"></button><?php echo Session::get('message');?> 
                        </div>
                        @endif
                       <br>
                        <!-- END PAGE TITLE-->
                        <!-- END PAGE HEADER-->
                        <!-- BEGIN DASHBOARD STATS 1-->
                        
                        <div class="clearfix"></div>
                        <!-- END DASHBOARD STATS 1-->
                   
                        <!-- BEGIN CONTENT -->

				        <div class="row clearfix">
				        	<div class="col-md-6 main_date_wrape">
				            <div class="col-md-4">
				                <label>Reservations#</label>
				                <input type="text" class="form-control" value="{{$orders->reservation_id}}"  readonly>
				            </div>

				            @php
				            $start_date;
				            $end_date;
				            @endphp

				            
                        @if(isset($booked))
                          <!--  @php
                           $start = $booked->checkin;
                           $end = $booked->checkout;

                           $start_date = new Carbon\Carbon($start);
							$end_date = new Carbon\Carbon($end);
							$days = ($start_date->diff($end_date)->days < 1)
							    ? '0'
							    : $start_date->diffInDays($end_date);
                           @endphp -->
                           
				            <div class="col-md-4">
				                <div class="row">
				                    <div class="col-md-6">
				                        <div class="form-group row">
				                            <label>CheckIn</label>
				                            <input class="form-control sDate" value="{{$booked->checkin}}" type="text" name="" readonly>
				                        </div>
				                    </div>
				                    <div class="col-md-6">
				                        <div class="form-group row">
				                            <label>Checkout</label>
				                            <input class="form-control eDate" value="{{$booked->checkout}}" type="text" name="" readonly>
				                        </div>
				                    </div>
				                </div>   
				            </div>
				        @else
				            <div class="col-md-4">
				                <label>Date</label>
					             <input class="form-control" value="Resource Free" type="text" name="" readonly>
				            </div>
				        @endif    

				            <div class="col-md-4">
				                <label>Depot</label>
					             <input class="form-control" value="{{$depo->name}}" type="text" name="" readonly>
				            </div>
				        </div>
				        <div class="col-md-6 main_date_wrape">

				            <div class="col-md-4">
				                <label>Reservation Status</label>
				                <input type="text" class="form-control"
				                  @if($orders->reservation_status == 1)
					             value="Not Confirmed" 
					             @elseif($orders->reservation_status  == 2)
					             value="Confirmed"
					             @endif
					             type="text" name="" readonly
				                 >
				            </div>

				            <div class="col-md-4">
				                <label>Payment status</label>
					             <input class="form-control"
					              @if($orders->payment_status == 1)
					             value="Un Paid" 
					             @elseif($orders->payment_status  == 2)
					             value="paid"
					             @endif
					             type="text" name="" readonly>
				            </div>
				             <div class="col-md-4">
				                <label>Source</label>
					             <input class="form-control" 
					             @if($orders->source == 1)
					             value="App" 
					             @elseif($orders->source == 2)
					             value="Manual"
					             @endif
					             type="text" name="" readonly>
				            </div>
				        </div>

				        @php
				        $name = $customer->name;
				        $seprate_name = explode(" ",$name);
				        
				        if(count($seprate_name) == 1){
				            $seprate_name[1] = "";
				        }
				        
				        @endphp

							<div class="col-md-12">
						  <h3 class="text-center">Customer Information</h3>
						    <div class="col-md-6">
						        <div class="form-group">
						            <label>First Name</label>
						            <input type="text" value="{{$seprate_name[0]}}" class="form-control" readonly>
						        </div>
						        <div class="form-group">
						            <label>Phone#</label>
						            <input type="text" value="{{$customer->phone}}" class="form-control" readonly>
						        </div>
						           
						         <div class="form-group">
						            <label>Country</label>
						            <input type="text" value="{{$customer->country_name}}" class="form-control" readonly>
						        </div>
						         <div class="form-group">
						            <label>Postal Code</label>
						             <input type="text" value="{{$customer->cus_postal_code}}" class="form-control" readonly>
						        </div>
						        
						       
						    </div>
						    <div class="col-md-6">
						    	 <div class="form-group">
						            <label>Last Name</label>
						            <input type="text" value="{{ $seprate_name[1] }}" class="form-control" readonly>
						        </div>
						        <div class="form-group">
						            <label>Email</label>
						            <input type="text" value="{{$customer->email}}" class="form-control" readonly>
						        </div>
						        <div class="form-group">
						            <label>City</label>
						            <input type="text" value="{{$customer->city_name}}" class="form-control" readonly>
						        </div>
						       
						      
						    </div>
						    <div class="col-md-12">
						        <div class="form-group">
						            <label>Address</label>
						            <textarea class="form-control" style="resize: none;" rows="5" cols="5" readonly>{{$customer->address}}</textarea>
						        </div>
							</div>
						</div>


					    <div class="col-md-12">
					        <h3 class="text-center">Resource</h3>
					        <table class="table">
					            <thead>
					                <tr>
					                    <th>Name</th>
					                    <th>Image</th>
					                    <th>Quantity UID</th>
					                    <th>Basic Rate</th>
					                    <th>After Discounted</th>
					                </tr>
					            </thead>
					            <tbody>
					            	@php
									$sum = 0;
									$days = $orders->select_days;
									@endphp
					            	
					            	@foreach($new['reso'] as $resource)

					            	@php
					            	$basic_rate = $resource['basic_rate'] * $days;
									$sum += $resource['dis_price'];
									
									@endphp

					            	<tr>
							            <td>
							              {{$resource['res_name']}}
							            </td>
							            <td>
							                <img class="img-circle picSize" src="{{ url('/') }}/{{$resource['res_img']}}"  alt="Image">
							            </td>
							            </td>
							            <td>
							               {{$resource['uid']}}
							            </td>
							            <td>
							               {{$basic_rate}} JPY
							            </td>
							            <td>
							               {{$resource['dis_price']}} JPY
							            </td>
							        </tr>
							        @endforeach
					            </tbody>
       						</table>
					        <h3 class="text-center">Additional Resource</h3>
					        <table class="table">
					            <thead>
					                <tr>
					                    <th>Name</th>
					                    <th>Image</th>
					                    <th>Quantity</th>
					                    <th>Rate</th>
					                    <th>Total</th>
					                    <th>Notes</th>
					                    <th>&nbsp;&nbsp;&nbsp;&nbsp;</th>
					                </tr>
					            </thead>
					            <tbody>
					            	@php
									$add_sum = 0;
									@endphp
										<tr>
										@foreach($additional_resources as $additional_resource)

										@php
										$rate =  $additional_resource->rate * $days;
										$add_sum += $additional_resource->quantity * $rate 
										@endphp

								            <td>
								            	 {{$additional_resource->add_res_name}}
								            </td>
								            <td>
								             <img class="img-circle picSize"  src="{{ url('/') }}/uploads/additional_Resource_Image/{{$additional_resource->add_res_image}}"  alt="Image">

								            </td>
								            <td>
								               {{$additional_resource->quantity}}
								            </td>
								            <td>
								                {{$rate}} JPY
								            </td>
								            <td>
								              {{$additional_resource->quantity * $rate}} JPY
								            </td>
								            <td>
								                {{$additional_resource->note}}
								            </td>

							            </tr>
							        @endforeach
					            
					               
					            </tbody>
					        </table>
					    </div>
       					<div class="col-md-12">
                            <div class="col-sm-12">
                            	<b>Charges:</b>
                            </div>
                            <div class="col-md-4">
                                <div class="col-md-6">
                                    <p>Resources: <span>{{$sum}}</span> JPY
                                    </p>
                                </div>
                                <div class="col-md-6">
                                    <p>Additional Resources Price: <span>{{$add_sum}}</span> JPY
                              </p>
                                </div>
                            </div>
							<div class="col-md-4">
								<div class="col-md-6">
								@if(isset($order_shipping_detail))
								<p>Shipping Charges:<span>{{$order_shipping_detail->shipping_charges}}</span> JPY
								</p>	
								@else
								<p>Shipping Charges: 0 JPY</p> 
								@endif
								</div>
								<div class="col-md-6">
								<?php  $tex=$sum+$add_sum;
								       $tax =  round($tex*$taxs->tax);
								?>
								<p  class="tax">Tax:
								{{$tax}} JPY
								 <span  
								class=""></span>
								</div>
							</div>
                            <div class="col-md-4">
                            	<div class="col-sm-6">
                            	@php $remote_delivery_charges = 0; @endphp
                            	@if(isset($order_shipping_detail->remote_delivery_charges)) 
                            	    @php $remote_delivery_charges = $order_shipping_detail->remote_delivery_charges; @endphp
                            	@endif
								<p>Remote Delivery Charges:<span>{{$remote_delivery_charges}}</span> JPY
								</p>
                            	</div>

                                <div class="col-md-6">
                                	@if(isset($order_shipping_detail))
                                      <p>Total Price: 
                                      	<span>
                                            {{ $orders->total_amount + $order_shipping_detail->
                                            shipping_charges + $tax + $remote_delivery_charges}}       
                                        </span>
                                        JPY
                                       </p>
                                        @else
                                    <p>Total Price:
                                       <span>
                                           {{ $orders->total_amount + $tax + $remote_delivery_charges}} 
                                       </span>
                                        JPY
                                   </p>
                                    @endif
                                </div>
                            </div>               
						</div>
				        </div>
						

                        <!-- END CONTENT -->
                          
                        </div>
                       <!-- start table -->
                       <!-- end table -->
                    </div>
                    <!-- END CONTENT BODY -->
                </div>
                <!-- END CONTENT -->

               
<script type="text/javascript">
    // $('#agents').addClass("active open");

         $(document).ready(function(){

               //  var d = new Date("2019-09-06");
               //  alert(d);
               //  return false;
               //  var startDay = new Date($('#sDate').val());
               //  var endDay = new Date($('#eDate').val());
               // alert(startDay);




               //  var millisecondsPerDay = 1000 * 60 * 60 * 24;


               //  var millisBetween = endDay.getTime() - startDay.getTime();
               //  var days = millisBetween / millisecondsPerDay;

               //  alert(days);
             
                // var exactdiff= Math.floor(days);
                // resourceTotal += parseInt(exactdiff*$('.pr'+value.id).val());

                        // $(".totalresourcePrice" ).text(resourceTotal);
                        // $(".totalresourcePrice" ).val(resourceTotal);
                        // total = resourceTotal;
                        // $(".total_price" ).text(total);

         });
</script>
@endsection
