@extends('layouts.app')

@section('content')

      <!-- BEGIN CONTENT -->
        <div class="page-content-wrapper">
            <!-- BEGIN CONTENT BODY -->
            <div class="page-content">
               
                <!-- BEGIN PAGE BAR -->
                <div class="page-bar">
                    <ul class="page-breadcrumb">
                        <li>
                                    <a href="{{url('home')}}">Home</a>
                                    <i class="fa fa-circle"></i>
                                </li>   
                                 <li>
                                  <span>All Orders</span>                                  
                                </li>
                    </ul>
                    <div class="page-toolbar">
                        <div id="dashboard-report-range" class="pull-right tooltips btn btn-sm" data-container="body" data-placement="bottom" data-original-title="Change dashboard date range">
                            <i class="icon-calendar"></i>&nbsp;
                            <span class="thin uppercase hidden-xs"></span>&nbsp;
                            <i class="fa fa-angle-down"></i>
                        </div>
                    </div>
                </div>
                <!-- END PAGE BAR -->
                <!-- BEGIN PAGE TITLE-->
                <br>
                @if ($errors->any())
                    <div class="alert alert-danger">
                        <ul>
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif

               @if(Session::has('message'))
                <div class="alert alert-success">
                                            <button class="close" data-close="alert"></button><?php echo Session::get('message');?> </div>
                @endif

                <br>
                <!-- END PAGE TITLE-->
                <!-- END PAGE HEADER-->
                <!-- BEGIN DASHBOARD STATS 1-->
                
                <div class="clearfix"></div>
                <!-- END DASHBOARD STATS 1-->
           
              
                <!-- END CONTENT -->
                    <div class="row">
                    <div class="col-md-12">

                        @php
                            $url = request()->segment(count(request()->segments()));
                            $all = "all_orders";
                        @endphp

                        <div class="clearfix">
                          <ul class="list-inline custom_page_tabs pull-left">

                            <li><a href="{{url('all_orders')}}" 

                                @if($url == $all)
                                    style="background-color:#32c5d2;"
                                @endif

                                >All Order</a></li>
                            <li><a href="{{url('inprocessOrder')}}">Check In</a></li>          
                            <li><a href="{{url('pendingOrder')}}">Pending</a></li>
                            <li><a href="{{url('completeOrder')}}">Check Out</a></li>
                            <li><a href="{{url('cancelledOrder')}}">Cancelled</a></li>
                            
                          </ul>
                            
                                 
                            <div class="btn-group pull-right">
                                <a href="{{url('add_resvation')}}" id="sample_editable_1_new" class="btn sbold green"> Add Reservation
                                    <i class="fa fa-plus"></i>
                                </a>
                            </div>
                        </div>
                                                       <!-- BEGIN EXAMPLE TABLE PORTLET-->
                        <div class="portlet light bordered">
                            <div class="portlet-title">
                                <div class="caption font-dark">
                                    <i class="icon-settings font-dark"></i>
                                    <span class="caption-subject bold uppercase">
                                    All Orders </span>
                                </div>
                            </div>
                            <div class="portlet-body">
                             
                                <table class="table table-striped table-bordered table-hover table-checkable order-column" id="sample_1">
                                    <thead>
                                        <tr>
                                            <th>Order Id </th>
                                            <th>Customer Name </th>    
                                            <th> Depot Name </th>            
                                            <th> Status </th>
                                            <th> Total Amount </th>
                                            <th> Order Status </th>
                                            <th> Check In </th>
                                            <th> Check Out </th>
                                            <th> order Created </th>
                                            <th> Action </th>
                                           
                                        </tr>
                                    </thead>
                                    <tbody>                                        
                                         @foreach($order as $value)
                                   
                                        <tr class="odd gradeX">
                                            <td>{{$value->id}}</td>
                                            <td>{{$value->CustomerN}}</td>
                                            <td> {{$value->depot_name}}</td>
                                            
                                            <!-- <td> {{$value->status}} </td> -->
                                            <td>
                                                @if($value->status == 1)
                                                    Only Order 
                                                @elseif($value->status != 1)
                                                    Order With Shipping 
                                                @endif
                                            </td>
                                            <td> 
                                                 
                                                @php
                                                        $total_tax = $value->total_amount*$taxs;
                                                @endphp
                                                {{ round($value->total_amount+$total_tax+$value->shipping_charges+$value->remote_delivery_charges) }} JPY
                                            </td>

                                                @if($value->order_status == 0)
                                                <td> New </td>
                                                @elseif($value->order_status == 1)
                                                <td> Check Out </td>
                                                @elseif($value->order_status == 2)
                                                <td> Pending </td>
                                                @elseif($value->order_status == 3)
                                                <td> Check In </td>
                                                @elseif($value->order_status == 4)
                                                <td> Cancel </td>
                                                @endif


                                                @if($value->checkin)
                                                <td> {{$value->checkin}} </td>
                                                @else
                                                <td> Released  </td>
                                                @endif

                                                @if($value->checkout)
                                                <td> {{$value->checkout}} </td>
                                                @else
                                                <td> Released  </td>
                                                @endif

                                             <td> {{$value->created_at}} </td>
                                            <td>
                                                <div class="btn-group">
                                                    <button class="btn btn-xs green dropdown-toggle" type="button" data-toggle="dropdown" aria-expanded="false"> Actions
                                                        <i class="fa fa-angle-down"></i>
                                                    </button>
                                                  <ul class="dropdown-menu pull-left" 
                                                      role="menu">
                                                      
                                                    <li>
                                                    <a href="{{ url('/')}}/status/{{$value->id}}/3" @if($value->order_status
                                                    == 3)
                                                    style="background-color:#32c5d2;"
                                                    @endif
                                                    >
                                                    <i class="icon-tag"></i> Check In </a>
                                                    </li>
                                                    
                                                    <li>
                                                    <a href="{{ url('/')}}/status/{{$value->id}}/2" 
                                                    @if($value->order_status
                                                    == 2)
                                                    style="background-color:#32c5d2;"
                                                    @endif >
                                                    <i class="icon-tag"></i> Pending </a>
                                                    </li>

                                                    <li >
                                                    <a href="{{ url('/')}}/status/{{$value->id}}/1"
                                                    @if($value->order_status
                                                    == 1)
                                                    style="background-color:#32c5d2;"
                                                    @endif
                                                    >
                                                    <i class="icon-tag"></i> Check Out </a>
                                                    </li>

                                                    <li >
                                                    <a href="{{ url('/')}}/status/{{$value->id}}/4"
                                                    @if($value->order_status
                                                    == 4)
                                                    style="background-color:#32c5d2;"
                                                    @endif
                                                    >
                                                    <i class="icon-tag"></i>  Cancel </a>
                                                    </li>

                                          <!--           <li >
                                                    <a href="{{ url('/')}}/status/{{$value->id}}/5">
                                                    <i class="icon-tag"></i>  Delete </a>
                                                    </li> -->
   
                                                  </ul>
                                                </div>
                                                <a href="{{ url('/')}}/view_detail/{{$value->id}}"><i class="fa fa-eye"></i></a>
                                            </td>
                               
                                        </tr>
                                        @endforeach
                      </tbody>
               
                                </table>
                                
                                <div class="text-right">
                                    {{ $order-> links() }}
                                </div>
                              
                                
                            </div>
                        </div>
                        <!-- END EXAMPLE TABLE PORTLET-->
                    </div>
                </div>
               <!-- start table -->
               <!-- end table -->
            </div>
            <!-- END CONTENT BODY -->
        </div>
      <!-- END CONTENT -->
<script type="text/javascript">
    $('#orders').addClass("active open");
</script> 

@endsection
