@extends('layouts.app')
@section('content')
<!-- BEGIN CONTENT -->
<div class="page-content-wrapper">
    <!-- BEGIN CONTENT BODY -->
    <div class="page-content">
        <!-- BEGIN PAGE BAR -->
        <div class="page-bar">
            <ul class="page-breadcrumb">
                <li>
                    <a href="{{url('home')}}">Home</a>
                    <i class="fa fa-circle"></i>
                </li>
                <li>
                    <a href="{{url('resources')}}">Resources</a>
                    <i class="fa fa-circle"></i>
                </li>
                <li>
                    <span>New Resource</span>
                </li>
            </ul>
            <div class="page-toolbar">
                <div id="dashboard-report-range" class="pull-right tooltips btn btn-sm" data-container="body" data-placement="bottom" data-original-title="Change dashboard date range">
                    <i class="icon-calendar"></i>&nbsp;
                    <span class="thin uppercase hidden-xs"></span>&nbsp;
                    <i class="fa fa-angle-down"></i>
                </div>
            </div>
        </div>
        <!-- END PAGE BAR -->
        <!-- BEGIN PAGE TITLE-->
        <br>
        @if(Session::has('message'))
        <div class="alert alert-success">
            <button class="close" data-close="alert"></button><?php echo Session::get('message');?> 
        </div>
        @endif
        <br>
        <!-- END PAGE TITLE-->
        <!-- END PAGE HEADER-->
        <!-- BEGIN DASHBOARD STATS 1-->
        <div class="clearfix"></div>
        <!-- END DASHBOARD STATS 1-->
        <!-- BEGIN CONTENT -->
        <form class="form-horizontal" enctype="multipart/form-data"  method="post" action="{{url('addresources')}}">
            @csrf
            <div class="form-group">
                <label class="col-md-3 control-label">Resource ID</label>
                <div class="col-md-4">
                    <input type="text" name="resource_id" class="form-control" placeholder="Resource ID">
                </div>
                <div class="col-md-5">
                    <span class="help-block help-block-error">{!!$errors->first('resource_id')!!}</span>
                </div>
            </div>
            <div class="form-group">
                <label class="col-md-3 control-label">Select Type</label>
                <div class="col-md-4">
                    <select class="form-control" name="auto_type">
                        @foreach ($types as $type)
                        <option value="{{$type->id}}">{{$type->name}}</option>
                        @endforeach
                    </select>
                </div>
            </div>
            <div class="form-group">
                <label class="col-md-3 control-label">Resource Name</label>
                <div class="col-md-4">
                    <input type="text" name="resource_name" class="form-control" placeholder="Resource Name">
                </div>
                <div class="col-md-5">
                    <span class="help-block help-block-error">{!!$errors->first('resource_name')!!}</span>                                    
                </div>
            </div>
            <div class="form-group">
                <label class="col-md-3 control-label">Select Depot</label>
                <div class="col-md-4">
                    <select class="form-control" name="depot_type">
                        @foreach ($depots as $depot)
                        <option value="{{$depot->id}}">{{$depot->name}}</option>
                        @endforeach
                    </select>
                </div>
            </div>
            <div class="form-group">
                <label class="col-md-3 control-label">Select Agent</label>
                <div class="col-md-4">
                    <select class="form-control" name="agent">
                        @foreach ($agents as $agent)
                        <option value="{{$agent->id}}">{{$agent->name}}</option>
                        @endforeach
                    </select>
                </div>
            </div>
            <div class="form-group">
                <label class="col-md-3 control-label">Resource Description</label>
                <div class="col-md-4">
                    <textarea class="form-control" rows="5" name="res_description"></textarea>
                </div>
            </div>
            <div class="form-group mb-2">
                <label class="col-md-3 control-label">Featured Image</label>
                <div class="col-md-4">
                    <input type="file" name="resource_featured_img" id="resource-featured-img" class="form-control" >
                    <div class="resource-featured-img-show resource-add-img mt-1">
                    </div>
                </div>
            </div>
            <div class="form-group mb-2">
                <label class="col-md-3 control-label">Slide Images</label>
                <div class="col-md-4">
                    <input type="file" id="files" name="all_files[]" multiple />
                    <div class="resource-silde-img-list">
                    </div>
                </div>
            </div>
            <div class="form-group mb-2">
                <label class="col-md-3 control-label">Quantity</label>
                <div class="col-md-4">
                    <input type="text" name="quantity" id="quantity" class="form-control" placeholder="Quantity">
                    <div class="add-uid-fields">
                    </div>
                </div>
            </div>
            <div class="form-group">
                <label class="col-md-3 control-label">Attributes:</label>
                <div class="col-md-4">
                    @foreach ($variations as $variation)
                    <?php $var=variation_values($variation->id);?>
                    <div class="row mt-1">
                        <label class="col-md-3 control-label">{{$variation->name}}:</label>
                        <div class="col-md-9">
                            <select class="form-control" name="variation[]">
                                <?php for($v=0;$v<count($var);$v++) {?>
                                <option value="<?php print_r($var[$v]->id);?>"><?php print_r($var[$v]->v_value);?></option>
                                <?php }?>
                            </select>
                        </div>
                    </div>
                    @endforeach
                </div>
            </div>
            <div class="form-group">
                <div class="col-md-offset-3 col-md-9">
                    <button type="submit" class="btn blue">Save</button>
                </div>
            </div>
        </form>
        <!-- END CONTENT -->
    </div>
    <!-- start table -->
    <!-- end table -->
</div>
<!-- END CONTENT BODY -->
</div>
<!-- END CONTENT -->
<script type="text/javascript">
    $('#item').addClass("active open");
    $('#item ul li:nth-child(1)').addClass("active open");
    
    
    $("#add_field").click(function(){
        $(".add_field_div").append("<div class='form-group'><label class='col-md-3 control-label'></label><div class='col-md-4'><input type='text' name='value[]'class='form-control' placeholder='Value'></div><ul class='col-md-2 list-unstyled list-inline edit-delete-links'><li><a class='delete' href='#'><span><i class='fa fa-trash text-danger'></i></span></a></li></ul></div>");
    });
    
     $(document).on("click",".delete",function() {
        $(this).closest('.form-group').remove()
    
    });
    
     $(document).on("click",".resource-img-del",function() {
        $(this).parent().remove();
    
    });
    
    
     $("#quantity").on('change', function(){
     var quantity = parseInt($('#quantity').val());
    
        for(var i=0; i<quantity; i++){
            $('.add-uid-fields').append('<div class="row mt-1"><label class="col-md-3 control-label">UID '+ (i+1) + ':</label><div class="col-md-9"><input type="text" name="uid'+(i+1)+'" class="form-control" placeholder="UID"></div></div>');
        }   
    
        $("#quantity").on('change', function(){
         var quantity = parseInt($('#quantity').val());
         $('.add-uid-fields').html('');
            for(var i=0; i<quantity; i++){
                $('.add-uid-fields').append('<div class="row mt-1"><label class="col-md-3 control-label">UID '+ (i+1) + ':</label><div class="col-md-9"><input type="text" name="uid'+(i+1)+'" class="form-control" placeholder="UID"></div></div>');
            }  
        });
     });
    
    
     $("#resource-featured-img").on('change', function(){
        var resource_slide_img = $("#resource-featured-img").val();
        
        $(".resource-featured-img-show").html('<div class="resource-add-img mt-1"><img src="https://placehold.it/60x60"/></div>');
     });
    
    
     $("#resource-featured-img").on('change', function () {
    
        if (typeof (FileReader) != "undefined") {
    
            var image_holder = $(".resource-featured-img-show");
            image_holder.empty();
    
            var reader = new FileReader();
            reader.onload = function (e) {
                $("<img />", {
                    "src": e.target.result,
                    "class": "img-responsive",
                    "width": 60,
                }).appendTo(image_holder);
    
            }
            image_holder.show();
            reader.readAsDataURL($(this)[0].files[0]);
        } else {
            alert("This browser does not support FileReader.");
        }
    });
    
    
     var inputLocalFont = document.getElementById("files");
    inputLocalFont.addEventListener("change",previewImages,false);
    
    function previewImages(){
        var fileList = this.files;
        
        var anyWindow = window.URL || window.webkitURL;
    
            for(var i = 0; i < fileList.length; i++){
              var objectUrl = anyWindow.createObjectURL(fileList[i]);
              $('.resource-silde-img-list').append('<div class="resource-silde-img-show mt-1 mb-1"><img src="' + objectUrl + '" /> <button href="#" class="resource-img-del"><span><i class="fa fa-minus-square"></i></span></button></div>');
              window.URL.revokeObjectURL(fileList[i]);
            }
    }
    
    
    
     
    //  $(document).ready(function() {
    
    //     if(window.File && window.FileList && window.FileReader) {
    //         $("#files").on("change",function(e) {
    //             var files = e.target.files ,
    //             filesLength = files.length ;
    //             for (var i = 0; i < filesLength ; i++) {
    //                 var f = files[i]
    //                 var fileReader = new FileReader();
    //                 fileReader.onload = (function(e) {
    //                     var file = e.target;
    //                     $("<img></img>",{
    //                         class : "imageThumb",
    //                         src : e.target.result,
    //                         title : file.name,
    //                         width:50
    //                     }).insertAfter("#files");
    //                 });
    //                 fileReader.readAsDataURL(f);
    //             }
    //         });
    //     }
    //     else { alert("Your browser doesn't support to File API") }
    // });
    
</script> 
@endsection
