@extends('layouts.app')

@section('content')

    <!-- BEGIN CONTENT -->
    <div class="page-content-wrapper">
        <!-- BEGIN CONTENT BODY -->
        <div class="page-content">

            <!-- BEGIN PAGE BAR -->
            <div class="page-bar">
                <ul class="page-breadcrumb">
                    <li>
                        <a href="{{url('home')}}">Home</a>
                        <i class="fa fa-circle"></i>
                    </li>
                    <li>
                        <a href="{{url('depots')}}">Depots</a>
                        <i class="fa fa-circle"></i>
                    </li>
                    <li>
                        <span>Update Depot</span>
                    </li>
                </ul>
                <div class="page-toolbar">
                    <div id="dashboard-report-range" class="pull-right tooltips btn btn-sm" data-container="body"
                         data-placement="bottom" data-original-title="Change dashboard date range">
                        <i class="icon-calendar"></i>&nbsp;
                        <span class="thin uppercase hidden-xs"></span>&nbsp;
                        <i class="fa fa-angle-down"></i>
                    </div>
                </div>
            </div>
            <!-- END PAGE BAR -->
            <!-- BEGIN PAGE TITLE-->
            <br>

            @if(Session::has('message'))
                <div class="alert alert-success">
                    <button class="close" data-close="alert"></button><?php echo Session::get('message');?> </div>
            @endif
            <br>
            <!-- END PAGE TITLE-->
            <!-- END PAGE HEADER-->
            <!-- BEGIN DASHBOARD STATS 1-->

            <div class="clearfix"></div>
            <!-- END DASHBOARD STATS 1-->

            <!-- BEGIN CONTENT -->
            <form class="form-horizontal" method="post" action="{{url('editdepotscript')}}" enctype="multipart/form-data">
                @csrf

                <input type="hidden" name="id" class="form-control" id="inputName1" value="<?php echo $depot->id;?>">

                <div class="form-group">
                    <label class="col-md-3 control-label">Name</label>
                    <div class="col-md-4">
                        <input type="text" name="name" class="form-control" value="<?php echo $depot->name;?>"
                               placeholder="Name">
                    </div>
                    <div class="col-md-5">
                        <span class="help-block help-block-error">{!!$errors->first('name')!!}</span>

                    </div>
                </div>

                <div class="form-group">
                    <label class="col-md-3 control-label">Address</label>
                    <div class="col-md-4">
                        <div class="input-group">
                            <input type="text" id="search_location" class="form-control search_addr"
                                   placeholder="Search location" name="address" value="<?php echo $depot->address;?>">
                            <div class="input-group-btn">
                                <button class="btn btn-default get_map" type="submit">
                                    Locate
                                </button>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-5">
                        <span class="help-block help-block-error">{!!$errors->first('search')!!}</span>

                    </div>
                </div>

                <div class="form-group input-group">

                </div>

                <div class="form-group">
                    <label class="col-md-3 control-label">Latitude</label>
                    <div class="col-md-4">
                        <input type="text" name="lat" class="form-control search_latitude" readonly
                               value="<?php echo $depot->lat;?>">
                    </div>
                    <div class="col-md-5">
                        <span class="help-block help-block-error">{!!$errors->first('lat')!!}</span>
                    </div>
                </div>
                <div class="form-group">
                    <label class="col-md-3 control-label">Longitude</label>
                    <div class="col-md-4">
                        <input type="text" name="long" class="form-control search_longitude" readonly
                               value="<?php echo $depot->long;?>">
                    </div>
                    <div class="col-md-5">
                        <span class="help-block help-block-error">{!!$errors->first('long')!!}</span>
                    </div>
                </div>
                @if($currentUser -> type == 2)
                    <input type="hidden" value="{{$currentUser->id}}" name="agent[]"/>
                @else
                    <div class="form-group">
                        <label class="col-md-3 control-label">Agents</label>
                            <div class="col-md-4">
                                <div class="dropdown">
                                    <button id="dLabel" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                    Select Agent
                                    <span class="caret"></span>
                                    </button>
                                    <ul class="dropdown-menu" aria-labelledby="dLabel">
                                        @foreach($agents as $agent)
                                        <input type="checkbox" name="agent[]" value="{{$agent->id}}"  
                                           @foreach($depot_with_agent as $mutliagent)
                                                <?php if($mutliagent->agent_id == $agent->id){ ?> checked <?php } ?> 
                                            @endforeach
                                            >
                                        <label>{{$agent->name}}</label>
                                        <br/>
                                        @endforeach
                                    </ul>
                                     
                                </div>
                            </div>
                        <div class="col-md-5">
                            <span class="help-block help-block-error">{!!$errors->first('agent')!!}</span>
                        </div>
                    </div>
                @endif
                
               <!--  <div class="form-group">
                 <label class="col-md-3 control-label">Featured Image</label>
                    <div class="col-md-4">  
                        @if($depot->depo_image)
                        <img src="{{ url('uploads/depo_img/' . $depot->depo_image) }}" class="img-responsive"/>
                        @else
                                <p>No image found</p>
                        @endif
                       <input type="file" name="depo_img" value="{{ $depot->depo_image }}"/>
                    </div>
                </div> -->

                <div class="form-group">
                    <label class="col-md-3 control-label">Featured Image</label>
                    <div class="col-md-4">

                       <img id="img" src="{{ url('uploads/depo_img/'.$depot->depo_image) }}" style="width: 150px; border: 1px solid; padding: 5px; border-radius: 5px;"/>
                        <br>
                        <a href="javascript:void(0)" class="btn remove_picture {{$depot->depo_image ? '' : 'hidden' }}" style="padding-left: 0px;display:inline-block;">Remove</a>
                         <input type="file" name="depo_img" class="" id="featured_img"
                          onchange="readURL(this)" style= "display:inline-block"
                          value="{{ $depot->depo_image }}"/>

                        <input type="hidden" name="remove_res_img" id="res_img_input" style="display:inline-block;">
                    </div>
                    
                    <div class="col-md-5">
                            <span class="help-block help-block-error">{!!$errors->first('depo_img')!!}</span>
                 </div>
                </div>
                
                
                <div class="form-group">
                    <div class="col-md-offset-3 col-md-9">
                        <button type="submit" class="btn blue">Submit</button>
                    </div>
                </div>
            </form>
            <!-- END CONTENT -->
            <div id="geomap"></div>
        </div>
        <!-- start table -->
        <!-- end table -->

    </div>
    <!-- END CONTENT BODY -->
    </div>
    <!-- END CONTENT -->

    <script type="text/javascript">
        $('#depot').addClass("active open");


     jQuery(document).ready(function ($) {
      $('.remove_picture').on('click', function(){
           $('#res_img_input').val('yes');
           $('.remove_picture').addClass('hidden');
           $('#featured_img').val('').trigger('change');
      });
    });

    function readURL(input) {
           var url = input.value;
           var ext = url.substring(url.lastIndexOf('.') + 1).toLowerCase();
           if (input.files && input.files[0]&& (ext == "gif" || ext == "png" || ext == "jpeg" || ext == "jpg")) {
               var reader = new FileReader();
               reader.onload = function (e) {
                   $('#img').attr('src', e.target.result);
               }
               reader.readAsDataURL(input.files[0]);
               $('#res_img_input').val('no');
               $('.remove_picture').removeClass('hidden');
           }else{
                $('#img').attr('src', 'https://via.placeholder.com/150');
           }
       }
    </script>


@endsection
