@extends('layouts.app')

@section('content')

    <!-- BEGIN CONTENT -->
    <div class="page-content-wrapper">
        <!-- BEGIN CONTENT BODY -->
        <div class="page-content">

            <!-- BEGIN PAGE BAR -->
            <div class="page-bar">
                <ul class="page-breadcrumb">
                    <li>
                        <a href="{{url('home')}}">Home</a>
                        <i class="fa fa-circle"></i>
                    </li>
                    <li>
                        <a href="{{url('additional_resource')}}"> Additional Resource </a>
                        <i class="fa fa-circle"></i>
                    </li>
                    <li>
                        <span>New Additional Resource</span>
                    </li>
                </ul>
                <div class="page-toolbar">
                    <div id="dashboard-report-range" class="pull-right tooltips btn btn-sm" data-container="body"
                         data-placement="bottom" data-original-title="Change dashboard date range">
                        <i class="icon-calendar"></i>&nbsp;
                        <span class="thin uppercase hidden-xs"></span>&nbsp;
                        <i class="fa fa-angle-down"></i>
                    </div>
                </div>
            </div>
            <!-- END PAGE BAR -->
            <!-- BEGIN PAGE TITLE-->
            <br>

            @if(Session::has('message'))
                <div class="alert alert-success">
                    <button class="close" data-close="alert"></button><?php echo Session::get('message');?> </div>
            @endif
            <br>
            <!-- END PAGE TITLE-->
            <!-- END PAGE HEADER-->
            <!-- BEGIN DASHBOARD STATS 1-->

            <div class="clearfix"></div>
            <!-- END DASHBOARD STATS 1-->

            <!-- BEGIN CONTENT -->
            <form class="form-horizontal" method="post" action="{{url('updateAdditional')}}" 
                  enctype="multipart/form-data">
                @csrf
                <input type="hidden" name="AdditResourceid" 
                value="{{$AdditionalResource->id}}">
                <div class="form-group">
                    <label class="col-md-3 control-label">Additional Resource ID</label>
                    <div class="col-md-4">
                        <input type="text" name="addresid" class="form-control" 
                        value="{{$AdditionalResource->add_res_id}}" readonly 
                        placeholder="">
                    </div>
                    <div class="col-md-5">
                        <span class="help-block help-block-error"></span>
                    </div>
                </div>

                <div class="form-group">
                    <label class="col-md-3 control-label">Additional Resource Name</label>
                    <div class="col-md-4">
                        <input type="text" name="addResName" class="form-control"
                        value="{{$AdditionalResource->add_res_name}}" 
                        placeholder="Additional Resource Name" >
                    </div>
                    <div class="col-md-5">
                        <span class="help-block help-block-error"></span>
                    </div>
                </div>

                 <div class="form-group">
                        <label class="col-md-3 control-label">Select Depot</label>
                        <div class="col-md-4">
                            <select class="form-control" name="depot">
 
                               @foreach($depots as $depot)
                               <option value="{{$depot->id}}"
                               <?php if($AdditionalResource->depot_id == $depot->id){ ?> selected 
                               <?php } ?> >
                               {{$depot->name}}
                               </option>
                               @endforeach
                           
                            </select>
                        </div>
                        <div class="col-md-5">
                            <span class="help-block help-block-error"></span>
                        </div>
                </div>

                 <div class="form-group">
                    <label class="col-md-3 control-label">Additional Resource Description</label>
                    <div class="col-md-4">
                        <textarea type="text" name="addResDes" class="form-control" 
                        placeholder="" 
                        rows="5">{{$AdditionalResource->add_res_description}}</textarea> 
                    </div>
                    <div class="col-md-5">
                        <span class="help-block help-block-error"></span>
                    </div>
                </div>
      
            <div class="form-group">
                <label class="col-md-3 control-label">Featured Image</label>
                <div class="col-md-4">
                    <!-- <input type="file" name="addit_res_img" id=""> -->
                   <!-- @if($AdditionalResource->add_res_image)-->
                   <!-- <img src="{{ url('uploads/additional Resource Image/' . $AdditionalResource->add_res_image) }}" />-->
                   <!-- @else-->
                   <!--         <p>No image found</p>-->
                   <!-- @endif-->
                   <!--<input type="file" name="addit_res_img" -->
                   <!--value="{{ $AdditionalResource->add_res_image }}"/>-->
                   <img id="img" src="{{url('uploads/additional_Resource_Image/' . $AdditionalResource->add_res_image) }}" style="width: 150px; border: 1px solid; padding: 5px; border-radius: 5px;"/>
                    <br>
                    <a href="javascript:void(0)" class="btn remove_picture {{ $AdditionalResource->add_res_image ? '' : 'hidden' }}" style="padding-left: 0px;display:inline-block;">Remove</a>

                     <input type="file" name="addit_res_img" class="" id="featured_img"
                      onchange="readURL(this)" style= "display:inline-block"
                      value="{{ $AdditionalResource->add_res_image }}"/>

                    <input type="hidden" name="remove_res_img" id="res_img_input" style="display:inline-block;">
                </div>
            </div>

                <div class="form-group">
                    <label class="col-md-3 control-label">Quantity</label>
                    <div class="col-md-4">
                        <input type="text" name="additquantity" class="form-control" 
                        id="quantity_edit" placeholder="Quantity" value=" {{$AdditionalResource->quatity_selectable}}">

                        <input type="hidden" name="res_quantity" class="form-control qty_removes" 
                        id="quantitys" placeholder="Quantity" value=" {{$AdditionalResource->quatity_selectable}}">

                        <div class="add-uid-fields">
                        	<?php $c = 0; ?>
                            @foreach($AdditResQuantity as $quantity)
                                <?php echo View::make('admin.resources.partials._quantity',
                                ['u_id'=>$quantity->uid, 'call_count'=>$c, 'count'=>$c+1])->render(); ?>
                                <?php $c += 1; ?>
                            @endforeach
                          <div class="extra-uid-fields"></div>
                        </div>

                    </div>
                    <div class="col-md-5">
                        <span class="help-block help-block-error"></span>
                    </div>
                </div>

             

               <div class="form-group">
                <label class="col-md-3 control-label">Attributes:</label>
                <div class="col-md-4">
                 <select class="form-control selectbox" id="variation_select" name="additatribute">
                        <option value="" selected="selected">Select Attribute</option>
                         @foreach($variations as $variation)
                            <option value="{{$variation->id}}">{{$variation->name}}</option>
                        @endforeach
                      
                    </select>
                    <a class="btn blue" id="add_attribute_btn">Add</a>
                    <div id="attribute_value_fields">
                    	  <?php $c = 0; ?>
                            @foreach($AdditionalResource->variations as $resources_variations)
                            	<?php
                            		$attribute = $resources_variations->variation;
                            		$values = $resources_variations->variation_values->pluck('v_value','id')->toArray();
                            	?>
                            	<script type="text/javascript">
                            		$('#variation_select option[value=' + '{{ $attribute->id }}' + ']').prop('disabled', true);
                            	</script>
                                <?php echo View::make('admin.resources.partials._attribute',['values'=>$values, 'attribute'=>$attribute,'removeable'=>true,'call_count'=>mt_rand(1000000, 9999999),'resources_variations'=>$resources_variations])->render()?>
                                <?php $c += 1; ?>
                            @endforeach
                         
                    </div>
                </div>

                <div class="col-md-5">
                    <span class="help-block help-block-error"></span>
                </div>
               </div>

                 

                  <div class="form-group">
                <label class="col-md-3 control-label">Resource</label>
                <div class="col-md-4">
                    <select class="form-control" name="resource">
                            @foreach($resources as $resource)
                               <option value="{{$resource->id}}"
                               <?php if($AdditionalResource->res_id== $resource->id){ ?> selected 
                               <?php } ?> >
                               {{$resource->res_name}}
                               </option>
                               @endforeach
                          
                    </select>
                </div>
                <div class="col-md-5">
                    <span class="help-block help-block-error"></span>
                </div>
               </div>

                <div class="form-group">
                <label class="col-md-3 control-label">Resource Type</label>
                <div class="col-md-4">
                    <select class="form-control" name="restype">
                               @foreach($resource_types as $resource_type)
                               <option value="{{$resource_type->id}}"
                               <?php if($AdditionalResource->res_type_id == $resource_type->id){ ?> selected 
                               <?php } ?> >
                               {{$resource_type->name}}
                               </option>
                               @endforeach
                        
                    </select>
                </div>
                <div class="col-md-5">
                    <span class="help-block help-block-error"></span>
                </div>
               </div>
                
                
                
                <div class="form-group">
                    <div class="col-md-offset-3 col-md-9">
                          <a href="{{url('additional_resource')}}" class="btn btn-default"> Cancel </a>
                        <button type="submit" class="btn blue">Update</button>

                    </div>
                </div>
            </form>
            <!-- END CONTENT -->
            
        </div>
        <!-- start table -->
        <!-- end table -->

    </div>
    <!-- END CONTENT BODY -->
    </div>
    <!-- END CONTENT -->

    <script type="text/javascript">
       $('#item').addClass("active open");
       $('#item ul li:nth-child(4)').addClass("active open");

       var quantitys = parseInt($('#quantitys').val());

       $("#quantity_edit").on('change', function(){
        var quantity = parseInt($('#quantity_edit').val());
        var check="edit";
          // $('.add-uid-fields').html('');
          if(quantity >quantitys){
            $.ajax({beforeSend: function(){},
            method: "Get",url: "{{ URL::route('admin.quantity.uuid') }}",data: { quantity: quantity,check:check, quantitys: quantitys}})
            .done(function( result ){
              if(result){
                var uid_data = JSON.parse(result);
                $('.extra-uid-fields').html(uid_data);
                console.log(uid_data);
              }
           });
          }
       });
    </script>

@include('admin.resources.partials._scripts')
@endsection
