@extends('layouts.app')

@section('content')

    <!-- BEGIN CONTENT -->
    <div class="page-content-wrapper">
        <!-- BEGIN CONTENT BODY -->
        <div class="page-content">

            <!-- BEGIN PAGE BAR -->
            <div class="page-bar">
                <ul class="page-breadcrumb">
                    <li>
                        <a href="{{url('home')}}">Home</a>
                        <i class="fa fa-circle"></i>
                    </li>
                    <li>
                        <a href="{{url('additional_resource')}}"> Additional Resource </a>
                        <i class="fa fa-circle"></i>
                    </li>
                    <li>
                        <span>New Additional Resource</span>
                    </li>
                </ul>
                <div class="page-toolbar">
                    <div id="dashboard-report-range" class="pull-right tooltips btn btn-sm" data-container="body"
                         data-placement="bottom" data-original-title="Change dashboard date range">
                        <i class="icon-calendar"></i>&nbsp;
                        <span class="thin uppercase hidden-xs"></span>&nbsp;
                        <i class="fa fa-angle-down"></i>
                    </div>
                </div>
            </div>
            <!-- END PAGE BAR -->
            <!-- BEGIN PAGE TITLE-->
            <br>
            @if ($errors->any())
                <div class="alert alert-danger">
                    <ul>
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            @if(Session::has('message'))
                <div class="alert alert-success">
                    <button class="close" data-close="alert"></button><?php echo Session::get('message');?> </div>
            @endif
            <br>
            <!-- END PAGE TITLE-->
            <!-- END PAGE HEADER-->
            <!-- BEGIN DASHBOARD STATS 1-->

            <div class="clearfix"></div>
            <!-- END DASHBOARD STATS 1-->

            <!-- BEGIN CONTENT -->
            <form class="form-horizontal" method="post" action="{{url('additionalStore')}}" 
                  enctype="multipart/form-data">
                @csrf
                <div class="form-group">
                    <label class="col-md-3 control-label">Additional Resource ID</label>
                    <div class="col-md-4">
                        <input type="text" name="addresid" class="form-control" 
                        value="{{$add_res_id}}"  readonly
                        placeholder="">
                    </div>
                    <div class="col-md-5">
                        <span class="help-block help-block-error"></span>
                    </div>
                </div>

                <div class="form-group">
                    <label class="col-md-3 control-label">Additional Resource Name</label>
                    <div class="col-md-4">
                        <input type="text" name="addResName" class="form-control" 
                        placeholder="Additional Resource Name" value="{{ old('addResName') }}" required>
                    </div>
                    <div class="col-md-5">
                        <span class="help-block help-block-error"></span>
                    </div>
                </div>

                 <div class="form-group">
                        <label class="col-md-3 control-label">Select Depot</label>
                        <div class="col-md-4">
                            <select class="form-control" name="depot" required>
                            <option value="" selected="selected" disabled="disabled" >Select Depot</option>
                                 @foreach($depots as $depot)
                                    <option value="{{$depot->id}}">{{$depot->name}}</option>
                                 @endforeach
                            </select>
                        </div>
                        <div class="col-md-5">
                            <span class="help-block help-block-error"></span>
                        </div>
                </div>

                 <div class="form-group">
                    <label class="col-md-3 control-label">Additional Resource Description</label>
                    <div class="col-md-4">
                        <textarea type="text" name="addResDes" class="form-control" 
                        placeholder="" rows="5" required>{{ old('addResDes')}}</textarea> 
                    </div>
                    <div class="col-md-5">
                        <span class="help-block help-block-error"></span>
                    </div>
                </div>
      
            <div class="form-group">
                <label class="col-md-3 control-label">Featured Image</label>
                <div class="col-md-4">
                     <img id="img" src="{{'https://via.placeholder.com/150' }}" style="width: 150px; border: 1px solid; padding: 5px; border-radius: 5px;"/>
                    <br>         
                   <a href="javascript:void(0)" class="btn remove_picture {{'hidden'}}" style="padding-left: 0px;display:inline-block;">Remove</a>
                     <input type="file" name="Image" class="" id="featured_img"
                      onchange="readURL(this)" style= "display:inline-block"/>
                    <input type="hidden" name="remove_res_img" id="res_img_input" style="display:inline-block;">

                    <!--<input type="file" name="addit_res_img" id="">-->
                </div>
            </div>

                <div class="form-group">
                    <label class="col-md-3 control-label">Quantity</label>
                    <div class="col-md-4">
                        <input type="text" name="additquantity" class="form-control" 
                        id="quantity" placeholder="Quantity" required >
                        <div class="add-uid-fields">
                         
                        </div>

                    </div>
                    <div class="col-md-5">
                        <span class="help-block help-block-error"></span>
                    </div>
                </div>

             <!--   <div class="form-group">
                <label class="col-md-3 control-label">Atribute</label>
                <div class="col-md-4">
                    <select class="form-control" name="additatribute" id="variation_select">
                        <option selected="true" disabled="disabled">SELECT ATTRIBUTE</option>
                            @foreach($variations as $variation)
                            <option value="{{$variation->id}}">{{$variation->name}}</option>
                            @endforeach 
                    </select>
                    <a class="btn blue" id="add_attribute_btn">Add</a>  
                </div> -->

               <div class="form-group">
                <label class="col-md-3 control-label">Attributes</label>
                <div class="col-md-4">
                    <select class="form-control selectbox" id="variation_select" name="additatribute" required>
                        <option value="" selected="selected">Select Attribute</option>
                        @foreach($variations as $variation)
                            <option value="{{$variation->id}}">{{$variation->name}}</option>
                        @endforeach
                    </select>
                    <a class="btn blue" id="add_attribute_btn">Add</a>
                    <div id="attribute_value_fields">
                         
                    </div>
                </div>

                 <div class="col-md-5">
                    <span class="help-block help-block-error">{!!$errors->first('attr_values')!!}  </span>
                </div>
               </div>
<!-- 
               <div class="form-group">
                <label class="col-md-3 control-label">Color</label>
                <div class="col-md-4">
                    <select class="form-control" name="color">
                    <option selected="true" disabled="disabled">SELECT COLOR</option>
                            @foreach($variation_values as $variation_value)
                            <option value="{{$variation_value->id}}">{{$variation_value->v_value}}</option>
                            @endforeach   
                    </select>
                </div>
                <div class="col-md-5">
                    <span class="help-block help-block-error"></span>
                </div>
               </div> -->

                 

                  <div class="form-group">
                <label class="col-md-3 control-label">Resource</label>
                <div class="col-md-4">
                    <select class="form-control" name="resource" required >
                    <option value=""  selected="selected" disabled="disabled">SELECT RESOURCE</option>
                            @foreach($resources as $resource)
                            <option value="{{$resource->id}}">{{$resource->res_name}}</option>
                            @endforeach 
                    </select>
                </div>
                <div class="col-md-5">
                    <span class="help-block help-block-error"></span>
                </div>
               </div>

                <div class="form-group">
                <label class="col-md-3 control-label">Resource Type</label>
                <div class="col-md-4">
                    <select class="form-control" name="restype" required>
                        <option value=""  selected="selected" disabled="disabled">SELECT RESOURCE TYPE</option>
                            @foreach($resource_types as $resource_type)
                            <option value="{{$resource_type->id}}">{{$resource_type->name}}</option>
                            @endforeach 
                    </select>
                </div>
                <div class="col-md-5">
                    <span class="help-block help-block-error"></span>
                </div>
               </div>
                
                
                
                <div class="form-group">
                    <div class="col-md-offset-3 col-md-9">
                        
                        <a href="{{url('additional_resource')}}" class="btn btn-default"> Cancel 
                        </a>
                        <button type="submit" class="btn blue">Submit</button>

                    </div>
                </div>
            </form>
            <!-- END CONTENT -->
            
        </div>
        <!-- start table -->
        <!-- end table -->

    </div>
    <!-- END CONTENT BODY -->
    </div>
    <!-- END CONTENT -->

 <script type="text/javascript">
    $('#item').addClass("active open");
    $('#item ul li:nth-child(4)').addClass("active open");
    </script>

@include('admin.additionalResource.partials._scripts')
@endsection
