﻿// (c) ammap.com | SVG (in JSON format) map of Malaysia - Low
// areas: {id:"BN"},{id:"MY-01"},{id:"MY-02"},{id:"MY-03"},{id:"MY-04"},{id:"MY-05"},{id:"MY-06"},{id:"MY-07"},{id:"MY-08"},{id:"MY-09"},{id:"MY-10"},{id:"MY-11"},{id:"MY-12"},{id:"MY-13"},{id:"MY-15"}
AmCharts.maps.malaysiaLow={
	"svg": {
		"defs": {
			"amcharts:ammap": {
				"projection":"mercator",
				"leftLongitude":"99.639942",
				"topLatitude":"7.364329",
				"rightLongitude":"119.268560",
				"bottomLatitude":"0.853582"
			}
		},
		"g":{
			"path":[
				{
					"id":"BN",
					"title":"Brunei Darussalam",
					"d":"M626.19,99.58l0.73,1.42l0.53,0.15l-0.08,0.45l2.36,1.99l-0.25,1.38l0.97,1.26l-0.12,1.44l0.57,0.82l-0.32,1l1.08,0.89l0.18,1.15l-0.18,1.25l-0.63,0.9l0.02,1.38l0.51,1.88l-0.2,0.69l0.4,1l2.13,1.84l1,1.5l-0.04,0.72l-0.58,0.56l-0.85,0.42l-0.47,-0.12l-0.58,-0.94l-0.81,-0.49l-1.25,0.16l-0.21,-1.07l-0.31,-0.23l-1.57,0.12l-2.1,-0.76l-1.32,0.16l-0.47,-0.33l-0.29,-2.45l0.16,-1.3l-1.32,-4.26l-0.52,-0.85l-0.75,-3.38l0.16,-1.11l-0.39,-1.27l0.54,-1.4l0,0l-0.45,-0.42l0,-0.49l0.52,0.13l0.42,0.86l-0.05,-1.45l2.21,-0.87l0.16,-0.45l-0.58,-0.5l-0.2,-0.79l0.76,-0.5L626.19,99.58zM622.18,94.35l1.3,0.08l-0.94,0.68l-0.22,0.81l-1.08,-0.06l0.1,0.88l0.37,0.4l-1.21,1.48l0.26,1.21l-0.77,0.39l0,0l-1.24,2.34l-4,0.92l-0.52,0.34l-0.61,1.54l-0.44,0.37l-1.15,0.11l-0.59,0.36l-0.14,1.51l0.88,1.46l0.16,1.01l0.57,7.78l0.72,0.78l1.58,0.46l-0.06,1.97l-1.05,2.1l-1.36,1.54l0.01,0.88l1.42,-0.88l-0.43,1.26l-2.02,2.68l-0.06,0.67l0.88,-0.11l-0.08,0.27l-1.55,1.28l-2.29,2.85l-1.85,1.09l-1.64,0.51l-0.66,-0.16l0.74,-1.03l-0.13,-0.41l-1.32,-0.22l-0.97,-0.61l-1.18,-2.21l-0.63,-0.65l-1.43,-0.16l-1.63,-3.04l-0.49,-2.08l-0.65,0l-0.77,0.76l-1.4,-0.44l-1.13,0.53l-1.3,-0.47l-0.05,-1.31l0.5,-1.76l-0.85,-0.78l0.03,-1.83l-1.79,-3.1l-1.09,-1.41l-1.19,-0.63l-0.48,0.16l-0.95,-1.23l-1.79,-0.62l0,0l5.14,-0.48l7.52,-2.6l2.75,-1.52l7.18,-6.07l4.07,-2.64l2.57,-2.13l0.54,0.07l6.74,-2.77l1.07,-0.32L622.18,94.35z"
				},
				{
					"id":"MY-01",
					"title":"Johor",
					"d":"M152.54,244.29l-0.07,-1.33l0.69,0.45l-0.02,0.59L152.54,244.29zM115.05,211.93l0.95,-0.22l0,0l0.64,-0.37l-0.04,-1.26l-0.49,-0.46l-1.5,-0.53l-0.07,-0.81l0.75,-0.67v-1.68l0.85,-3.61l0.88,-0.76l0.1,-0.62l1.78,-0.69l0.12,-0.54l0,0l0.06,-1.07l0.96,-1.15l-0.23,-0.9l0.33,-0.74l-0.19,-1.88l0.41,-1.02l0.79,-0.64l-0.52,-1.23l2.82,-7.87l0,0l3.74,1.1l7.03,8.23l7.16,3.11l5.45,-2.11l3.15,-0.6l2.44,1.35l1.4,0.23l1,1.22l4.38,2.21l0.59,0.12l0.35,-0.27l0.53,0.23l0.48,-0.75l-0.64,-1.36l0.02,-0.59l-0.92,0.1l-0.27,-0.22l0.14,-0.95l0.89,-0.24l-0.11,-0.44l-0.39,0.26l-0.21,-0.42l0.85,-0.4l-0.29,-0.26l0.33,-0.52l-0.08,-0.83l-0.27,-0.79l-0.2,0.66l-0.43,-0.03l-0.27,-0.97l0.64,-0.39l0.96,0.21l0.08,-0.36l0,0l1.51,0.26l2.76,1.12l0.82,-0.74l0.34,0.45l-0.17,0.92l1.83,1.37l0.71,-0.02l-0.34,0.39l0.28,1.33l0.94,1.34l-1,0.37l-0.13,0.29l0.9,2.18l0.57,0.23l2.32,3.19l0.98,0.25l1.02,1.4l-0.41,0.34l0.07,0.25l1.17,1.86l-0.44,-0.14l-0.48,0.29l0.05,1.48l2.34,3.14l1.12,2.49l2.77,3.96l0.63,1.67l-0.11,0.28l-0.64,-0.66l-0.25,1.11l0.18,1.33l0.93,1.16l0.73,0.01v-0.38l0.44,0.37l-0.13,0.77l1.2,1.7l0.52,1.85l0.81,1.06l-0.22,0.67l1.32,1.68l-0.12,0.82l0.78,0.92l-0.44,0.4l0.02,1.46l1.18,1.66l0.08,0.51l-0.45,0.25l-0.04,0.49l0.86,1.75l-0.74,0.8l0.31,2.29l-0.3,0.25l-0.75,0.23l-0.53,-0.42l-1.63,1.2l-1.05,-0.36l-1.66,0.26l-0.3,-0.53l-1.64,-0.51l1.45,-1.81l-0.72,0.31l-0.5,-0.7l-2.15,-1.56l0.82,-1.09l-0.27,-0.57l0.6,-0.5h1.08l1.43,-0.99l0.15,-0.51l-1.78,1.28l-0.87,-0.25l-0.7,0.42l-0.47,0.86l-0.47,-1.53l0.04,-1.07l-1.98,-2.15l-0.36,-1.23l-1.15,-0.49l-0.5,0.13l1.41,1.26l0.16,1.31l1.15,0.86l0.67,1.52l-0.45,0.75l0.08,2.53l-0.74,0.65l-1.12,0.24l-2.46,-0.37l-0.61,-0.31l-0.58,-0.95l-2.14,-0.74l-0.87,0.04l-1.4,1.25l-0.97,-0.25l-0.67,-0.85l-0.3,0.07l0.17,0.56l-1.4,0.97l-1.24,1.39l-0.52,1.33l-1.27,1.09l-0.92,0.05l-1.43,-0.39l-0.37,-1.23l0.09,-0.82l-0.38,0.09l0.13,1.86l0.48,0.9l-1.28,1.18l-0.07,1.56l-0.19,0.06l-2.46,-2.24l-2.99,-7.81l-1.07,-1.35l-1.06,-0.76l-5.99,-2.51l-4.52,-3.26l-1.35,-0.66l-1.76,-0.56l-1.7,0.08l-2.21,-2.1l0.39,-0.72l-2.76,-1.7l-2.25,-0.56l-1.59,0.02l-0.98,0.54l-0.75,-0.56l-3.03,-3.86l-2.74,-2.62l-0.28,-1.21l-0.46,-0.56l-2.33,-1.42l0,0l0.7,-0.17l0,0L115.05,211.93zM182.75,180.48l0.38,0.17l0.56,2.15l0.84,1.51l-0.43,0.31l0.07,0.46l0.73,0.53l-0.45,2l-2.18,0.11l-1.53,-1.27l-0.13,-1.4l1.87,-1.83l-0.64,-1.5l0.32,-1.08L182.75,180.48z"
				},
				{
					"id":"MY-02",
					"title":"Kedah",
					"d":"M7.63,47.01l0.02,0.63l-0.66,1.55l-0.5,-1.08l-0.37,0.45L5.9,48.45l0.11,-0.39l-0.66,-0.51l-0.22,-0.63l0.82,-0.79l0.4,-1.35l0.78,-0.3l0.68,-0.68l0.22,0.02l0.04,0.77L7.44,44.9l0.03,0.68l0.79,-0.73l0.62,0.65l-0.17,0.53l0.33,0.25l-0.43,0.87l-0.13,-0.53l-0.76,0.11L7.63,47.01zM7.88,36.64l0.71,0.46l0.09,0.98L10.21,39l0.26,0.96l0.43,-0.08l-0.41,1.08l0.55,0.69l-0.13,0.82l-1.22,0.39l-0.08,0.42l-0.73,0.48l-0.49,-0.34l0.18,-0.18l-0.25,-0.47l-1.28,-0.02l-1.72,1.71l-0.58,-0.18L4.4,44.86l-0.82,0.41l-0.02,-0.97l-0.62,-1.09l0.36,-0.63l-0.1,-0.87l-0.32,-0.57l-0.75,0.23l-0.59,-0.46L0.48,41.1l-0.44,-1.27l-0.02,-1.68l0.34,-0.09l0.7,0.46l0.45,-0.42l2.19,0.2l-0.14,0.52l0.31,0.19L4.2,38.5l1.3,0.21l0.62,-0.13l0.84,-1.21l0.67,-0.07l0.63,0.47l-0.23,-0.62l-0.85,-0.16l0.26,-0.52L7.88,36.64zM30.03,34.3l1.76,0.46l1.18,-0.47l0.46,0.43l0.84,-0.18l0.57,0.98l0.94,0.56l0.86,0.09l0.52,-0.43l0.5,0.51l3.57,1.28l0.85,-0.1l1.01,-0.7l1.09,-1.57l0.32,0.21l0.36,1.83l2.34,0.6l0.52,0.58l-0.06,2.96l0.33,0.39l0.46,-0.41l0.24,0.12l0.08,1.68l-0.57,0.94l0.75,1.82l0.56,0l0.48,-0.73l1.04,0.67l1.42,-0.19l1.52,-1.6l1.68,1.45l2.98,-0.3l0.68,0.36l-0.19,0.57l0.86,1.72l-0.76,0.64l-1.29,0.37l-0.69,1.11l1.4,0.53l1.56,1.1l-1.19,1.91l0.39,0.65l-0.24,1.6l0.83,0.84l-1.16,1.35l-0.51,1.37l-0.41,-0.28l-2.02,0.21l0.14,0.46l-0.79,1.12l0.11,1.67l-1,0.88l0.1,0.77l0,0l-0.17,0.74l-1.16,-0.17l-0.25,0.24l0.06,1.05l0.98,0.86l0.23,0.56l-0.5,2.35l-0.81,0.06l-0.24,0.88l-0.65,0.65l0.03,0.54l0.45,0.53l0.24,1.56l-0.93,1.97l-0.6,0.28l-0.69,-0.17l-0.54,0.63l-0.31,2l-0.49,0.82l0.11,0.66l-0.42,1.85l-1.43,1.21l-2.78,0.29l-0.35,0.78l0.02,0.98L42.97,86l-0.6,0.05l-0.83,1.59l0.23,0.35l-0.28,0.67l-1.49,0.54l-0.65,1.53l-1.09,0.22l-1.08,1.52l-0.69,-0.38l-0.54,0.19l-0.73,-0.29l0.13,-0.85l-0.31,-0.27L34.63,91l-0.17,-0.42l0.35,-0.52l0,0l1.71,0.38l0.18,-0.19l-0.98,-9.11l0.11,-7.65l-0.91,-0.39l-1.03,0.39l-1.3,-0.37l-1.14,0.06l-1.18,-0.68l-1.75,0.2l0,0l-0.34,-0.29l-0.04,-3.07l0.62,-1.11l-0.16,-0.81l0.5,-1.13l0.22,-1.49l-0.85,-8.25l-0.81,-2.68l-1.7,-2.08l-0.48,-2.25l-0.7,-1.52l-1.21,-1.59l-1.18,-0.98l0,0l0.55,-1.48l2.92,-3.17l0.9,-1.47l1.77,-1.27l0.71,-0.88l0.26,-3.12l0,0L30.03,34.3z"
				},
				{
					"id":"MY-03",
					"title":"Kelantan",
					"d":"M99,45.99l2.02,1.37l1.19,0.3l0.12,-0.58l1.79,-0.33l0.37,0.78l0.33,-0.52l4.42,2.1l1.16,1.67l3.02,6.88l1.29,2.17l-0.26,0.25l0.08,0.53l1,0.81l0.37,-0.19l0.99,0.77l0,0l-2.57,2.94l-3.61,3.32l0.98,5.45l-0.65,1.66l0.35,3.14l-0.69,0.66l2.37,2.05l-0.96,2.62l-0.11,2.36l0.23,1.16l-0.28,1.41l2.83,1.15l1.18,0.99l0.49,1.01L115.47,93l0.77,1.88l-0.54,1.2l0.47,1.64l-0.15,2.15l0.46,0.27l1.27,-0.14l1.28,0.94l0.61,0.06l1.74,1.07l0.03,1.12l0.72,1.73l-0.42,0.71l0,0l-1.59,-0.65l-0.38,0.13l-0.38,0.83l0.42,2.24l-1.18,0.09l-1.17,-0.42l-1.34,1.55l-0.57,-0.05l-1.85,-1.71l-2.13,-0.19l-1.35,0.28l0.04,1.17l-1.42,1.66l-0.54,0.11l-1.44,-0.79l-1.71,0l-0.44,1.07l-0.31,0.04l-2.01,-1.41l-0.58,-1.42l-1.22,-0.85l-0.14,-1.04l-0.51,-0.57l-0.79,0.13l-1.88,1.03l-0.6,-0.44l-0.58,0.29l-0.26,-0.15l-0.48,-0.95l-0.47,0.73l-0.98,-0.76l-0.58,0.65l0.16,1.43l-0.38,1.62l-0.71,0.71l-0.49,1.52l-0.25,0.07L91.05,111l-0.13,-1.72l-1.63,-0.69l-0.4,-1.26l-0.91,-0.46l0.02,-1.01l-1.39,-0.22l-0.49,0.82l0.23,1.22l-0.27,1.05l0.14,0.88l-0.44,1.4l-0.53,0.53l-0.92,-0.31l-0.39,0.68l-1.7,0.66l-0.41,0.92l-0.46,0.32l-1.06,0.33l-0.94,-0.44l-0.49,0.33l-3,-2.31l-0.97,0.12l-1.29,1.27l-2.27,-1.59l-0.95,0.19l0,0l-1.74,-2.57l-0.2,-0.93l0.32,-0.48l1.53,0l-0.28,-1.79l0.89,-0.45l0.62,-1.61l-0.17,-1.51l0.36,-0.38l1.3,-0.33l-0.4,-0.37l0.66,-1.23l-0.19,-1.99l-0.85,-0.76l-0.04,-0.43l0.89,-0.87l-0.08,-0.56l0.44,-0.56l0.29,-1.42l0.77,-0.76l0.16,-3.43l0.91,-1.38L75.5,87.1l0.62,-0.86l-0.13,-1.03l0.72,-0.02l1.14,-0.83l0.18,-1.08l0.73,-0.68l0.4,-1.24l0.59,0.18l0.82,0.91l1.8,0.5l2.1,-0.75l0.71,-1.05l-0.32,-1.3l2.3,1.9l4.33,0.24l2.31,-2.37L93.66,78l0.82,-0.39l0.5,-0.73l-0.22,-0.73l0.35,-1.57l-1.2,-0.2l0.19,-2.07l-0.96,-0.8l0.23,-0.62l0.63,-0.2l0.4,-1.08l-0.75,-1.45l0.48,-1.01l-0.28,-0.16l-0.63,0.28l-0.35,-0.66l-0.54,-0.15l-0.15,-0.51l-1.03,-0.63l-0.86,-2.03l0,0l0.19,-1.01l1.34,-0.24l0.97,-0.96l-0.33,-1.51l-0.46,-0.52l0.33,-1.27l0.55,-0.18L93,56.26l1.07,-0.77l-0.03,-0.54l0.66,-0.73l2.66,-1.73l0.32,-0.92l1.27,-1.77l-0.58,-1l-0.05,-0.79l0.13,-1.38L99,45.99z"
				},
				{
					"id":"MY-04",
					"title":"Melaka",
					"d":"M94.05,201.37l1.08,-0.47l1.38,-1.7l0.75,0.15l0.4,-0.83l0.56,-0.4l2.98,-0.05l0.94,-1.41l2.89,1.31l1.5,-0.05l3.24,-1.04l1.53,0.36l1.54,1.05l5.1,1.51l1.09,-0.09l0,0l-0.12,0.54l-1.78,0.69l-0.1,0.62l-0.88,0.76l-0.85,3.61v1.68l-0.75,0.67l0.07,0.81l1.5,0.53l0.49,0.46l0.04,1.26l-0.64,0.37l0,0l-1.12,0.26l0,0l-0.7,0.17l0,0l-1.25,-0.2l-1.42,-0.77l-1.31,-0.07l-1.1,-0.74l-3.97,-1.39l-2.05,-1.26l-1.63,0.03l-1.39,-2.04l-1.71,-1.11l-0.81,-1.77l-1.7,-1.02l-1.6,-0.19L94.05,201.37z"
				},
				{
					"id":"MY-05",
					"title":"Negeri Sembilan",
					"d":"M91.94,166.07l0.22,-0.56l0.53,-0.32l1.3,0.34l0.88,1.53l2.03,0.26l1.04,2.38l2.1,-1.25l0.86,-0.04l1.05,0.99l8.96,2.35l3.03,3.9l7.67,5.07l1.22,0.34l0.62,2.14l0,0l-2.82,7.87l0.52,1.23l-0.79,0.64l-0.41,1.02l0.19,1.88l-0.33,0.74l0.23,0.9l-0.96,1.15l-0.06,1.07l0,0l-1.09,0.09l-5.1,-1.51l-1.54,-1.05l-1.53,-0.36l-3.24,1.04l-1.5,0.05l-2.89,-1.31l-0.94,1.41l-2.98,0.05l-0.56,0.4l-0.4,0.83l-0.75,-0.15l-1.38,1.7l-1.08,0.47l0,0l-0.14,-0.98l-0.63,-0.12l-0.91,-0.83l-1.34,0.32l-1.22,-0.08l-0.52,0.6l-0.24,-0.32l0.39,-0.98l-0.56,-2.08l-1.01,-1.31l-1.15,-0.04l-0.04,-0.38l0.39,-0.45l-0.17,-1.29l-1.6,-1.13l-1.04,0.36l-0.69,-0.21l0,0l0.05,-0.29l0.86,-0.28l-0.06,-0.89l0.61,-0.58l-0.16,-0.54l0.55,-0.95l0.15,-1.26l-0.52,-6.1l4.91,0.17l0.67,-0.81l2.21,-5.01l1.11,-0.68l0.03,-0.66l-0.92,-2l0.56,-1.75l-0.48,-0.98L92.99,168l-0.48,-0.8l-0.1,-0.85L91.94,166.07z"
				},
				{
					"id":"MY-06",
					"title":"Pahang",
					"d":"M70.4,111.69l0.95,-0.19l2.27,1.59l1.29,-1.27l0.97,-0.12l3,2.31l0.49,-0.33l0.94,0.44l1.06,-0.33l0.46,-0.32l0.41,-0.92l1.7,-0.66l0.39,-0.68l0.92,0.31l0.53,-0.53l0.44,-1.4l-0.14,-0.88l0.27,-1.05l-0.23,-1.22l0.49,-0.82l1.39,0.22l-0.02,1.01l0.91,0.46l0.4,1.26l1.63,0.69l0.13,1.72l0.54,0.61l0.25,-0.07l0.49,-1.52l0.71,-0.71l0.38,-1.62l-0.16,-1.43l0.58,-0.65l0.98,0.76l0.47,-0.73l0.48,0.95l0.26,0.15l0.58,-0.29l0.6,0.44l1.88,-1.03l0.79,-0.13l0.51,0.57l0.14,1.04l1.22,0.85l0.58,1.42l2.01,1.41l0.31,-0.04l0.44,-1.07l1.71,0l1.44,0.79l0.54,-0.11l1.42,-1.66l-0.04,-1.17l1.35,-0.28l2.13,0.19l1.85,1.71l0.57,0.05l1.34,-1.55l1.17,0.42l1.18,-0.09l-0.42,-2.24l0.38,-0.83l0.38,-0.13l1.59,0.65l0,0l1.25,1.75l0.75,0.34l0.78,0.83l2.26,0.54l2.57,0.01l1.64,2.59l-0.98,0.42l0.4,0.58l-0.24,0.68l-0.92,0.24l0.52,2.57l1.35,1.24l1.6,0l1.07,-0.48l0.73,0.14l0.86,0.78l1.01,1.84l0.14,0.59l-0.79,1.26l0.42,1.23l-1.69,0.26l-0.46,1.33l-1.02,0.97l0.07,1.17l-0.71,1.27l0.27,1.76l-0.97,1.32l0.68,0.99l0.92,0.51l2.26,-1.09l1.01,0.42l1.78,0.07l0.69,0.71l1.11,0.24l1.04,1.29l1.4,1.07l1.29,-0.27l0.64,0.89l1.2,-0.03l0.09,0.78l1.34,1.21l-0.21,0.76l1.48,2.18l0.43,-0.21l-0.36,-0.9l0.85,-0.75l0.13,-0.69l-0.46,-1.81l-0.01,-1.88l-0.99,-1.15l0.19,-1.36l0.78,-1.43l-0.35,-2.06l1.1,0.71l0.75,0.14l3.1,-0.4l0,0l-0.35,0.4l-0.81,0.03l-0.28,1.49l-0.91,0.73l-0.08,0.48l0.54,2.66l1.7,3.07l-0.28,0.28l-1.29,-0.4l-1.36,1.98l-0.09,1.43l0.51,2.48l-0.15,0.63l-1.32,-0.07l-0.54,1.47l-0.11,1.26l0.54,1.61l1.23,2.12l2.7,3.44l1.29,1.11l0.32,1.12l-0.15,0.64l-1.15,1.33l-0.59,1.9l-0.25,2.02l0.95,6.02l0.01,4.2l-0.41,1.22l-0.33,4.68l0.57,2.74l0.56,1.17l2.91,3.71l4.08,3.98l0,0l-0.08,0.36l-0.96,-0.21l-0.64,0.39l0.27,0.97l0.43,0.03l0.2,-0.66l0.27,0.79l0.08,0.83l-0.33,0.52l0.29,0.26l-0.85,0.4l0.21,0.42l0.39,-0.26l0.11,0.44l-0.89,0.24l-0.14,0.95l0.27,0.22l0.92,-0.1l-0.02,0.59l0.64,1.36l-0.48,0.75l-0.53,-0.23l-0.35,0.27l-0.59,-0.12l-4.38,-2.21l-1,-1.22l-1.4,-0.23l-2.44,-1.35l-3.15,0.6l-5.45,2.11l-7.16,-3.11l-7.03,-8.23l-3.74,-1.1l0,0l-0.62,-2.14l-1.22,-0.34l-7.67,-5.07l-3.03,-3.9l-8.96,-2.35l-1.05,-0.99l-0.86,0.04l-2.1,1.25l-1.04,-2.38l-2.03,-0.26l-0.88,-1.53l-1.3,-0.34l-0.53,0.32l-0.22,0.56l0,0l-0.83,-0.43l-1.15,0.03l-2.07,-1.16l-1.64,-2.53l-0.7,-0.47l0.31,-1.05l0.87,-1.01l-0.36,-1.51l-0.81,-1.57l0.95,-1.7l1,-0.49l0.21,-2.02l-0.86,-0.9l-0.82,-1.98l-1.14,-1.16l-0.53,-0.27l-1.83,-0.05l-1.13,-0.69l-1.29,-1.67l0,0l-0.37,-0.76l-1.04,-0.43l0.1,-1.34l0.42,-0.85l-0.29,-1.1l-0.8,-0.69l-0.07,-3.72l-0.79,-1.1l0.18,-0.73l0.85,-1.2l-0.02,-0.57l-1.98,-1.67l-0.97,-0.16l-0.44,-1.55l0.43,-1.69l-1.56,-0.17l-0.52,-0.44l-0.15,-0.68l0.42,-0.51l-0.71,-1.13l0.17,-1.52l-0.86,-0.94l0.56,-1.33l-0.11,-0.29l-1.79,-0.83l-1.38,0.3l-0.44,-1.16l-0.72,-0.44l1,-1.27l0.29,-1.08l0.84,-0.6l-0.05,-0.38l-1,-0.67l-0.23,-1.92l0.42,-0.82L70.4,111.69z"
				},
				{
					"id":"MY-07",
					"title":"Pulau Pinang",
					"d":"M25.58,76.74L26,77.18l0.94,0.1l0.15,1.08l1.37,0.63l-1.18,1.58l-0.07,1.27l-1.24,3.67l-0.37,0.11l-0.62,-0.85l-1.28,-0.34l-1.54,0.25l-0.18,0.59l-0.3,-0.55l0.17,-1.02l0.57,-0.19l-0.04,-1.27l-0.47,-2.02l0.01,-2.54l-0.34,-0.76l0.18,-0.16l1.28,0.7l1.07,-0.22l0.71,-0.71L25.58,76.74zM28.52,72.7l1.75,-0.2l1.18,0.68l1.14,-0.06l1.3,0.37l1.03,-0.39l0.91,0.39l-0.11,7.65l0.98,9.11l-0.18,0.19l-1.71,-0.38l0,0l-1.04,0.4l-3.57,0.22l0,0l1.37,-1.49l-0.21,-0.33l0.27,-1.85l-0.6,-1.9l0.31,-0.64l-0.26,-1.07l-0.34,-0.31l0.11,-0.67l-1.64,-1.99l-0.1,-0.5l0.49,-0.99l0.25,-1.61l-0.78,-3.48l-0.92,-0.92L28.52,72.7z"
				},
				{
					"id":"MY-08",
					"title":"Perak",
					"d":"M39.33,110.09l1.92,1.69l-0.58,0.62l0.18,0.99l-1.52,0.48l-1.36,-0.52l0.35,-2.01L39.33,110.09zM39.5,105.71l1.56,0.71l0.29,0.7l-1,1.89l-0.66,-0.09l-1.17,0.4l-0.64,-1.89l-0.1,-1.46l0.31,-0.56L39.5,105.71zM78.34,58.37l1.67,1.41l0.5,0.79l1.07,0.3l0.07,2.29l1.18,1.37l0.37,0.86l0.47,-0.2l0.44,-0.83l1.34,-0.54l1.75,2.11l0.87,0.33l-0.04,-1.05l0.34,-0.94l0.68,-0.11l1.28,-0.88l0,0l0.86,2.03l1.03,0.63l0.15,0.51l0.54,0.15l0.35,0.66l0.63,-0.28l0.28,0.16l-0.48,1.01l0.75,1.45l-0.4,1.08l-0.63,0.2l-0.23,0.62l0.96,0.8l-0.19,2.07l1.2,0.2l-0.35,1.57l0.22,0.73l-0.5,0.73L93.66,78l0.13,1.62l-2.31,2.37l-4.33,-0.24l-2.3,-1.9l0.32,1.3l-0.71,1.05l-2.1,0.75l-1.8,-0.5l-0.82,-0.91l-0.59,-0.18l-0.4,1.24l-0.73,0.68l-0.18,1.08l-1.14,0.83l-0.72,0.02l0.13,1.03L75.5,87.1l0.12,0.75l-0.91,1.38l-0.16,3.43l-0.77,0.76l-0.29,1.42l-0.44,0.56l0.08,0.56l-0.89,0.87l0.04,0.43l0.85,0.76l0.19,1.99l-0.66,1.23l0.4,0.37l-1.3,0.33l-0.36,0.38l0.17,1.51l-0.62,1.61l-0.89,0.45l0.28,1.79l-1.53,0l-0.32,0.48l0.2,0.93l1.74,2.57l0,0l-0.93,0.3l-0.42,0.82l0.23,1.92l1,0.67l0.05,0.38l-0.84,0.6l-0.29,1.08l-1,1.27l0.72,0.44l0.44,1.16l1.38,-0.3l1.79,0.83l0.11,0.29l-0.56,1.33l0.86,0.94l-0.17,1.52l0.71,1.13l-0.42,0.51l0.15,0.68l0.52,0.44l1.56,0.17l-0.43,1.69l0.44,1.55l0.97,0.16l1.98,1.67l0.02,0.57l-0.85,1.2l-0.18,0.73l0.79,1.1l0.07,3.72l0.8,0.69l0.29,1.1l-0.42,0.85l-0.1,1.34l1.04,0.43l0.37,0.76l0,0l-0.99,-0.05l0.04,1.03l-0.28,0.38l-0.29,-0.14l-0.26,0.23l-0.3,1.33l-0.86,0.35l-0.44,0.77l-0.55,0.12l-1.92,-1.47l-1.21,-0.49l-0.43,-0.93l-1.81,-1.01l-0.33,0.07l-0.14,-0.83l-1.06,-0.45l-0.8,0.28l-0.44,0.76l0.81,2.18l-0.03,0.96l-1.48,0.85L66,149.63l-1.18,-0.26l0.08,-1.76l-1.31,0.4l-0.78,-0.41l-0.88,0.24l-0.75,-1.24l-0.21,0.46l-0.6,-0.22l0.27,-0.48l-0.34,-0.46l-0.5,0.77l-0.4,-0.09l-0.21,0.43l-0.58,-0.39l-0.63,0.61l0.03,-1.34l0.91,0.11l-0.5,-0.96l-0.9,1l-0.27,-0.02l-0.11,-1.45l-1.1,0.4l-0.17,-0.72l-1.04,-0.01l-0.38,0.23l-0.34,0.91l-0.57,-0.06l-0.36,-0.74l0.58,-1.04l-1.42,-0.69l-0.1,-1.27l-1.35,0.46l-3.01,0.3l-0.76,1.73l0,0l0.4,-2.16l-0.66,-0.09l-1.1,0.53l-0.88,-0.19l-1.59,-1.05l-0.38,-1.28l-0.01,-3.32l0.4,-0.52l1.87,-0.52l0.28,-1.1l-0.22,-1.62l-2.71,-2.95l-1.28,-0.46h-1.05l-0.43,0.56l-0.95,-1.35l0.28,-0.95l-0.56,-0.47l-0.19,-0.69l1.33,0.41l1.04,-0.45l0.66,-0.88l0.13,-2.08l-0.38,-0.15l-0.25,2.36l-0.66,0.59l-1.86,-0.37l-0.18,-1.41l-0.44,-0.73l-0.71,0.01l1.09,-2.61l0.09,-1.52l-0.2,-0.18l0.37,-0.56l0.18,0.31l0.41,-0.08l0.25,-0.55l0.37,-3.5l1.03,-0.79l0.48,-1.06l-0.21,-0.81l0.4,-0.65l-1.67,-1.63l1.45,-1.4l0.55,-1.82l-0.3,-0.64l-2.16,-1.09l0.08,-0.49l0.6,-0.59l-0.16,-1.64l-1.52,-0.21l-0.45,-0.73l-0.66,0.17l-0.43,-0.23l0.18,-0.88l-0.65,-0.35l0.09,-0.23l0.3,-0.06l0.48,0.49l0.56,-0.17l0.21,-0.2L37.71,99l-0.32,-0.12l-0.61,0.37l-0.33,-0.55h-0.38l-0.24,0.22l0.22,0.54l-0.59,-0.07l0.22,0.54l-0.18,0.15l-0.55,-0.72l-1.44,-0.47l-1.15,0.49l-0.52,-0.64l-0.34,-0.74l-0.1,-1.69l-0.67,-0.1l-0.89,-2.43l-0.84,-1.35l0.21,-0.6l0.74,-0.45l0.22,-0.71l0,0l3.57,-0.22l1.04,-0.4l0,0l-0.35,0.52L34.63,91l0.42,-0.15l0.31,0.27l-0.13,0.85l0.73,0.29l0.54,-0.19l0.69,0.38l1.08,-1.52l1.09,-0.22l0.65,-1.53l1.49,-0.54l0.28,-0.67l-0.23,-0.35l0.83,-1.59l0.6,-0.05l1.25,-0.75l-0.02,-0.98l0.35,-0.78l2.78,-0.29l1.43,-1.21l0.42,-1.85l-0.11,-0.66l0.49,-0.82l0.31,-2l0.54,-0.63l0.69,0.17l0.6,-0.28l0.93,-1.97L52.4,72.4l-0.45,-0.53l-0.03,-0.54l0.65,-0.65l0.24,-0.88l0.81,-0.06l0.5,-2.35l-0.23,-0.56l-0.98,-0.86l-0.06,-1.05l0.25,-0.24l1.16,0.17l0.17,-0.74l0,0l1.05,0.73l0.57,1.02l1.1,0.02l0.29,0.25l2.37,3.43l0.45,1.61l1.6,-1.38l1.28,-0.47l2.07,-2.13l0.11,-0.7l-0.4,-1.19l0.54,-1.42l0.73,-0.83l0.49,-0.1l0.9,0.5l2.15,-1.11l1.01,-1.56l3.67,-0.15L76.62,59L78.34,58.37z"
				},
				{
					"id":"MY-09",
					"title":"Perlis",
					"d":"M22.8,26.53L23.19,26.66L24,27.72L24.72,27.55L24.9,27.05L25.04,27.72L25.5,27.82L25.73,27.16L26.42,27.13L26.44,28.01L27.61,28.97L27.65,30.77L27.15,31.36L28.78,32.71L29,33.68L29.49,34.06L29.49,34.06L29.22,37.18L28.51,38.07L26.75,39.33L25.85,40.8L22.93,43.97L22.38,45.45L22.38,45.45L21.37,43.97L19.52,39.38L20.46,37.43L20.36,36.81L20.94,36.05L20.82,32.44L21.75,32.66L21.93,32.44L21.2,30.28L21.8,29.32L21.76,28.3L21.43,27.73L22.07,26.83z"
				},
				{
					"id":"MY-10",
					"title":"Selangor",
					"d":"M47.14,144.08l0.76,-1.73l3.01,-0.3l1.35,-0.46l0.1,1.27l1.42,0.69l-0.58,1.04l0.36,0.74l0.57,0.06l0.34,-0.91l0.38,-0.23l1.04,0.01l0.17,0.72l1.1,-0.4l0.11,1.45l0.27,0.02l0.9,-1l0.5,0.96l-0.91,-0.11l-0.03,1.34l0.63,-0.61l0.58,0.39l0.21,-0.43l0.4,0.09l0.5,-0.77l0.34,0.46l-0.27,0.48l0.6,0.22l0.21,-0.46l0.75,1.24l0.88,-0.24l0.78,0.41l1.31,-0.4l-0.08,1.76l1.18,0.26l1.31,-0.27l1.48,-0.85l0.03,-0.96l-0.81,-2.18l0.44,-0.76l0.8,-0.28l1.06,0.45l0.14,0.83l0.33,-0.07l1.81,1.01l0.43,0.93l1.21,0.49l1.92,1.47l0.55,-0.12l0.44,-0.77l0.86,-0.35l0.3,-1.33l0.26,-0.23l0.29,0.14l0.28,-0.38l-0.04,-1.03l0.99,0.05l0,0l1.29,1.67l1.13,0.69l1.83,0.05l0.53,0.27l1.14,1.16l0.82,1.98l0.86,0.9l-0.21,2.02l-1,0.49l-0.95,1.7l0.81,1.57l0.36,1.51l-0.87,1.01l-0.31,1.05l0.7,0.47l1.64,2.53l2.07,1.16l1.15,-0.03l0.83,0.43l0,0l0.48,0.28l0.1,0.85l0.48,0.8l0.15,1.84l0.48,0.98l-0.56,1.75l0.92,2l-0.03,0.66l-1.11,0.68l-2.21,5.01l-0.67,0.81l-4.91,-0.17l0.52,6.1l-0.15,1.26l-0.55,0.95l0.16,0.54l-0.61,0.58l0.06,0.89l-0.86,0.28l-0.05,0.29l0,0l-0.69,0.19l-0.99,-0.9l-2.48,-0.63l-1.26,-0.8l-1.57,-0.37l-2.28,-1.03l-0.85,-0.84l-1.35,-2.59l-0.95,-0.93l0.41,-0.46l0.02,-1.51l0.34,-0.12l0.06,-0.61l0.79,-0.09l0.37,-0.84l-0.1,-0.37l-0.92,-0.47L72,181.33l-0.53,-0.68l0.38,-0.72l0.41,-0.2l-0.3,-0.6l-0.74,-0.26l1.34,-1.13l-0.63,-0.5l-0.44,0.02l-0.4,0.9l-0.67,0.65l-0.25,1.22l-0.33,0.11l-0.53,-0.52l0.39,-1.62l1.06,-1.16l-0.22,-0.54l-0.98,0.05l-0.34,-0.52l0.19,-1.94l-1.98,-2.65l-0.32,-3.45l-0.83,-2.45l-1.68,-1.71l-2.13,-1.23l-0.46,-1.22l-3.24,-4.5l-1.52,-3.78l-0.96,-1.37l-1.94,-1.72l-2.03,-0.61l-0.87,-2l-0.82,-0.94l-1.49,-0.97l-1.54,-0.17L47.14,144.08z"
				},
				{
					"id":"MY-11",
					"title":"Terengganu",
					"d":"M117.81,62.54l2.83,1.96l2.33,3.02l1.53,1.38l2.9,1.89l1.97,1.95l2.88,1.63l0.65,0.16l0.57,-0.28l1.65,1.16l4.75,4.66l3.19,5.09l-0.12,0.58l0.5,0.98l1.28,1.96l2.26,4.67l6.31,11.49l-0.72,0.56l1.12,3.2l-0.42,1.83l1.51,4.6l-1.16,1.09l-0.15,1.19l0.48,1.43l-0.04,1.51l1.52,2.93l-0.85,2.74l-0.46,0.69l-0.74,0.33l0.13,1.86l0,0l-3.1,0.4l-0.75,-0.14l-1.1,-0.71l0.35,2.06l-0.78,1.43l-0.19,1.36l0.99,1.15l0.01,1.88l0.46,1.81l-0.13,0.69l-0.85,0.75l0.36,0.9l-0.43,0.21l-1.48,-2.18l0.21,-0.76l-1.34,-1.21l-0.09,-0.78l-1.2,0.03l-0.64,-0.89l-1.29,0.27l-1.4,-1.07l-1.04,-1.29l-1.11,-0.24l-0.69,-0.71l-1.78,-0.07l-1.01,-0.42l-2.26,1.09l-0.92,-0.51l-0.68,-0.99l0.97,-1.32l-0.27,-1.76l0.71,-1.27l-0.07,-1.17l1.02,-0.97l0.46,-1.33l1.69,-0.26l-0.42,-1.23l0.79,-1.26l-0.14,-0.59l-1.01,-1.84l-0.86,-0.78l-0.73,-0.14l-1.07,0.48l-1.6,0l-1.35,-1.24l-0.52,-2.57l0.92,-0.24l0.24,-0.68l-0.4,-0.58l0.98,-0.42l-1.64,-2.59l-2.57,-0.01l-2.26,-0.54l-0.78,-0.83l-0.75,-0.34l-1.25,-1.75l0,0l0.42,-0.71l-0.72,-1.73l-0.03,-1.12l-1.74,-1.07l-0.61,-0.06l-1.28,-0.94l-1.27,0.14l-0.46,-0.27l0.15,-2.15l-0.47,-1.64l0.54,-1.2L115.47,93l0.97,-1.09l-0.49,-1.01l-1.18,-0.99l-2.83,-1.15l0.28,-1.41l-0.23,-1.16l0.11,-2.36l0.96,-2.62l-2.37,-2.05l0.69,-0.66l-0.35,-3.14l0.65,-1.66l-0.98,-5.45l3.61,-3.32l2.57,-2.94l0,0L117.81,62.54z"
				},
				{
					"id":"MY-12",
					"title":"Sabah",
					"d":"M713.55,29.16l0.54,-0.77l1.35,-0.14l1.4,0.3l1.15,-0.81l-0.49,-0.5l-1.17,-0.29l-0.32,-0.83l0.16,-0.34l1.09,-0.51l1.17,0.31l1.03,-0.46l0.9,1.98l0.65,0.77l0.02,0.79l-0.38,0.56l-0.84,0.55l-1.13,0.17l-0.9,0.63l-1.36,0.13l-0.63,-0.51l-1.44,-0.17L713.55,29.16zM695.66,6.52l-0.42,0.18l0.16,-0.47l0.9,0.09l0.21,-0.59l1.12,0.25l1.03,-0.68l1.26,0.25l-0.25,-0.71l-0.66,-0.66l0.61,-1.22l0.72,0.24l-0.21,0.55l0.36,0.35l0.81,0.28l-0.19,-0.88l0.22,-1.07l-0.63,-1.47l-0.62,0.48l-0.4,1.06l-1.97,1.09l-0.91,-0.35l-0.56,0.55l-0.38,-0.06l-1.36,3.53l0.35,0.38l1.33,-0.7L695.66,6.52zM702.94,8.03l-0.08,0.3l0.57,-0.05l-0.48,0.67l-0.11,1.1l0.68,0.66l-0.08,0.61l0.64,-0.62l0.16,-0.96l2.54,-1.62l1.1,-0.42l1.43,0.2l1.01,-1.45l-0.2,1.4l0.64,-0.03L711.02,7l0.83,-1.02l-0.08,-0.66l-0.72,0.17l-0.13,-0.37l0.71,-0.37l-0.48,-0.07l-0.12,-0.46l0.46,-1.08l0.8,-0.58l-0.46,-1.26l-1.93,-0.61l-1.3,0.49l-0.8,-0.33l-0.68,0.71l-0.58,-0.45l-1.15,1.52l-1.95,0.43l-0.55,0.49l0.34,1.28l-0.61,2.08l0.47,0.13l-0.55,0.62L702.94,8.03zM763.04,112.53l0.54,-1.2l0.53,-0.05l0.32,-0.57l-1.58,-0.86l-0.49,0.37l-0.65,-0.12l-0.12,-0.48l-0.33,-0.01l-0.07,0.6l-0.4,0.2l-0.42,-1.34l-0.79,-0.32l-0.23,-0.71l-1.2,0.65l-0.06,0.83l-3.47,-0.17l-0.93,0.44l0.87,0.47l1.17,-0.12l2.71,0.76l0.36,0.81l0.77,0.11l0.51,-0.46l1.44,0.85l0.72,-0.02l-0.14,-0.35l0.5,-0.47L763.04,112.53zM791.24,86.14l-0.18,-0.85l0.41,-0.48l0.33,-1.33l-0.32,-1.95l-0.63,-1.18l-1.64,-1.63l-1.67,-0.84l-1.99,0.55l-0.38,0.97l-1.61,0.45l-1.94,-0.27l-2.74,-0.96l0.07,2l-1.64,0.28l-1.03,-0.44l2.23,-1.29l-0.54,-0.82l-4.56,-2.88l0.13,1.86l-0.09,0.88l-0.3,0.21L773,76.66l0.27,-0.7l-0.4,-0.64l-3.47,-2.05l-2.31,-2.67l-0.88,-0.54l-1.51,0.83l-0.4,2.22l-0.58,0.76l-0.34,1.25l-0.32,-0.01l-0.3,-0.29l0.31,-1.45l0.84,-1.13l-0.12,-1.56l0.57,-0.03l0.84,-0.64l-0.21,-0.5L764,68.44l-9.09,-5.77l-0.21,0.09l0.3,1.13l-0.27,0.94l-0.86,-1.76l-1.41,-0.18l-1.98,-0.79l-1.01,0.91l-2.52,0.62l-0.28,0.38l0.63,1.63l-0.31,0.46l-0.75,0l-0.37,0.58l0.9,1.42l-0.67,0.49l-0.12,0.49l-0.38,-0.06l-0.26,-1.49l-0.61,-0.19l-0.47,0.58l-0.81,-0.26l0.09,-0.69l-0.44,-0.04l-1,0.4l-0.43,0.62l-1.16,0.64l-1.64,0.06l-0.44,0.5l0.05,-0.48l0.47,-0.47l-0.63,0.1l-0.17,-0.77l0.61,-0.74l-0.1,-0.31l-1.28,-0.16l-0.45,-0.37l0.35,-0.48l-0.7,0.07l-0.4,-0.32l0.96,-0.44l-0.49,-0.75l0.75,-0.31l1.54,0.28l0.29,-0.16l-0.23,-0.29l1.36,0.01l0.77,-0.49l0.36,1.01l0.54,0.12l1.1,-0.71l0.85,-0.08l0.17,-0.67l1.63,-0.59l0.39,-0.47l-1.47,-1.22l0.1,-1.07l-0.74,0.21l-1.24,-0.87l0.76,-1.39l-1.36,-1.65l0.43,-1.44l-1.29,0.38l-0.18,-1.35l-1.01,-0.23l-0.53,0.34l-0.24,0.82l-2.71,2.32l0.31,0.37l-0.38,0.69L735.84,58l-2.11,0.31L731,58.18l-0.02,0.46l0.72,1.32l-0.22,0.74l-0.13,-1.12l-1.47,0.28l-2,-0.48l-2.2,0.54l-1.21,-0.4l-3.82,1l-0.53,0.68l-0.67,-0.08l0.76,-0.82l1.3,-0.28l2.48,-1.28l-0.41,-0.43l-0.13,0.41l-0.25,-0.15l-0.01,-1.2l0.29,0.01l0.27,0.56l0.25,-1.23l0.79,0.09l1.01,-0.85l-0.16,-1.32l0.33,-0.7l0.94,-0.44l0,-0.77l-0.66,-1.21l-0.54,0.13l0.34,-0.59l-0.82,-0.84l-0.65,-1.24l-0.61,-0.33l0.93,-1.19l2.01,-1.32l2.03,0.3l0.18,-0.27l0.84,-2.62l-0.45,-2.21l0.08,-1.25l0.58,-0.65l0.2,-0.89l-4.5,-3.44l-1.01,0.09l-2.16,-1.12l0.25,-0.59l-0.93,-1.12l-0.55,-2.08l-1.98,3.12l-0.41,0.03l-1.46,-0.02l-0.83,-0.42l-0.39,-1.38l-1.34,-0.38l-0.34,-0.47l-0.74,0.5l-0.67,-0.56l-0.38,0.49l-0.73,-0.29l-1.1,-3.41l0.71,-0.6l0.08,-0.5l-1.55,-1.31l-0.45,-1.85l-0.52,-0.52l0.56,-0.58l-0.13,-0.66l0.85,-0.63l-0.09,-0.39l-0.36,-0.04l0.65,-0.63l-0.39,-1.53l0.19,-0.54l-1.58,-0.22l-0.66,-0.36l-0.72,-1.21l-1.09,-1.07l-1.03,0.21l0.18,0.82l-1.25,-0.42l-1.68,0.91l0,0.61l1.05,0.5l-0.52,0.43l-0.8,0.07l-0.08,-0.39l-0.49,-0.28l-0.33,0.24l0.06,2.2l0.95,0.57l-0.2,1.36l0.37,0.01l-0.03,0.21l-1.32,0.41l0.09,0.43l-0.63,1.19l-0.72,0.45l0.04,0.45l-0.76,0.78l-0.07,0.56l0.35,0.48l-0.13,0.71l-1.57,0.96l-0.48,0.6L696.78,29l-1.31,1.67l-0.77,0.2l-0.18,1.39l-1.74,0.69L692,32.94l-1.47,-0.57l0.13,-2.2l1.06,-1.27l1.38,-2.77l1.6,-1.54l-0.27,-0.88l0.22,-1.22l-0.72,-0.6l0.76,-0.73l-1.09,-0.25l-1.24,0.46l-0.45,-0.57l-0.1,-0.77l0.97,0.58l0.64,-0.82l0.97,0.61l0.35,-0.09l0.1,-0.43l-0.96,-1.72l0.12,-0.62l-0.48,-0.85l-0.65,-0.2l-1.4,-1.63l-0.97,-0.92l-0.3,0.01l-0.89,1.94l0,0.86L688.47,17l0.08,1.22l-0.97,1.74l-0.53,0.49l-1.17,0.41l0.17,1.07l0.9,0.34l0.16,0.34l-0.79,0.25l-0.44,1.08l-0.46,0.33l0.61,1.72l-0.02,1.2l-1.09,1.6l-1.67,0.82l-1.36,2.58l-1.85,2.1l0.26,0.27l-0.52,1.59l-2.5,1.9l-3.66,2.04l0.39,0.85l-0.45,0.25l-0.19,-0.37l-0.65,0.52l0.39,0.72l-0.19,0.65l0.46,0.58l-0.38,0.38l-0.74,0.11l-0.3,-0.08l-0.01,-0.65l-0.91,1.01l-1.66,0.62l-0.4,0.85l-1.49,1.33l-0.55,1.35l-1.19,1.74L664.5,51l-1.01,0.38l0.75,1.18l0.58,-0.8l0.52,0.4l-0.84,1.52l-0.02,2.1l-0.44,0.28l-0.46,-0.27l-0.71,0.76l-0.43,0.08l-0.86,3.02l0.42,1.33l-0.61,1.6l-0.85,0.21l-0.25,0.81l-1.38,0.94l-2.75,1.2l-0.32,0.78l-0.51,4.85l-1.02,1.79l-1.74,0.95l-2.07,0.51l-4.1,-0.41l-1.59,-0.58l-0.67,-0.6l0.63,-1.8l-0.17,-0.37l-0.92,-0.26L643,72.3l-1.26,1.94l-2.11,1.61l-2.85,3.06l-0.71,0.44l-0.84,0.09l-0.59,0.58l-0.37,3.02l-0.81,1.02l1.02,0.02l0.36,-0.28l0.19,-0.75l0.77,-0.38l-0.8,1.48l1.38,0.92l0.02,-0.38l0.36,-0.25l0.52,0.57l-0.25,0.81l2.72,1.89l0.58,-0.05l0.46,0.41l1.24,-0.21l-0.07,0.73l0.52,-0.25l0.83,-1.47l0.53,0.26l-0.42,0.63l0.15,0.94l-0.53,0.06l-1.04,1.59l0.1,1.03l-0.32,1.68l-1.44,1.77l-1.71,0.57l-0.58,1.16l0,0L640,97.3l2.4,-1.15l2.04,-0.25l0.44,0.11l0.41,0.64l0.08,1.39l1.22,4.41l-0.04,1.95l-0.84,0.94l-1.38,3.32l-1.67,1.71l-0.35,1.32l0.88,1.45l-0.03,1.05l0.42,0.81l-0.03,0.64l-0.65,0.77l1.29,2.59l-0.25,2.1l0.86,0.74l1.53,0.4l0.82,1.18l0.02,0.81l-1,1.87l-0.38,2.49l0.56,1.99l0.99,0.55l0,0l0.19,-1.22l0.7,-1.38l1.05,-0.06l0.29,-0.59l0.82,-0.34l0.57,-1.1l0.87,-0.01l0.48,0.84l0.87,-0.23l0.33,-1.33l1.68,-1.35l-0.35,-0.99l0.37,-2.43l0.58,-0.41l0.68,0.1l0.94,1.34l2.71,0.28l1.22,0.79l0.4,1.47l1.39,0.83l1.63,-2.49l1.65,-0.44l0.54,-1.63l3.25,0.41l0.86,0.52l3.47,-0.9l1.73,1.08l0.51,0.94l0.59,0.22l0.22,1.22l0.45,0.33l1.25,-0.48l0.51,-1.26l0.74,0.44l1.18,-0.19l-0.15,-1.41l1.34,-1.69l0.67,1.04l1.13,0.44l0.24,1.14l0.33,0.26l1.04,-0.18l0.58,-0.41l0.71,0.33l1.17,0l0.85,-0.51l0.7,-1.26l1.5,1.7l0.89,-0.17l0.84,0.7l1.58,-0.37l1.7,-1.15l0.57,0.38l0.82,0.06l0.66,0.62l1.55,-0.07l0.73,0.92l1.07,-1.08l2.37,0.51l1.47,-0.49l1.35,0.44l1.21,-0.14l0.52,-0.88l1.3,-0.59l2.82,2.58l4.29,2.64l0.59,1.63l0.9,0.78l2.75,0.77l0.46,-0.93l-0.35,-1.97l1.1,-0.9l-0.54,-0.9l-0.05,-1.05l0.35,-0.46l1.37,0.17l0.78,-0.23l0.31,0.69l0.29,-0.02l0.27,-1.78l-0.5,-0.51l-0.24,0.55l-0.85,-1.82l1.35,-0.22l-0.91,-0.42l0.04,-0.23l0.45,-0.17l0.26,0.31l1.62,-0.92l0.7,0.36l0.23,0.49l-0.17,0.75l0.56,0.62l1.1,0.86l0.99,0.14l0.71,0.77l1.42,0.14l0.8,1.01l1.58,0.64l0.96,1.84l0.92,0.2l1.22,-0.38l1.41,0.48l0.49,0.51l0.72,0.05l3.24,-1.31l2.06,-1.28l1.87,-0.46l0.86,0.27l1.1,-0.28l0.95,-0.64l3.18,-0.44l0.5,-0.5l0.06,-0.59l-0.64,-0.07l-0.25,-0.55l1,0.25l0.56,0.84l1.04,-0.2l0.36,0.58l0.38,0.09l3.45,-1.25l2.67,0.36l-0.13,-1.13l0.53,0.33l1.4,-1.14l-0.86,-1.14l1.19,0.23l0.01,0.63l0.37,0.13l1.21,-1.55l-0.97,-1.38l-1,-0.34l-0.07,-0.39l-0.4,-0.03l-0.01,0.32l-0.48,-0.09l0.92,-0.78l-0.08,-0.22l-2.4,-0.4l-1.26,1.74l-0.52,-0.11l-0.43,-0.71l-1.54,-0.96l0.43,-0.33l0.56,0.33l0.47,-0.16l0.47,-1.3l-0.15,-0.28l-0.36,-0.26l-0.52,0.23l-1.15,-1.28l-0.64,0.04l-0.26,0.61l-0.4,0.15l-1.3,-1.21l-0.01,-0.68l-2.6,-0.17l-0.05,-0.92l-1.52,-0.24l-0.4,-0.97l-1.17,-0.82l-1.15,-2.1l-0.36,-2l-0.73,-0.46l-0.3,-0.81l-1.32,-0.04l-0.24,-1.52l0.85,-0.26l0.4,0.25l0.3,-1.29l1.17,-0.43l-0.39,-0.45l0.3,-0.36l1.75,-1.13l1.91,0.27l0.12,-0.7l0.32,-0.07l-0.03,0.75l0.47,0.1l0.51,-1.78l0.75,-0.69l2.25,0.07l1.67,0.58l0.78,0.81l-0.26,0.87l1.06,1.66l1.81,0.01l1.42,-1.54l4.79,1.12l1.99,-0.77l0.15,0.26l0.88,-0.09l2.45,-1.45l2.3,-0.41l1.27,-1.13l0.92,-0.36l7.02,-1.83l3.22,-1.3l2.04,-1.62l1.89,-2.36l-0.12,-1.54L791.24,86.14zM724.77,124.98l-1.22,-0.99l-0.73,-0.03l-0.01,-0.46l-0.46,0.78l0.66,1.5l2.29,1.27l1.39,-1.03l-0.34,-0.94l-0.86,-0.21L724.77,124.98zM770.64,117.49l-0.19,0.6l-0.1,-0.42l-0.52,-0.12l-0.1,-0.32l-0.98,0.03l-0.85,-0.98l-0.89,0.17l-0.91,-0.29l0.42,0.41l-0.5,0.12l0.06,0.31l1.2,1.4l-0.54,1.11l1.17,-0.43l0.51,-0.55l1.46,0.17l0.75,-0.26l0.58,-0.57L770.64,117.49z"
				},
				{
					"id":"MY-13",
					"title":"Sarawak",
					"d":"M437.74,231.08l0.93,0.28l0.85,1.93l-0.18,0.77l-0.28,0.33l-1.29,-0.7l-0.68,0.94l-0.15,0.58l0.62,0.31l0.5,-0.68l-0.06,0.75l0.76,0.12l0.06,0.27l-0.83,0.13l-0.38,-0.42l-1.18,0.48l-0.93,-0.6l-0.35,-1.48l0.55,0.26l0.37,-0.64l-0.36,-0.37l0.88,-0.1l0.31,-0.43l-0.36,-1.21L437.74,231.08zM428.62,228.03l0.47,0.29l0.43,-0.16l0.09,0.45l-0.35,0.62l0.96,0.96l-0.77,0.76l-0.99,0.38l-0.63,-1.79l-1.23,-0.23l-0.26,-0.5l0.31,-0.39L428.62,228.03zM438.28,226.47l0.91,1.07l-1.1,0.65l-0.33,0.99l0.18,0.36l-0.59,0.27l0.15,0.59l0.48,0.13l-0.88,0.3l-0.83,0.71l0.01,0.68l0.36,0.57l-2.04,0.71l-0.44,-0.59l-0.64,0.12l-0.02,-0.63l-0.77,-0.11l-0.51,-1.5l0.54,-0.28l0.63,-0.34l-0.2,-1.25l0.5,-0.18l0.79,0.15l0.69,0.36l0.62,-1.03l0.11,-0.92l1.07,-0.19l0.34,0.48l0.52,-0.08l0.45,-0.27l-0.25,-0.54L438.28,226.47zM431.57,224.21l0.43,0.33l-0.33,0.78l0.66,0.8l-0.09,1.6l0.76,0.56l0.26,1.85l-1.08,0.51l-0.47,-1.06l0.18,-1.25l-0.5,-0.5l-0.67,0.01l-0.54,-0.85l0.7,-0.92l0.01,-0.71L431.57,224.21zM472.96,208.28l0.11,-0.41l0.67,-0.13l-0.07,0.49l0.59,0.33l0.34,0.24l-0.56,0.41l-0.24,-0.41l-0.44,0.01l-0.09,0.82l-1.25,0.66l-0.32,1.42l-1.39,-0.85l-2.01,-0.51l-1.44,0.12l-1.15,0.49l-1.01,-0.88l0.32,-1.11l1.53,-1.03l0.57,-0.97l1.13,1.74l0.77,0.17l0.67,-0.34l0.3,-0.93l-0.26,-2.5l0.91,0.24l1.45,1l0.23,0.89l0,0.83l0.35,0.34L472.96,208.28zM468.39,198.88l-0.2,1.16l0.42,-0.45l2.99,1.32l-1.05,1.24l0.69,0.85l-0.71,0.3l-1.07,1.85l0.24,3.04l-0.96,0.46l-0.3,-0.09l-0.32,-1.05l-0.9,-0.97l-0.48,-0.06l-0.69,0.62l-0.14,-0.38l0.13,-1.97l-0.3,-3.01l0.56,-1.24l0.77,-0.86L468.39,198.88zM474.22,187.65l-0.41,-1.43l0.81,-0.55L474.22,187.65zM471.82,184.23l2.12,3.1l-0.27,1.66l0.17,2.31l-0.26,5.51l0.74,1.17l0.34,2.17l0.71,0.94l-0.29,0.56l-1.42,-0.1l-0.67,0.98l-0.73,-0.89l-0.19,-1.39l-1.55,-1.06l-0.07,-1.4l0.41,-1.89l-1.19,-5.3l-0.02,-2.5l0.33,-1.59l1,-1.83L471.82,184.23zM494.06,181.41l4.62,-0.68l6.37,-1.42l4.76,-1.41l9.26,-1.99l2.45,-0.42l0.66,0.21l1.56,-0.91l2.35,-0.74l9.83,-2.27l3.36,-1.86l0.82,-0.69l1.92,-2.67l-0.75,-0.93l3.98,-3.19l1.62,-2.79l3.78,-3.24l0.6,-0.95l-0.38,-0.65l3.18,-3.4l1.72,-2.89l0.43,-0.95l-0.15,-0.81l0.48,-0.77l4.81,-3.17l5.68,-4.82l2.74,-2.97l2.27,-3.74l4.32,-5.23l1.57,-2.82l0.29,-1.09l-0.4,-0.55l0.92,-1.14l0.53,-2.08l-0.1,-2.32l-1.08,-3.21l0.62,-0.53l5.85,0.29l0,0l1.79,0.62l0.95,1.23l0.48,-0.16l1.19,0.63l1.09,1.41l1.79,3.1l-0.03,1.83l0.85,0.78l-0.5,1.76l0.05,1.31l1.3,0.47l1.13,-0.53l1.4,0.44l0.77,-0.76l0.65,0l0.49,2.08l1.63,3.04l1.43,0.16l0.63,0.65l1.18,2.21l0.97,0.61l1.32,0.22l0.13,0.41l-0.74,1.03l0.66,0.16l1.64,-0.51l1.85,-1.09l2.29,-2.85l1.55,-1.28l0.08,-0.27l-0.88,0.11l0.06,-0.67l2.02,-2.68l0.43,-1.26l-1.42,0.88l-0.01,-0.88l1.36,-1.54l1.05,-2.1l0.06,-1.97l-1.58,-0.46l-0.72,-0.78l-0.57,-7.78l-0.16,-1.01l-0.88,-1.46l0.14,-1.51l0.59,-0.36l1.15,-0.11l0.44,-0.37l0.61,-1.54l0.52,-0.34l4,-0.92l1.24,-2.34l0,0l0.78,-0.39l0.29,0.98l-1.1,1.3l-0.39,2.51l0.43,0.12l0.21,-2.42l0.59,-0.75l0,1.34l1.09,1.24l0,0l-0.54,1.4l0.39,1.27l-0.16,1.11l0.75,3.38l0.52,0.85l1.32,4.26l-0.16,1.3l0.29,2.45l0.47,0.33l1.32,-0.16l2.1,0.76l1.57,-0.12l0.31,0.23l0.21,1.07l1.25,-0.16l0.81,0.49l0.58,0.94l0.47,0.12l0.85,-0.42l0.58,-0.56l0.04,-0.72l-1,-1.5l-2.13,-1.84l-0.4,-1l0.2,-0.69l-0.51,-1.88l-0.02,-1.38l0.63,-0.9l0.18,-1.25l-0.18,-1.15l-1.08,-0.89l0.32,-1l-0.57,-0.82l0.12,-1.44l-0.97,-1.26l0.25,-1.38l-2.36,-1.99l0.08,-0.45l-0.53,-0.15l-0.73,-1.42l0,0l-0.48,-0.37l2.06,-0.72l0.22,-0.41l-0.11,-0.96l1.23,-0.26l0.42,0.32l0.49,1.4l0.5,0.38l1.34,0.28l1,0.66l1.62,-0.16l1.24,-0.82l-0.15,-0.9l0.47,-0.12l1.14,-1.17l0.87,-0.16l0,0L640,97.3l2.4,-1.15l2.04,-0.25l0.44,0.11l0.41,0.64l0.08,1.39l1.22,4.41l-0.04,1.95l-0.84,0.94l-1.38,3.32l-1.67,1.71l-0.35,1.32l0.88,1.45l-0.03,1.05l0.42,0.81l-0.03,0.64l-0.65,0.77l1.29,2.59l-0.25,2.1l0.86,0.74l1.53,0.4l0.82,1.18l0.02,0.81l-1,1.87l-0.38,2.49l0.56,1.99l0.99,0.55l0,0l0.24,0.06l-0.32,2.09l-1.05,3.41l-0.66,1.08l-0.67,0.49l-1.71,0.28l-0.42,0.32l0.7,1.11l1.26,0.78l0.38,0.66l-1.53,4.61l-0.37,3.74l0.37,2.37l0.88,1.11l0.31,2.63l1.48,2.47l-0.99,1.39l-0.7,-1.43l-0.98,-0.12l-1.43,2.83l-0.7,2.52l0.09,2.71l-0.45,1.51l1.72,1.29l-0.04,0.68l-1.88,1.78l-0.05,2.24l-0.33,0.6l-1.06,0.71l-1.99,0.14l-1.39,1.64l-3,0.06l-0.31,-1.26l-1.16,-1.24l-0.55,1.75l-0.97,1.05l-1.45,0.58l-0.7,0.84l-1.07,0.46l-0.35,2.21l-2.24,2.07l-0.08,0.2l0.57,0.34l0.87,-0.01l0.36,0.56l-0.46,0.83l0.04,1l-1.45,1.2l0.54,2.42l-0.26,1l-0.69,0.54l0.02,0.46l0.78,0.97l0.65,-0.05l1.22,-0.74l0.45,0.1l1.54,1.79l0.11,0.85l0.99,0.4l0.04,1.25l-1.75,1.11l-1.32,-0.18l-1.18,0.25l-1.37,1.25l-0.39,1.35l-1.61,-0.03l-1.22,1.45l-1.11,0.69l-0.89,-0.68l-0.49,0.12l-0.64,1.73l0.66,0.83l-0.03,0.39l-1.01,0.49l-0.67,0.76l-4.07,0.38l-0.55,0.31l-0.68,2.87l-0.01,1.82l0.29,0.54l0.89,0.39l0.07,0.59l-0.44,0.56l-0.01,1.22l0.57,1.17l0.41,0.04l1.44,-0.81l1.02,0.49l0.11,0.48l-1.69,1.81l0.06,0.73l1.03,1.13l-0.91,0.82l-1.33,0.06l-1.55,1.81l-1.57,-0.63l-0.98,0.42l0.07,0.96l-1.09,0.85l0.64,1.2l-0.18,0.99l0.32,1.08l-0.36,2.21l-1.11,1.09l-0.85,1.84l-1.93,1.1l-0.39,1.52l0.35,0.94l-0.19,0.89l-1.65,2.41l-1.12,-0.15l-1.72,-1.4l-0.94,-0.06l-2.83,-1.81l-0.33,0.01l-0.66,1.01l-2.81,0.97l-0.82,0.63l-1.91,0.22l-1.4,1.54l-0.4,-0.58l-2.3,-1.68l-1.16,0.34l-1.17,-0.29l-2.41,0.71l-1.62,-0.31l-1.25,0.48l-0.52,0.85l-4.55,1.88l-0.2,0.44l0.4,1.07l-0.85,1.37l-4.13,1.56l-1.72,1.68l-1.32,0.06l-0.31,-0.23l0,-0.88l-0.99,-0.53l-0.71,-1.7l-1.66,-0.82l-1.81,0.33l-1.37,0.51l-0.71,0.65l-0.72,0.08l-1.24,-1.27l-1.07,-0.45l-0.67,-1.34l-3.16,-1.1l-2.11,-0.16l-1.92,0.47l-1.49,-0.5l-0.91,-1.49l-0.62,-0.48l-3.33,1.3l-1.67,0.01l-0.2,-0.97l0.38,-0.67l2.14,-0.95l0.47,-1.57l0.86,-0.91l-0.33,-0.84l-2.46,-0.96l-0.72,0.54l-0.58,0.02l-1.71,-0.18l-0.66,-0.48l-0.97,-0.15l-1.51,1.83l-1.77,-0.1l-0.31,-0.46l-0.98,-0.41l-0.69,0.28l-0.85,-0.3l-2.17,0.4l-0.98,-0.59l-0.81,0.24l-5.51,-0.67l-1.87,1.03l-0.72,1.19l-3.21,0.9l-1.27,-0.09l-1.76,1.4l-2.22,0.55l-0.63,0.42l-0.39,1.39l1.12,0.97l-0.73,2.01l-1.28,1.44l-0.18,1.69l-0.47,0.63l0.22,0.77l-0.15,0.73l-0.66,0.93l0.32,0.8l-0.16,0.51l-0.57,0.28l-1.73,-0.01l-5.8,0.87l-0.73,1.19l-1.51,1.03l-0.51,0.85l-0.32,1.58l-1.52,0.02l-1.27,-0.55l-0.56,0.67l-0.74,-0.78l-1.69,0.37l-0.36,-0.55l-2.03,-0.83l-0.82,0.34l-2.26,1.78l-1.19,0.05l0.06,1.2l-0.29,0.37l-0.88,-0.33l-0.7,-1.83l-1.38,-1.14l-0.66,-0.03l-1.26,0.84l-1.62,0.04l-1.69,-0.95l-3.99,-1.19l-0.71,-0.62l-1.6,0.73l-2.23,0.5l-3.22,0.24l-1.4,0.55l-4.67,0.23l-0.7,0.71l-0.08,0.64l-1.57,1.76l-1.97,0.15l-0.09,0.42l0.37,0.68l-0.26,0.56l-0.67,-0.16l-0.42,-0.72l-0.39,-0.14l-0.45,1.06l-1.42,-0.13l-1.19,0.87l-1.02,0.25l-0.57,-0.23l-0.23,-0.79l-0.4,-0.16l-0.55,1.44l-2.08,0.7l-3.34,-0.93l-1.75,-1.31l-0.4,-0.57l0.17,-0.71l-1.24,-0.31l-0.09,-1.06l-0.48,-0.66l-1.27,0.32l-1.04,-0.51l-2.46,0.03l0.1,-1.99l-0.67,-0.22l-0.69,-1.21l-0.16,-1.16l-1.3,-0.27l-0.07,-1.35l-0.57,-0.91l-1.72,-0.95l-2.14,0.04l-0.55,-0.63l-1.67,0.34l0.04,-0.42l0.92,-0.97l-0.15,-0.79l-2.32,-1.43l-1.02,-0.16l-0.76,-2.55l-0.03,-1.28l-1.42,-1.1l-3.77,-0.1l-0.11,-1.33l0.35,-1l-0.98,0.64l-0.46,-0.12l-0.79,-1.34l-3.56,-3.57l-0.28,-0.64l-0.81,-0.29l-0.56,-0.8l0.5,-3.89l0.66,-1.96l-0.36,-0.39l-2.9,-0.78l-0.74,-1.47l-1.13,-0.49l-0.62,-2.5l0.53,-0.33l0.76,0.04l0.75,-1.62l1.21,-0.73l0.57,-0.9l0.56,-1.69l0.42,0.53l-0.41,1.21l0.8,0.92l-0.65,0.11l-0.03,2.68l1.39,1.57l-0.11,0.63l1.7,0.99l2.04,0.71l0.51,0.41l2.25,0.83l0.36,0.65l1.23,0.72l-0.42,0.9l2.15,1.21l-0.84,-0.15l-0.37,0.29l1.76,0.44l0.84,-0.61l0.67,0.31l0.05,0.64l1.2,-0.81l4.62,-0.01l3.09,-0.32l0.09,0.94l1.76,0.64l-0.01,0.58l0.44,0.39l-0.1,0.42l0.34,0.58l1.88,-1.37l-0.5,-1.41l1.41,-1.05l0.52,0.41l-0.24,1.3l1.11,2.66l0.82,0.18l0,0.58l0.73,0.08l0.07,0.57l-0.43,0.23l0.23,0.34l0.51,-0.14l0.46,-0.8l0.87,0.29l-0.25,0.53l-0.35,-0.32l-0.25,0.19l0.07,1.03l0.23,0.47l1.01,0.64l1.18,-0.42l0.43,0.42l0.91,-0.2l-0.11,-0.38l-0.64,-0.13l0.17,-0.91l-0.52,0.17l-0.29,0.67l-0.4,-0.29l0.04,-0.36l0.66,-0.89l0.95,0.65l0.53,0.01l0.53,-1.47l1.01,-0.47l1.78,0.01l4.88,2.03l0.48,1.28l-0.17,1.3l-3.56,1.77l-0.35,1.08l0.7,0.72l1.83,-0.98l1.76,0.83l-0.8,-0.71l-0.93,-0.36l-1.83,0.98l-0.39,-0.84l4.12,-2.14l0.43,-0.87l0.1,-2.58l0.83,-0.75l0.61,0.01l2.94,1.61l2.65,0.61l1.55,0.95l1.12,0.99l1.19,1.93l1.3,0.97l2.24,0.5l1.91,1.17l0.98,-0.41l0.97,-0.86l1.36,-0.15l0.49,0.39l0.65,1.73l1.63,0.64l0.12,-0.39l-0.65,-1l-0.03,-1.13l-0.48,-0.44l-2.21,-0.67l-1.53,0.36l-1.19,0.82l-1.6,-1.24l-2.76,-1.15l-1.16,-2.46l-0.93,-0.61l-0.75,0l0.21,-0.7l-0.21,-1.26l0.92,-3.18l0.93,-1.08l1.43,0.11l1.02,-0.38l1.74,0.38l0.3,1.43l0.72,0.49l1.55,-0.5l1.14,0.93l1.91,-0.18l-0.82,-0.4l-1.06,0.06l-1.07,-0.91l-1.74,0.42l-0.46,-1.96l-1.28,-0.42l-0.56,-0.76l-0.05,-0.53l-0.91,-0.94l0.68,-1.03l0.99,-0.29l0.34,-0.48l0.18,-0.63l-0.18,-0.12l-0.73,1.06l-0.5,0.05l-0.1,-1.12l2.64,-5.36l0.13,-1.44l1.55,-4.25l0.87,0.84l0.86,0.34l1.22,-0.25l0.81,0.62l0.58,-0.09l1.26,-1.38l0.34,-2.45l0.98,0.48l1.27,-0.43l1,0.59l0.18,-0.23l-1.18,-0.66l-1.28,0.43l-0.4,-0.53l0.15,-0.88l1.12,0.69l0.29,-0.56l-0.17,-0.48l-0.92,-0.56l0.01,-0.46l-0.79,0.13l-0.39,0.39l-0.35,-1.83l-1.78,-1.82l0.94,-1.45l-0.07,-0.45l-0.61,-0.5l0.79,-0.52l1.04,1.32l0.85,-0.11l0.53,-0.99l1.02,0.2l1.06,-0.71l2.16,1.36l-0.54,-0.95l-2.61,-1.93l-0.1,-1.64l-0.86,-1.24l0.86,-0.16l2.22,0.74l1.32,-0.74l0.35,1.34l1.4,0.94l0.57,-0.19l0.37,-1l0.74,0.78l0.49,0.18l0.22,-0.35l-0.73,-0.16l-0.3,-0.67l-0.48,-0.1l-0.86,1.24l-1.14,-0.98l-0.3,-1.31l-0.62,-0.1l-1.17,0.55l-2.64,-1.76l-0.01,-1.2l0.87,-2.77l0.44,-2.72l1.77,-0.84l0.65,-1.05l4.34,-1.98l1.49,-2.22h0.57l0.35,0.78l3.33,1.35l0.14,-0.25l-2.67,-1.36l5.63,-1.33L494.06,181.41z"
				},
				{
					"id":"MY-15",
					"title":"Wilayah Persekutuan Labuan",
					"d":"M624.42,86.91l0.43,0.01l0.1,0.29l-0.42,0.13l-0.5,-0.52L624.42,86.91zM632.92,85.09l-0.07,0.2l-0.79,-0.33l0.38,-0.43l0.4,0.08L632.92,85.09zM629.4,80.44l0.22,0.24l-0.48,0.65l0.04,0.75l1.3,2.48l-0.57,0.48l-0.82,-0.06l0.09,0.56l0.43,0.19l-0.2,0.58L628.77,86l-0.4,-0.95l-0.6,-0.23l-0.63,0.25l-0.87,1l-0.57,0.05l0.48,-1.9l0.91,-1.73l1.56,-1.94L629.4,80.44z"
				}
			]
		}
	}
};