﻿// (c) ammap.com | SVG (in JSON format) map of Italy - High
// areas: {id:"VA"},{id:"SM"},{id:"FR-H"},{id:"MT"},{id:"IT_65"},{id:"IT-77"},{id:"IT-78"},{id:"IT-72"},{id:"IT-45"},{id:"IT-36"},{id:"IT-62"},{id:"IT-42"},{id:"IT-25"},{id:"IT-57"},{id:"IT-67"},{id:"IT-21"},{id:"IT-75"},{id:"IT-88"},{id:"IT-82"},{id:"IT-52"},{id:"IT-32"},{id:"IT-55"},{id:"IT-23"},{id:"IT-34"}
AmCharts.maps.italyHigh={
	"svg": {
		"defs": {
			"amcharts:ammap": {
				"projection":"mercator",
				"leftLongitude":"6.624486",
				"topLatitude":"47.092916",
				"rightLongitude":"18.521301",
				"bottomLatitude":"35.490303"
			}
		},
		"g":{
			"path":[
				{
					"id":"VA",
					"title":"Vatican City",
					"d":"M298.99,371.87L298.88,371.76L298.78,371.79L298.61,371.83L298.45,372.09L298.42,372.15L298.48,372.23L298.54,372.21L298.8,372.27L299,372.19L299.02,372.13L298.98,372.05z"
				},
				{
					"id":"SM",
					"title":"San Marino",
					"d":"M296.55,232.56L296.55,232.56L300.38,232.99L300.77,231.65L300.77,231.65L301.91,230.09L301.59,226.34L297.89,228.82L296.23,228.85L296.51,232.46z"
				},
				{
					"id":"FR-H",
					"title":"Corsica,  France",
					"d":"M143.42,295.38l2.08,1.75l-0.62,1.66l0.92,1.83l1.22,9.13l-1.4,3.35l-0.98,5.98l3.78,6.52l0.74,2.76l0.46,7.67l-0.59,3.89l1.42,6.09l-0.27,10.95l-0.27,1.38l-7.04,10.31l0.09,2.61l-0.85,2.57l0.47,3.94l-0.62,1.45l0.72,2.21l-0.09,3.63l-0.28,1.35l-1.45,1.01l0.84,1.5l-0.94,1.38l-0.8,1.37l-2.39,-0.8l0,0.81l-1.38,0.76l0.34,2.1l1.57,-2.06l2.55,0.92l-1.25,2.21l-3.57,1.95l0.56,0.9l-0.81,1.21l0.99,0.36l-0.18,1.11l-0.93,0.51l0.61,0.42l-2.84,1.48l0.21,1.72l-0.55,0.55l0.31,0.36l2.21,-1.65l-0.3,0.99l-1.98,3.22l-2.11,0.16l-1.17,-1.91l-3.26,-0.12l1.3,-3.3l-2.51,-0.11l-1.56,-0.84l-0.74,-0.31l-2.14,-0.86l-1.16,-1.27l-2.08,0.23l-1.51,-1.85l-0.75,-0.55l-1.71,0.44l0.56,-1.99l-1.64,0.2l-1.77,-0.81l-0.25,-0.72l-0.41,-1.75l0.8,-0.32l0.04,-2.19l0.73,-0.88l0.75,0.83l1.65,-1.28l1.07,0.1l0.48,-1.65l1.71,-0.68l-0.11,-0.7l-3.64,-0.4l-1.55,-1.17l-1.56,0.99l-0.35,-2.83l-3.48,1.34l-0.12,-1.2l-2.35,-0.08l0.09,-0.66l1.23,0.23l2.36,-2.03l0.27,-1.4l0.68,-1.02l1.16,0.01l0.61,-1.43l0.24,-1.23l-0.51,-2.22l1.26,-0.86l-1.06,-1.88l-0.94,0.17l-1.04,0.14l-1.27,0.7l-3.96,-0.15l-1.75,1.13l0.79,-2.83l-1.56,-2.07l2.86,-0.24l1.06,-0.98l-0.74,-1.13l0.29,-0.9l4.47,-2.56l-0.49,-1.09l-0.95,0.14l-0.98,-3.37l-2.09,0.81l-0.66,-1.44l-1.76,-0.92l-1.61,0.46l0.66,-1.06l-0.44,-0.56l-1.41,0.41l0.16,-1.78l1.23,-0.52l-0.2,-1.84l-0.76,0.05l-0.75,-1.52l-0.58,-0.72l7.94,-2.02l-1.77,-2.46l-1.04,0.22l-0.74,-0.91l-1.09,0.47l-0.34,-0.93l1.55,-0.9l-0.6,-1.17l-1.26,-0.27l-1.7,1.45l-0.04,-1.94l-0.75,-0.54l0.22,-0.79l1.12,0.71l0.38,-0.97l1.67,-0.23l-0.17,-2.07l2.55,0.07l0.67,-2.04l0.6,-1.67l-1.6,-0.67l0.92,-2.57l2.25,-1.4l0.63,-1.44l-0.23,-0.94l-0.61,0.05l1,-1.05l0.09,1.62l1.42,-0.7l0.22,0.86l1.51,0.38l1.12,-2.49l-0.44,-0.89l3.33,-0.41l0.61,-1.44l1.66,0.02l0.59,-0.75l4.74,-0.1l2.32,-1.39l0.51,-2.13l0.8,-1.59l1.99,-1.17l2.18,-0.35l1.58,0.83l1.22,-0.74l0.53,1.04l1.31,0.18l0.58,1.14l0.8,1.8l0.71,-0.09l2.36,-4.12l-0.12,-4.1l-1.7,-2.66l1.58,-2.28l-0.94,-2.38l2.02,-1.67l-0.63,-0.38l0.51,-1.08l-0.95,-3.42l0.88,-0.92L143.42,295.38z"
				},
				{
					"id":"MT",
					"title":"Malta",
					"d":"M397.03,760.26l0.3,0.54l-1.33,1.04l2.38,0.22l-0.62,1.41l2.3,-0.96l-0.21,0.78l0.64,-0.44l3,1.72l-0.29,0.48l1.27,0.76l-0.81,-0.02l-0.09,0.91l1.19,-0.62l-1.02,1.49l1.37,-1.14l2.2,1.54l-0.43,3.34l-0.72,-1.24l-1.01,0.92l1.11,0.41l-0.99,0.74l-5.57,-1.2l-4.42,-3.34l-0.42,-1.59l0.65,-0.07l-0.4,-0.93l0.6,-0.77l-0.83,-0.57l0.67,-0.76l-0.26,-0.96l-0.9,-0.13l0.55,-0.96L397.03,760.26zM395.42,758.67l0.66,0.71l-1.36,0.32l-0.08,-0.9L395.42,758.67zM390.08,754.81l3.9,1.41l1.33,1.69l-3.83,1.31l-3.73,-1.43l-0.18,-2.54L390.08,754.81z"
				},
				{
					"id":"IT_65",
					"title":"Abruzzo",
					"d":"M373.96,303.76L375.32,310.1L377.56,315.61L383.83,326.79L390.84,334.5L399.08,340.65L399.95,342.98L403.62,346.51L403.95,347.86L409.51,351.56L414.67,353.39L414.88,358.24L418.31,360.67L418.31,360.67L417.14,362.52L418.05,363.36L415.21,365.32L412.91,368.16L412.09,371.26L409.73,372.92L408.01,376.65L403.25,381.78L401.21,381.41L402,380.77L400.93,376.48L399.83,375.41L397.39,373.79L396.34,375.11L395.77,374.89L394.79,372.7L393.55,372.83L392.61,371.57L389.7,373.95L388.27,376.17L386.05,376.32L385.63,377.22L386.88,380.77L388.4,381.66L387.98,382.69L387.13,382.56L386.88,381.55L386.21,382.79L384.22,382.84L383.59,385.48L382.8,383.41L381.64,383.5L380.77,385.9L379.44,385.95L379.16,387.41L377.29,386.43L375.19,386.95L375.19,386.95L372.7,383.68L370.74,383.87L368.34,382.46L367.31,383.11L365.98,382.71L364.23,379.4L362.91,380.13L361.84,378.95L360.06,378.46L359,380.55L354.95,381.9L353.47,380.97L352.74,379.16L350.9,378.73L349.42,377.3L347.69,376.6L346.29,377.96L345.29,374.33L346.57,372.04L345.57,370.63L344.56,370.81L342.58,368.53L341.68,368.9L334.03,364.41L332,363.69L331.98,364.93L329.6,364.29L328.19,362.04L328.34,357.12L329.12,357.48L331.2,355.7L331.25,353.31L332.98,353.18L339.54,356.71L340.78,355.94L342.47,356.56L343.54,354.33L345.04,354.04L344.51,353.33L346.34,353L344.41,351.78L344.11,350.15L341.68,349.31L339.1,346.77L338.45,343.49L334.71,341.01L336.79,338.68L332.8,334.94L335.98,332.52L335.88,330.14L334.88,328.28L335.91,327.7L336.67,324.94L339.42,325.98L340.03,325.25L341.38,325.25L341.96,326.23L343.46,325.46L345.72,325.77L347.07,324.6L347.83,321.17L345.84,320.54L344.69,319.17L345.23,317.49L345.23,317.49L345.23,317.49L345.23,317.49L345.23,317.49L345.23,317.49L346.89,317.97L348.77,316.64L349.34,317.1L349.94,314.73L352.31,314.34L352.61,311.85L353.95,310.36L354.19,308.92L356.27,310.05L358.64,308.94L359.31,309.88L360.66,309.71L362.67,308.77L363.13,306.56L363.81,306.18L366.59,306L368.7,304.59L373.69,303.52L373.69,303.52z"
				},
				{
					"id":"IT-77",
					"title":"Basilicata",
					"d":"M457.12,429.87L456.79,428.64L458.13,427.41L460.08,427.03L464.73,427.81L467.24,426.91L468.69,427.96L470.38,427.05L470.22,426.1L471.89,425.67L471.71,424.91L472.53,425.2L473.95,424.35L476.25,426L477.99,426.3L478.23,427.33L479.49,427.63L480.1,429.98L480.72,429.56L482.56,431.06L481.92,432.1L482.22,433.65L480.43,435.7L478.92,435.43L479.53,436.56L485.12,438.94L486.71,440.45L488.85,438.49L490.85,439.14L493.79,445.6L500.35,451.65L501.13,453.39L502.66,453.81L506.14,449.77L508.18,452.24L508.12,450.35L509.09,450.09L509.94,451.42L510.05,449.68L511.74,450.41L512.75,449.77L512.92,450.76L514.09,451.46L514.63,450.72L517.55,452.94L516.52,453.45L517.74,454.86L516.84,458.48L517.76,460.53L517.13,460.99L516.7,463.88L517.66,464.89L517.22,465.7L518.38,466.58L517.42,468.66L518.28,469.6L519.98,469.17L521.75,470.24L522.12,471.86L523.86,473.33L524.64,475.19L524.64,475.19L520.7,480.83L515.89,491.19L513.6,492.86L513.6,492.86L510.88,491.91L507.76,492.88L504.68,491.86L502.77,492.23L502.11,491.12L501.48,492.59L501.7,495.43L500.67,497.65L500.93,499.65L497.88,505.09L498.99,506.23L498.55,507.55L496.41,505.16L494.41,504.98L491.48,505.64L491.46,507.39L488.68,506.12L487.64,507.2L482.84,507.46L481.29,505.72L481.66,505.1L480.81,503.5L482.05,501.27L480.89,500.95L479.4,501.8L478.71,500.84L476.86,500.54L475.43,501.77L474.81,500.9L473.88,501.39L472.98,500.45L471.3,500.63L468.95,503.16L468,505.76L468,505.76L466.21,502.21L464.11,500.29L463.97,498.81L462.29,497.83L462.29,497.83L463.98,496.82L462.71,495.44L463.92,495.1L465.48,492.98L465.16,490.07L466.78,488.42L466.64,487.42L470.11,485.94L469.59,484.71L470.52,483.88L470.48,482.46L469.87,481.31L466.94,480.46L466.8,479.14L465.16,477.63L465.11,475.07L463.01,474.31L461.41,472.17L459.35,471.14L458.87,469.41L456.7,467.7L457.42,466.62L456.07,463.41L456.77,462.59L452.42,459.96L453.15,457.94L454.8,456.93L454.86,456.12L448.93,452.27L449.1,447.42L448.28,447.35L448.5,446.17L446.44,444.9L448.54,444.75L448.66,442.61L447.64,442.09L448.07,441.43L452.86,442.51L453.5,442.16L453.27,441L456.23,439.71L458.49,433.84z"
				},
				{
					"id":"IT-78",
					"title":"Calabria",
					"d":"M468,505.76l0.95,-2.6l2.35,-2.52l1.68,-0.18l0.9,0.93l0.93,-0.49l0.62,0.87l1.43,-1.23l1.86,0.3l0.69,0.96l1.49,-0.85l1.16,0.31l-1.24,2.23l0.85,1.6l-0.37,0.62l1.55,1.74l4.8,-0.26l1.04,-1.08l2.78,1.26l0.02,-1.75l2.93,-0.65l2,0.18l2.14,2.38l0.44,-1.32l-1.1,-1.14l3.05,-5.44l-0.27,-2.01l1.03,-2.21l-0.21,-2.84l0.63,-1.46l0.66,1.1l1.91,-0.37l3.09,1.02l3.12,-0.97l2.72,0.95l0,0l-1.91,2.44l-0.34,2.63l1.36,5.79l-4.6,5.83l-2.5,4.63l0.04,2.92l2.01,2.32l-0.55,3.46l5.08,3.01l8.04,0.12l4.72,5.33l4.69,2.87l3.47,0.89l0.78,2.06l2.14,2.06l3.92,1.35l-2.36,5.88l-0.25,3.69l2.17,3.18l-1.96,6.55l1.44,1.88l-0.31,0.95l0.72,1.14l3.06,1.45l-2.16,1.96l0.25,2.8l-3.82,4l-0.27,-1.1l-1.41,-0.51l-2.11,0.76l-2.14,-2.17l-4.69,0.74l-5.72,2.13l-8.75,5.42l-3.65,6.55l1.15,2.04l1.31,13.66l-0.46,2.82l-5.65,5.88l-7.24,3.06l-8,10.12l-1.01,6.78l-2.54,4.83l-1.69,2.1l-3.34,0.54l-4.03,-0.94l-8.19,0.77l-4.24,-2.41l-2.17,-4.07l1.07,-1.52l-1.27,-3.39l1.26,-2.9l-1.12,-3.36l0.05,-2.72l4.1,-1.68l1.89,-0.06l2.58,-1.46l1.25,-2.17l0.46,-3.18l1.15,-1.04l0.8,-2.74l1.47,-1.34l0.73,-1.94l0.75,-4.87l-5.32,-4.76l0.48,-1.82l1.81,-1.72l4.22,-1.4l1.74,-1.83l2.46,-0.3l3.42,1.02l1.73,-0.5l2.42,-1.9l1.98,-6.48l-0.29,-5.12l-3.09,-1.5l-3.02,-5.58l-1.62,-7.27l-0.78,-10.46l-2.75,-9.07l-3.65,-5.7l-2.64,-1.89l-2.12,-7.35l-0.91,-0.75l-1.4,-8.79l-0.96,-1.69l1.15,-1.94L468,505.76z"
				},
				{
					"id":"IT-72",
					"title":"Campania",
					"d":"M389.63,463.3l2.01,0.24l-0.69,0.92l-2.93,0.41l0.13,-1.63L389.63,463.3zM371.32,449.83l4.41,1.2l0.53,0.77l-0.69,2.07l-2.82,0.03l-0.31,0.6l-1.98,-1.04l-0.04,-1.87L371.32,449.83zM376.92,402.16l1.52,0.77l-0.28,1.52l2.06,2.45l2.15,-0.48l1.3,0.86l-0.27,-2.42l-1.37,-1.67l2.2,-4.03l2.29,1.91l0.39,-1.38l3.45,0.06l0.21,0.85l1.77,0.01l0.27,1.02l2.03,1.09l8.01,2.34l0.38,1.59l1.19,0.91l3.34,-0.52l1.22,1.76l2.19,-1.95l1.05,-0.06l-0.04,-0.94l1.97,-0.24l0.94,0.74l1.88,-0.58l1.72,-2.89l4.01,1.7l1.57,-1.59l2.65,-0.22l2.98,-2.1l0,0l1.81,2.84l2.86,0.8l0.19,0.8l-0.82,0.78l0.54,1.2l-1.06,0.18l-0.84,1.17l0.62,2.62l2.97,1.06l0.21,2.17l3.42,-0.14l1.04,1.48l1.62,-0.32l1.26,1.43l-1.61,1.02l0.85,2.38l-2.02,1.2l-0.81,1.99l1.57,0.77l0.73,1.89l2.01,1.44l1.1,-0.9l2.83,1.19l1.7,-1.29l2.1,1.8l1.57,-0.14l3.6,1.8l0,0l1.37,3.97l-2.26,5.87l-2.96,1.29l0.23,1.16l-0.64,0.35l-4.79,-1.09l-0.44,0.67l1.02,0.51l-0.12,2.15l-2.1,0.15l2.06,1.27l-0.22,1.17l0.83,0.07l-0.17,4.85l5.93,3.85l-0.06,0.81l-1.66,1l-0.73,2.02l4.35,2.63l-0.69,0.82l1.35,3.21l-0.72,1.08l2.16,1.71l0.49,1.73l2.06,1.03l1.6,2.14l2.1,0.76l0.05,2.56l1.65,1.51l0.14,1.32l2.93,0.85l0.61,1.15l0.04,1.43l-0.93,0.83l0.52,1.23l-3.47,1.47l0.14,1l-1.61,1.65l0.32,2.91l-1.56,2.12l-1.2,0.34l1.27,1.37l-1.7,1.01l0,0l-0.86,-1.96l-2.78,-0.38l-3.58,0.94l-4.24,4.87l-3.39,-0.57l-2.03,-1.98l-2.21,0.55l-0.19,-0.63l0.86,-0.65l-0.69,-2.23l-3.31,-3.18l-1.48,-0.22l-2.51,-3.03l-4.68,0.06l-2.65,-3.3l-3.68,-1.14l-0.62,-1.06l1.98,-1.5l0.1,-4.01l2.61,-1.5l0.01,-2.94l-6.05,-12.56l-5.33,-5.6l-2.73,0.42l-1.36,2.13l-3.34,-0.97l-2.71,2.4l-2.35,0.41l-2.43,-1.33l-8.06,3.87l0.78,-4.1l3.16,-0.63l0.43,-1.47l3.58,-2.46l-1.08,-3.17l-3.1,-0.98l-3.54,-3.89l-2.76,-1.84l-2.65,1.11l-1.84,2.38l-1.47,-0.22l0.78,-0.38l-0.71,-1.02l-3.35,-0.96l-1.1,0.78l0.85,2.69l-2.25,-0.76l-0.01,-4.52l-1.12,-3.93l-2.65,-4.23l-0.06,-0.15l-2.41,-2.6l-1.4,-4.83l-3.56,-5.82l-3.19,-3.21l0,0l0.55,-1.32l3,-0.58l0.5,-0.77l-0.65,-0.24l0.1,-1.03l3.11,-1.11l-1.03,-4.47l0.82,-1.5l-1.32,-2.22l2.15,-0.37l3.05,-2.77L376.92,402.16z"
				},
				{
					"id":"IT-45",
					"title":"Emilia-Romagna",
					"d":"M314,227.91l-1.17,3.09l0.23,4.13l-2.52,0.99l-0.54,2.1l-2.92,-0.36l0.19,-1.04l-0.8,-0.31l-0.69,-2.51l-2.72,1.13l0,-2.14l-2.27,-1.32l0,0l1.13,-1.56l-0.32,-3.75l-3.7,2.48l-1.66,0.04l0.28,3.6l0,0l0,0l0,0l1.21,2.22l-1.62,-0.01l-0.34,-0.82l-1.99,0.79l-1.01,3.47l-2.6,2.09l-0.2,2.17l0,0l-0.04,-0.03l0,0l-1.64,0.89l-2.03,-0.37l-0.83,1.97l-1.55,-2.31l-1.44,0.8l-1.41,-0.16l0,0l-1.72,0.9l-1.11,-1.27l0,0l-0.92,0.25l-1.46,-0.9l-1.06,0.42l0,0l-1.63,-1.05l-0.21,-0.97l0,0l-1.35,-0.18l-0.52,-1.29l-4.66,-0.21l-2,-2.41l-3.58,-2l0.27,-3.06l-1.82,-1.22l0.33,-1.63l-2.17,-2.08l0.25,-1.15l0.67,0.09l-0.2,-1.09l1.68,-0.64l0.43,-1.99l2.03,-2.19l0.34,-2.69l-5.47,1.1l-2.65,-0.36l1.45,-2.1l-0.19,-1.04l-2.6,-0.53l-1.03,1l-1.2,-0.26l-1.73,-1.97l-1.39,-0.38l-0.34,-2.14l-1.33,-1.2l-2.46,2.39l-2.49,0.26l-0.2,1.07l-2.28,2.07l-3.99,0.14l-0.11,0.94l2.93,1.7l0.25,1.08l-2.54,0.16l-3.09,-0.89l-3.34,1.45l-2.76,-0.32l-1.55,-1.15l0.62,-1.04l-0.4,-0.91l-4.86,5.46l-0.66,-0.3l0.32,-0.95l-0.68,-0.91l-2.28,-0.5l-4.97,-4.03l-5.57,-0.13l-1,1.23l0.07,1.35l-1.67,0.42l-3.42,-3.05l-0.24,-1.55l-1.74,-1.6l0.05,-1.38l-1.22,-0.67l-1.67,0.29l-2.95,-3.04l-1.6,-0.03l-2.19,-1.23l-2.38,1.19l-5.63,-5.95l-2.44,0.51l-4.28,-2.94l-1.13,-1.26l0.54,-2.62l-1.05,-0.21l-0.5,-1.24l-2.43,-0.87l-5.35,0.59l-3.41,5.37l-3.6,2.09l0,0l-1.42,-3.32l-2.7,-1.99l-1.05,0.65l-1.41,-0.87l-0.35,0.96l-2.78,0.27l-0.94,1.13l-0.26,-1.17l-1.65,0.39l1.54,-4.51l1.32,-0.21l0.48,-3.42l-0.86,-2.09l-3.23,-1.11l-0.79,-1.73l-2.44,1.79l-3.15,-2.55l-0.44,1.05l-2.1,-0.35l0.34,-0.84l-0.59,-0.63l-2.26,0.44l0,0l-0.03,-5.08l0.49,0.19l0,0l1.75,-0.11l-0.32,-2.02l1.31,2.51l3.23,-0.85l-0.71,-1.39l0.89,-1.04l-0.15,-1.22l-1.74,-0.93l-0.3,-1.1l3.85,-3.88l-1.07,-3.25l-0.97,-0.82l-0.73,0.4l-1.75,-1.61l1.25,-1.64l-0.6,-1.02l1.66,-0.42l1.37,-4.05l1.64,-1.75l-0.12,-2.18l2.05,-1.84l-0.11,-0.67l1.23,0.18l0.32,-0.81l2.84,-0.72l1.57,1.86l1.13,-1.03l-0.63,-2.73l0.73,-0.12l1.6,2.14l1.28,-0.54l0.65,-1.91l0.92,1.25l-0.15,2.5l4.18,1.79l1.62,-1.42l0.5,-1.01l-0.75,-1.09l0.87,-0.27l0.83,1.54l1.85,0.95l0.37,1.86l0.93,-3.21l1,0.03l1.01,1.48l0.88,-0.39l0.2,-1.16l-1.13,-1.59l1.8,-1.46l0.73,0.61l-0.38,2.19l2.88,-2.21l0.89,0.09l1.88,2.45l-0.44,1.49l1.52,1.23l0.07,1.22l1.49,-0.35l0.8,1.74l3.33,-1.56l0.53,0.93l2.22,-0.06l3,2.37l1.6,0.04l2.83,2.27l2.45,-1.34l1.47,2.92l4.57,2.23l3.94,-0.17l1.45,-0.84l2.86,-4.12l0.45,1.62l1.8,-2.07l0.97,3.12l4.41,0.72l0.75,0.79l0.88,-0.16l0.08,0.75l1.34,-0.17l-0.2,0.58l1.46,-0.9l1.35,0.22l0.23,-1.15l2.32,-1.19l3.12,0.26l0.93,-0.79l2.65,0.64l1.22,1.55l0.55,-0.65l3.89,-0.31l0.36,-0.66l1.48,1.05l1.67,-1.59l6.23,0.92l0,0l0.16,1.49l5.7,-0.37l2.1,1.41l0.43,1.62l0.71,0.25l1.24,-0.12l2.02,-1.9l3.19,-0.89l0.74,-2.22l2.92,-1.36l6.27,0.08l2.21,-0.78l6.7,1.07l2.29,3.08l1.48,-0.97l0.81,1.05l2.15,0.17l1.46,-1.29l1.08,-0.01l0.83,1.08l-0.63,1.24l0.33,2.89l0.64,0.95l1.99,0.51l0.6,2.18l0,0l-0.65,0.17l-1.19,-1.84l-1.19,-0.36l-1.73,2.28l1.26,-0.5l-1.66,4.37l-0.59,4.98l0.48,3.31l1.96,3.83l-0.11,8.84l1.77,4.76l0.21,3.39l2.05,7.15l1.76,3.53l6.71,7.82l2.52,1.69l5.97,6.43L314,227.91zM284.58,239.22l-0.27,1.13l1.37,1.59l2.18,-1.12l-0.3,-1.1l0,0l-0.21,-0.47L284.58,239.22z"
				},
				{
					"id":"IT-36",
					"title":"Friuli-Venezia Giulia",
					"d":"M316.33,34.01l1.93,0.64v1.43l0.7,0.37l4.11,-0.3l6.15,1.19l1.94,-0.54l4.17,1.02l3.66,2.76l1.7,-0.71l2.55,0.71l1.18,-1.28l1.33,0.15l0.11,-0.91l1.84,0.52l-0.1,0.8l0.96,0.31l3.9,-0.7l0.77,1.44l2.21,-0.33l0.6,1.02l2.4,-0.29l4.98,1.57l-1.5,6.1l-1.9,-0.65l-2.92,0.74l-1.37,2.85l-4.88,2.76l-1.57,0.07l0.02,2.67l-3.36,2.08l2.47,4.57l-0.58,1.71l1.83,-0.18l-0.07,-0.92l1.81,0.06l0.99,0.71l1.43,-0.24l1.59,1.05l0.64,1.48l3.2,-0.5l1.42,0.81l-1.03,3.22l-3.57,3.45l-3.77,2.39l0.3,2.27l-1.57,1.61l3.05,2.85l1.64,-0.23l1.33,-1.49l2.58,0.34l-0.28,3.48l-3.14,6.06l1.04,3.26l1.33,0.89l2.38,-0.38l3.98,3.37l2.52,0.67l3.6,6.29l2.79,2.03l-4.12,3.68l-2.16,0.14l-2.47,-1.3l-1.5,0.37l-0.09,-0.93l0.78,-0.42l2.71,0.85l1.21,-0.96l-1.43,0.05l-0.46,-1.56l-1.01,0.22l-0.59,-0.66l1.23,-0.94l-0.72,-2.06l-6.15,-6.59l-2.5,-0.73l-1.13,0.37l-0.56,-0.8l-1.37,1.48l-0.19,1.66l1.76,1.42l-3.36,1.62l-0.8,-0.27l-2.12,2.06l-2.42,0.23l-5.13,-2.76l-1.84,-0.3h-0.31l-0.09,-0.07l-4.23,1.12l-2.88,4.42l0,0l-1.07,-0.6l0.12,-0.61l-0.98,0.12l0.17,-1.32l-1.01,-0.8l0.37,-0.8l-0.79,-0.2l-0.57,-2.67l-0.97,0.71l0.35,-1.17l-0.65,-1.3l0.49,-0.26l-2.03,-1.93l1.09,-0.64l-0.82,-0.34l0.18,-0.82l-0.39,-0.37l0.04,-0.31l-0.58,-1.58l-0.59,0.24l0.45,1.42l-1.55,0.5l-0.49,-1.09l-1.52,0.94l-1.25,-1.14l0.4,-1.1l-0.64,-0.07l-2.17,1.09l-0.55,1.04l-0.63,-0.73l0.43,-1l-1.13,-0.84l-1.98,2.1l-0.67,-0.67l-3.88,3.59l-0.05,-1.62l-1.12,-0.52l-0.12,-0.89l-1.24,-0.66l-0.68,1.61l-2,-1.05l0.22,-1.2l-1.39,-1.26l-1.26,-4.53l-1.48,-0.01l-1.04,-1.51l-1.43,-0.04l-0.02,-3.47l-0.71,-2.6l-0.92,-0.8l1.77,-2.81l2.9,-1.96l0.45,-3.58l-2.42,-1.95l-0.3,-2.13l-1.83,0.1l-0.26,-1.58l-2.08,0.02l-2.12,-2.85l1.8,-1.88l-0.04,-1.99l1.04,-0.84l1.91,0.27l0.33,-2.02l1.83,-0.93l-0.18,-0.6l0.6,0.27l-0.32,-1.38l2,-1.76l0.28,-1.75l1.48,-2.04l0.41,0.43l1.57,-1.25l1.85,0.79l1.04,-0.79l1.82,0.78l-0.39,-1.74l-1.23,-0.8l0.12,-0.94l3.46,-2.18l2.55,-0.06l-0.88,-1.16l0.7,-2.27l-0.97,-1.66l0.19,-1.8l0,0l1.65,-0.91L316.33,34.01z"
				},
				{
					"id":"IT-62",
					"title":"Lazio",
					"d":"M325.06,439.36l-0.25,1.32l0.57,0.19l-1,1.15l-0.18,-2.82l2.24,-1.01L325.06,439.36zM376.67,400.02l1.01,0.85l-0.76,1.3l-0.75,-0.03l-3.04,2.77l-2.15,0.37l1.32,2.22l-0.81,1.5l1.03,4.47l-3.11,1.12l-0.1,1.03l0.65,0.24l-0.5,0.77l-3,0.58l-0.55,1.32l-2.81,-2.02l-1.22,0.6l-2.81,-1.15l-2.95,1.66l0.11,1.46l0.9,0.6l-2.04,0.07l-8.94,-5.21l-4.34,-1.04l-1.64,1l-2.32,-0.12l-2.92,0.93l-3.31,3.15l-2.41,-0.19l-2.93,-6.73l-3.66,-3.89l-3.6,-1.99l-3.37,-0.34l-0.81,0.63l-4.82,-3.23l-1.7,0.28l-0.14,0.71l-0.87,-0.37l-3.32,-5.86l-7.08,-8.45l-3.68,-3.12l-6.21,-2.83l-0.93,-5.9l-3.13,-5.75l-4.83,-2.83l-1.3,-1.94l-2.56,-0.98l-0.57,-1.21l-2.34,-1.48l-4.27,0.63l-1.67,-3.89l-3.04,-4.01l-0.18,-1.88l-2.12,-4.27l-2.25,-3.16l-5.44,-4.43l-5.13,-2.45l1.86,-4.15l6.8,-0.08l-0.09,-3.43l-2.79,-1.91l1.37,-1.94l-0.45,-1.76l0.62,-0.33l1.14,1.05l0.67,-0.89l0.81,0.23l1.74,-0.88l0.21,-1.08l1.5,-1.11l1.29,0.25l0.91,-2.14l1.37,0.19l1.4,-0.92l-0.08,-1.08l-1.05,-0.48l-0.41,-2.62l1.23,0.01l1.04,-2.36l-3.78,-2.96l1.16,-2.44l1.21,0.47l0.7,1.32l0.51,-2.01l1.63,-1.07l2.48,0.14l1.62,3.89l2.78,1.8l-1.01,1.98l-1.85,1.04l1.29,2.11l4.14,2.56l3.68,-1.31l1.01,1.07l0.12,-0.75l0.67,0.22l1.38,-1.19l1.63,0.68l1.67,2.06l0.55,4.47l1.67,0.78l-0.21,1.96l1.04,0.85l-0.75,0.67l1.52,0.8l-0.69,0.46l1.87,-0.21l1.23,1.26l2,-1.62l1.47,0.16l-0.25,1.86l0.74,0.68l-0.68,0.23l-0.01,2.06l2.29,0.8l-0.97,1.42l3.64,-0.52l-0.05,1.68l0.87,1l4.33,-3.36l0.22,-3.88l1.19,-0.08l0.89,1.86l1.21,-0.05l2.99,-1.97l-1.37,-2.04l3.06,-0.88l0.17,-1.33l2.05,0.1l1.85,-1.63l2.09,-0.67l-0.62,-2.55l0.58,-1.17l2.02,0.99l0.8,-0.97l3.25,0.04l0.71,-1.53l2.06,1.08l2.8,-1.72l0.05,-0.78l1.62,0.64l1.33,-1.28l0.75,-4.45l3.28,0.79l0.54,-1.17l1.09,-0.1l3.68,3.16l-0.54,1.69l1.15,1.36l1.99,0.63l-0.76,3.44l-1.35,1.17l-2.26,-0.32l-1.5,0.77l-0.58,-0.97l-1.35,-0.01l-0.61,0.73l-2.75,-1.03l-0.76,2.76l-1.03,0.57l1,1.86l0.1,2.38l-3.18,2.42l3.99,3.74l-2.09,2.34l3.74,2.47l0.65,3.29l2.58,2.54l2.42,0.83l0.3,1.63l1.94,1.22l-1.83,0.33l0.52,0.7l-1.49,0.29l-1.07,2.23l-1.69,-0.62l-1.24,0.77l-6.56,-3.53l-1.73,0.13l-0.05,2.4l-2.08,1.78l-0.77,-0.36l-0.15,4.92l1.4,2.25l2.39,0.64l0.02,-1.24l2.03,0.72l7.65,4.49l0.89,-0.37l1.98,2.28l1.02,-0.19l1,1.41l-1.28,2.29l1,3.63l1.4,-1.36l1.73,0.7l1.48,1.43l1.84,0.43l0.74,1.81l1.48,0.93l4.05,-1.36l1.07,-2.09l1.77,0.49l1.07,1.18l1.33,-0.73l1.75,3.31l1.33,0.4l1.02,-0.66l2.4,1.42l1.96,-0.19l2.5,3.27l1.99,1.72l1.4,3.59l0.1,1.37l-0.68,0.64l1.37,1.51l-0.22,0.95l-0.85,0.18l1.22,1.06L376.67,400.02zM299.02,372.13l-0.04,-0.08l0.01,-0.18l-0.11,-0.11l-0.09,0.03l-0.17,0.04l-0.16,0.26l-0.03,0.06l0.07,0.08l0.06,-0.02l0.26,0.06l0.2,-0.08L299.02,372.13z"
				},
				{
					"id":"IT-42",
					"title":"Liguria",
					"d":"M165.5,222.33l-0.4,0.99l-0.62,-0.99L165.5,222.33zM55.67,221.16l0.79,0.27l1.55,-1.67l-1.31,0.02l-0.91,-1.44l0.47,-1.54l1.94,-1.07l9,2.88l1.64,-0.87l1.96,0.69l0.44,-0.73l-0.56,-0.87l-1.31,-0.61l1.84,-1.52l1.53,1.02l1.42,-0.49l1.18,-1.54l-0.05,-1.94l-1.46,-1.28l0.73,-1.7l-0.86,-1.1l1.25,-1.23l-1.27,-1.31v-1l0.43,-0.54l1.46,0.65l0.3,-2.17l1.29,0.16l0.98,-1.61l-0.24,-1.99l3.19,-1.76l0.75,-1.93l-1.37,-3.28l1.38,-0.45l-0.04,-1.9l1.55,-1.24l0.98,1.53l1.85,0.19l3.08,2.61l1.31,-0.71l0.56,-2.2l0.81,-0.38l1.47,1.05l1.14,-1.71l0.35,0.86l3.2,-0.12l1,0.75l2.74,-3.03l-0.79,-0.91l1.23,-1.93l3.56,0.2l1.62,0.24l1.79,2.94l-0.3,0.9l0.86,-0.04l0.38,2.2l1.27,-0.46l-0.36,-1.48l1.74,-1.46l-0.02,-1.47l2.28,-0.29l0.88,1.18l1.44,-0.77l-0.3,-3.72l-1.44,-1.56l1.56,-1.26l0.64,-1.66l1.61,-0.24l0.72,1.02l2.28,-0.25l1.6,3.43l1.44,-0.29l1.46,0.85l-0.05,1.48l1.63,1.21l3.52,-1.46l-0.06,-1.46l0,0l2.26,-0.44l0.6,0.63l-0.34,0.84l2.1,0.35l0.44,-1.05l3.15,2.55l2.44,-1.79l0.79,1.73l3.23,1.11l0.86,2.09l-0.48,3.42l-1.32,0.21l-1.54,4.51l1.65,-0.39l0.26,1.17l0.94,-1.13l2.78,-0.27l0.35,-0.96l1.42,0.87l1.05,-0.65l2.7,1.99l1.42,3.32l0,0l1.32,-0.19l1.01,2.58l4.03,3.13l2.59,1.06l0.09,2.57l0.81,0.7l-0.43,2.73l2.08,-1.75l1.47,1.02l-0.75,0.06l-1.24,1.98l3.93,-0.13l0.2,2.36l0.94,1.39l-0.49,1.23l1.78,-1.5l2.37,1.47l-0.27,1.38l-2.22,2.55l0,0l-1.58,-0.27l-1.19,0.87l-2.95,-2.2l0.05,-0.92l-1.35,-0.01l-1.99,-2l-1.29,0.79l1.3,1.62l-0.24,0.59l0.75,-0.13l-1.05,1.4l-4.76,-3.11l-1.9,-2.46l-2.44,-1.28l-1.12,0.82l-1.35,-2.56l-2.04,-0.9l-0.91,-1.69l-2.12,-0.8l-0.93,-1.42l-2.36,-0.08l-1.4,-1.45l-0.66,0.47l-1.62,-2.79l-7.03,-3.96l-1.09,1.04l0.12,2.41l-3.64,-1.69l0.52,-1.78l-0.69,-0.96l-10.67,-2.7l-0.65,-1.06l-0.59,0.44l0.41,0.67l-4.54,-1.23l1.17,-0.21l-0.92,-0.37l-2.38,-0.11l0.27,0.52l-2.06,-0.48l-2.07,0.8l-1.53,1.47l-1.83,0.35l-1.47,1.54l-5.94,3.02l-0.77,1.01l0.7,-0.14l-3,2.75l0.76,1.01l-1.92,2.55l0.38,2.04l-8,4l-1.99,3.46l-0.27,3.34l-3.14,3.53l-0.22,1.41l0.74,1.36l-4.29,2.89l-0.91,1.67l-2.31,0.5l-4.2,2.75l-4.44,0.9l-1.44,1.21l-1.54,-0.46l-3.33,1.96l-1.81,-0.3l-1.53,1.59l-4.69,-1.07l-1.24,1.01l-1.02,-0.22l-2.15,-5.17l0.09,-1.54l0.75,-0.94l2.45,-0.75l0.38,-3.17l4.37,-2.29l0.79,-1.75l-0.25,-2.12l2.17,-0.93L55.67,221.16z"
				},
				{
					"id":"IT-25",
					"title":"Lombardia",
					"d":"M185.79,35.38l0.52,0.58l-0.91,1.44l0.26,1.12l2.07,0.38l0.48,1.55l2.24,0.59l0.66,-1.01l2.23,0.88l1.1,-0.48l1.91,1.48l0,0l1.15,2.7l3.77,0.3l2.64,1.77l1.03,1.36l-0.23,2.19l0.84,1.39l-1.49,1.56l-1.97,0.11l-2.58,2.55l2.64,1.27l0.6,2.02l-0.89,1.27l0.81,0.47l0.52,2.14l-2.28,4.16l1.07,1.59l-0.94,4.43l-3.33,4.07l0.36,1.9l-1.19,0.94l-0.57,1.83l0.05,1l1.74,0.32l-0.16,2.03l1.3,1.99l-0.91,2.1l0.52,4.31l2.25,0.95L200.39,96l0.42,0.87l1.32,0.13l2.14,-1.33l1.98,-0.07l0.47,-2.15l4.01,-0.81l1.27,0.98l0.39,-0.86l3.97,0.77l0,0l-11.09,16.5l1.13,11.75l-0.4,1.98l0.84,0.18l0.7,-0.81l2.46,1.13l-0.96,2.57l0.96,0.75l-1.3,0.98l1,1.49l-0.68,1.91l1.49,0.39l0.51,0.99l2.41,-2l1.96,1.93l1.12,2.35l2.64,0.59l0.11,0.68l1.83,0.48l-0.1,1.3l2.87,1.3l0.8,1.22l-0.38,1.71l1.61,-0.32l0.87,0.55l-0.96,1.88l2.32,1.95l1.2,0.22l0.24,-1.27l1.36,0.73l0.93,-1.68l3,1.12l-1.27,1.02l0.41,1.01l-0.59,1.62l3.13,1.16l1.43,-0.85l0.01,2.46l7.98,4.28l0.23,1.03l0,0l-6.23,-0.92l-1.67,1.59l-1.48,-1.05l-0.36,0.66l-3.89,0.31l-0.55,0.65l-1.22,-1.54l-2.65,-0.64l-0.93,0.79l-3.12,-0.26l-2.32,1.19l-0.23,1.16l-1.35,-0.22l-1.46,0.9l0.2,-0.58l-1.34,0.17l-0.08,-0.75l-0.88,0.16l-0.75,-0.79l-4.41,-0.71l-0.97,-3.12l-1.8,2.07l-0.45,-1.62l-2.85,4.12l-1.45,0.84l-3.94,0.17l-4.57,-2.23l-1.47,-2.92l-2.45,1.34l-2.83,-2.27l-1.6,-0.04l-3,-2.37l-2.22,0.07l-0.53,-0.92l-3.33,1.56l-0.79,-1.73l-1.49,0.35l-0.07,-1.22l-1.52,-1.23l0.44,-1.49l-1.88,-2.45l-0.89,-0.09l-2.88,2.22l0.38,-2.19l-0.73,-0.61l-1.8,1.46l1.13,1.59l-0.19,1.16l-0.88,0.39l-1.01,-1.48l-1,-0.03l-0.93,3.21l-0.37,-1.86l-1.85,-0.95l-0.82,-1.54l-0.87,0.27l0.75,1.09l-0.5,1.01l-1.62,1.42l-4.18,-1.79l0.15,-2.5l-0.92,-1.25l-0.65,1.91l-1.28,0.54l-1.6,-2.14l-0.73,0.12l0.63,2.73l-1.13,1.03l-1.57,-1.86l-2.83,0.72l-0.32,0.81l-1.23,-0.18l0.11,0.67l-2.04,1.84l0.12,2.18l-1.63,1.75l-1.37,4.05l-1.66,0.42l0.6,1.02l-1.25,1.64l1.75,1.61l0.73,-0.4l0.97,0.82l1.07,3.25l-3.85,3.88l0.3,1.1l1.74,0.93l0.15,1.22l-0.89,1.04l0.71,1.4l-3.23,0.86l-1.31,-2.51l0.32,2.02l-1.75,0.11l0,0l-0.37,-2.85l0.63,-2l-2.27,-1.68l-0.47,-2.93l-2.72,0.75l-0.45,-0.78l-1.46,-0.12l0.12,-0.94l-1.16,-1.17l0.94,-1.01l-0.73,-1.98l-1.02,0.12l-1.68,-1.49l-1.55,-2.55l0.24,-1.73l-0.73,-1.29l-0.47,-0.44l-1.32,0.62l-1.29,-1.75l-0.29,-3.2l-2.91,0.23l-1.62,1.61l-1.64,0.18l-0.25,1.03l-1.28,-0.17l-0.17,-1l-1.12,0.16l-0.39,-1.16l-0.46,1.76l-3.32,-1.92l-0.29,-3.52l-1.42,-1.3l0.35,-1.3l-1.12,-0.31l-0.59,-1.49l-1.43,-0.43l-0.55,-0.98l1.79,-2.57l-2.17,0.96l-0.5,-0.39l1.19,-0.43l-1.25,-1.17l0.94,-0.85l-0.57,-0.41l1.26,-0.16l-1.61,-0.53l-0.02,-0.49l0.97,0.13l-0.31,-1.77l-2.01,-1.04l0.73,-1.49l1.35,-0.46l-0.6,-1.79l1.5,-1.38l1.18,1l2.78,-0.11l0,0.91l1.13,0.74l0.49,2.55l1.47,-0.11l1.1,-0.59l0.56,-2.1l1.88,-1.2l-2.17,-2.32l1.51,0.28l1.17,-0.8l1.57,0.44l2.13,-1.08l-0.93,-2.79l-0.89,0.06l-1.15,-3.9l-3.51,-1.81l-1.29,-4.92l0.44,-1.71l-1.93,-1.64l-0.32,-1.26l1.52,0.31l-0.81,-1.84l0.37,-1l-2.03,-0.4l0.55,-2.66l-3.05,-0.91l-2.02,-3.82l0.06,-1.49l2.08,-2.35l-1.28,-4.95l8.05,-8.76l-1.01,-4.55l0.63,-1.61l0,0l1.21,-1.33l0.85,1.4l1.26,0.65l1.22,-0.52l2.36,1.93l0.03,1.11l-1.05,0.63l-2.48,4.44L113,82.03l1.94,2.04l1.42,0.33l0.04,1.68l2.47,4.88l-1.75,2.63l2.32,-0.87l2.1,0.78l-0.34,1l2.33,0.08l0.74,-3.66l2.04,-2.17l-0.74,-0.1l-0.82,-1.6l-2.06,-0.54l-0.26,-2.26l-1.22,-0.7l1.89,-1.73l-1.13,-3.27l0.54,-1.04l3.03,-1.09l0.6,-1.63l-0.79,-2.42l2.42,-1.19l2.14,-2.44l1.06,-0.07l2.03,-4.69l1.46,-0.15l0.17,-2.39l2.34,-4.37l-0.11,-2.05l-1.08,-1.21l0.27,-3.23l-1.66,-2.08l1.34,-1.14l0.18,-2.89l4.4,-0.99l0.62,1.79l1.88,1.31l1.26,-2.4l1.45,-0.71l-0.24,1.46l-0.69,0.26l0.98,0.59l-0.12,7.65l1.89,0.63l1,3.01l1.52,1.82l0.46,-0.38l3.87,1.56l2.14,-1.21l1.8,0.76l1.41,-4.28l2.11,1.1l6.62,-3.38l0.96,1.1l1.39,-1l2.26,2.05l-0.77,2.15l1.04,0.67l-0.12,2.19l2.92,1.49l-0.53,2.56l1.22,0.85l1.1,-0.77l1.63,0.29l2.76,-2.36l-1.09,-2.62l-2.56,-2.99l0.13,-1.5l1.08,-0.69l0.52,-1.77l1.19,-0.24l0.21,-1.52l-0.9,-0.2l-0.36,-1.24l-3.12,0.55l-2.1,-1.73l0.7,-1.51l-0.57,-1.05l0.61,-3.01l-0.51,-1.49l2.88,-3.11l0.1,-2.17l1.41,0.38l3.03,-1.55l1.31,0.64l1.23,-1.24L185.79,35.38z"
				},
				{
					"id":"IT-57",
					"title":"Marche",
					"d":"M358.91,257.63l-2.77,-1.61l-1.18,-2.32l-2.08,-1.73l-0.84,1.52l-2.06,-0.25l-7.56,-4.21l-20.49,-17.97l-5.49,-2.9l-2.43,-0.24l0,0l-1.17,3.09l0.23,4.13l-2.52,0.99l-0.54,2.1l-2.92,-0.36l0.19,-1.04l-0.8,-0.31l-0.69,-2.51l-2.72,1.13l0,-2.14l-2.27,-1.32l0,0l-0.4,1.35l-3.82,-0.43l0,0l-0.04,-0.1l0,0l1.21,2.22l-1.62,-0.01l-0.34,-0.82l-1.99,0.79l-1.01,3.47l-2.6,2.09l-0.2,2.17l0,0l0.13,0.1l0,0l2.15,0.86l2.29,3.08l-2.1,0.02l0.3,2.18l-0.92,-0.06l-0.61,-3.72l-0.44,3.12l-1.23,0.66l-1.46,-0.28l0.2,0.81l-0.94,1.05l-2.31,0.83l1.45,2.23l0,0l0.71,1.17l3.09,-0.04l0.35,0.56l2.08,-1.68l1.88,-0.12l-0.51,0.78l0.48,1.44l-2.92,2.7l1.36,1.42l1.43,-0.73l1.27,1.73l1.42,-2.09l0.99,0.13l0.83,1.42l0.92,0.05l0.29,-0.86l0.91,0.42l6.36,7.29l2.13,-1.29l2.23,0.82l1.32,-2.69l2.08,0.56l-0.37,2.01l0.9,0.84l-1.8,1.69l0.05,0.84l2.27,2.96l0.38,2.91l-0.62,0.7l1.88,1.34l0.67,3.42l1.39,0.69l-0.14,2.9l-1.62,1.55l0.67,1.54l2.07,0.42l0.57,1.71l-0.24,2.77l0.75,2.11l-0.87,0.66l0.94,1.95l-0.56,1.49l2.69,1.61l0.2,0.87l1.11,0.13l0.12,4.04l1.21,-1.36l0.02,-1.71l1.3,0.77l1.4,-1.39l3.01,2.3l2.5,3.94l2.67,-0.61l1.25,-1.82l1.41,3.62l-0.25,1.82l-0.92,1.9l-0.38,-0.77l-1.92,0.78l-0.25,2l0,0l3.28,0.79l0.54,-1.17l1.09,-0.1l3.68,3.16l0,0l1.67,0.49l1.88,-1.33l0.56,0.46l0.6,-2.38l2.37,-0.39l0.3,-2.49l1.33,-1.48l0.25,-1.45l2.08,1.14l2.36,-1.11l0.67,0.95l1.35,-0.17l2.01,-0.94l0.46,-2.21l0.68,-0.38l2.78,-0.19l2.12,-1.41l4.99,-1.07l0,0l-2.2,-6.7l-1.54,-8.13l-11.26,-27.91L358.91,257.63zM297.73,254.39l-0.74,-0.26l0,0l-0.19,-0.06l0,0l0.32,-0.7l0.57,0.33l0,0l0.1,0.53l0,0L297.73,254.39z"
				},
				{
					"id":"IT-67",
					"title":"Molise",
					"d":"M418.76,361.06L424.2,363.95L429.19,364.88L433.16,369.22L436.32,370.45L436.32,370.45L436.53,373.72L434.4,376.79L435.22,379.72L434.26,381.31L435.26,382.53L434.51,383.05L435.51,384.54L437.37,385.39L435.32,386.41L434.64,387.91L433.87,387.14L433.84,387.96L431.75,388.87L430.43,391.29L427.19,389.79L425.94,391.31L426.85,392.11L426.14,397.69L427.7,398.36L429.69,400.66L429.69,400.66L426.71,402.76L424.06,402.97L422.48,404.57L418.47,402.86L416.75,405.76L414.87,406.34L413.93,405.6L411.96,405.83L412,406.77L410.95,406.84L408.76,408.79L407.54,407.03L404.2,407.55L403.01,406.64L402.63,405.05L394.62,402.71L392.59,401.62L392.33,400.61L390.55,400.6L390.35,399.76L386.9,399.69L386.51,401.07L384.22,399.16L382.02,403.19L383.4,404.86L383.67,407.28L382.37,406.42L380.22,406.9L378.16,404.45L378.44,402.93L376.92,402.16L376.92,402.16L377.68,400.87L376.67,400.02L379.53,397.96L378.31,396.9L379.16,396.72L379.37,395.77L378,394.26L378.68,393.63L378.58,392.26L377.18,388.67L375.19,386.95L375.19,386.95L377.29,386.43L379.16,387.41L379.44,385.95L380.77,385.9L381.64,383.5L382.8,383.41L383.59,385.48L384.22,382.84L386.21,382.79L386.88,381.55L387.13,382.56L387.98,382.69L388.4,381.66L386.88,380.77L385.63,377.22L386.05,376.32L388.27,376.17L389.7,373.95L392.61,371.57L393.55,372.83L394.79,372.7L395.77,374.89L396.34,375.11L397.39,373.79L399.83,375.41L400.93,376.48L402,380.77L401.21,381.41L403.25,381.78L408.01,376.65L409.73,372.92L412.09,371.26L412.91,368.16L415.21,365.32L418.05,363.36L417.14,362.52L418.31,360.67L418.31,360.67z"
				},
				{
					"id":"IT-21",
					"title":"Piemonte",
					"d":"M92.94,46.87L94.49,48.44L93.87,49.96L94.61,51.93L94.25,56.67L92.3,59.22L93.8,61.71L93.14,62.89L94.56,64.16L97.61,65.16L99.81,69.15L101.29,69.78L100.98,70.84L101.74,72.22L103.55,72.16L105.57,73.71L107.21,73.58L107.21,73.58L106.58,75.19L107.59,79.74L99.54,88.5L100.82,93.46L98.74,95.81L98.68,97.31L100.7,101.13L103.75,102.04L103.2,104.69L105.23,105.09L104.86,106.09L105.67,107.94L104.14,107.62L104.46,108.89L106.39,110.52L105.95,112.23L107.24,117.15L110.75,118.96L111.9,122.86L112.79,122.8L113.72,125.59L111.59,126.67L110.01,126.24L108.84,127.04L107.33,126.75L109.5,129.07L107.62,130.27L107.06,132.37L105.96,132.96L104.49,133.07L104,130.52L102.87,129.78L102.88,128.87L100.1,128.98L98.91,127.98L97.42,129.36L98.02,131.15L96.66,131.61L95.94,133.1L97.95,134.14L98.26,135.91L97.28,135.78L97.3,136.26L98.92,136.79L97.66,136.95L98.23,137.37L97.28,138.22L98.53,139.39L97.34,139.82L97.84,140.21L100.01,139.25L98.22,141.82L98.77,142.8L100.2,143.24L100.79,144.73L101.91,145.04L101.55,146.34L102.98,147.63L103.27,151.16L106.58,153.07L107.04,151.32L107.44,152.47L108.56,152.31L108.74,153.32L110.02,153.48L110.27,152.46L111.91,152.28L113.53,150.67L116.44,150.43L116.73,153.64L118.02,155.39L119.34,154.77L119.8,155.21L120.53,156.5L120.29,158.23L121.84,160.78L123.52,162.27L124.54,162.15L125.26,164.14L124.32,165.15L125.48,166.32L125.36,167.26L126.81,167.39L127.26,168.17L129.98,167.42L130.45,170.35L132.72,172.03L132.1,174.03L132.47,176.88L132.47,176.88L131.97,176.69L132,181.77L132,181.77L132.06,183.22L128.54,184.69L126.92,183.48L126.97,182L125.51,181.15L124.07,181.44L122.47,178.01L120.19,178.26L119.47,177.24L117.86,177.48L117.23,179.14L115.66,180.4L117.1,181.96L117.4,185.68L115.96,186.46L115.09,185.27L112.81,185.57L112.84,187.04L111.1,188.5L111.46,189.98L110.19,190.45L109.8,188.25L108.94,188.28L109.24,187.38L107.45,184.44L105.83,184.21L102.28,184L101.05,185.93L101.84,186.84L99.1,189.88L98.1,189.13L94.89,189.25L94.55,188.39L93.41,190.1L91.94,189.06L91.14,189.44L90.58,191.64L89.27,192.35L86.19,189.74L84.34,189.55L83.36,188.03L81.81,189.27L81.85,191.16L80.47,191.62L81.84,194.89L81.09,196.82L77.91,198.58L78.14,200.58L77.16,202.19L75.87,202.03L75.57,204.21L74.11,203.56L73.69,204.1L73.69,205.1L74.96,206.41L73.71,207.64L74.57,208.74L73.83,210.45L75.29,211.72L75.34,213.66L74.16,215.21L72.74,215.7L71.21,214.68L69.37,216.19L70.68,216.81L71.24,217.68L70.81,218.41L68.84,217.72L67.21,218.6L58.21,215.72L56.27,216.8L55.8,218.34L56.71,219.78L58.02,219.76L56.47,221.43L55.67,221.16L55.67,221.16L55.73,219.67L53.29,216.38L54.19,213.27L51.71,213.17L50.83,215.08L47.93,214.6L42.75,216.79L41.2,216.44L40.88,217.74L39.24,216.81L37.41,217.5L36.69,215.32L33.43,215.7L31.61,213.49L30.28,213.71L28.73,211.39L27.41,210.95L26.46,211.47L23.42,209.41L20.74,209.8L19.48,208.94L18.86,205.77L16.91,204.64L17.09,203.62L15.41,202.07L15.18,200.73L13.36,199.9L13.64,195.67L16.5,195.11L12.89,191.48L11.77,187.85L12.9,186.15L14.5,185.98L15.68,184.82L16.56,181.64L17.49,181.56L16.51,179.16L17.22,177.43L18.51,176.45L23.09,176.74L22.61,174.86L20.76,173.77L20.21,170.55L19.15,169.39L20.31,166.92L19.45,165.78L15.87,164.13L14.57,165.43L12.17,164.97L9.09,162.88L8.93,161.99L6.4,161L6.6,158.92L6.02,158.57L7.1,157.03L5.7,154.85L6.39,154.3L6.05,153.14L2.42,152.73L1.8,148.98L0.88,148.72L0,146.53L2.38,145.05L2.78,143.97L5.95,144.15L7.26,142.59L11.34,144.3L11.43,144.94L13.69,144.25L13.7,141.95L16.39,141.85L16.81,140.34L19.22,138.22L20.51,138.43L21.74,137.69L22.71,138.82L24.85,136.2L25.58,136.3L26.11,133.67L24.84,130.39L25.82,130.21L26.23,128.67L27.55,127.98L27.56,126.51L28.8,124.71L25.06,122.7L24.44,120.25L24.44,120.25L26.21,116.69L26.57,119.54L27.47,118.86L30.54,119.93L32.93,116.92L35.73,116.85L37.61,115.96L38.57,116.63L42.11,113.79L43.04,112.22L44.27,111.83L46.12,112.3L48.2,111.17L50.21,112.42L50.34,113.29L51.75,112.63L53.72,113.93L56.04,113.55L56.72,114.16L61.61,110.69L64.25,110.49L65.26,111.14L65.99,108.1L67.19,107.86L65.37,104.13L67.03,101.3L66.67,100.1L65.05,99.5L63.34,96.4L64.04,91.35L63.34,87.29L63.34,87.29L64.06,86.61L64.16,82.98L65.63,81.4L69.78,81.52L70.89,80.35L71.01,78.83L72.17,78L71.5,75.89L72.04,73.9L75.76,73.03L76.32,71.6L78.23,70.6L78.11,69.11L78.9,67.97L77.53,64.69L76.06,62.88L74.35,62.08L77.54,58.91L78.99,59.35L81.18,58.48L81.92,56.55L83.84,55.7L83.87,54.35L86.25,53.36L86.72,51.86L85.27,51.16L86.05,49.92L87.05,49.84L89.04,47.92z"
				},
				{
					"id":"IT-75",
					"title":"Puglia",
					"d":"M481.43,368.91l3.85,0.75l4.91,3.74l-0.67,1.54l1.26,2.39l-0.08,1.6l-0.39,1.97l-1.36,1.36l-4.73,3.16l-0.29,1.08l-8.39,5.25l0.15,5.69l2.5,4.73l3.46,2.51l9.37,4.34l2.98,2.34l8.1,3.05l8.43,5.09l9.93,3.16l1.66,1.43l1.8,0.05l0.45,0.75l0.94,-0.41l0.25,0.73l4.19,1.82l6.85,2.24l9.64,6.31l3.63,4.43l2,0.91l4.56,4.29l11.81,4.74l6.2,4.3l5.61,0.67l1.12,1.85l-0.49,0.85l3.59,0.12l-0.33,1.09l1.56,1.93l-0.54,2.04l2.25,2.78l2.38,2.17l5.88,3.28l9.38,10.06l2,4.46l-0.23,1.76l1.55,3.62l1.42,0.87l-0.51,0.48l0.59,1.65l-1.72,1.58l-0.49,2.38l-1.99,1.38l-1.44,3.17l-0.88,4.56l0.03,6l-1.11,1.56l-1.21,0.32l-3.83,-2.96l-5.1,-1.07l-6.43,-5.23l-2.72,-4.74l1.21,-0.5l-0.18,-1.95l-2.08,-1.12l1.51,-1.11l0.41,-2.5l-4.61,-5.73l0.33,-1.91l-1.02,-2.19l-2.52,-2.09l-9.07,-1.33l-8.78,0.68l-3.15,-2.28l-2.7,-0.29l-8.68,-5.02l-1.12,0.03l0.3,-0.91l1.92,-0.84l0.22,-1.48l-1.35,-1.64l-2.29,0.11l-0.58,-1.62l-2.85,-1.07l-3.82,0.57l-3.5,1.9l-3.57,3.16l-2.13,3.51l0,0l-0.78,-1.86l-1.75,-1.47l-0.36,-1.62l-1.77,-1.07l-1.7,0.44l-0.86,-0.95l0.96,-2.08l-1.16,-0.88l0.44,-0.81l-0.96,-1.01l0.43,-2.89l0.63,-0.46l-0.92,-2.06l0.9,-3.61l-1.22,-1.41l1.02,-0.51l-2.92,-2.22l-0.53,0.75l-1.17,-0.7l-0.17,-0.99l-1,0.64l-1.69,-0.73l-0.11,1.74l-0.85,-1.33l-0.97,0.26l0.07,1.89l-2.04,-2.47l-3.49,4.04l-1.53,-0.42l-0.77,-1.74l-6.57,-6.04l-2.94,-6.46l-2,-0.65l-2.13,1.96l-1.59,-1.51l-5.59,-2.38l-0.6,-1.13l1.51,0.27l1.8,-2.05l-0.31,-1.55l0.64,-1.04l-1.84,-1.5l-0.61,0.42l-0.61,-2.35l-1.26,-0.3l-0.24,-1.02l-1.74,-0.3l-2.3,-1.65l-1.42,0.85l-0.81,-0.29l0.18,0.76l-1.67,0.43l0.15,0.95l-1.68,0.92l-1.46,-1.06l-2.51,0.9l-4.65,-0.78l-1.94,0.38l-1.35,1.23l0.33,1.23l0,0l-3.6,-1.8l-1.57,0.14l-2.1,-1.8l-1.7,1.29l-2.83,-1.19l-1.1,0.9l-2.01,-1.44l-0.73,-1.89l-1.57,-0.77l0.82,-1.99l2.02,-1.2l-0.85,-2.38l1.61,-1.02l-1.26,-1.43l-1.62,0.32l-1.04,-1.48l-3.42,0.14l-0.21,-2.17l-2.97,-1.06l-0.62,-2.62l0.84,-1.17l1.06,-0.18l-0.54,-1.2l0.82,-0.78l-0.18,-0.8l-2.85,-0.8l-1.81,-2.84l0,0l-1.99,-2.3l-1.56,-0.67l0.72,-5.58l-0.92,-0.81l1.25,-1.52l3.24,1.5l1.32,-2.41l2.09,-0.91l0.03,-0.83l0.77,0.77l0.68,-1.5l2.06,-1.02l-1.86,-0.84l-1,-1.5l0.74,-0.52l-0.99,-1.22l0.96,-1.59l-0.82,-2.93l2.13,-3.06l-0.21,-3.27l0,0l10.43,0.64l1.25,1.02l3.19,0.12l9.93,-1.85l3.37,0.95l4.13,-0.21L481.43,368.91z"
				},
				{
					"id":"IT-88",
					"title":"Sardegna",
					"d":"M89.46,559.47l0.55,0.96l2.26,-0.65l2.12,3.57l-1.14,5.62l-1.56,0.89l-2.8,-5.35l-0.56,-2.85L89.46,559.47zM86.27,554.94l-0.13,5.46l-1.62,0.38l-1.35,-0.95l0.05,-1.69l-1.54,-0.91l2.44,-2.24L86.27,554.94zM159.27,439.11l0.55,0.51l-2.49,1.59l-0.53,-0.41l2.76,-2.27L159.27,439.11zM82.15,435.22l-0.56,0.57l-0.06,-1L82.15,435.22zM86.96,425.57l0.27,1.13l1.24,0.83l-0.73,0.74l-0.17,1.96l-2.73,-1.27l-2.18,3.03l0.66,-0.19l0.82,1.62l-0.47,1.37l-2.3,-0.29l0.99,-2.47l-0.63,-0.09l0.16,-1.12l1.48,-0.62l0.87,-1.6l0.96,-0.11l-0.54,-1.95L86.96,425.57zM146,417.24l0.86,1.53l-1.24,2.08l0.86,0.23l-2.3,0.35l1.09,-4.32L146,417.24zM139.27,416.59l0.97,0.61l-1.06,0.94L139.27,416.59zM133.6,416.13l2.52,2.07l-0.75,1.88l1.06,1.11l2.45,-0.17l0.27,-1.28l1.25,-0.14l0.54,1.82l0.57,0.15l1.98,0.02l-0.98,1.27l1.26,0.22l0.9,1.38l-0.17,2.92l1.49,-2.26l-0.28,-1.15l2.49,0.14l0.31,-1.15l0.92,1.24l-0.56,0.33l0.98,0.06l-0.27,1.23l1.33,-0.06l0.26,1.12l-1,1.52l-0.55,-0.67l-0.39,0.37l0.29,1.44l-0.83,0.52l-0.77,2.98l0.77,-0.04l0.17,-1.35l1.76,-0.53l-0.53,2.25l1.32,0.06l-0.04,-0.82l0.46,0.3l0.49,-0.79l3.55,1.83l-0.7,0.74l-2.17,-1.11l-1.38,1.19l0.58,1.04l-1.29,1.73l0.33,0.93l-2.72,-0.4l-0.91,0.41l0.9,0.47l2.12,0.05l0.86,0.35l-0.38,0.41l0.97,1.14l1.48,-2.05l1.26,0.24l-1.48,1.88l2.24,1.11l-0.53,1.36l1.67,-0.37l2.1,1.45l-0.73,0.56l-1,-0.36l-0.41,0.97l0.57,0.77l-0.88,0.46l-0.14,1.26l2.36,2.34l-0.16,2.72l2,2.51l-0.61,2.56l0.64,2.55l1.84,1.72l0.28,1.81l1.66,1.04l-3.14,9.17l-3.94,3.36l-3.24,5.54v3.43l1.37,4.05l2.02,2.71l2.06,1.2l-0.02,1.66l-2.37,5.82l0.16,2.12l1.23,0.31l0.21,0.75l-1.83,1.85l0.74,3.17l-1.37,4.67l0.45,4.66l-1.64,4.03l0.53,5.51l-1.25,4.44l0.72,2.68l-2.47,7.5l0.31,2.11l1.48,1.21l-1.56,0.52l-1.07,1.64l-1,4.63l0.85,1.28l-1.08,2.98h-1.02l-0.92,1.13l0.13,1.3l-1,-0.84l0,-1.45l-0.95,-0.36l-2.42,0.82l-7.24,-5.97l-4.44,-0.93l-2.13,1.29l-0.48,1.71l-2.56,-2.06l-2.13,0.94l-2.54,3.16l-0.05,4.15l1.47,2.05l-1.25,4.73l-0.55,-0.55l-0.73,0.37l-7.09,7.14l-1.26,-0.05l-1,-1.31l-0.65,0.85l-1.28,-2.04l-2.78,-1.59l-0.17,1.04l-2.76,0.68l0.29,1.04l-1.09,0.55l0.5,1.33l-0.86,0.29l0.29,-2.01l-2.05,0.11l0.73,-3.3l-2.54,-2.31l-0.43,-4.26l-1.66,-0.96l-2.92,-0.06l0.46,-1.85l-0.71,-1.55l-0.64,-0.6l-1.1,0.59l-0.04,-2.91l-3.48,-3.73l-0.1,-0.98l2.99,-2.8l0.53,-1.38l-0.77,-2.71l-1.38,-0.49l-0.2,-1.71l-0.82,-0.68l1.98,-3.13l-0.05,-1.18l-1.49,-0.98l0.21,-1l3.41,-5.04l0.91,-3.68l-1.1,-2.15l0.44,-2.02l-0.62,-1.13l0.51,-1.6l-0.5,-3.33l0.68,-0.84l1.78,3.07l0.78,-0.06l0.34,-2.07l1.62,-2.76l0.4,-4.28l-1.52,-2.77l-2.41,-0.15l-1.91,1.96l-2.19,-2.07l-0.25,-4.49l1.03,-2.95l-1.82,-1.06l1.3,-1.08l0.5,0.7l2.14,-0.66l1.84,-1.96l0.08,-1.51l-1.77,-4.92l1.33,-7.34l-1.18,-2.26l-1.98,-1.15l-1.95,-0.11l-0.18,-1.44l1.14,-3.36l-1.43,-5.38l-1.81,-0.64l-1.94,-6.04l-2.71,0.54l-0.14,0.92l-2.04,0.05l-0.02,-1.76l0.75,-0.52l-1.09,-1.14l-1.81,2.85l-0.56,-0.18l-0.29,-2.99l2.05,-0.94l1.08,-3.18l-1.56,-0.67l-2.16,-2.46l1.75,-2.35l-0.28,-1.94l1.36,-1.18l1.84,-5.06l-2.4,-3.34l1.4,-2.4l1.72,1.24l-0.25,2.86l4.13,4.43l3.05,0.61l2.28,-0.38l1.94,1.42l5.44,-0.8l6.83,-5.52l5.01,-0.74l4.14,-4.71l-0.11,-1.31l3.08,-1.85l4.11,-5.58l1.65,-0.89l0.65,0.73l2.59,-0.5l0.61,-1.39l1.68,-0.07l0.82,-0.92l-0.76,-1.91l0.67,-2.18l-1.29,-0.22l0.15,-0.94l1.05,0.71l1.44,-0.77l0.06,0.92L133.6,416.13zM143.28,415.47l1.46,2.36l-0.43,1.15l-2.96,0.46l-0.45,-1.26l1.48,-1.12l-0.13,-1.1l0.69,0.74L143.28,415.47z"
				},
				{
					"id":"IT-82",
					"title":"Sicilia",
					"d":"M302.68,789.79l4.91,0.51l0.32,1.67l-5.98,-1.61L302.68,789.79zM273.26,706.81l2.34,1.2l0.6,-0.37l2.01,1.7l0.12,2.36l-1.41,1.66l-1.88,-0.13l-3.32,-4.07l0.09,-1.56L273.26,706.81zM298.46,642.33l-0.94,-3.28l1.32,-0.71L298.46,642.33zM291.36,635.17l0.79,1.49l1.13,-0.41l1.09,0.78l-0.01,1.15l-0.73,0.18l-0.94,-1.02l-2.46,0.28l-0.83,-1.4L291.36,635.17zM278.85,632.73l1.33,2.86l-2.49,-0.75l-0.7,-2.16L278.85,632.73zM457.95,612.73l2.42,1.62l2.74,0.66l-2.76,0.76l-1.51,1.25l-0.77,2.89l0.84,-0.17l-4.12,7.59l-9.76,12.73L445,641.71l-1.66,1.13l0.2,0.92l-3.3,4.26l-0.38,1.12l0.73,1.72l-1.02,3.58L438.35,656l0.07,3.52l-3.12,2.95l-1.54,2.87l0.59,10.6l3.34,2.07l1.51,0.38l0.68,-0.67l2.64,3.23l-0.55,0.76l-0.95,-0.66l-0.19,1.67l-0.46,-1.87l-1.15,0.4l-0.33,3.21l1,2.34l1.37,-0.45l0.57,0.83l-0.79,-0.33l-0.38,0.56l0.67,1.63l1.43,0.81l1.74,-0.08l0.1,3.06l-1.08,-0.41l-0.09,1.59l0.7,0.44l0.97,-0.57l1.44,2.49l-1.79,-0.8l-1.29,0.52l-0.73,2.16l-2.68,0.64l-2.89,3.19l-2.96,7.3l2.31,7.29l-0.46,1.15l-0.81,-0.5l-1.78,1.69l-3.2,-3.39l-3.09,0.56l-2.25,-1.92l-1.86,-0.48l-4.95,1.71l-1.93,-1.06l-2.73,-0.01l-2.69,-2.55l-2.52,-1l-4.87,-0.63l-1.77,-1.91l-0.82,-3.48l-3.21,-5.76l-6.02,-6.1l-4.99,-2.35l-4.91,-1.09l-5.26,0.12l-3.2,0.85l-1.51,-0.43l-2.7,-2.75l-3.69,-0.33l-4.62,-2.86l-0.95,-2.12l-4.47,-3.67l-1.52,0.39l-0.76,-0.84l-3.1,-0.09l-2.41,-2.52l-4.08,-2.02l-1.32,-1.57l-1.28,-0.09l-1.06,-2.39l-4.43,-4.3l-4.56,-0.77l-2.91,0.69l-2.96,-4.45l-2.3,-0.79l-7.06,-0.25l-5.37,1.33l-3.42,-5.2l-2.17,-1.38l-2.32,0.15l-2.22,-2.57l-0.19,-2.89l-2.44,-3.67l1.95,-1.12l1.14,-3.61l-1.42,-2.15l2.07,-2.9l-0.2,-2.01l1.24,-0.55l-1.48,-1.6l1.51,-0.38l2.66,-3.02l1.69,0.31l1.79,-0.71l1.21,-1.21l-0.12,-1.12l2.58,0.1l1.35,-1.95l-1.11,-2.19l0.81,-1.06l0.34,0.85l1.58,-0.18l0.05,1.81l1.08,1.06l-0.04,1.6l1.13,2.01l4.56,3.53l4.5,-1.24l4.58,-2.85l-1.28,-3.3l0.98,-0.23l0.66,-1.25l-0.4,-0.68l1.62,-1.37l4.26,1.51l2.11,-0.86l0.44,-1.36l1.75,0.26l2.18,-1.6l0.66,1.68l1.87,1.12l0.51,2.15l-0.74,1.14l1.05,1.47l3.29,0.92l2.25,-0.55l0.89,-1.12l1.49,0.42l0.03,3l1.55,1.78l7.44,4.02l2.78,0.43l4.93,-1.34l4.32,-2.55l3.86,-0.76l2.24,1.48l2.17,0.23l1.89,-0.96l7.21,1.44l4.38,-0.57l2.76,-1.55l2.72,0.41l8.22,-2.63l5.6,-5.98l2.16,0.91l5.12,-1.36l1.23,-1.26l2.9,2.55l3.78,0.01l0.84,1.58l1.96,0.4l3.89,-2.14l2.25,-2.55l1.14,-3.18l-0.87,-1.83l0.84,-0.06l0.7,1.53l-0.54,2.11l2.25,0.63l5.74,-1.57l6.3,-4.25L457.95,612.73zM427.27,604.98l1.89,1.45l0.3,1.71l-1.04,0.18l-1.7,-1.09l-0.57,-1.83l1.05,-1.35l0.51,0.5L427.27,604.98zM427.38,598.26l0.02,1.94l0.91,0.65l-1.28,0.42l-0.1,2.34l-2.89,-3.04l0.83,-2.18L427.38,598.26zM396.6,596.12l-0.06,1.42l-0.87,0.05l-0.12,-1.15L396.6,596.12zM420.15,594.25l2.57,0.12l-0.03,2.87l-0.79,0.18l-3.07,-1.76l0.55,-1.42L420.15,594.25zM406.16,594.11l1.42,0.28l0.88,1.66l-2.03,-0.2l-0.73,-1.18L406.16,594.11zM433.22,590.22l-0.09,1.03l-0.93,0.31l0.14,-1.2L433.22,590.22zM336.74,585.75l0.43,0.29l-0.74,0.86l-1.71,0.15l0.35,-1.22l1.03,-0.54L336.74,585.75zM440.89,579.4l0.89,0.66l-1.53,1.91l-1.31,-1.3L440.89,579.4z"
				},
				{
					"id":"IT-52",
					"title":"Toscana",
					"d":"M189.13,341.23l0.86,1.8l-0.76,0.73l-1.01,-0.17l-0.16,-2.15L189.13,341.23zM218.46,338.48l1.97,2.03l-0.22,3.02l-1.97,-2.44l-0.82,-0.13L218.46,338.48zM177.15,322.6l1.08,2.11l-0.65,1.48l-2.22,-0.98l1.43,-0.67L177.15,322.6zM194.48,305.33l1.33,1.4l-0.77,2.13l0.32,2.67l-2.52,1.36l2.45,1.7l-0.55,1.88l-2.47,-0.8l-0.92,-2.73l-0.77,-0.37l-1.22,0.24l0.07,1.67l-0.9,-1.6l-0.83,1.66l-2.23,-0.99l-0.22,1.65l-2.72,-0.74l-1.65,0.26l0.19,0.53l-1.81,-1.11l-1.03,-1.75l0.1,-1.58l1.84,-1.41l2.85,-0.07l2.54,1.55l0.17,-0.79l1.07,-0.28l-0.36,-0.57l0.65,-0.47l-0.61,-0.84l3.63,0.87l-0.76,0.97l1.9,0.34l2.67,-5.01L194.48,305.33zM164.4,291.58l0.69,1.98l-1.83,2.42l-0.92,-1.33l0.51,-2.3l1.23,-1.3L164.4,291.58zM287.49,239.55l0.08,0.16l0,0l0.3,1.1l-2.18,1.13l-1.37,-1.59l0.27,-1.12l2.77,0.02l0,0L287.49,239.55zM156.74,199.9l3.6,-2.09l3.41,-5.36l5.35,-0.59l2.44,0.87l0.5,1.24l1.05,0.22l-0.54,2.63l1.13,1.26l4.28,2.94l2.44,-0.51l5.63,5.96l2.38,-1.19l2.19,1.23l1.6,0.03l2.95,3.04l1.67,-0.29l1.22,0.67l-0.05,1.38l1.74,1.6l0.24,1.55l3.42,3.05l1.67,-0.42l-0.07,-1.34l1,-1.23l5.57,0.13l4.97,4.03l2.28,0.51l0.68,0.91l-0.32,0.95l0.66,0.3l4.86,-5.46l0.4,0.91l-0.61,1.04l1.55,1.15l2.76,0.32l3.34,-1.45l3.09,0.89l2.54,-0.16l-0.25,-1.08l-2.93,-1.7l0.11,-0.94l3.99,-0.14l2.28,-2.07l0.2,-1.07l2.49,-0.26l2.46,-2.39l1.33,1.21l0.34,2.15l1.4,0.38l1.73,1.97l1.21,0.26l1.03,-1l2.6,0.53l0.2,1.04l-1.45,2.1l2.66,0.36l5.47,-1.1l-0.34,2.69l-2.03,2.19l-0.43,1.99l-1.68,0.64l0.2,1.09l-0.67,-0.09l-0.25,1.15l2.17,2.08l-0.33,1.63l1.82,1.22l-0.27,3.06l3.58,2l2,2.41l4.67,0.21l0.52,1.3l1.35,0.18l0,0l0.21,0.97l1.64,1.05l0,0l1.06,-0.42l1.46,0.9l0.92,-0.25l0,0l1.11,1.27l1.72,-0.9l0,0l1.42,0.16l1.44,-0.8l1.55,2.31l0.83,-1.97l2.04,0.38l1.64,-0.89l0,0l0.17,0.13l0,0l2.15,0.86l2.29,3.08l-2.1,0.02l0.3,2.18l-0.92,-0.06l-0.61,-3.72l-0.44,3.12l-1.23,0.66l-1.46,-0.28l0.2,0.81l-0.94,1.05l-2.31,0.83l1.45,2.23l0,0l-2.48,3.13l-0.77,2.59l-2.19,-0.18l-0.55,0.56l-0.17,1.76l2.61,1.48l-0.1,0.56l-2.13,0.9l-1.01,1.7l-1.09,-0.34l-1.71,1.74l0.33,1l2.14,-0.22l0.11,2.66l1.43,-0.54l0.65,0.6l1.01,2.29l-0.59,1.71l0.4,0.9l2.23,0.84l0.9,-2.23l1.54,1.26l-6.67,4.18l-2.2,-1.23l-0.82,0.37l0.5,1.33l-0.99,2.73l-5.18,3.05l-0.49,1.32l0.88,2.44l-0.33,1.22l0.79,1.57l0.84,-1.05l1.27,1.36l-2.42,9.85l1.09,0.75l0.15,1.81l-1.28,0.08l-1.95,2.34l0,0l-2.48,-0.14l-1.62,1.07l-0.51,2.01l-0.7,-1.32l-1.2,-0.47l-1.16,2.44l3.78,2.96l-1.04,2.36l-1.23,-0.01l0.41,2.62l1.05,0.48l0.08,1.08l-1.4,0.92l-1.37,-0.19l-0.91,2.14l-1.29,-0.25l-1.5,1.11l-0.2,1.08l-1.74,0.88l-0.81,-0.23l-0.67,0.89l-1.14,-1.05l-0.62,0.33l0.45,1.76l-1.37,1.94l2.79,1.91l0.09,3.43l-6.8,0.08l-1.85,4.15l0,0l-8.37,-1.95l-1.17,-0.95l-2.73,0.72l0.13,1.48l-0.99,0.48l-0.23,1.22l-1.82,0.15l-1.36,-1.7l-1.62,-0.51l-0.44,-2.58l0.98,-1.23l0.85,0.87l2.24,-0.19l1.01,-2.06l0.31,-3.12l-1.73,-3.57l-1.76,0.36l-0.98,-2.88l-1.1,-1.07l0.21,-0.98l-4.14,-1.77l-0.93,-3.72l-2.21,-2.29l-4.43,-1.78l-3.39,-0.4l-3.08,-2.02l1.84,-1.13l0.14,-3.65l0.89,-1.29l-0.66,-1.47l-1.79,-1.34l-3.2,-1.49l-2.86,-0.31l-3.73,0.58l-0.39,1.77l-2.31,-0.78l-0.59,-3.94l1.69,-0.8l1.12,-6.21l-0.66,-11.12l-1.17,-2.9l-2.16,-2.26l-1.83,-5.45l-1.08,-0.1l-1.15,-3.16l-2.62,-1.98l-1.62,-4.33l0.32,-2.36l-1.86,-7.72l0.6,-0.88l-0.25,-4.01l-1.84,-8.73l-5.04,-7.69l-4.12,-3.65l-2.16,-1.04l0,0l2.23,-2.54l0.27,-1.38l-2.37,-1.47l-1.78,1.5l0.49,-1.23l-0.94,-1.39l-0.19,-2.36l-3.93,0.14l1.24,-1.98l0.75,-0.06l-1.47,-1.02l-2.08,1.75l0.43,-2.73l-0.81,-0.7l-0.09,-2.57l-2.59,-1.06l-4.03,-3.13l-1.01,-2.58L156.74,199.9z"
				},
				{
					"id":"IT-32",
					"title":"Trentino-Alto Adige",
					"d":"M285.92,0.44L287.65,1.8L286.49,2.62L285.95,4.79L282.98,5.1L281.66,6.37L282.51,10.17L284.11,11.69L282.81,13.61L285.08,14.04L286.52,16.36L287.89,15.29L289.65,15.7L291.23,18.92L290.1,20.77L290.04,23.09L293.66,23.74L295.03,28L300.07,30.91L300.07,30.91L297.61,31.83L295.94,33.7L295.06,33.5L295.44,34.83L294.93,35.29L293.67,35.35L292.93,34.46L289.94,35.4L288.73,34.64L285.39,37.29L285.28,35.03L283.73,34.05L282.9,34.34L278.97,31.27L279.27,33.6L277.76,36.28L277.93,37.77L275.47,41.69L274.89,40.92L273.73,40.98L272.55,42.16L270.98,41.84L266.11,44.3L265.99,45.94L269.06,46.36L269.66,47.75L267.36,50.47L267.09,54.13L266.28,53.39L263.92,54.82L266.83,57.26L267.41,58.66L266.74,60.56L267.53,61.26L269.69,60.76L270.13,62.7L270.77,62.29L271.98,62.88L271.19,64.85L273.62,67.07L273.01,68.67L271.91,68.23L270.2,72.18L266.01,73.64L263.78,73.4L263.03,74.18L262.37,73.41L259.63,74.28L259.62,76.3L260.55,77.83L258.49,78.44L259.23,79.12L258.5,79.93L259.64,81.95L258.73,83.82L254.52,83.52L253.98,80.71L252.09,80.11L249.94,80.4L247.2,82.67L243.58,82.44L243.96,85.29L242.67,85.45L241.99,86.99L242.34,87.98L239.86,86.64L239.79,85.86L239.81,87.22L237.39,87.04L236.53,91.95L234.18,94.78L234.78,97.14L233.23,96.99L233.36,100.59L230.86,103.96L229.26,103.75L227.33,101.91L225.69,102.79L225.25,101.62L223.41,104.27L222.92,103.23L221.42,104.92L219.93,103.99L220.58,102.85L218.53,101.84L216.34,101.83L218.53,97.8L217.75,96.29L219.03,95.19L216.35,93.53L216.35,93.53L212.39,92.76L212,93.63L210.73,92.64L206.72,93.45L206.24,95.6L204.27,95.66L202.12,97L200.8,96.87L200.39,96L201.08,94.61L198.83,93.65L198.31,89.34L199.22,87.24L197.92,85.25L198.08,83.22L196.34,82.9L196.29,81.9L196.86,80.07L198.06,79.12L197.7,77.22L201.03,73.15L201.96,68.73L200.9,67.14L203.17,62.98L202.66,60.85L201.85,60.38L202.73,59.11L202.13,57.09L199.49,55.82L202.08,53.28L204.05,53.16L205.54,51.6L204.7,50.22L204.93,48.02L203.9,46.66L201.26,44.89L197.49,44.59L196.35,41.9L196.35,41.9L197.35,41.01L198.24,35.94L195.96,33.86L193.67,34.17L192.83,30.52L194.37,28.61L193.62,26.86L195.81,25.12L194.59,22.55L196.03,21.75L197.49,17.61L198.61,18.51L201.41,18.31L201.04,19.19L207.13,16.35L208.49,17.12L208.48,18.13L211.65,19.42L212.1,20.23L210.35,22.87L211.69,23.1L213.32,22.28L214.72,23.8L215.9,23.31L218.38,24.76L220.04,23.89L225.29,24.45L226.23,21.59L228.52,20.39L227.9,17.95L229.33,15.33L229.19,13.53L230.09,12.23L231.4,12.41L232.58,11.53L232.72,9.58L233.97,9.21L234.89,9.82L240.66,7.59L241.51,8.17L242.58,7.7L244.97,9.65L246.84,8.86L248.84,6.14L251.77,8.26L255.97,6.02L258.25,7.54L260.65,7.6L261.52,9.02L262.55,9.31L264.33,7.66L267.12,7.53L271.14,4.43L272.75,4.35L274.18,3.2L276.41,3.39L277.41,2.29L279.24,2.48L280.38,1.04L281.45,1.43L284.83,0z"
				},
				{
					"id":"IT-55",
					"title":"Umbria",
					"d":"M297.51,254.71l-0.52,-0.58l0,0l-0.19,-0.06l0,0l0.24,-0.68l0.66,0.31l0,0l0.1,0.53l0,0L297.51,254.71zM286.48,253.23l0.71,1.17l3.09,-0.04l0.35,0.56l2.08,-1.68l1.88,-0.12l-0.51,0.78l0.48,1.44l-2.92,2.7l1.36,1.42l1.43,-0.73l1.27,1.73l1.42,-2.09l0.99,0.13l0.83,1.42l0.92,0.05l0.29,-0.86l0.91,0.42l6.36,7.29l2.13,-1.29l2.23,0.82l1.32,-2.69l2.08,0.56l-0.37,2.01l0.9,0.84l-1.8,1.69l0.05,0.84l2.27,2.96l0.38,2.91l-0.62,0.7l1.88,1.34l0.67,3.42l1.39,0.69l-0.14,2.9l-1.62,1.55l0.67,1.54l2.07,0.42l0.57,1.71l-0.24,2.77l0.75,2.11l-0.87,0.66l0.94,1.95l-0.56,1.49l2.69,1.61l0.2,0.87l1.11,0.13l0.12,4.04l1.21,-1.36l0.02,-1.71l1.3,0.77l1.4,-1.39l3.01,2.3l2.5,3.94l2.67,-0.61l1.25,-1.82l1.41,3.62l-0.25,1.82l-0.92,1.9l-0.38,-0.77l-1.92,0.78l-0.25,2l0,0l-0.75,4.46l-1.33,1.28l-1.62,-0.64l-0.05,0.78l-2.8,1.72l-2.06,-1.08l-0.71,1.53l-3.25,-0.04l-0.79,0.97l-2.01,-0.99l-0.58,1.17l0.62,2.55l-2.09,0.67l-1.85,1.63l-2.05,-0.1l-0.17,1.33l-3.06,0.88l1.37,2.04l-2.99,1.97l-1.2,0.05l-0.89,-1.85l-1.19,0.08l-0.22,3.88l-4.33,3.36l-0.87,-1l0.05,-1.68l-3.64,0.53l0.97,-1.42l-2.29,-0.79l0.02,-2.06l0.68,-0.23l-0.74,-0.68l0.25,-1.86l-1.47,-0.16l-2,1.62l-1.23,-1.26l-1.87,0.22l0.69,-0.46l-1.52,-0.8l0.75,-0.67l-1.04,-0.85l0.21,-1.95l-1.67,-0.78l-0.55,-4.47l-1.67,-2.06l-1.62,-0.68l-1.38,1.19l-0.67,-0.21l-0.12,0.75l-1.01,-1.07l-3.68,1.31l-4.14,-2.56l-1.29,-2.11l1.85,-1.04l1.01,-1.98l-2.78,-1.79l-1.62,-3.88l0,0l1.95,-2.34l1.28,-0.08l-0.15,-1.81l-1.09,-0.75l2.42,-9.85l-1.27,-1.36l-0.84,1.05l-0.78,-1.57l0.33,-1.22l-0.88,-2.43l0.49,-1.32l5.18,-3.05l1,-2.73l-0.5,-1.32l0.83,-0.36l2.2,1.23l6.67,-4.18l-1.54,-1.26l-0.9,2.23l-2.23,-0.84l-0.39,-0.9l0.59,-1.71l-1.01,-2.29l-0.65,-0.6l-1.42,0.54l-0.11,-2.66l-2.14,0.22l-0.33,-1l1.71,-1.74l1.09,0.34l1.01,-1.7l2.13,-0.9l0.1,-0.56l-2.61,-1.48l0.17,-1.76l0.55,-0.56l2.19,0.18l0.77,-2.59L286.48,253.23z"
				},
				{
					"id":"IT-23",
					"title":"Valle d'Aosta",
					"d":"M48.76,82.18L49.34,83.35L53.16,82.81L54.07,84.29L55.39,84.83L56.03,86.76L57.63,85.61L60.1,87.22L61.27,86.56L63.34,87.29L63.34,87.29L64.04,91.35L63.34,96.4L65.05,99.5L66.67,100.1L67.03,101.3L65.37,104.13L67.19,107.86L65.99,108.1L65.26,111.14L64.25,110.49L61.61,110.69L56.72,114.16L56.04,113.55L53.72,113.93L51.75,112.63L50.34,113.29L50.21,112.42L48.2,111.17L46.12,112.3L44.27,111.83L43.04,112.22L42.11,113.79L38.57,116.63L37.61,115.96L35.73,116.85L32.93,116.92L30.54,119.93L27.47,118.86L26.57,119.54L26.21,116.69L24.44,120.25L24.44,120.25L21.72,119.86L21.99,118.23L19.2,117.47L18.97,112.41L18.02,111.41L19.19,107.62L17.45,106.57L14.85,106.75L14.33,105.3L11.88,104.38L9.36,101.47L9.73,100.27L8.97,97.32L9.98,93.18L11.17,92.84L12.16,93.48L12.89,92.29L14.68,92.91L16.17,92.44L16.7,91.41L19.01,90.6L19.33,88.54L21.39,86.8L24.55,91.6L27.12,90.05L28.98,91.55L30.22,89.44L32.35,89.38L34.18,86.96L38.9,88.8L43.35,86L43.31,85.01L44.66,83.96L46.88,84.38L47.18,82.25z"
				},
				{
					"id":"IT-34",
					"title":"Veneto",
					"d":"M303.59,157.18l-1.35,0.77l0.94,-1.05l-0.9,-0.37l1.6,-0.18L303.59,157.18zM301.95,155.08l1.19,0.9l-2.37,0.53l0.62,-1.75L301.95,155.08zM301.58,31l2.84,1.95l5.54,-0.56l2.07,0.74l0.89,1.09l0,0l-0.19,1.8l0.97,1.66l-0.7,2.27l0.88,1.16l-2.55,0.06l-3.46,2.18l-0.12,0.94l1.23,0.8l0.4,1.74l-1.82,-0.78l-1.04,0.79l-1.85,-0.79l-1.57,1.25l-0.41,-0.43l-1.48,2.04l-0.28,1.75l-2,1.76l0.32,1.39l-0.6,-0.27l0.18,0.6l-1.83,0.93l-0.33,2.02l-1.91,-0.27l-1.04,0.84l0.04,1.99l-1.8,1.89l2.12,2.85l2.08,-0.01l0.26,1.58l1.84,-0.1l0.3,2.13l2.42,1.95l-0.45,3.58l-2.9,1.96l-1.77,2.81l0.92,0.8l0.71,2.6l0.02,3.47l1.43,0.04l1.05,1.51l1.48,0.01l1.26,4.53l1.39,1.26l-0.21,1.2l2,1.05l0.68,-1.6l1.24,0.66l0.12,0.9l1.12,0.52l0.05,1.62l3.88,-3.59l0.67,0.68l1.98,-2.1l1.13,0.84l-0.43,1l0.63,0.73l0.55,-1.04l2.17,-1.08l0.64,0.07l-0.4,1.1l1.25,1.14l1.52,-0.94l0.49,1.09l1.55,-0.5l-0.45,-1.41l0.59,-0.24l0.58,1.58l-0.04,0.31l0.4,0.37l-0.17,0.82l0.82,0.35l-1.09,0.64l2.03,1.93l-0.49,0.26l0.65,1.3l-0.35,1.17l0.97,-0.71l0.57,2.67l0.79,0.2l-0.37,0.8l1.01,0.81l-0.17,1.32l0.98,-0.12l-0.12,0.61l1.07,0.6l0,0l-0.56,0.77l-4.92,0.34l0.09,-0.75l-0.91,-0.35l-0.48,1.36l-3,0.39l-0.95,1.29l-6.26,3.91l-15.92,7.41l-1.53,1.97l-1.67,-0.84l-1.92,2.58l-1.44,2.81l-0.1,1.08l0.83,0.39l-1.08,0.4l-1.56,6.49l1.36,0.42l-1.08,1.07l0.57,2.52l1.28,1.45l-0.29,5.3l1.44,1.22l1.58,3.1l-0.51,-0.34l-0.8,0.95l0.91,0.56l0.86,-0.63l-0.24,1.11l0.51,0.14l0.55,-0.31l-0.44,-1.76l0.49,0.03l4.3,5.37l-0.66,4.47l-1.07,0.98l0.04,2.85l-1.6,-0.55l0.34,-2.86l-1.02,-0.44l-0.92,0.38l-0.75,1.72l0.87,1.09l-0.38,2.07l0.78,0.66l0.65,-0.45l0.06,0.72l-1.32,-0.13l-0.11,1.44l-2.41,-1.92l0,0l-0.6,-2.18l-1.99,-0.51l-0.64,-0.95l-0.33,-2.89l0.63,-1.24l-0.83,-1.08l-1.08,0.01l-1.46,1.29l-2.15,-0.17l-0.81,-1.05l-1.48,0.97l-2.29,-3.08l-6.7,-1.07l-2.2,0.78l-6.27,-0.08l-2.92,1.36l-0.74,2.22l-3.19,0.9l-2.01,1.9l-1.24,0.12l-0.71,-0.24l-0.43,-1.62l-2.1,-1.41l-5.7,0.38l-0.16,-1.49l0,0l-0.23,-1.03l-7.98,-4.28l0,-2.46l-1.42,0.85l-3.13,-1.16l0.59,-1.62l-0.41,-1.01l1.27,-1.02l-3,-1.12l-0.93,1.68l-1.36,-0.73l-0.24,1.27l-1.2,-0.22l-2.32,-1.95l0.96,-1.88l-0.87,-0.55l-1.61,0.32l0.38,-1.71l-0.79,-1.22l-2.87,-1.3l0.1,-1.3l-1.82,-0.48l-0.11,-0.68l-2.64,-0.59l-1.12,-2.35l-1.96,-1.92l-2.41,2.01l-0.51,-0.99l-1.49,-0.38l0.68,-1.91l-0.99,-1.49l1.3,-0.97l-0.96,-0.75l0.96,-2.57l-2.46,-1.13l-0.7,0.81l-0.83,-0.18l0.41,-1.98l-1.13,-11.75l11.09,-16.5l0,0l2.68,1.66l-1.28,1.1l0.77,1.52l-2.18,4.03l2.18,0.01l2.05,1.02l-0.65,1.13l1.49,0.93l1.49,-1.69l0.49,1.05l1.85,-2.66l0.44,1.17l1.64,-0.88l1.93,1.84l1.6,0.21l2.5,-3.37l-0.13,-3.6l1.55,0.15l-0.6,-2.37l2.35,-2.83l0.87,-4.9l2.42,0.18l-0.02,-1.36l0.07,0.78l2.48,1.34l-0.35,-0.98l0.68,-1.54l1.29,-0.16l-0.37,-2.84l3.62,0.23l2.74,-2.26l2.15,-0.29l1.89,0.6l0.54,2.81l4.21,0.3l0.91,-1.87l-1.14,-2.02l0.73,-0.8l-0.73,-0.68l2.06,-0.6l-0.93,-1.54l0.01,-2.02l2.74,-0.87l0.67,0.77l0.74,-0.77l2.24,0.24l4.18,-1.46l1.71,-3.95l1.1,0.44l0.6,-1.6l-2.42,-2.22l0.79,-1.97l-1.21,-0.58l-0.64,0.41l-0.44,-1.94l-2.16,0.5l-0.79,-0.7l0.68,-1.89l-0.58,-1.41l-2.92,-2.43l2.36,-1.44l0.81,0.74l0.27,-3.66l2.3,-2.71l-0.59,-1.39l-3.08,-0.42l0.12,-1.65l4.87,-2.46l1.57,0.33l1.17,-1.18l1.16,-0.07l0.58,0.77l2.47,-3.92l-0.17,-1.48l1.52,-2.69l-0.31,-2.33l3.94,3.08l0.83,-0.29l1.55,0.98l0.11,2.26l3.34,-2.65l1.21,0.76l2.98,-0.94l0.75,0.89l1.26,-0.06l0.51,-0.46l-0.38,-1.32l0.87,0.2l1.67,-1.88l2.47,-0.92l0,0L301.58,31z"
				}
			]
		}
	}
};