<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateCouponsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('coupons', function (Blueprint $table) {
            $table->increments('id');
            $table->string('cop_title');
            $table->string('cop_code');
            $table->string('cop_description');
            $table->integer('discount');
            $table->integer('discount_bit');
            $table->date('validity')->nullable()->default(NULL);
            $table->integer('cop_category');
            $table->integer('cop_limit');
            $table->integer('cop_status')->default('1');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('coupons');
    }
}
