<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateBookedResourcesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('booked_resources', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('resource_quantity_id')->unsigned();
            $table->integer('order_id')->unsigned();
            $table->date('checkin');
            $table->date('checkout');
            $table->foreign('resource_quantity_id')->references('id')->on('resource_quantities')->onDelete('cascade');
            $table->foreign('order_id')->references('id')->on('orders')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('booked_resources');
    }
}
