<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateAttitionalResourceVariationsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('attitional_resource_variations', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('add_res_id')->unsigned();
            $table->integer('var_value_id')->unsigned();
            $table->integer('var_id')->unsigned();
            $table->integer('status')->default('1');
            $table->foreign('add_res_id')->references('id')->on('additional_resources')->onDelete('cascade');
            $table->foreign('var_id')->references('id')->on('variation')->onDelete('cascade');
            $table->foreign('var_value_id')->references('id')->on('variation_values')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('attitional_resource_variations');
    }
}
