<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateOrderShipingAdressesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('order_shiping_adresses', function (Blueprint $table) {
           $table->increments('id');
            $table->string('hotal_name');
            $table->string('hotal_adress');
            $table->string('reg_guest_name');
            $table->string('hotal_booking_no');
            $table->date('check_in_date');
            $table->date('check_out_date');
            $table->string('lat');
            $table->string('long');
            $table->string('shipping_charges');
            $table->integer('order_id')->unsigned();
                  $table->foreign('order_id')->references('id')->on('orders')->onDelete('cascade');

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('order_shiping_adresses');
    }
}
