<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateOrdersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('orders', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('total_amount')->default('0');
            $table->integer('status')->default('1');
            $table->integer('customer_id')->unsigned();
            // $table->integer('agent_id')->unsigned();
            $table->string('transaction_id');
            $table->string('payment_gateway');
            $table->string('cop_code');
            $table->integer('cop_discount');
            $table->integer('order_status')->default('0');
            $table->integer('reservation_id');
            $table->integer('reservation_status');
            $table->integer('payment_status');
            $table->integer('source');
            $table->integer('select_days');
            $table->foreign('customer_id')->references('id')->on('customers')->onDelete('cascade');
            // $table->foreign('agent_id')->references('id')->on('users')->onDelete('cascade');
            // $table->foreign('cop_id')->references('id')->on('coupons')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('orders');
    }
}
