<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateCartsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('carts', function (Blueprint $table) {
            $table->increments('id');
            $table->string('device_id');
            $table->integer('res_id')->unsigned();
            $table->integer('depot_id')->unsigned();
            $table->integer('agent_id');
            $table->integer('res_qty_id')->unsigned();    
            $table->date('date_check_in');    
            $table->date('date_check_out');    
            $table->foreign('res_id')->references('id')->
            on('resources')->onDelete('cascade');
            $table->foreign('depot_id')->references('id')->
            on('depots')->onDelete('cascade');
            $table->foreign('res_qty_id')->references('id')->
            on('resource_quantities')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('carts');
    }
}
