<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateAdditResQuantitiesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('addit_res_quantities', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('uid');
            $table->integer('add_res_id')->unsigned();
            $table->integer('status')->default('1');
            $table->foreign('add_res_id')->references('id')->
            on('additional_resources')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('addit_res_quantities');
    }
}
