<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateAdditionalResourcesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('additional_resources', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('add_res_id');
            $table->integer('depot_id')->unsigned();
            $table->integer('res_type_id')->unsigned();
            $table->integer('res_id')->unsigned();
            $table->integer('agent_id');
            $table->string('add_res_name'); 
            $table->text('add_res_description');
            $table->string('add_res_image');
            $table->integer('status')->default('1');
            $table->string('quatity_selectable');
            $table->string('notes_req');
            $table->foreign('depot_id')->references('id')->on('depots')->onDelete('cascade');
            $table->foreign('res_type_id')->references('id')->on('resource_types')->onDelete('cascade');
             $table->foreign('res_id')->references('id')->on('resources')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('additional_resources');
    }
}
