<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateResourcePriceRulesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('resource_price_rules', function (Blueprint $table) {
            $table->increments('id');
            $table->string('limit');
            $table->integer('price');
            $table->integer('resource_price_id')->unsigned();
            $table->integer('status')->default('1');
            $table->foreign('resource_price_id')->references('id')->
                    on('resource_prices')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('resource_price_rules');
    }
}
