<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateResourceVariationTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('resource_variation', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('res_id')->unsigned();
            $table->integer('var_value_id')->unsigned();
            $table->integer('status')->default('1');
            $table->foreign('res_id')->references('id')->on('resources')->onDelete('cascade');
            $table->foreign('var_value_id')->references('id')->on('variation_values')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('resource_variation');
    }
}
