<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateResourcesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('resources', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('res_id')->unique();
            $table->integer('res_type')->unsigned();
            $table->string('res_name');
            $table->integer('res_depot')->unsigned();
            $table->integer('res_agent')->unsigned();
            $table->text('res_details');
            $table->string('res_img');
            $table->integer('res_quantity');
            $table->foreign('res_type')->references('id')->on('resource_types')->onDelete('cascade');
            $table->foreign('res_depot')->references('id')->on('depots')->onDelete('cascade');
            $table->foreign('res_agent')->references('id')->on('users')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('resources');
    }
}
