<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateCustomersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('customers', function (Blueprint $table) {
        	$table->increments('id');
            $table->string('name');            
            $table->string('email');
            $table->string('phone');
			$table->text('address');
			$table->text('hotel_address');
			$table->integer('country');
			$table->string('location_phone');
            $table->text('notes');
            $table->integer('city');
            $table->integer('cus_city');
            $table->integer('cus_country');
            $table->string('cus_postal_code');
            $table->string('hotal_name');
            
            $table->integer('status')->default('1');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('customers');
    }
}
