<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateDepotsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('depots', function (Blueprint $table) {
            $table->increments('id');
             $table->string('name');
             $table->string('lat');
             $table->string('long');
            //  $table->integer('agent_id')->unsigned();
             $table->integer('created_by')->unsigned();
             $table->integer('status')->default('1');
             $table->integer('total_bicycle')->default('0'); 
             $table->string('depo_image');
            //  $table->foreign('agent_id')->references('id')->on('users')->onDelete('cascade');
            $table->foreign('created_by')->references('id')->on('users')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('depots');
    }
}
