<?php

namespace App;
use App\Depot;
use App\ResourceTypes;
use App\User;
use App\Variation;
use App\Resources;

use Illuminate\Database\Eloquent\Model;
use App\Traits\UploadFiles;
use File;

class Resources extends Model
{   
    use UploadFiles;
    protected $table = 'resources';
    protected $fillable = ['res_id', 'res_type', 'res_name', 'res_depot','res_agent','res_details','res_img','res_quantity' ,'created_by'];

    public function quantities()
    {
        return $this->hasMany(ResourceQuantity::class, 'resource_id', 'id');
    }

    public function images()
    {
        return $this->hasMany(ResourceImage::class, 'resource_id', 'id');
    }

    public function variations()
    {
        return $this->hasMany(ResourceVariation::class, 'res_id', 'id');
    }

    public function user()
    {
        return $this->belongsTo('App\User','res_agent');
    }


    public static function get_preloaded_data($source){
    	$data = [];
        if($source == 'create'){
            $data['res_id'] = Resources::genRandomId();    
        }
    	$data['depots'] = Depot::pluck('name','id')->toArray();
        $data['resource_types'] = ResourceTypes::pluck('name','id')->toArray();
        $data['agents'] = User::where('type',2)->pluck('name','id')->toArray();
        $data['variations'] = Variation::WhereRaw('status=1 AND (assosiate_with=1 OR assosiate_with=3)')->pluck('name','id')->toArray();
        return $data;
    }

    public static function resourceQuantityUidsManipulation($input, $resource_object){
        if(isset($input['quantity_uids'])){
            if($resource_object){
                $resource_object->quantities()->delete();
            }
            foreach ($input['quantity_uids'] as $key => $quantity_uid) {
                $resource_object->quantities()->create(['uid'=>$quantity_uid]);
            }
        }else{
            if($resource_object){
                $resource_object->quantities()->delete();
            }
        }
    }

    public static function resourceImagesManipulation($input, $resource_object){
        if(isset($input['slide_images'])){
            // $resource_object->images()->delete();
            foreach ($input['slide_images'] as $key => $image) {
                if (!file_exists(public_path('uploads/')))
                    File::makeDirectory(public_path('uploads/'));
                if (!file_exists(public_path('uploads/resource/')))
                    File::makeDirectory(public_path('uploads/resource/'));
                $filename = $image->store('resource', ['disk' => 'autods_files']);
                $file_url = 'uploads/'.$filename;
                $resource_object->images()->create(['image'=>$file_url]);
            }
        }else{
            // $resource_object->images()->delete();
        }

        if(isset($input['remove_slider_images']))
        {
            $remove_slider_images_array = explode(",",$input['remove_slider_images']);
            $resource_object->images()->whereIn('id', $remove_slider_images_array)->delete();
        }
    }

    public static function resourceAttributesManipulation($input, $resource_object){
        if(isset($input['attr_values'])){
            if($resource_object){
                $resource_object->variations()->delete();
            }
            foreach ($input['attr_values'] as $attr_id => $attr_value) {
                $resource_object->variations()->create(['var_value_id'=>$attr_value, 'var_id'=>$attr_id]);
            }
        }else{
            if($resource_object){
                $resource_object->variations()->delete();
            }
        }
    }

    public static function fileManipulation($input){
        $uploadFile = Resources::uploadFile(['input' => $input,'image_name' => 'res_img', 'path' => 'uploads/resources/', 'folder'=>'resources']);
        if($uploadFile != 'ignore' || $uploadFile == ''){$input['res_img'] = $uploadFile;}else{unset($input['res_img']);}
        return $input;
    }

    public static function genRandomId()
    {
      $existed_random_ids = Resources::select('res_id')->where('res_id','<>','')->pluck('res_id')->toArray();
      return Resources::genRandomIdString($existed_random_ids);
    }

    public static function genRandomIdString($existed_random_ids)
    {
      $idStr = str_pad(mt_rand(000000000, 999999999), 5, "0", STR_PAD_LEFT);
      if(in_array($idStr, $existed_random_ids))
      {
        return Resources::genRandomIdString($existed_random_ids);
      }else{
        return $idStr;
      }
    }
}
