<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class Order extends Model
{

    protected $table = 'orders';
    protected $fillable = ['customer_id','agent_id','reservation_id','status','total_amount','reservation_status','payment_status','source','select_days','order_status'];



      public static function allOrder(){
      return DB::Table('orders as odr')
       ->leftjoin('customers as cus', 'cus.id','=','odr.customer_id')
       ->leftjoin('order_shiping_adresses as osa','osa.order_id', '=', 'odr.id')
       ->leftjoin('order_details as od','od.order_id', '=', 'odr.id')
       ->leftjoin('booked_resources as br','br.order_id', '=', 'odr.id')
       ->leftjoin('users as usr','usr.id', '=', 'od.agent_id' )
       ->SELECT('odr.id','cus.name as CustomerN','usr.name','odr.status','odr.total_amount',
        'odr.order_status','odr.created_at','osa.shipping_charges','od.depot_name', 'osa.remote_delivery_charges', 'br.checkin','checkout')
       ->orderBy('odr.created_at', 'DESC')
       ->groupBy('odr.id')
       ->paginate(25);
    }

      public static function order_agent_records($agent_id){
    	 return DB::Table('orders as odr')
       ->leftjoin('customers as cus', 'cus.id','=','odr.customer_id')
       ->leftjoin('order_shiping_adresses as osa','osa.order_id', '=', 'odr.id')
       ->leftjoin('order_details as od','od.order_id', '=', 'odr.id')
       ->leftjoin('users as usr','usr.id', '=', 'od.agent_id'  )
       ->SELECT('odr.id','cus.name as CustomerN','usr.name','odr.status','odr.total_amount',
        'odr.order_status','odr.created_at','osa.shipping_charges','od.depot_name', 'osa.remote_delivery_charges')
       ->where('od.agent_id', $agent_id)
       ->orderBy('odr.created_at', 'DESC')
          ->groupBy('odr.id')
       ->paginate(25);
    }

     public static function completeOrder(){
       return DB::Table('orders as odr')
       ->leftjoin('customers as cus', 'cus.id','=','odr.customer_id')
       ->leftjoin('order_shiping_adresses as osa','osa.order_id', '=', 'odr.id')
       ->leftjoin('order_details as od','od.order_id', '=', 'odr.id')
       ->leftjoin('users as usr','usr.id', '=', 'od.agent_id' )
       ->SELECT('odr.id','cus.name as CustomerN','usr.name','odr.status','odr.total_amount',
        'odr.order_status','odr.created_at','osa.shipping_charges','od.depot_name')
       ->where('order_status','=','1')
       ->orderBy('odr.created_at', 'DESC')
       ->groupBy('odr.id')
       ->paginate(25);
    }

      public static function completeOrder_agent_record($agent_id){
       return DB::Table('orders as odr')
       ->leftjoin('customers as cus', 'cus.id','=','odr.customer_id')
       ->leftjoin('order_shiping_adresses as osa','osa.order_id', '=', 'odr.id')
       ->leftjoin('order_details as od','od.order_id', '=', 'odr.id')
       ->leftjoin('users as usr','usr.id', '=', 'od.agent_id'  )
       ->SELECT('odr.id','cus.name as CustomerN','usr.name','odr.status','odr.total_amount',
        'odr.order_status','odr.created_at','osa.shipping_charges','od.depot_name')
       ->where('od.agent_id', $agent_id)
       ->where('order_status','=','1')
       ->orderBy('odr.created_at', 'DESC')
      ->groupBy('odr.id')
       ->paginate(25);
    }

       public static function pendingOrder(){
       return DB::Table('orders as odr')
       ->leftjoin('customers as cus', 'cus.id','=','odr.customer_id')
       ->leftjoin('order_shiping_adresses as osa','osa.order_id', '=', 'odr.id')
       ->leftjoin('order_details as od','od.order_id', '=', 'odr.id')
       ->leftjoin('users as usr','usr.id', '=', 'od.agent_id' )
       ->SELECT('odr.id','cus.name as CustomerN','usr.name','odr.status','odr.total_amount',
        'odr.order_status','odr.created_at','osa.shipping_charges','od.depot_name')
       ->where('order_status','=','2')
       ->orderBy('odr.created_at', 'DESC')
       ->groupBy('odr.id')
       ->paginate(25);
    }

      public static function pendingOrder_agent_record($agent_id){
       return DB::Table('orders as odr')
       ->leftjoin('customers as cus', 'cus.id','=','odr.customer_id')
       ->leftjoin('order_shiping_adresses as osa','osa.order_id', '=', 'odr.id')
       ->leftjoin('order_details as od','od.order_id', '=', 'odr.id')
       ->leftjoin('users as usr','usr.id', '=', 'od.agent_id'  )
       ->SELECT('odr.id','cus.name as CustomerN','usr.name','odr.status','odr.total_amount',
        'odr.order_status','odr.created_at','osa.shipping_charges','od.depot_name')
       ->where('od.agent_id', $agent_id)
       ->where('order_status','=','2')
       ->orderBy('odr.created_at', 'DESC')
          ->groupBy('odr.id')
       ->paginate(25);
    }

       public static function processOrder(){
       return DB::Table('orders as odr')
       ->leftjoin('customers as cus', 'cus.id','=','odr.customer_id')
       ->leftjoin('order_shiping_adresses as osa','osa.order_id', '=', 'odr.id')
       ->leftjoin('order_details as od','od.order_id', '=', 'odr.id')
       ->leftjoin('users as usr','usr.id', '=', 'od.agent_id' )
       ->SELECT('odr.id','cus.name as CustomerN','usr.name','odr.status','odr.total_amount',
        'odr.order_status','odr.created_at','osa.shipping_charges','od.depot_name')
       ->where('order_status','=','3')
       ->orderBy('odr.created_at', 'DESC')
       ->groupBy('odr.id')
       ->paginate(25);
    }

      public static function processOrder_agent_record($agent_id){
       return DB::Table('orders as odr')
       ->leftjoin('customers as cus', 'cus.id','=','odr.customer_id')
       ->leftjoin('order_shiping_adresses as osa','osa.order_id', '=', 'odr.id')
      ->leftjoin('order_details as od','od.order_id', '=', 'odr.id')
       ->leftjoin('users as usr','usr.id', '=', 'od.agent_id'  )
       ->SELECT('odr.id','cus.name as CustomerN','usr.name','odr.status','odr.total_amount',
        'odr.order_status','odr.created_at','osa.shipping_charges','od.depot_name')
       ->where('od.agent_id', $agent_id)
       ->where('order_status','=','3')
       ->orderBy('odr.created_at', 'DESC')
          ->groupBy('odr.id')
       ->paginate(25);
    }

        public static function cancelOrder(){
       return DB::Table('orders as odr')
       ->leftjoin('customers as cus', 'cus.id','=','odr.customer_id')
       ->leftjoin('order_shiping_adresses as osa','osa.order_id', '=', 'odr.id')
        ->leftjoin('order_details as od','od.order_id', '=', 'odr.id')
       ->leftjoin('users as usr','usr.id', '=', 'od.agent_id' )
       ->SELECT('odr.id','cus.name as CustomerN','usr.name','odr.status','odr.total_amount',
        'odr.order_status','odr.created_at','osa.shipping_charges','od.depot_name')
       ->where('order_status','=','4')
       ->orderBy('odr.created_at', 'DESC')
       ->groupBy('odr.id')
       ->paginate(25);
    }

      public static function cancelOrder_agent_record($agent_id){
       return DB::Table('orders as odr')
       ->leftjoin('customers as cus', 'cus.id','=','odr.customer_id')
       ->leftjoin('order_shiping_adresses as osa','osa.order_id', '=', 'odr.id')
       ->leftjoin('order_details as od','od.order_id', '=', 'odr.id')
       ->leftjoin('users as usr','usr.id', '=', 'od.agent_id'  )
       ->SELECT('odr.id','cus.name as CustomerN','usr.name','odr.status','odr.total_amount',
        'odr.order_status','odr.created_at','osa.shipping_charges','od.depot_name')
       ->where('od.agent_id', $agent_id)
       ->where('order_status','=','4')
       ->orderBy('odr.created_at', 'DESC')
       ->groupBy('odr.id')
       ->paginate(25);
    }




        public static function genRandomId()
    {
      $existed_random_ids = Order::select('reservation_id')->where('reservation_id','<>','')->pluck('reservation_id')->toArray();
      return Order::genRandomIdString($existed_random_ids);
    }

    public static function genRandomIdString($existed_random_ids)
    {
      $idStr = str_pad(mt_rand(000000000, 999999999), 5, "0", STR_PAD_LEFT);
      if(in_array($idStr, $existed_random_ids))
      {
        return Order::genRandomIdString($existed_random_ids);
      }else{
        return $idStr;
      }
    }



    // public static function viewData($orderId){

    //   $data = [];
    //   $data['resources'] = DB::table('order_details as OD')
    //   ->select("OD.res_name","OD.uid",'R.res_img','P.basic_rate')
    //   ->join('resources as R', 'R.id','=', 'OD.res_id')
    //   ->join('resource_prices as P', 'P.resource_id', '=', 'R.id')
    //   ->where('OD.order_id', $orderId)
    //   ->get();

    //   $data['additional_resources'] = DB::table('order_addit_resources as ODD')
    //   ->select("ODD.quantity","ODD.note",'AR.add_res_name','AP.rate','AR.add_res_image')
    //   ->join('additional_resources as AR', 'AR.id','=', 'ODD.add_res_id')
    //   ->join('additional_res_pricings as AP', 'AP.add_res_id', '=', 'AR.id')
    //   ->where('ODD.order_id', $orderId)
    //   ->get();

    //   // $data['orders'] = DB::table('orders as O')
    //   //    ->select("O.total_amount","OSA.shipping_charges")
    //   //    ->join('order_shiping_adresses as OSA', 'OSA.order_id','=', 'O.id')
    //   //    ->where('O.id', $orderId)
    //   //    ->first();

    //   $data['orders'] = Order::where('id', $orderId)->first();
    //   $data['booked'] = BookedResources::where('order_id', $orderId)->first();
    //   $data['order_shipping_detail'] = OrderShipingAdress::where('order_id', $orderId)->first();

    //   $data['depo'] = DB::table('order_details as OD')
    //   ->select("D.name")
    //   ->join('depots as D', 'D.id','=', 'OD.depot_id')
    //   ->where('OD.order_id', $orderId)
    //   ->first();

    //   return $data;

    // }


    // public static function viewDataAcordingAgent($orderId,$agentId){
      
    //   $data = [];
    //   $data['resources'] = DB::table('order_details as OD')
    //   ->select("OD.res_name","OD.uid",'R.res_img','P.basic_rate')
    //   ->join('resources as R', 'R.id','=', 'OD.res_id')
    //   ->join('resource_prices as P', 'P.resource_id', '=', 'R.id')
    //   ->where('OD.order_id', $orderId)
    //   ->where('OD.agent_id', $agentId)
    //   ->get();

    //   $data['additional_resources'] = DB::table('order_addit_resources as ODD')
    //   ->select("ODD.quantity","ODD.note",'AR.add_res_name','AP.rate','AR.add_res_image')
    //   ->join('additional_resources as AR', 'AR.id','=', 'ODD.add_res_id')
    //   ->join('additional_res_pricings as AP', 'AP.add_res_id', '=', 'AR.id')
    //   ->where('ODD.order_id', $orderId)
    //   ->get();

    //   // $data['orders'] = DB::table('orders as O')
    //   //    ->select("O.total_amount","OSA.shipping_charges")
    //   //    ->join('order_shiping_adresses as OSA', 'OSA.order_id','=', 'O.id')
    //   //    ->where('O.id', $orderId)
    //   //    ->first();

    //   $data['orders'] = Order::where('id', $orderId)->first();
    //   $data['booked'] = BookedResources::where('order_id', $orderId)->first();
    //   $data['order_shipping_detail'] = OrderShipingAdress::where('order_id', $orderId)->first();

    //   $data['depo'] = DB::table('order_details as OD')
    //   ->select("D.name")
    //   ->join('depots as D', 'D.id','=', 'OD.depot_id')
    //   ->where('OD.order_id', $orderId)
    //   ->first();

    //   return $data;

    // }


    public static function viewDataAllAgent($orderId){

      $resources = [];
      $resources['resources'] = DB::table('order_details as OD')
      ->select("R.id","OD.res_name","OD.uid",'R.res_img','P.basic_rate')
      ->join('resources as R', 'R.id','=', 'OD.res_id')
      ->join('resource_prices as P', 'P.resource_id', '=', 'R.id')
      ->where('OD.order_id', $orderId)
      ->get();
      return $resources;

   }

    public static function viewDataAcordingAgent($orderId,$agentId){
    
      $resources = [];
      $resources['resources']= DB::table('order_details as OD')
      ->select("R.id","OD.res_name","OD.uid",'R.res_img','P.basic_rate')
      ->join('resources as R', 'R.id','=', 'OD.res_id')
      ->join('resource_prices as P', 'P.resource_id', '=', 'R.id')
      ->where('OD.order_id', $orderId)
      ->where('OD.agent_id', $agentId)
      ->get();
      return $resources;
    }

    public static function viewData($orderId){

      $data = [];
      $data['additional_resources'] = DB::table('order_addit_resources as ODD')
      ->select("ODD.quantity","ODD.note",'AR.add_res_name','AP.rate','AR.add_res_image')
      ->join('additional_resources as AR', 'AR.id','=', 'ODD.add_res_id')
      ->join('additional_res_pricings as AP', 'AP.add_res_id', '=', 'AR.id')
      ->where('ODD.order_id', $orderId)
      ->get();

      // $data['orders'] = DB::table('orders as O')
      //    ->select("O.total_amount","OSA.shipping_charges")
      //    ->join('order_shiping_adresses as OSA', 'OSA.order_id','=', 'O.id')
      //    ->where('O.id', $orderId)
      //    ->first();

      $data['orders'] = Order::where('id', $orderId)->first();
      $data['booked'] = BookedResources::where('order_id', $orderId)->first();
      $data['order_shipping_detail'] = OrderShipingAdress::where('order_id', $orderId)->first();

      $data['depo'] = DB::table('order_details as OD')
      ->select("D.name")
      ->join('depots as D', 'D.id','=', 'OD.depot_id')
      ->where('OD.order_id', $orderId)
      ->first();
    
      $data['customer'] = DB::table('orders')
      ->join('customers', 'customers.id','=', 'orders.customer_id')
      ->join('countries', 'countries.id','=', 'customers.cus_country')
      ->join('cities', 'cities.id','=', 'customers.cus_city')
      ->select('customers.*', 'countries.country_name','cities.city_name')
      ->where('orders.id', $orderId)
      ->first();
      
      return $data;

    }



}
