<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class TypeEditRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'type_id'=>'required|sometimes|max:15|min:3|unique:resource_types,type_id,'.$this->id.'',
            'name'=>'required|max:100|min:3',
            'description' => 'required|min:3' 
        ];
    }
}
