<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class AgentAddRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'name'=>'required|max:100|min:3|',
            'email'=>'required|email|unique:users',
            'password' => 'required|min:8',
            'confirm' => 'required|same:password',
            'confirm' => 'required|same:password',
            'address' => 'required',
        ];
    }
}
