<?php

namespace App\Http\Controllers\reservation;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use App\User;
use App\Customer;
use App\ResourcePrice;
use App\OrderDetail;
use App\Order;
use App\OrderAdditResource;
use App\OrderShipingAdress;
use App\BookedResources;
use App\Depot;
use App\Cart;
use App\Common;
use App\ResourceVariation;
use App\VariationValue;
use Illuminate\Support\Facades\Session;


class ReservationController extends Controller
{
    
    //   public function all_resvation(){
    //     return view('admin.reservation.all_resvation');   
    // }

      public function add_resvation(){


          $agentId = Auth::user()->id;
          $currentUser = User::find($agentId);
          $type = $currentUser->type;

         if($type == 1){
            $data['depots'] = DB::table('depots')->get();
         }else{
             $data['depots']=Depot::get_agent_records($agentId);
         }

  		// $data['depots'] = DB::table('depots')->get();
  		$data['countries'] = DB::table('countries')->get();
  		$data['reservation_id'] = Order::genRandomId();

        return view('admin.reservation.add_resvation', $data);   
    }




		public function city(Request $request){
			$cities = DB::table("cities")
		            ->where("country_id",$request->country_id)
		            ->select("city_name","id")
		            ->orderBy('city_name', 'ASC')
		            ->get();
		            // die;
		    return $cities;
		}


		public function get_depot_resource(Request $request){
	
			   $check_in = date("Y-m-d", strtotime($request->check_in_date));
			   $resources = DB::select("SELECT * FROM `booked_resources` WHERE `checkout` >= '".$check_in."' ");
			   $a = '';
			 for ($res=0; $res <count($resources); $res++)
			 { 
			 	$a .= $resources[$res]->resource_quantity_id.",";
			 }

		     $booked_resources = rtrim($a,',');
		    
			
			if(!empty($booked_resources)){

				$available_resources = DB::select(
					"select `res`.`id`, `res`.`res_name`, `res`.`res_img`, `resprice`.`basic_rate`, `resqty`.`uid`, `resqty`.`id` as `uidID` 
					from `resources` as `res` 
					left join `resource_prices` as `resprice` on `resprice`.`resource_id` = `res`.`id` 
					inner join `resource_quantities` as `resqty` on `res`.`id` = `resqty`.`resource_id`
					where `res_depot` = ".$request->dep_id." 
					AND `resqty`.`id` NOT IN (".$booked_resources.") 
					GROUP BY `resqty`.`resource_id` ");

			}else{
				$available_resources = DB::select(
					"select `res`.`id`, `res`.`res_name`, `res`.`res_img`, `resprice`.`basic_rate`, `resqty`.`uid`, `resqty`.`id` as `uidID` 
					from `resources` as `res` 
					left join `resource_prices` as `resprice` on `resprice`.`resource_id` = `res`.`id` 
					inner join `resource_quantities` as `resqty` on `res`.`id`=`resqty`.`resource_id` 
					where `res_depot` = ".$request->dep_id." 
					GROUP BY `resqty`.`resource_id` ");

			}			

			return response()->json($available_resources);
		}


		// 	public function get_depot_resource(Request $request){
		// 	 $resources = DB::table("resources as res")
	 //          ->leftjoin('resource_prices as resprice','resprice.resource_id', '=', 'res.id')
	 //          ->join ('resource_quantities as resqty','res.id', '=' ,'resqty.resource_id')
	 //          ->join ('booked_resources as bkres','bkres.resource_quantity_id','<>','resqty.id')
	 //          ->where("res_depot",$request->dep_id)

	 //          ->select("res.id","res.res_name","res.res_img","resprice.basic_rate","resqty.uid",
	 //          	"resqty.id as uidID")
	 //          ->groupBy('resqty.resource_id')
	 //          ->get();

				             

		//     return response()->json($resources);
		// }

			public function get_depot_addit_resource(Request $request){
			return $add_resources = DB::table("additional_resources as add_res")
		        ->leftjoin('additional_res_pricings as add_resprice','add_resprice.add_res_id', '=', 
		        	'add_res.id')
		        ->where("depot_id",$request->dep_id)
				->select("add_res.id","add_res.add_res_name","add_res.add_res_image","add_resprice.rate")
				->get();
				die;
				             

		    return response()->json($add_resources);
		}

		public function insert_cart_data(Request $request){
			$checkin = date("Y-m-d", strtotime($request->checkin));
			$checkout = date("Y-m-d", strtotime($request->checkout));
			$sec_id = Session::getId();
			// return $id;
			$data = array(
            'depot_id'   => $request->depot_id,
            'res_id'     => $request->res_id,
            'res_name'   => $request->res_name,
            'res_qty_id' => $request->uidID,
            'uid'        => $request->uid,
            'price'      => $request->price,
            'date_check_in'    => $checkin,
            'date_check_out'    => $checkout,
            'device_id'    => $sec_id,
	        );
			$cart =  Cart::create($data);
			  return $cart->id;
		}
	

			public function check_cart_resources(Request $request){

			 $cart = DB::select("SELECT res_qty_id FROM `carts`");
			 $a = '';
				for ($c=0; $c <count($cart); $c++)
				{ 
				    $a .= $cart[$c]->res_qty_id.",";
				}
				$selected_resources = rtrim($a,',');

		    $check_in = date("Y-m-d", strtotime($request->checkin));
		    $resources = DB::select("SELECT * FROM `booked_resources` WHERE `checkout` >= '".$check_in."' ");
			$b = '';
				 for ($res=0; $res <count($resources); $res++)
				 { 
				 	$b .= $resources[$res]->resource_quantity_id.",";
				 }
				$booked_resources = rtrim($b,',');
			

			if(!empty($booked_resources)){
				$check_cart= DB::select(
					"select `resource_quantities`.`uid` as uidd, `resource_quantities`.`id` as `uidIDD` 
					from `resource_quantities`  
					where `resource_quantities`.`resource_id` = ".$request->check_res_id."
					AND `resource_quantities`.`id` NOT IN (".$selected_resources.") 
					AND `resource_quantities`.`id` NOT IN (".$booked_resources.")					
					GROUP BY `resource_quantities`.`resource_id` ");

			}else{
				$check_cart= DB::select(
					"select `resource_quantities`.`uid` as uidd, `resource_quantities`.`id` as `uidIDD` 
					from `resource_quantities`  
					where `resource_quantities`.`resource_id` = ".$request->check_res_id."
					AND `resource_quantities`.`id` NOT IN (".$selected_resources.")					
					GROUP BY `resource_quantities`.`resource_id` ");

			}	
			return response()->json($check_cart);
			}



			public function get_cart_data(){
				 $sec_id = Session::getId();

				    $get_cart = DB::table('carts')
				    ->select('carts.id','carts.res_name','carts.uid','carts.price' , 'resources.res_img')
				    ->join('resources' , 'carts.res_id' , '=', 'resources.id') 
				    ->where('device_id', $sec_id)
				    ->get();

				  return response()->json($get_cart);
			}

			public function delete_cart_row(Request $request){
				 $device_id = Session::getId();
		         $id =  $request->cart_id;
		         $delete = DB::table('carts')->where([['device_id', $device_id],['id',$id]])->delete();
		        if($delete>0){
		         return "Resource Is Deleted";
		        
		        }else{
		           return "Particulary ID Not Found";
		        }
		        
		     }

	          public function delete_cart(){
		        $device_id = Session::getId(); 
		        $delete =DB::table('carts')->where('device_id', $device_id)->delete();
		        if($delete>0){
		          return "Cart Is Deleted";     
		        }else{
		          return "Device ID Not Found";
		      }
	  		}


		public function make_reservation(Request $request){

			// $depot_row = Depot::where('id',$request->depot)->first();
			// $agentId = $depot_row->agent_id;
			// $agent = User::where('id', $depot_row->agent_id)->first();
			// return $agent->name;
			// die;

		    $agentId = Auth::user()->id;
	        $exsisting_email = Customer::where('email', $request->email)->first();
	    
	            if(empty($exsisting_email->email)){ 
	                   $data = array(
		                    'name'        => $request->fName ." " . $request->lName,
		                    'phone'       => $request->phone,
		                    'email'       => $request->email,
		                    'cus_country' => $request->country,
		                    'cus_city'    => $request->city,
		                    'address'     => $request->address
	                );

		                  $customer_data = Customer::create($data);
		                  $email_id = $customer_data->id;
	            }
	                  else{
	                  	  $email_id =	$exsisting_email->id;                     
	            } 
	            		


	            	    $device_id = Session::getId();
		                $cartdata=Common::cartdata($device_id);
		                $count =  count($cartdata);
		                if ($count>0) {
		                	// return $cartdata;
		                	// die;

		                 ////////////////start Orders Table//////////////////
		                	$data = array(
			                    'customer_id'   => $email_id, 
			                    'agent_id'      =>  $agentId,
			                    'reservation_id'=> $request->reservation,
			                    'status'     => $request->optionsRadios,
			                    'total_amount' => $request->res_t_price + $request->add_res_t_price,
			                    'reservation_status' => $request->reservation_status,
			                    'payment_status' => $request->payment_status,
			                    'source' => $request->source,
		                       );	
		                               
		                     $order_row = Order::create($data);
		 				     $order_id  = $order_row->id;
		 				     $order_status = $order_row->status;
						  ////////////////END Orders Table/////////////////////


		 				  ////////////////Start Orders Detail/////////////////////
		 				      for($i=0;$i<$count;$i++){
		                            $id = $cartdata[$i]->id;
		                            $device_id = $cartdata[$i]->device_id;
		                            $res_id = $cartdata[$i]->res_id;
		                            $res_name = $cartdata[$i]->res_name;
		                            $depot_id = $cartdata[$i]->depot_id;
		                            // $depot_name = $cartdata[$i]->depot_name;
		                            $res_qty_id = $cartdata[$i]->res_qty_id;
		                            $uid = $cartdata[$i]->uid;
		                            $date_check_in = $cartdata[$i]->date_check_in;
		                            $date_check_out = $cartdata[$i]->date_check_out;

		                            $detailReg = new OrderDetail();
		                            $detailReg->order_id = $order_id;
		                            $detailReg->device_id = $device_id;
		                            $detailReg->res_id = $res_id;
		                            $detailReg->res_name = $res_name;
		                            $detailReg->depot_id = $depot_id;
		                            // $detailReg->depot_name = $depot_name;
		                            $detailReg->res_qty_id = $res_qty_id;
		                            $detailReg->uid = $uid;
		 				     ////////////////End Orders Detail/////////////////////

			                            if($detailReg->save()){

		 				     ////////////////Start Booked Resources/////////////////		 
			                                $booked = new BookedResources();
			                                $booked->order_id = $order_id;
			                                $booked->resource_quantity_id = $res_qty_id;
			                                $booked->checkin = $date_check_in;
			                                $booked->checkout = $date_check_out;
			                                $booked->save();
										    Cart::where('id',$id)->delete();
			                              }			                       
			                 /////////////End Booked Resources/////////////////////

 								}


  						     /////////////Start addititonal Resources/////////////////////
			                        $selectedAdditResources =  $request->selectedAdditResources;
			 				     	$add_resource_id = $request->add_resource_id;
			 				     	$additional_quantity = $request->additional_quantity;
			 				     	$notes = $request->notes;

				 				     	for($j=0;$j<count($selectedAdditResources);$j++){
						 					if($selectedAdditResources[$j] == 'yes'){
							 				       $order_id = $order_id;
							 				       $add_res_id =  $request->add_resource_id[$j];
							 				       $quantity =  $request->additional_quantity[$j];
					 				     	 	   $notes = $request->notes[$j];
					                			  
					                			     $detailReg1 = new OrderAdditResource();
							 				     	 $detailReg1->order_id = $order_id;
							 				     	 $detailReg1->add_res_id = $add_res_id;
							 				     	 $detailReg1->quantity = $quantity;
									                 $detailReg1->note = $notes;
							                    	 $detailReg1->save();
								            }
									             else{
									                // echo 'no';
									            }                           		
							 			}
							    /////////////End addititonal Resources/////////////////////


	    // ******************************Start Order Mail Code***********************************
						     $customer_data = Customer::where('id',$order_row->customer_id)->first();
						     $order_detail = OrderDetail::where('order_id', $order_id)->get();
						    $depo =   DB::table('order_details as OD')
							           ->select("D.name","D.agent_id")
							           ->join('depots as D', 'D.id','=', 'OD.depot_id')
							           ->where('OD.order_id', $order_id)
							           ->first();
							 $agent_data = User::where('id', $depo->agent_id)->first();

						       $msg = "Your Order ID is ".$order_id."\n"; 
						       $msg.= "Agent Name  ".$agent_data->name."\n";
						       $msg.= "Customer Name ".$customer_data->name."\n";
						       $msg.= "Customer Email ".$customer_data->email."\n";
						       $msg.= "Customer Address ".$customer_data->address."\n";
						       $msg.= "Customer Phone ".$customer_data->phone."\n";
						       $msg.= "Depot Name ".$depo->name."\n"; 

			                for ($i=0; $i < count($order_detail); $i++) { 
			                  $reso_id    =  $order_detail[$i]->res_id;	
			                  $res_name   = $order_detail[$i]->res_name;
			                  $uid        = $order_detail[$i]->uid;

						       $msg.= "Resource Name ".$res_name."\n";
						       $msg.= "UID ".$uid."\n";

						      $res_var_val = ResourceVariation::where('res_id', $reso_id)->get();
						                for ($j=0; $j < count($res_var_val); $j++) { 
						                     $valueID =  $res_var_val[$j]->var_value_id;
						                    $varValue = VariationValue::where('id', $valueID)->first();
						                    $v_value = $varValue->v_value;
						       $msg.= "V Value ".$v_value."\n";
						                      }
						                   }

						       $msg.= "Amount ".$order_row->total_amount."\n";
						       // $msg.= "Transaction Id ".$reg->transaction_id."\n";
						       // $msg.= "Payment Gateway  ".$reg->payment_gateway."\n";
	   // ******************************End Order Mail Code***********************************




							   /////////////Start Shipping Detail/////////////////////
										if($order_status == 2 || $order_status == 3){
							 				$checkin =  $request->check_in;
							 				$checkout = $request->check_out;
							 				$check_in = date("Y-m-d", strtotime($checkin)); 
							 				$check_out = date("Y-m-d", strtotime($checkout)); 

							 				$data = array(
							 					'order_id' => $order_id,
							                    'hotal_booking_no' => $request->hotal_booking_number,
							                    'hotal_name'       => $request->hotal_name,
							                    'reg_guest_name'       => $request->reg_guest_name,
							                    'hotal_adress' => $request->hotal_address,
							                    'check_in_date'    => $check_in,
							                    'Check_out_date'     => $check_out,
							                    'shipping_charges'     => $request->charges
					                         );
							 				 OrderShipingAdress::create($data);

				/***********************start Order Shipping Mail code*************************/
			            $o_ship_adres = OrderShipingAdress::where('order_id',$order_id)->first();

			               $msg.= "Hotal Booking No ".$o_ship_adres->hotal_booking_no."\n";
			               $msg.= "Hotal Name ".$o_ship_adres->hotal_name."\n";
			               $msg.= "Hotal Adress ".$o_ship_adres->hotal_adress."\n";
			               $msg.= "Reg Guest Name ".$o_ship_adres->reg_guest_name."\n";
			               $msg.= "Shipping Charges ".$o_ship_adres->shipping_charges."\n";
			               $total_charges = $o_ship_adres->shipping_charges + $order_row->total_amount;
			               $msg.= "Total Charges ".$total_charges."\n";
			  /************************* End Order Shipping mail code**********************/
							 			}
							  /////////////Start Shipping Detail/////////////////////
		
		                }else{
		                	Session::flash('message', 'Your Device ID is Not Exit.');
                            return redirect()->back();
		                }


                       $agent_email= $agent_data->email;
                       $subject = "New Booking for Astuto CC";
                       mail($to_email,$subject,$msg);

                 $cus = Customer::where('id', $order_row->customer_id)->first();
	             $customer_email =  $cus->email;
	             $booked_res = BookedResources::where('order_id',$order_id)->first();

     			 $cus_msg= "Dear ".$cus->name."\n";
     			 $cus_msg.= "We have received your reservation for the rental Resource starting from ".$booked_res->checkin." and finishing on "
     			 .$booked_res->checkout.". Your reservation will be confirmed upon receipt of payment. \n";
     			 $cus_msg.= "Pickup or delivery of the rental item(s) will be based on your delivery selection in the reservation. \n";
     			 $cus_msg.= "Your rental item(s) are located at ".$depo->name."\n";
     			 $cus_msg.= "Thank you for your reservation, we will be contacting you soon.If you have any questions or need to make a change please contact us following this link. \n";
                 $cus_msg.= "AstutoCC"; 
	             $cust_subject = "Order for Astuto CC";
                  mail($customer_email,$cust_subject,$cus_msg);



			 	  Session::flash('message', 'Reservation has been successfully created.');
                  return redirect('all_orders');

		}


}








