<?php

namespace App\Http\Controllers\reservation;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use App\User;
use App\Customer;
use App\ResourcePrice;
use App\OrderDetail;
use App\Order;
use App\OrderAdditResource;
use App\OrderShipingAdress;
use App\BookedResources;
use App\Depot;
use App\Cart;
use App\Common;
use App\PriceKm;
use App\ResourceVariation;
use App\VariationValue;
use App\AdditionalResource;
use App\AttitionalResourceVariation;
use Illuminate\Support\Facades\Session;
use Carbon\Carbon;
use Illuminate\Support\Facades\Crypt;


class ReservationController extends Controller
{
    
    //   public function all_resvation(){
    //     return view('admin.reservation.all_resvation');   
    // }

      public function add_resvation(){


          $agentId = Auth::user()->id;
          $currentUser = User::find($agentId);
          $type = $currentUser->type;
          DB::table('carts')->truncate();

         if($type == 1){
            $data['depots'] = DB::table('depots')->get();
         }else{
             $data['depots']=Depot::get_agent_records($agentId);
         }

  		// $data['depots'] = DB::table('depots')->get();
  		$data['countries'] = DB::table('countries')->orderBy('country_name', 'ASC')->get();
  		$data['reservation_id'] = Order::genRandomId();

        return view('admin.reservation.add_resvation', $data);   
    }




		public function city(Request $request){
			$cities = DB::table("cities")
		            ->where("country_id",$request->country_id)
		            ->select("city_name","id")
		            ->orderBy('city_name', 'ASC')
		            ->get();
		            // die;
		    return $cities;
		}


		public function get_depot_resource(Request $request){
	
			   $check_in = date("Y-m-d", strtotime($request->check_in_date));
			   $check_out = date("Y-m-d", strtotime($request->chek_out_date));
			   $resources = DB::select("SELECT * FROM `booked_resources` WHERE `checkout` >= '".$check_in."' AND `checkout` <= '".$check_out."' ");
			   $a = '';
			 for ($res=0; $res <count($resources); $res++)
			 { 
			 	$a .= $resources[$res]->resource_quantity_id.",";
			 }

		     $booked_resources = rtrim($a,',');
		    
			
			if(!empty($booked_resources)){

				$available_resources = DB::select(
					"select `res`.`id`, `res`.`res_name`, `res`.`res_img`, `resprice`.`basic_rate`, `resqty`.`uid`, `resqty`.`id` as `uidID` ,`res`.`res_agent`
					from `resources` as `res` 
					left join `resource_prices` as `resprice` on `resprice`.`resource_id` = `res`.`id` 
					inner join `resource_quantities` as `resqty` on `res`.`id` = `resqty`.`resource_id`
					where `res_depot` = ".$request->dep_id." 
					AND `resqty`.`id` NOT IN (".$booked_resources.") 
					GROUP BY `resqty`.`resource_id` ");

			}else{
				$available_resources = DB::select(
					"select `res`.`id`, `res`.`res_name`, `res`.`res_img`, `resprice`.`basic_rate`, `resqty`.`uid`, `resqty`.`id` as `uidID` ,`res`.`res_agent` 
					from `resources` as `res` 
					left join `resource_prices` as `resprice` on `resprice`.`resource_id` = `res`.`id` 
					inner join `resource_quantities` as `resqty` on `res`.`id`=`resqty`.`resource_id` 
					where `res_depot` = ".$request->dep_id." 
					GROUP BY `resqty`.`resource_id` ");

			}			

			return response()->json($available_resources);
		}


		// 	public function get_depot_resource(Request $request){
		// 	 $resources = DB::table("resources as res")
	 //          ->leftjoin('resource_prices as resprice','resprice.resource_id', '=', 'res.id')
	 //          ->join ('resource_quantities as resqty','res.id', '=' ,'resqty.resource_id')
	 //          ->join ('booked_resources as bkres','bkres.resource_quantity_id','<>','resqty.id')
	 //          ->where("res_depot",$request->dep_id)
	 //          ->select("res.id","res.res_name","res.res_img","resprice.basic_rate","resqty.uid",
	 //          	"resqty.id as uidID")
	 //          ->groupBy('resqty.resource_id')
	 //          ->get();   
		//     return response()->json($resources);
		// }

			public function get_depot_addit_resource(Request $request){
			return $add_resources = DB::table("additional_resources as add_res")
		        ->leftjoin('additional_res_pricings as add_resprice','add_resprice.add_res_id', '=', 
		        	'add_res.id')
		        ->where("depot_id",$request->dep_id)
				->select("add_res.id","add_res.add_res_name","add_res.add_res_image","add_resprice.rate")
				->get();
				die;
				             

		    return response()->json($add_resources);
		}

		public function insert_cart_data(Request $request){
			$checkin = date("Y-m-d", strtotime($request->checkin));
			$checkout = date("Y-m-d", strtotime($request->checkout));
			$sec_id = Session::getId();

			$depot_name = Depot::where('id', $request->depot_id)->select('name')->first();

			// return $id;
			$data = array(
            'depot_id'   => $request->depot_id,
            'agent_id'   => $request->agent_id,
            'depot_name'   => $depot_name->name,
            'res_id'     => $request->res_id,
            'res_name'   => $request->res_name,
            'res_qty_id' => $request->uidID,
            'uid'        => $request->uid,
            'price'      => $request->price,
            'date_check_in'    => $checkin,
            'date_check_out'    => $checkout,
            'device_id'    => $sec_id,
	        );
			$cart =  Cart::create($data);
			  return $cart->id;
		}
	

			public function check_cart_resources(Request $request){

			 $cart = DB::select("SELECT res_qty_id FROM `carts`");
			 $a = '';
				for ($c=0; $c <count($cart); $c++)
				{ 
				    $a .= $cart[$c]->res_qty_id.",";
				}
			$selected_resources = rtrim($a,',');


		    $check_in = date("Y-m-d", strtotime($request->checkin));
		    $check_out = date("Y-m-d", strtotime($request->checkout));
			
		    $resources = DB::select("SELECT * FROM `booked_resources` WHERE `checkout` >= '".$check_in."'  AND `checkout` <= '".$check_out."' ");
			$b = '';
				 for ($res=0; $res <count($resources); $res++)
				 { 
				 	$b .= $resources[$res]->resource_quantity_id.",";
				 }
				$booked_resources = rtrim($b,',');
			

			if(!empty($booked_resources)){
				$check_cart= DB::select(
					"select `resource_quantities`.`uid` as uidd, `resource_quantities`.`id` as `uidIDD` 
					from `resource_quantities`  
					where `resource_quantities`.`resource_id` = ".$request->check_res_id."
					AND `resource_quantities`.`id` NOT IN (".$selected_resources.") 
					AND `resource_quantities`.`id` NOT IN (".$booked_resources.")
					GROUP BY `resource_quantities`.`resource_id` ");

			}else{
				$check_cart= DB::select(
					"select `resource_quantities`.`uid` as uidd, `resource_quantities`.`id` as `uidIDD` 
					from `resource_quantities`  
					where `resource_quantities`.`resource_id` = ".$request->check_res_id."
					AND `resource_quantities`.`id` NOT IN (".$selected_resources.")					
					GROUP BY `resource_quantities`.`resource_id` ");

			}	
			return response()->json($check_cart);
			}



			public function get_cart_data(Request $request){


				$days = $request->day_diff;
				// $days = 5;

				$sec_id = Session::getId();

				 $get_cart = DB::table('carts')
				->select('carts.id','carts.res_id','carts.res_name','carts.uid','carts.price', 
				'resources.res_img')
				->join('resources' , 'carts.res_id' , '=', 'resources.id') 
				->where('device_id', $sec_id)
				->get();
 

				for ($a=0; $a <count($get_cart); $a++){ 

				  	 $price_rules = DB::table('resource_prices as resP')
				    ->select('resPR.limit', 'resPR.price') 
				    ->join('resource_price_rules as resPR' , 'resP.id' , '=', 'resPR.resource_price_id')
				    ->where('resource_id', $get_cart[$a]->res_id)
				    ->orderBy('resPR.limit', 'ASC')
				    ->get();
				    
				    $finalresult="";

			    	if($days < $price_rules[0]->limit){

			    		$finalresult = $get_cart[$a]->price; 
					}
					else{

						for ($b=0; $b <count($price_rules); $b++){

				    		if($days >= $price_rules[$b]->limit )
				    		{

				    		   $tb_price = $days * $get_cart[$a]->price;
					 		   $discount_value = ($tb_price / 100) * $price_rules[$b]->price;
					 		   $finalresult = $tb_price - $discount_value;

				    		}
					 	}

					}


					$cart[$a]['id'] = $get_cart[$a]->id;
		 			$cart[$a]['res_id'] = $get_cart[$a]->res_id;
		 			$cart[$a]['res_name'] = $get_cart[$a]->res_name;
		 			$cart[$a]['uid'] = $get_cart[$a]->uid;
		 			$cart[$a]['price'] = $get_cart[$a]->price;
		 			$cart[$a]['res_img'] = $get_cart[$a]->res_img;
		 			$cart[$a]['dis_price'] = round($finalresult);
				 
					
				// echo $finalresult;
				// echo "<br>";
			 	

				}

				$total = 0;
				for ($s=0; $s<count($cart); $s++) { 

					$total = $total + $cart[$s]['dis_price'];
				}
				
				$tax=DB::table('price_kms')->first();
				return response()->json(['cart'=>$cart,'tax'=>$tax->tax, 'after_rules_TP' => $total ]);
			}


			public function delete_cart_row(Request $request){
				 $device_id = Session::getId();
		         $id =  $request->cart_id;
		         $delete = DB::table('carts')->where([['device_id', $device_id],['id',$id]])->delete();
		        if($delete>0){
		         return "Resource Is Deleted";
		        
		        }else{
		           return "Particulary ID Not Found";
		        }
		        
		     }

	          public function delete_cart(){
		        $device_id = Session::getId(); 
		        $delete =DB::table('carts')->where('device_id', $device_id)->delete();
		        if($delete>0){
		          return "Cart Is Deleted";     
		        }else{
		          return "Device ID Not Found";
		      }
	  		}


	public function make_reservation(Request $request){

		$exsisting_email = Customer::where('email', $request->email)->first();

		$data = array(
			'name'        => $request->fName ." " . $request->lName,
			'phone'       => $request->phone,
			'email'       => $request->email,
			'cus_country' => $request->country,
			'cus_city'    => $request->city,
			'address'     => $request->address,
			'cus_postal_code'    => $request->postal_code
		);

		if(empty($exsisting_email->email)){ 

			$customer_data = Customer::create($data);
			$email_id = $customer_data->id;
		}
		else
		{
			$email_id =	$exsisting_email->id;     
		    Customer::where('id', $email_id)->update($data);                
		} 


		$verify_email = Customer::where('id', $email_id)->first();

		$check_in = date("Y-m-d", strtotime($request->date_in));
		$check_out = date("Y-m-d", strtotime($request->date_out));

            $start_date = new Carbon($check_in);
			$end_date = new Carbon($check_out);
			$days = ($start_date->diff($end_date)->days < 1)
			    ? '0'
			    : $start_date->diffInDays($end_date);

			    // return $days;
			    // die;

		if ($verify_email->status == 1) {

			$device_id = Session::getId();
			$cartdata=Common::cartdata($device_id);
			$count =  count($cartdata);

         ////////////////START Orders Table/////////////////////
            
        	$data = array(
                'customer_id'   => $email_id, 
                'reservation_id'=> $request->reservation,
                'status'     => $request->optionsRadios,
                'total_amount' => $request->res_t_price + $request->add_res_t_price,
                'reservation_status' => $request->reservation_status,
                'payment_status' => $request->payment_status,
                'source' => $request->source,
                'select_days' => $days + 1,
                'order_status' => 2
               );
            
			$order_row = Order::create($data);
			$order_id  = $order_row->id;
			$order_status = $order_row->status;
			////////////////END Orders Table/////////////////////

			if ($count>0) {

			 ////////////////Start Orders Detail//////////////////

				for($i=0;$i<$count;$i++){

					$id = $cartdata[$i]->id;
					$device_id = $cartdata[$i]->device_id;
					$res_id = $cartdata[$i]->res_id;
					$res_name = $cartdata[$i]->res_name;
					$depot_id = $cartdata[$i]->depot_id;
					$agent_id = $cartdata[$i]->agent_id;
					$depot_name = $cartdata[$i]->depot_name;
					$res_qty_id = $cartdata[$i]->res_qty_id;
					$uid = $cartdata[$i]->uid;
					$date_check_in = $cartdata[$i]->date_check_in;
					$date_check_out = $cartdata[$i]->date_check_out;

					$detailReg = new OrderDetail();
					$detailReg->order_id = $order_id;
					$detailReg->device_id = $device_id;
					$detailReg->res_id = $res_id;
					$detailReg->res_name = $res_name;
					$detailReg->depot_id = $depot_id;
					$detailReg->agent_id = $agent_id;
					$detailReg->depot_name = $depot_name;
					$detailReg->res_qty_id = $res_qty_id;
					$detailReg->uid = $uid;

						if($detailReg->save()){

					     ////////////////End Orders Detail/////////////////////

					     ////////////////Start Booked Resources/////////////////	

							$booked = new BookedResources();
							$booked->order_id = $order_id;
							$booked->resource_quantity_id = $res_qty_id;
							$booked->checkin = $date_check_in;
							$booked->checkout = $date_check_out;
							$booked->save();
							Cart::where('id',$id)->delete();
						}			                       
			    		 /////////////End Booked Resources/////////////////////
			    } // end for loop after if count
			}else{

				$depot_data =  Depot::where('id',$request->depot)->first();
				$detailReg = new OrderDetail();
				$detailReg->order_id = $order_id;
				$detailReg->depot_id = $request->depot;
				$detailReg->depot_name = $depot_data->name;
				$detailReg->save();
			} 
 							

			/////////////Start addititonal Resources/////////////////////


			$selectedAdditResources =  $request->selectedAdditResources;

			for($j=0;$j<count($selectedAdditResources);$j++){

				if($selectedAdditResources[$j] == 'yes'){

					$order_id = $order_id;
					$add_res_id =  $request->add_resource_id[$j];
					$quantity =  $request->additional_quantity[$j];
					$notes = $request->notes[$j];

					$addit_row =  AdditionalResource::where('id',$request->add_resource_id[$j])->first();
					$agent_id = $addit_row->agent_id;

					$detailReg1 = new OrderAdditResource();
					$detailReg1->order_id = $order_id;
					$detailReg1->add_res_id = $add_res_id;
					$detailReg1->agent_id = $agent_id;
					$detailReg1->quantity = $quantity;
					$detailReg1->note = $notes;
					$detailReg1->save();
				}
				else{
				// echo 'no';
				}                           		
			}
			/////////////End addititonal Resources/////////////////////


		 // ******************************Start Order Mail Code***********************************

			$customer_data = Customer::where('id',$order_row->customer_id)->first();
			$order_itt = Order::where('id',$order_id)->first();
			$order_detail = OrderDetail::where('order_id', $order_id)->get();
			$agents_array = $order_detail->pluck('agent_id')->toArray();
			$uniqe_ar = array_unique($agents_array);
			$order_additional_detail = OrderAdditResource::where('order_id', $order_id)->get();
			$booked_res = BookedResources::where('order_id',$order_id)->first();

			$depo =  DB::table('order_details as OD')
					->select("D.name")
					->join('depots as D', 'D.id','=', 'OD.depot_id')
					->where('OD.order_id', $order_id)
					->first();

			$uniqeMsg = "";
			// $everyOneMsg =  "Your Order ID is ".$order_id."\n".
			// 				"Customer Name ".$customer_data->name."\n".
			// 				"Customer Email ".$customer_data->email."\n".
			// 				// "Customer Country ".$customer_data->cus_country."\n".
			// 				"Customer Postal Code ".$customer_data->cus_postal_code."\n".
			// 				"Customer Address ".$customer_data->address."\n".
			// 				"Customer Phone ".$customer_data->phone."\n".
			// 				"Depot Name ".$depo->name."\n";

			if ($count>0) {

				foreach ($uniqe_ar as $agent) {
					$agent_data = User::find($agent);
					$agent_order_detail = OrderDetail::where([['order_id', $order_id],['agent_id',$agent]])->get();

					// for ($i=0; $i < count($agent_order_detail); $i++) { 

					// 	$reso_id    =  $agent_order_detail[$i]->res_id;	
					// 	$res_name   = $agent_order_detail[$i]->res_name;
					// 	$uid        = $agent_order_detail[$i]->uid;

					// 	$uniqeMsg.= "Resource Name ".$res_name."\n";
					// 	$uniqeMsg.= "UID ".$uid."\n";

					// 	$res_var_val = ResourceVariation::where('res_id', $reso_id)->get();
					// 		for ($j=0; $j < count($res_var_val); $j++) { 
					// 			$valueID =  $res_var_val[$j]->var_value_id;
					// 			$varValue = VariationValue::where('id', $valueID)->first();
					// 			$v_value = $varValue->v_value;
					// 			$uniqeMsg.= "V Value ".$v_value."\n";
					// 		}
					// }


	                $everyOneMsg = "Dear ".$agent_data->name." <br/>
	                        A new reservation has been entered.<br/><br/>
	                        Best regards,<br/>
	                        AstutoCC<br/><br/>
	                            <b>Reservation Information:</b><br/>
	                            <ul>
	                                <li><b>ReservationID:</b> ".$order_id." </li>
	                                <li><b>Resource:</b> "; 
	                                foreach($order_detail as $order_resource){
	                             $everyOneMsg.=$order_resource->res_name.",";
	                                }
	                $everyOneMsg.="</li>
	                                <li><b>Number of resources:</b> ".count($order_detail)." </li>
	                                <li><b>Additional Resource:</b></li>";

	                                foreach($order_additional_detail as $additional_detail){
	                                    $addit_row =  AdditionalResource::where('id',$additional_detail->add_res_id)->first();
	                                    $everyOneMsg.=$addit_row->add_res_name.",";
	                             
	                                }
	                $everyOneMsg.="</li>
	                                <li><b>Number of Additinal Resources:</b> ".count($order_additional_detail)." </li>
	                                <li><b>Duration:</b> ".$booked_res->checkin." - ".$booked_res->checkout."</li>
	                                <li><b>Created:</b> ".$order_itt->created_at." </li>
	                                <li><b>Status:</b> New </li>
	                                <li><b>Price:</b> ".$order_itt->total_amount." </li>
	                            </ul>
	                            <b>Customer Information:</b><br/>
	                            <ul>
	                                <li><b>UserID:</b> ".$customer_data->id."  </li>
	                                <li><b>Name:</b> ".$customer_data->name."  </li>
	                                <li><b>Email:</b> ".$customer_data->email."  </li>
	                                <li><b>Postal Code:</b> ".$customer_data->cus_postal_code."  </li>
	                                <li><b>Address:</b> ".$customer_data->address."  </li>
	                                <li><b>Phone:</b> ".$customer_data->phone."  </li>
	                            </ul>
	                            <b>Shopping cart Items:</b><br/>
	                            <table>
	                            <tr>
	                            <th width='100px'>ReservationID</th>
	                            <th width='30%'>Recource</th>
	                            <th width='25%'>Duration</th>
	                            <th width='100px'>Status</th>
	                            <th width='100px'>Price</th>
	                            </tr>
	                            <tr>
	                            <td>".$order_id."</td>
	                            <td>";
	                            foreach($order_detail as $order_resource){
	                     $everyOneMsg.= $order_resource->res_name."<br/>";              
	                            }
	                            
	                     $everyOneMsg.= "</td>
	                            <td>".$booked_res->checkin." - ".$booked_res->checkout."</td>
	                            <td>New</td>
	                            <td>".$order_itt->total_amount."</td>
	                            </tr>
	                            <tr>
	                            <td></td>
	                            <td>Quantity: ".count($order_detail)."</td>
	                            <td></td>
	                            <td></td>
	                            <td></td>
	                            </tr>
	                            </table>";


			       // ******************************End Order Mail Code***************

				    /////////////Start Shipping Detail/////////////////////

					if($order_status == 2 || $order_status == 3){

						$checkin =  $request->check_in;
						$checkout = $request->check_out;
						$check_in = date("Y-m-d", strtotime($checkin)); 
						$check_out = date("Y-m-d", strtotime($checkout)); 

						if(isset($request->remote_delivery_charges)){
							$remote_delivery_charges = $request->remote_delivery_charges;
						}
						else{
							$remote_delivery_charges = NULL;
						}

						$data = array(
						'order_id' => $order_id,
						'hotal_booking_no' => $request->hotal_booking_number,
						'hotal_name'       => $request->hotal_name,
						'reg_guest_name'       => $request->reg_guest_name,
						'hotal_adress' => $request->hotal_address,
						'check_in_date'    => $check_in,
						'Check_out_date'     => $check_out,
						'shipping_charges'     => $request->charges,
						'remote_delivery_charges' => $remote_delivery_charges
						);
						OrderShipingAdress::create($data);

					 /**********start Order Shipping Mail code*************************/

						$addMsg = "";
						$o_ship_adres = OrderShipingAdress::where('order_id',$order_id)->first();

						$addMsg =   "Hotal Booking No ".$o_ship_adres->hotal_booking_no."\n".
									"Hotal Name ".$o_ship_adres->hotal_name."\n".
									"Hotal Adress ".$o_ship_adres->hotal_adress."\n".
									"Reg Guest Name ".$o_ship_adres->reg_guest_name."\n".
									"Shipping Charges ".$o_ship_adres->shipping_charges."\n";

						// $total_charges = $o_ship_adres->shipping_charges + $order_row->total_amount;
						// $addMsg.= "Total Charges ".$total_charges."\n";

					 /****************** End Order Shipping mail code*******************/
					}
					/////////////End Shipping Detail/////////////////////


		                       
					// print_r($to_email);
					// echo '<br/>';
					// if (empty($addMsg)) {
					// 	$finalMsg = $everyOneMsg.$uniqeMsg;
					// }else{
					// 	$finalMsg = $everyOneMsg.$uniqeMsg.$addMsg;	
					// }
					// print_r($finalMsg);
					// echo '<br/>';

					if (empty($addMsg)) {
					$finalMsg = $everyOneMsg.$uniqeMsg;
					}else{
					$finalMsg = $everyOneMsg.$uniqeMsg.$addMsg;	
					}

					$to_email = $agent_data->email;
					$subject = "New Booking for Astuto CC";

		            $headers = "MIME-Version: 1.0" . "\r\n";
                    $headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";
                    $headers .= 'Reply-To:directeur@gsastuto.com' . "\r\n" ;
					mail($to_email, $subject, $finalMsg, $headers);
					$uniqeMsg = ""; 


				} //endforeach  for uniqe array

                 $cus = Customer::where('id', $order_row->customer_id)->first();
	             $customer_email=  $cus->email;
				 $depot_array = $order_detail->pluck('depot_id')->toArray();
				 $encrypted = Crypt::encryptString($depot_array[0]);
				 $link_url = url('/')."/map_link/".$encrypted;
				 $o_ship_adres = OrderShipingAdress::where('order_id',$order_id)->first();


         //         $cus_msg= "Dear ".$cus->name."\n";
     			 // $cus_msg.= "We have received your reservation for the rental Resource starting from ".$booked_res->checkin." and finishing on"
     			 // .$booked_res->checkout.". Your reservation will be confirmed upon receipt of payment. \n";
     			 // $cus_msg.= "<h1>Pickup or delivery of the rental item(s) will be based on your delivery selection in the reservation</h1>. \n";
     			 // $cus_msg.= "Your rental item(s) are located at ".$depo->name."\n";
     			 // $cus_msg.= "Address : ".$cus->address."\n";
     			 // $cus_msg.= "Thank you for your reservation, we will be contacting you soon.If you have any questions or need to make a change please contact us following this link. \n";
         //         $cus_msg.= "AstutoCC \n"; 
         //         $cus_msg.= 'https://maps.google.com/?q='.$cus->address;
	             
     			 
	        //      $cust_subject = "Order for Astuto CC";
         //         mail($customer_email,$cust_subject,$cus_msg);


                    $cus_msg= "Dear ".$cus->name."<br/>";
                    $cus_msg.= "We have received your reservation for the rental Resource starting from ".$booked_res->checkin." and finishing on "
                    .$booked_res->checkout.". <br/> Your reservation will be confirmed upon receipt of payment. <br/>";
                    $cus_msg.= "Pickup or delivery of the rental item(s) will be based on your delivery selection in the reservation. <br/>";
                    $cus_msg.= "If you have any questions or require additional assistance regarding this reservation please don't hesitate to contact us anytime! <br/><br/>";
                    $cus_msg.= "Best regards, <br/>"; 
                    $cus_msg.= "AstutoCC<br/><br/>"; 
                    $cus_msg.="<b>Reservation Information:</b><br/>
                                <ul>
                                    <li><b>ReservationID:</b> ".$order_id." </li>
                                    <li><b>Resource:</b> "; 
                                    foreach($order_detail as $order_resource){
                                		 $cus_msg.=$order_resource->res_name.",";
                                    }
                    $cus_msg.="</li>
                                    <li><b>Number of resources:</b> ".count($order_detail)." </li>
                                    <li><b>Additional Resource:</b></li>";

                                    foreach($order_additional_detail as $additional_detail){
                                        
                                        $addit_row =  AdditionalResource::where('id',$additional_detail->add_res_id)->first();
                                        $cus_msg.=$addit_row->add_res_name.",";
                                 
                                    }
                    $cus_msg.="</li>
                                    <li><b>Number of Additinal Resources:</b> ".count($order_additional_detail)." </li>
                                    <li><b>Duration:</b> ".$booked_res->checkin." - ".$booked_res->checkout."</li>
                                    <li><b>Created:</b> ".$order_itt->created_at." </li>
                                    <li><b>Status:</b> New </li>
                                    <li><b>Price:</b> ".$order_itt->total_amount." </li>
                                    <li><b>Map Link:</b> ".$link_url." </li>
                                </ul>
                                <b>Shopping cart Items:</b><br/>
                                <table>
                                <tr>
                                <th width='100px'>ReservationID</th>
                                <th width='30%'>Recource</th>
                                <th width='25%'>Duration</th>
                                <th width='100px'>Status</th>
                                <th width='100px'>Price</th>
                                </tr>
                                <tr>
                                <td>".$order_id."</td>
                                <td>";
                                foreach($order_detail as $order_resource){
                         $cus_msg.= $order_resource->res_name."<br/>";              
                                }
                                
                         $cus_msg.= "</td>
                                <td>".$booked_res->checkin." - ".$booked_res->checkout."</td>
                                <td>New</td>
                                <td>".$order_itt->total_amount."</td>
                                </tr>
                                <tr>
                                <td></td>
                                <td>Quantity: ".count($order_detail)."</td>
                                <td></td>
                                <td></td>
                                <td></td>
                                </tr>
                                </table>
                        ";
                    
                    $cust_subject = "Order for Astuto CC";
                    // return $cus_msg;
                    // print_r($cus_msg);die;
                    
                    $headers = "MIME-Version: 1.0" . "\r\n";
                    $headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";
                    // $headers .= 'Reply-To:'.$agent_data->email. "\r\n";

                    mail($customer_email,$cust_subject,$cus_msg, $headers);

			}else{

				$addit_detail = OrderAdditResource::where('order_id', $order_id)->get();
				$agents_array = $addit_detail->pluck('agent_id')->toArray();
				$agent_uniqe = array_unique($agents_array);

				foreach ($agent_uniqe as $agent) {
					$agent_data = User::find($agent);
					$addit_order_detail = OrderAdditResource::where([['order_id', $order_id],['agent_id',$agent]])->get();

					for ($i=0; $i < count($addit_order_detail); $i++) { 

						$add_res_id    =  $addit_order_detail[$i]->add_res_id;	
						$quantity    =  $addit_order_detail[$i]->quantity;	
						$note    =  $addit_order_detail[$i]->note;
						$addit_row = AdditionalResource::where('id', $add_res_id)->first();

						$uniqeMsg.= "Additional Resource Name ".$addit_row->add_res_name."\n";
						$uniqeMsg.= "Additional Resource Qty ".$quantity."\n";
						$uniqeMsg.= "Additional Resource Note ".$note."\n";
						

						$add_var_val = AttitionalResourceVariation::where('add_res_id', $add_res_id)->get();
							for ($j=0; $j < count($add_var_val); $j++) { 
								$valueID =  $add_var_val[$j]->var_value_id;
								$varValue = VariationValue::where('id', $valueID)->first();
								$v_value = $varValue->v_value;
								$uniqeMsg.= "V Value ".$v_value."\n";
							}
							// for ($j=0; $j < count($add_var_val); $j++) { 
							// 	$valueID =  $add_var_val[$j]->var_value_id;
							// 	$variation =Variation::where('id',$add_var_val[$j]->var__id)->first();
							// 	$varValue = VariationValue::where('id', $valueID)->first();
							// 	$v_value = $varValue->v_value;
							// 	$uniqeMsg.= $varValue->name .$v_value."\n";
							// }
					}

			     // ******************************End Order Mail Code*********************




					/////////////Start Shipping Detail/////////////////////

					if($order_status == 2 || $order_status == 3){
						$checkin =  $request->check_in;
						$checkout = $request->check_out;
						$check_in = date("Y-m-d", strtotime($checkin)); 
						$check_out = date("Y-m-d", strtotime($checkout)); 

						if(isset($request->remote_delivery_charges)){
							$remote_delivery_charges = $request->remote_delivery_charges;
						}
						else{
							$remote_delivery_charges = NULL;
						}

						$data = array(
						'order_id' => $order_id,
						'hotal_booking_no' => $request->hotal_booking_number,
						'hotal_name'       => $request->hotal_name,
						'reg_guest_name'       => $request->reg_guest_name,
						'hotal_adress' => $request->hotal_address,
						'check_in_date'    => $check_in,
						'Check_out_date'     => $check_out,
						'shipping_charges'     => $request->charges,
						'remote_delivery_charges' => $remote_delivery_charges
						);
						OrderShipingAdress::create($data);

						/**********start Order Shipping Mail code*************************/

						$addMsg = "";
						$o_ship_adres = OrderShipingAdress::where('order_id',$order_id)->first();

						$addMsg =  "Hotal Booking No ".$o_ship_adres->hotal_booking_no."\n".
									"Hotal Name ".$o_ship_adres->hotal_name."\n".
									"Hotal Adress ".$o_ship_adres->hotal_adress."\n".
									"Reg Guest Name ".$o_ship_adres->reg_guest_name."\n".
									"Shipping Charges ".$o_ship_adres->shipping_charges."\n";

						// $total_charges = $o_ship_adres->shipping_charges + $order_row->total_amount;
						// $addMsg.= "Total Charges ".$total_charges."\n";

						/****************** End Order Shipping mail code*******************/

					} //end if for order status
					
					/////////////End Shipping Detail/////////////////////


		                       
					// print_r($to_email);
					// echo '<br/>';
					// if (empty($addMsg)) {
					// 	$finalMsg = $everyOneMsg.$uniqeMsg;
					// }else{
					// 	$finalMsg = $everyOneMsg.$uniqeMsg.$addMsg;	
					// }
					// print_r($finalMsg);
					// echo '<br/>';


					if (empty($addMsg)) {
					$finalMsg = $everyOneMsg.$uniqeMsg;
					}else{
					$finalMsg = $everyOneMsg.$uniqeMsg.$addMsg;	
					}

					$to_email = $agent_data->email;
					$subject = "New Booking for Astuto CC";
					mail($to_email,$subject,$finalMsg);
					$uniqeMsg = "";

				} //endforeach  for agent_uniqe include else part
				
			} //endif for count include email code
			               

			 	  Session::flash('message', 'Reservation has been successfully created.');
                  return redirect('all_orders');
   		}else{

			$device_id = Session::getId(); 
			DB::table('carts')->where('device_id', $device_id)->delete();
			Session::flash('message', 'Reservation has been Cancelled User Is Blocked.');
			return redirect('add_resvation');

        } // end if for verfiy customer 
	} //end if for make function




		// public function setting(){

		// 	 $setting = PriceKm::find('1');

		// 	return response()->json($setting);

		// }
}








