<?php

namespace App\Http\Controllers\items;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Session;
use App\Http\Requests\AddTypeRequest;
use App\Http\Requests\TypeEditRequest;
use App\Http\Requests\EditVariationRequest;
use App\ResourceTypes;
use App\Resources;
use App\Variation;
use App\Common;
// use App\Country;
use App\Customer;
use Carbon\Carbon;
use DateTime;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Input;
use App\Http\Requests\AddVariationRequest;
use App\ResourcePrice;
use App\ResourcePriceRules;
use App\Http\Requests\SetPricingRequest;
use App\AdditionalResource;
use App\Http\Requests\AdditResPricing;
use App\AdditionalResPricing;
use App\PriceKm;
use Illuminate\Support\Facades\Hash;

class ItemController extends Controller
{
    public function index(){
    	 return view('admin.items.index');
    }
    public function new_item(){
     	$where=array('type'=>'2','status'=>'1');
     	$data['agents'] = DB::table('users')->where($where)->get();
    	return view('admin.items.new_item',$data);
    }

    public function res_types()
    {
        $where=array('status'=>'1');
        $data['types'] = DB::table('resource_types')->where($where)->get();
       return view('admin.items.types',$data);
    }
    public function new_type()
    {
     return view('admin.items.new_type');
    }

     public function insert_res_type(AddTypeRequest $request){
         $type= new ResourceTypes();
         $user = Auth::user();
         $type->type_id=$request->type_id;
         $type->name=$request->name;
         $type->description=$request->description;
         $type->created_by=$user->id;
         if($type->save()){
         Session::flash('message', 'Resource type has been saved successfully');
         return redirect('res_types');
         }
    }
    public function deletetype($id)
    {
        DB::table('resource_types')->where('id', $id)->update(['status' => '0']);
       Session::flash('message', 'Resource type has been deleted successfully');
        return redirect('res_types');
    }

    public function edittype($id)
    {
        $where=array('id'=>$id);
        $data['type'] = DB::table('resource_types')->where($where)->first();
          return view('admin.items.edit_type',$data);
    }
    public function edit_type_script(TypeEditRequest $request)
    {
        $type= ResourceTypes::find($request->id);
        $type->type_id=Input::get('type_id');
        $type->name=Input::get('name');
        $type->description=Input::get('description');
        if($type->save())
        {
            Session::flash('message', 'Resource type has been updated successfully');
            return redirect('res_types');
        }
    }

    /*********************************************************************************************/
    /*********************************************************************************************/
    /*********************************************************************************************/
    public function res_variations(){
        $where=array('status'=>'1');
        $data['variations']=DB::table('variation')->where($where)->get();
        return view('admin.items.variations',$data);
    }
    public function new_variations(){
        return view('admin.items.new_variations');
    }


    public function edit_variations($id){
        $where=array('id'=>$id);
        $data['variation'] = DB::table('variation')->where($where)->first();
        $where=array('variation_id'=>$id);
        $data['variation_value'] = DB::table('variation_values')->where($where)->get();
        return view('admin.items.edit_variations',$data);
    }
    public function editvariations(EditVariationRequest $request)
    {

        $variation= Variation::find($request->id);
        $variation->v_id=Input::get('v_id');
        $variation->name=Input::get('name');
        $variation->assosiate_with=Input::get('assosiate_with');
        if($variation->save())
        {
            $string="";
            for($sti=0;$sti<count($request->value_ids);$sti++)
            {
                $string.=$request->value_ids[$sti].",";
            }

            $string=rtrim($string,",");
            $where="id NOT IN (".$string.") AND variation_id=".$request->id."";
            DB::table('variation_values')->whereRaw($where)->delete();
            for($va=0;$va<count($request->value);$va++)
            {
                if(isset($request->value_ids[$va])){
                    DB::table('variation_values')
                    ->where('id', $request->value_ids[$va])
                    ->update(['v_value' => $request->value[$va]]);
                 }
                 else{
                        $data=array(
                        'variation_id'=>$request->id,
                        'v_value'=>$request->value[$va],
                        'created_at'=>Carbon::now(),
                        'updated_at'=>Carbon::now()
                        );
                        DB::table('variation_values')->insert($data);
                }

            }

            Session::flash('message', 'Resource Variation has been updated successfully');
            return redirect('res_variations');
        }

    }

    public function insert_variation(AddVariationRequest $request){
         $variabtion= new Variation();
        // $user = Auth::user();
         $variabtion->v_id=$request->v_id;
         $variabtion->name=$request->name;
         $variabtion->assosiate_with=$request->assosiate_with;
         if($variabtion->save()){
             Session::flash('message', 'Variation has been saved successfully');
             for($i=0;$i<count($request->value);$i++){

                    $data=array(
                        'variation_id'=>$variabtion->id,
                        'v_value'=>$request->value[$i],
                        'created_at'=>Carbon::now(),
                        'updated_at'=>Carbon::now()
                    );
                Common::insert_data($data,'variation_values');
             }
             //echo $variabtion->id;
             Session::flash('message', 'Variation has been saved successfully');
             return redirect('res_variations');
         }

    }

    public function deletevariation($id)
    {
        DB::table('variation')->where('id', $id)->update(['status' => '0']);
        Session::flash('message', 'Variation has been deleted successfully');
        return redirect('res_variations');
    }

  /*********************************************************************************************/
  /*********************************************************************************************/
  /*********************************************************************************************/
    public function res_resources()
    {
        return view('admin.items.resources');
    }

    public function new_resources()
    {

         $data['depots']=DB::table('depots')->select('id','name')->get();
         $data['types']=DB::table('resource_types')->select('id','name')->get();
         $data['agents']=DB::table('users')->select('id','name')->where('type',2)->get();
         $data['variations']=DB::table('variation')->select('id','name')->WhereRaw('status=1 AND (assosiate_with=1 OR assosiate_with=3)')->get();
         return view('admin.items.new_resources',$data);
    }

/************************************************************************************************/
/************************************************************************************************/
/************************************************************************************************/
/************************************************************************************************/
/************************************************************************************************/
    public function insert_item(Request $request){
       $files=  $request->file('all_files');
       print_r($files);
        die;

       $varrr=Input::get('variation');

        $resources= new Resources();
        $resources->res_id=$request->resource_id;
        $resources->res_type=$request->auto_type;
        $resources->res_name=$request->resource_name;
        $resources->res_depot=$request->depot_type;
        $resources->res_agent=$request->agent;
        $resources->res_details=$request->res_description;
        /************************************************************************************/
        $image = $request->file('resource_featured_img');
        $image_name=image_uploading($image);
        /***********************************************************************************/
        $resources->res_img=$image_name;
         if($resources->save()){
            $id=$resources->id;
                for($var=0;$var<count($varrr);$var++){
                    $data = array(
                    'res_id' => $id,
                    'var_value_id' => $varrr[$var],
                    'status'=>1,
                    'created_at'=>Carbon::now(),
                    'updated_at'=>Carbon::now()
                    );
                    Common::insert_data($data,'resource_variation');
                }




         //Session::flash('message', 'Resource type has been saved successfully');
         //echo "Data has been saved";
         //return redirect('new_type');
         }

    }



    // ***********************zaid********************************

          public function setprice($id){
                $resources =Resources::where('id', $id)->first();
                $previous_price_data = ResourcePrice::where('resource_id', $id)->first();
                if($previous_price_data &&  $previous_price_data->status == 1){
                    $price_rules = ResourcePriceRules::where('resource_price_id',
                        $previous_price_data->id)->get();
                        return view('admin.resources.edit_setpricing',compact(['id','previous_price_data','price_rules','resources']));
                }
                else{

                    return view('admin.resources.setpricing',compact(['id','resources']));
                }
             }


         public function insert_reso_price(SetPricingRequest $request){



              $resourcesprice = new ResourcePrice();
              $resid     = $request->resid;
              $rate_type = $request->rate_type;
              $rate      = $request->rate;
              $resourcesprice->resource_id = $resid;
              $resourcesprice->type = $rate_type;
              $resourcesprice->basic_rate = $rate;
              if ($resourcesprice->save()){
                    $count = count($request->days);


                     if ($count>0) {

                        for($i=0;$i<$count;$i++){

                            $data=array(
                                'resource_price_id'=>$resourcesprice->id,
                                'limit'=>$request->days[$i],
                                'price'=>$request->charge[$i],
                                'created_at'=>Carbon::now(),
                                'updated_at'=>Carbon::now()
                            );
                          Common::price_insert_data($data,'resource_price_rules');
                        }

                      }



                     Session::flash('message', 'Resource Price has been saved successfully');
                     return redirect('resources');

              }
         }

        public function update_reso_price(Request $request){

        $pre_resid= ResourcePrice::find($request->pre_resid);
        $rate_type=Input::get('rate_type');
        $rate=Input::get('rate');
        $pre_resid->type = $rate_type;
        $pre_resid->basic_rate = $rate;
                                          // $test  = $request->rules_id;
                                          // print_r($test);
                                          // $pre_resid->save();
        if($pre_resid->save())
            {

              $string = 0;

              for($sti=0;$sti<count($request->rules_id);$sti++)
              {
                  $string.=$request->rules_id[$sti].",";
              }
              $string=rtrim($string,",");
              $where="id NOT IN (".$string.") AND resource_price_id=".$request->pre_resid."";
              DB::table('resource_price_rules')->whereRaw($where)->delete();

              $count =  count($request->days);

              if($count>0){

                 for($va=0;$va<$count;$va++)
                 {
                    if(isset($request->rules_id[$va])){
                        DB::table('resource_price_rules')
                        ->where('id', $request->rules_id[$va])
                        ->update(['limit' => $request->days[$va],
                                   'price'  => $request->charge[$va]]);
                     }
                     else{
                            $data=array(
                            'resource_price_id'=>$request->pre_resid,
                            'limit'=>$request->days[$va],
                            'price'=>$request->charge[$va],
                            'created_at'=>Carbon::now(),
                            'updated_at'=>Carbon::now()
                            );
                            DB::table('resource_price_rules')->insert($data);
                    }
                }
              }

                Session::flash('message', 'Resource Pricing has been updated successfully');
                return redirect('resources');
            }

        }

         public function additional_resource()
        {
           $additional_resource =  AdditionalResource::all();
           return view('admin.additionalResource.index', compact('additional_resource'));
        }

        public function additional_resource_setprice($id){

            $previous_addprice_data = AdditionalResPricing::where('add_res_id', $id)->first();
            if ($previous_addprice_data){
                return view('admin.additionalResource.edit_addRes_setprice',compact(['id','previous_addprice_data']));
            }

            return view('admin.additionalResource.additionalres_setprice',compact('id'));

        }

        public function insert_additionalreso_price(Request $request){
              $addresourcesprice = new AdditionalResPricing();
              $addresid     = $request->addresid;
              $ratetype = $request->ratetype;
              $rate      = $request->rate;
              $addresourcesprice->add_res_id = $addresid;
              $addresourcesprice->type = $ratetype;
              $addresourcesprice->rate = $rate;

              if ($addresourcesprice->save()){
                  Session::flash('message', 'Additional Resource Price has been saved successfully');
                     return redirect('additional_resource');
              }



        }

        public function update_additionalreso_price(AdditResPricing $request){
        $addresid= AdditionalResPricing::find($request->addresid);
        $ratetype=Input::get('ratetype');
        $rate=Input::get('rate');
        $addresid->type = $ratetype;
        $addresid->rate = $rate;
        if($addresid->save()){
            Session::flash('message', 'Additional Resource Price has been Updated successfully');
            return redirect('additional_resource');
        }


        }


        public function changePassword(){
            return view('admin.changepasword.change_password');
        }


      public function submit_password(Request $request){

        $oldpassword     = $request->old_password;
        $newpassword     = $request->new_password;
        $confermpassword = $request->conferm_password;

        $user = Auth::User();
        if($newpassword == $confermpassword){
            $current_password = $user->password;
              if (Hash::check($oldpassword, $current_password)){
                // print_r("yes match value");
                // echo "<br>";
                 $newpassword = Hash::make($newpassword);
                  // print_r($newpassword);
                  // echo "<br>";
                 $user_id = $user->id;
                 $data=array("password"=> $newpassword);
                 $newpassword = Common::newpassword($user_id,$data,"users");
                //  print_r("yes change");
                // echo "<br>";
                // return  redirect('/');
                return  redirect()->back()->with('message', 'Your Password is Changed..!');
              }
              else
              {

                return  redirect()->back()->with('message', 'Old Password is Incorect..!');
              }


        }else
        {

          return  redirect()->back()->with('message', 'Your Password In Not Match..!');
        }


     }


    public function price_km()
    {
        $price_row = PriceKm::find('1');
        return view('admin.items.setting',compact('price_row'));
    }



    public function update_price_km(Request $request)
    {

       $validatedAgent = $request->validate([

            'price_km' => 'required|numeric',
            'range_km' => 'required|numeric',
            'tax'      => 'required|numeric',
            'remote_delivery_charges'      => 'required|numeric',

           ]);

      $price_row = PriceKm::find('1');
      $price_row->price_km = $request->price_km;
      $price_row->tax      = $request->tax;
      $price_row->range      = $request->range_km;
      $price_row->remote_delivery_charges      = $request->remote_delivery_charges;
      if($price_row->save())
      {
          Session::flash('message', 'Setting has been successfully Updated.');
          return redirect('price_km');
      }

    }




      public function emptyCart(){

      date_default_timezone_set("Asia/Karachi");
      $date = new DateTime();
      $date->modify('-1 hours');
      $formatted_date = $date->format('Y-m-d H:i:s');
      // echo $formatted_date;die;
      $lb = DB::table('carts')->where('created_at', '<',$formatted_date)->delete();
      return $lb;

    }


    //   public function emptyCart(){

    //   date_default_timezone_set("Asia/Karachi");
    //   $date = new DateTime();
    //   $date->modify('-1 Min');
    //   $formatted_date = $date->format('Y-m-d H:i:s');
    //   // echo $formatted_date;die;
    //   $lb = DB::table('carts')->where('created_at', '<',$formatted_date)->delete();
    //   return $lb;

    // }


          public function calendar(){
            return view('calendar');
          }

          public function get_details(Request $request){
            $data=Customer::where('email',$request->email)->first();
            $country_name=DB::table('countries')->where('id',$data->cus_country)->first();
            $city_name=DB::table('cities')->where('id',$data->cus_city)->first();
            $countries=DB::table('countries')->get();
            $cities=DB::table('cities')->where('country_id',$country_name->id)->get();
            return response()->json(['data'=>$data,'country'=>$countries,'country_name'=>$country_name,'city_name'=>$city_name,'city'=>$cities]);
          }


 public function update_resource_quantity(Request $request){
        $data=DB::table('resources')->where('id',$request->id)->update(['res_quantity'=>$request->quantity]);
        return response()->json($data);
    }



}
