<?php

namespace App\Http\Controllers\depots;
use App\Depot;
use App\User;
use App\DepotWithAgent;
use Carbon\Carbon;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Session;
use App\Http\Requests\AddDepotsRequest;
use App\Http\Requests\DepotEditRequest;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Crypt;

class DepotsController extends Controller
{
     public function index(){

         $agentId = Auth::user()->id;
         $currentUser = User::find($agentId);
         $type = $currentUser->type;

         if($type == 1){
             $data['depots']=Depot::get_records();
         }else{
             $data['depots']=Depot::get_agent_records($agentId);
         }

    	return view('admin.depots.index',$data);
    }
     public function new_depot(){
     	$where=array('type'=>'2','status'=>'1');
     	$data['id'] = Auth::user()->id;
     	$data['currentUser'] = User::find( $data['id']);
     	$data['agents'] = DB::table('users')->where($where)->get();
    	 return view('admin.depots.new_depot',$data);
    }
    public function insert_depot(AddDepotsRequest $request){
        
        $validatedAgent = $request->validate([
            'agent' => 'required',
            'depo_img' => 'required',
         ]);


        $agents =  $request->agent;
    	$input = Input::all();
    	$user = Auth::user();
    	$dpts=new Depot();
    	$dpts->name=Input::get('name');
        $dpts->address=Input::get('address');
    	$dpts->lat=Input::get('lat');
    	$dpts->long=Input::get('long');
    	$dpts->created_by=$user->id;

        $file = $request->file('depo_img');
            if ($file !== null) {
                 $extension = $file->getClientOriginalExtension();
                 $filname = time() . '.' . $extension;
                 $file->move('uploads/depo_img' , $filname);
                 $dpts->depo_image = $filname;
            }
    	
        	if($dpts->save())
        	{
               $depot_id =  $dpts->id;

                    foreach ($agents as $agent) {
                         $depoAgent = new DepotWithAgent();
                         $depoAgent->depot_id = $depot_id;
                         $depoAgent->agent_id = $agent;
                         $depoAgent->save();
                    }

        		Session::flash('message', 'Depot has been created successfully');
                return redirect('depots');
        	}
    }

    public function delete_depot($id)
    {

        DB::table('depots')->where('id', $id)->update(['status' => '0']);
        Session::flash('message', 'Depot has been removed successfully');
        return redirect('depots');
    }

    public function edit_depot($id)
    {

        $where=array('type'=>'2','status'=>'1');
        $data['agents'] = DB::table('users')->where($where)->get();

        $where=array('id'=>$id,'status'=>'1');
        $data['depot']=DB::table('depots')->where($where)->first();
        $data['depot_with_agent']=DB::table('depot_with_agents')->where('depot_id',$id)->get();

        $data['id'] = Auth::user()->id;
        $data['currentUser'] = User::find( $data['id']);
  
        return view('admin.depots.edit_depot',$data);
    }

    public function editscript_depot(DepotEditRequest $request)
    {
        $validatedAgent = $request->validate([
            'agent' => 'required',
         ]);
         
        $agents =  $request->agent;
        $input = Input::all();
        $user = Auth::user();
        $dpts= Depot::find($request->id);
        $dpts->name=Input::get('name');
        $dpts->address=Input::get('address');
        $dpts->lat=Input::get('lat');
        $dpts->long=Input::get('long');
        $dpts->created_by=$user->id;
        
        $file = $request->file('depo_img');
            if ($file !== null) {
                 $extension = $file->getClientOriginalExtension();
                 $filname = time() . '.' . $extension;
                 $file->move('uploads/depo_img' , $filname);
                 $dpts->depo_image = $filname;
            }
                
        
            if($dpts->save())
            {
                $depot_id =  $dpts->id;
                DepotWithAgent::where('depot_id',$depot_id)->Delete();

                    foreach ($agents as $agent) {
                         $depoAgent = new DepotWithAgent();
                         $depoAgent->depot_id = $depot_id;
                         $depoAgent->agent_id = $agent;
                         $depoAgent->save();
                    }

                Session::flash('message', 'Depot has been updated successfully');
                return redirect('depots');
            }

    }
    
    
    public function linkView($encrypted){
        $decrypted = Crypt::decryptString($encrypted);
        $depot_data = Depot::find($decrypted);
        return view('admin.depots.map_link', compact('depot_data'));
    }


}
