<?php

namespace App\Http\Controllers\customer;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Session;
use App\Customer;
class CustomerController extends Controller
{
    public function index(){
    	// $where=array('status'=>'1');
    	$data['customers'] = DB::table('customers as cus')
    	                       ->leftjoin('countries as cot','cot.id', '=', 'cus.cus_country')
    	                       ->leftjoin('cities as c','c.id', '=', 'cus.cus_city')
    	                       ->select('cus.*','cot.country_name','c.city_name')
    	                       ->paginate(25);   
    	return view('admin.customers.index',$data);
    }

    public function active_customer(){
    	$where=array('status'=>'1');
    	$data['customers'] = DB::table('customers as cus')
    	                       ->leftjoin('countries as cot','cot.id', '=', 'cus.cus_country')
    	                       ->leftjoin('cities as c','c.id', '=', 'cus.cus_city')
    	                       ->select('cus.*','cot.country_name','c.city_name')
    	                       ->where($where)
    	                       ->paginate(25);   
    	return view('admin.customers.active_customer',$data);
    }




        public function de_active_customer(){
        $where=array('status'=>'2');
    	$data['customers'] = DB::table('customers as cus')
    	                       ->leftjoin('countries as cot','cot.id', '=', 'cus.cus_country')
    	                       ->leftjoin('cities as c','c.id', '=', 'cus.cus_city')
    	                       ->select('cus.*','cot.country_name','c.city_name')
    	                       ->where($where)
    	                       ->paginate(25);   
    	return view('admin.customers.deactive_customer',$data);
    }

        public function status($rowId, $value){
	        $update = array(
	            'status' => $value
	        );
             Customer::where('id', $rowId)->update($update);


           if ($value == 1) {
            $msg = "Customer Is Active";
	        }else if ($value == 2) {
	            $msg = "Customer Is DeActive";
	        }
        Session::flash('message', $msg);
        return redirect()->back();


    }

}
