<?php

namespace App\Http\Controllers\agents;
use App\User;
use App\Common;
use App\Http\Requests\AgentAddRequest;
use App\Http\Requests\AgentEditRequest;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Session;

class AgentController extends Controller
{
    public function index(){
        $where=array('type'=>'2','status'=>'1');
    	$data['users'] = DB::table('users')->where($where)->get();    	 	
    	 return view('admin.agents.index',$data);
    }
    public function new_agent(){    	
    	 return view('admin.agents.new_agent');
    }
    public function insert_agent(AgentAddRequest $request){
    	$agent= new User();
    	$agent->name=$request->name;
        $agent->email=$request->email;
        $agent->password=Hash::make($request->password);        
        $agent->address=$request->address;
        $agent->type='2';
        if($agent->save()){
        Session::flash('message', 'Agent has been created successfully');
        return redirect('agent');
        }
	}
    public function delete_agent($id)
    {   
       DB::table('users')->where('id', $id)->update(['status' => '0']);
       Session::flash('message', 'Agent has been removed successfully');
        return redirect('agent');
    }

    public function edit_agent($id)
    {
        $where=array('id'=>$id,'type'=>'2','status'=>'1');
        $data['agent']=DB::table('users')->where($where)->first();     
        return view('admin.agents.edit_agent',$data);
    }

    public function editscript_agent(AgentEditRequest $request)
    {

        $agent= User::find($request->id);       
        $agent->name=$request->name;
        $agent->address=$request->address;
        if($agent->save())
        {
            Session::flash('message', 'Agent has been updated successfully');
            return redirect('agent');
        }
    }


    public function agent_change_password($agent_id){
        // return $agent_id;
          return view('admin.agents.changePassword_agent');

    }


      public function submit_agent_password(Request $request){
        
        $newpassword     = $request->new_password;
        $confermpassword = $request->conferm_password;
        $agent_id        = $request->agent_id;
        if($newpassword == $confermpassword){ 
                 $newpassword = Hash::make($newpassword);
                 $data=array("password"=> $newpassword);
                 $newpassword = Common::newpassword($agent_id,$data,"users");
                 return  redirect('agent')->with('message', 'Your Password is Changed..!');
        
        }else
        {

          return  redirect()->back()->with('message', 'Your Password In Not Match..!');
        }
        
        
     } 

}
