<?php


namespace App\Http\Controllers;



use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

use Illuminate\Support\Facades\Validator;

use Illuminate\Support\Facades\Input;

use Illuminate\Support\Facades\Session;

use Illuminate\Support\Facades\Storage;

use Illuminate\Support\Facades\Redirect;
use App\Http\Requests\EditProfileRequest;
use App\UserModelApi;
use App\User;
use Hash;
use Image;

use Auth;


class UserControllerAPI extends Controller
{

    function index()
    {

    }






    function sign_up()
    {
        $users_detail = new UserModelApi();

         $rules = array(
           'name' => 'required|max:255',
           'email' => 'required|email|max:255|unique:customers',
           'phone' => 'required|max:255',
           'address' => 'required|max:255',
           'hotel_address' => 'required|max:255',
           'country' => 'required|max:255',
           'location_phone' => 'required|max:255',
           'notes' => 'required|max:255'
        );
        $validator = Validator::make(Input::all(), $rules);


        $input = Input::all();
        // print_r($input);
        // die;


        $users_detail = $users_detail->get_user_info($input['email']);
        // print_r($users_detail);
        // die;

        if ($validator->fails()) {

            $data = array('code' => 100,
                        'msg' => 'email already exists.',
                        'data' => $users_detail
                        );
        }
        else
        {
            $result = UserModelApi::save_user($input);
            if($result){
                $data = array('code' => 200,
                            'msg' => 'successfully',
                            'id' => $result
                            );
            }
            else
            {
                    $data = array('code' => 100,
                            'msg' => 'Failed'
                            );
            }

        }

        echo json_encode($data);
        die;

    }




/****************** User Social SignUp *****************************/


    function social_sign_up()
    {



         $rules = array(

           'social_token' => 'required|max:255',

           'name' => 'required|',
        );



        $validator = Validator::make(Input::all(), $rules);

        if ($validator->fails()) {

            $data = array('code' => 100,
                        'msg' => 'Empty Field!.',
                        );

        }
        else
        {
        $input = Input::all();


        // print_r($input);
        // die;

        $result = UserModelApi::save_compnay_social($input);



       // echo $result;
       // die;



        if($result){

            $data = array('code' => 200,
                        'msg' => 'successfully',
                        'id' => $result
                        );

        }
        else
        {
                $data = array('code' => 100,
                        'msg' => 'Failed'
                        );
        }

        }

        echo json_encode($data);
        die;

    }




    public function view_profile()
    {
        //print_r(Auth::user()->id);
        return view('profile');
    }

    public function update_profile(EditProfileRequest $request)
    {

        $user= User::find(Auth::user()->id);
        $user->name=Input::get('name');
        $user->cell=Input::get('cell');
        $user->address=Input::get('address');
        if($user->save())
        {
            Session::flash('message', 'Profile has been updated successfully');
            return redirect('view_profile');
        }
    }

    public function change_password(Request $request)
    {
        $user_id = Auth::user()->id;
        $user = User::where(array("id"=>$user_id))->first();
        $old_password = $request->old_password;
        $new_password=$request->new_pass;
        $confirm_password=$request->confirm_pass;
          if(!Hash::check($request->old_password, $user->password)){
                return response()->json(["code" => 100, "message" => "Current password dose not match."]);
            }
            else if($new_password != $confirm_password)
            {
                return response()->json(["code" => 100, "message" => "New password and confirm password is not matching"]);
            }
            else{

                $user->password = Hash::make($new_password);
                    $user->save();
                     return response()->json(["code" => 200, "message" => "Password has been changed"]);
            }
    }

}