<?php

namespace App\Http\Controllers\Orders;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use App\Order;
use Illuminate\Support\Facades\Auth;
use App\User;
use App\OrderShipingAdress;
use App\BookedResources;
use App\Customer;
use Illuminate\Support\Facades\Session;

class OrderController extends Controller
{
         // $agentId = Auth::user()->id;
         // $currentUser = User::find($agentId);
         // $type = $currentUser->type;




    public  function all_orders(){
         $agentId = Auth::user()->id;
         $currentUser = User::find($agentId);
         $type = $currentUser->type;


    	 if($type == 1){
             $order = Order::allOrder();
         }else{
             $order=Order::order_agent_records($agentId);
         }

        $taxs=DB::table('price_kms')->first();
        $taxs=$taxs->tax/100;

        return view('admin.orders.all_order',compact('order','taxs'));
    }


    public  function completeOrder(){
         $agentId = Auth::user()->id;
         $currentUser = User::find($agentId);
         $type = $currentUser->type;


         if($type == 1){
             $order = Order::completeOrder();
         }else{
             $order=Order::completeOrder_agent_record($agentId);
         }

         $taxs=DB::table('price_kms')->first();
         $taxs=$taxs->tax/100;

          return view('admin.orders.complete_order',compact('order', 'taxs'));


    }

       public  function pendingOrder(){
         $agentId = Auth::user()->id;
         $currentUser = User::find($agentId);
         $type = $currentUser->type;


         if($type == 1){
             $order = Order::pendingOrder();
         }else{
             $order=Order::pendingOrder_agent_record($agentId);
         }

               $taxs=DB::table('price_kms')->first();
               $taxs=$taxs->tax/100;
          return view('admin.orders.pending_order',compact('order','taxs'));


    }

     public  function inprocessOrder(){
         $agentId = Auth::user()->id;
         $currentUser = User::find($agentId);
         $type = $currentUser->type;


         if($type == 1){
             $order = Order::processOrder();
         }else{
             $order=Order::processOrder_agent_record($agentId);
         }

         $taxs=DB::table('price_kms')->first();
         $taxs=$taxs->tax/100;
          return view('admin.orders.inprocess_order',compact('order', 'taxs'));


    }

    public  function cancelledOrder(){
         $agentId = Auth::user()->id;
         $currentUser = User::find($agentId);
         $type = $currentUser->type;


         if($type == 1){
             $order = Order::cancelOrder();
         }else{
             $order=Order::cancelOrder_agent_record($agentId);
         }
         $taxs=DB::table('price_kms')->first();
         $taxs=$taxs->tax/100;

          return view('admin.orders.cancelled_order',compact('order','taxs'));


    }

    public function status($rowId, $value){
        $update = array(
            'order_status' => $value
        );
          Order::where('id', $rowId)->update($update);

         if ($value == 1 || $value == 4) {
             BookedResources::where('order_id',$rowId)->delete();
         }

            $order_id =  Order::where('id',$rowId)->first();
            $cus_row = Customer::where('id',  $order_id->customer_id)->first();
            $status_email= $cus_row->email;
            $subject = "Status for Astuto CC";




     if ($value == 1) {
            $msg = "Your Order Is Completed";
            mail($status_email,$subject,$msg);
            // $message = "Order Is Check Out";
        }else if ($value == 2) {
            $msg = "Your Order Is Pending";
            mail($status_email,$subject,$msg);
            // $message = "Order Change To Pending";
        }else if ($value == 3) {
            $msg = "Your Order Is Check In";
            mail($status_email,$subject,$msg);
            // $message = "Order Is Check In";
        }else if ($value == 4) {
            $msg = "Your Order Is Cancel";
            mail($status_email,$subject,$msg);
            // $message = "Order Is  Cancel";
        }
        // else if ($value == 5) {
        //     $message = "Order Is  Delete";
        // }
        Session::flash('message', $msg);
        return redirect()->back();


    }


    // public function view_detail($orderId){
    //     // return $orderId;
    //     $data = Order::viewData($orderId);
    //     return view('admin.orders.view_order',$data);

    // }


    // public function view_detail($orderId){
    //     // return $orderId;

    //      $agentId = Auth::user()->id;
    //      $currentUser = User::find($agentId);
    //      $type = $currentUser->type;

    //      if($type == 1){
    //           $data = Order::viewData($orderId);
    //      }else{
    //          $data = Order::viewDataAcordingAgent($orderId,$agentId);
    //      }
    //      return view('admin.orders.view_order',$data);

    // }

    public function view_detail($orderId){


         $agentId = Auth::user()->id;
         $currentUser = User::find($agentId);
         $type = $currentUser->type;

         if($type == 1){

            $res = Order::viewDataAllAgent($orderId);
            $data = Order::viewData($orderId);

         }else{
             $res = Order::viewDataAcordingAgent($orderId,$agentId);
             $data = Order::viewData($orderId);
         }



         $taxs = DB::table('price_kms')->first();
         $taxs->tax=$taxs->tax/100;

            $days =  $data['orders']->select_days;

            for ($a=0; $a <count($res['resources']); $a++){

                    $price_rules = DB::table('resource_prices as resP')
                    ->select('resPR.limit', 'resPR.price')
                    ->join('resource_price_rules as resPR' , 'resP.id' , '=', 'resPR.resource_price_id')
                    ->where('resource_id', $res['resources'][$a]->id)
                    ->orderBy('resPR.limit', 'ASC')
                    ->get();

                    $finalresult="";

                    if($days < $price_rules[0]->limit){

                        $finalresult = $res['resources'][$a]->basic_rate;
                    }
                    else{

                        for ($b=0; $b <count($price_rules); $b++){

                            if($days >= $price_rules[$b]->limit )
                            {
                               $tb_price = $days * $res['resources'][$a]->basic_rate;
                               $discount_value = ($tb_price / 100) * $price_rules[$b]->price;
                               $finalresult = $tb_price - $discount_value;
                            }
                        }
                    }

                    $new['reso'][$a]['id'] = $res['resources'][$a]->id;
                    $new['reso'][$a]['res_name'] = $res['resources'][$a]->res_name;
                    $new['reso'][$a]['uid'] = $res['resources'][$a]->uid;
                    $new['reso'][$a]['res_img'] = $res['resources'][$a]->res_img;
                    $new['reso'][$a]['basic_rate'] = $res['resources'][$a]->basic_rate;
                    $new['reso'][$a]['dis_price'] = round($finalresult);
            }
            // $total = 0;
            // for ($s=0; $s<count($new['reso']); $s++) {

            //     $total = $total + $new['reso'][$s]['dis_price'];
            // }
            $data['new']=$new;
            // $data['after_rules_TP']=$total;
         return view('admin.orders.view_order', $data )->with('taxs',$taxs);

    }




}
