<?php

namespace App\Http\Controllers;

use App\User;
use App\Depot;
use App\Customer;
use App\Order;
use DB;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Http\Response
     */

    // public function index()
    // {
    //     $id = Auth::user()->id;
    //     $currentuser = User::find($id);

    //     return view('home' , compact('currentuser'));
    // }

      public function index()
    {
        $agentId = Auth::user()->id;
        $currentUser = User::find($agentId);
        $type = $currentUser->type;

        $data['depo'] = Depot::where('status', 1)->count();
        $data['agents'] = User::where('type',2)->count();
        $data['customer'] = Customer::where('status',1)->count();
        $data['new_order'] = Order::whereDate('created_at', Carbon::today())->count();


        if($type == 1){
         $data['orders'] = Order::allOrder()->take(10);
         $data['depots'] = Depot::get_records()->take(10);
         $data['tax'] = DB::table('price_kms')->first();
         $data['tax']->tax=$data['tax']->tax/100;
        }else{
         $data['orders']  = Order::order_agent_records($agentId)->take(10);
         $data['depots']  = Depot::get_agent_records($agentId)->take(10);
         $taxs = DB::table('price_kms')->first();
         $taxs->tax=$taxs->tax/100;
        }

        // return $data;
        return view('home' ,compact('data'));

    }
}
