<?php

namespace App\Http\Controllers;


use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Common;
use Carbon\Carbon;
use App\Customer;
use App\Cart;
use App\Order;
use App\User;
use App\OrderDetail;
use App\OrderShipingAdress;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Input;
use App\OrderAdditResource;
use App\AttitionalResourceVariation;
use App\ResourceVariation;
use App\VariationValue;
use App\ResourceQuantity;
use App\BookedResources;
use App\Coupon;
use App\DepotWithAgent;
use App\PriceKm;
use App\AdditionalResource;
use DateTime;
use Stripe\Stripe;
use Stripe\Customer as StripeCustomer;
use Stripe\Charge;
use Exception;
use Illuminate\Support\Facades\Crypt;

class ApiController extends Controller
{
    
      public function countries(){

        $listofcountries = Common::countries();
        // print_r($listofcountries);
        // die;
          if($listofcountries){
            return response()->json(['code' => 200, 'data'=>$listofcountries], 200);
          }
          else{
            return response()->json(['code' => 100, 'data'=>'No Data Found'], 200);
          }      
      }




   
    public function customer_info(){
        $users_detail = new Customer();

        $rules = array(
            'email' => 'required|email|max:255|unique:customers'
        );
         $validator = Validator::make(Input::all(), $rules);
         
         $email = Input::get('email');
         $users_detail = $users_detail->get_user_info($email);

         if($validator->fails()){

            $data = array('code' => 200,
                          'msg' => '',
                          'data' => $users_detail
                        );
         }else{       
        $input = Input::all();
        $result = Customer::save_user($input);
            if($result){
                $data = array('code' => 200,
                            'msg' => 'successfully',
                            'id' => $result
                            );
            }
            else
            {
                    $data = array('code' => 100,
                            'msg' => 'Failed'
                            );            
            }

         }
         
        echo json_encode($data);
        die;

    }





  public function resource_detail(){
        $input = Input::all();
        $id = Input::get('id');
        $data=Common::getvalue($id);
        $dataimage=Common::getvalueimage($id);
        $variationValue = Common:: resource_variation($id);


        $final_array[]=array(
                        "data" => $data,
                        "resource_image"=>$dataimage,
                        "variation_value" =>$variationValue,               
                    );

        if($data){
            return response()->json(['code' => 200, 'data'=>$final_array], 200);
        }
        else{
            return response()->json(['code' => 100, 'data'=>'No Data Found'], 200);
        }
        
  }





    public function search_depots(){
    	$input = Input::all();
    	$lat = Input::get('lat');
    	$long = Input::get('long');
      $date_check_in = Input::get('date_check_in');
      $date_check_out = Input::get('date_check_out');

    	$depots = Common::get_depots($lat,$long);

      $final_array=array();

      foreach ($depots as $depot) {

          
          $check_in = date("Y-m-d", strtotime($date_check_in));
          $check_out = date("Y-m-d", strtotime($date_check_out));

          $resources = DB::select("SELECT * FROM `booked_resources` WHERE `checkout` >= '".$check_in."'  AND `checkout` <= '".$check_out."' ");

          $a = '';
            for ($res=0; $res <count($resources); $res++)
            { 
            $a .= $resources[$res]->resource_quantity_id.",";
            }

          $booked_resources = rtrim($a,',');

            if(!empty($booked_resources)){
              $available_resources = DB::select(
              "select COUNT(*) AS available_bike
              from `resources` as `res` 
              inner join `resource_quantities` as `resqty` on `resqty`.`resource_id` = `res`.`id` 
              where res.status=1 AND res.res_depot=".$depot->id." 
              AND `resqty`.`id` NOT IN (".$booked_resources.") 
              ");

            }else{

              $available_resources = DB::select(
              "select COUNT(*) AS available_bike
              from `resources` as `res` 
              inner join `resource_quantities` as `resqty` on `resqty`.`resource_id` = `res`.`id` 
              where res.status=1 AND res.res_depot=".$depot->id."
              ");

            }

            $sum = 0;
            foreach($available_resources as $av){
            $sum += $av->available_bike;
            }

            $depot_with_agent =  DepotWithAgent::where('depot_id', $depot->id)->select('agent_id')->get();

            $depo = array(
                "id"           => $depot->id,
                "name"         => $depot->name,
                "distance"     => $depot->distance,
                "lat"          => $depot->lat,
                "long"         => $depot->long,
                "depo_image"   => $depot->depo_image,
                "total_bicycle"=> $sum, 
            );

            $final_array[]=array(
                               "depot"=>$depo, 
                               "depot_with_agent"=>$depot_with_agent,                  
                    );
      }

          

    	if($depots){
    		return response()->json(['code' => 200, 'data'=>$final_array], 200);
    	}
    	else{
    		return response()->json(['code' => 100, 'data'=>'No Data Found'], 200);
    	}
    }


    public function resources(){

        $input = Input::all();
        $depot_id = Input::get('depot_id');
        $date_check_in = Input::get('date_check_in');
        $date_check_out = Input::get('date_check_out');
        $check_in = date("Y-m-d", strtotime($date_check_in));
        $check_out = date("Y-m-d", strtotime($date_check_out));

        $resources = DB::select("SELECT * FROM `booked_resources` WHERE `checkout` >= '".$check_in."'  AND `checkout` <= '".$check_out."' ");

        $a = '';
          for ($res=0; $res <count($resources); $res++)
          { 
          $a .= $resources[$res]->resource_quantity_id.",";
          }

        $booked_resources = rtrim($a,',');


       if(empty($booked_resources)){
          $booked_resources_condition = 0;
        }
        else{
          $booked_resources_condition = $booked_resources;
        }

        $available_resources = DB::select(
        "select COUNT(*) AS available_bike, `res`.`id`, `res`.`res_name`, `res`.`res_details`, `res`.`res_img`,`res`.`res_agent`, `restyp`.`id` as `ID`, `restyp`.`type_id`, `restyp`.`name` as `type_name`, `resqty`.`id` as `uidID`, `resqty`.`uid`
        from `resources` as `res` 
        inner join `resource_quantities` as `resqty` on `resqty`.`resource_id` = `res`.`id` 
        inner join `resource_types` as `restyp` on `restyp`.`id` = `res`.`res_type` 
        where res.status=1 AND res.res_depot=".$depot_id." 
        AND `resqty`.`id` NOT IN (".$booked_resources_condition.") 
        group by `resqty`.`resource_id` ");


        $final_array=array();

          for($r=0;$r<count($available_resources);$r++){ 
              
               $res_image =Common::getvalueimage($available_resources[$r]->id);

               $resVar = ResourceVariation::where('res_id', $available_resources[$r]->id)->get();
               for($t=0;$t<count($resVar);$t++){ 
                              
                    $select=array("id","name","v_id");
                    $where="status=1 AND id=".$resVar[$t]->var_id."";
                    $groups=Common::search_data($select,$where,"variation");

                        $select=array("v_value","id");
                        $where="status=1 AND id=".$resVar[$t]->var_value_id."";
                        $variation_values=Common::search_data($select,$where,"variation_values");

                          $sub_array[]=array(
                          "variation_groups"=>$groups,
                          "variation_values"=>$variation_values
                          );
                }
               
                 

             /***************** PRICE RULES ********************************/

                  $pricingdata =  $available_resources[$r]->id;
                  $pricing_data=Common::get_pricing($pricingdata);
                  $rules_prize_array = array();
                    for ($i=0; $i <count($pricing_data); $i++){ 

                      $add_rules =  $pricing_data[$i]->id; 
                      $rules_prize = Common::rules_prize($add_rules);
                        $rules_prize_array[] = array(  
                        "Resources_Price"=>$pricing_data[$i], 
                        "Price Rules" => $rules_prize, 
                        );
                    }
              /************************PRICE RULES*************************/

                  $final_array[]=array(
                  "available_resources"  =>$available_resources[$r],
                  "resource_image"       =>$res_image,		
                  "resources_price_data" =>$rules_prize_array,	
                  "variation_groups"     =>$sub_array,	        
                  );
                   $sub_array=array();  
          }

        if($available_resources){
          return response()->json(['code' => 200,'data'=>$final_array], 200);
        }
        else{
          return response()->json(['code' => 100, 'data'=>'No Resources Are Availabe'], 200);
        }


    }



    public function get_addit_resource(){

        $input = Input::all();
        $id = Input::get('add_depot_id');
        $data=Common::get_additResource($id);  
        $output_data=array();
        for($i=0;$i<count($data);$i++){
            $addpricing = $data[$i]->id;
            $add_pricing_data=Common::get_addit_pricing($addpricing);
            $output_data[]=array(
                "add_re"=>$data[$i],
                "price"=>$add_pricing_data
            ); 
        }
        if($data){
            return response()->json(['code' => 200, 'data'=>$output_data], 200);
        }
        else{
            return response()->json(['code' => 100, 'data'=>'No Data Found'], 200);
        }
   }



    public function insert_cart(Request $request){

        $device_id     = $request->device_id;
        $res_id        = $request->res_id;
        $depot_id      = $request->depot_id;
        $res_qty_id    = $request->res_qty_id;
        $res_name      = $request->res_name;
        $depot_name    = $request->depot_name;
        $agent_id      = $request->agent_id;
        $uid           = $request->uid;
        $price         = $request->price;

        $check_in      = date("Y-m-d", strtotime($request->date_check_in));
        $check_out     = date("Y-m-d", strtotime($request->date_check_out));
  

       $cart = DB::select("SELECT res_qty_id FROM `carts` WHERE `date_check_in` >= '".$check_in."'  AND `date_check_out` <= '".$check_out."' ");
       $a = '';
        for ($c=0; $c <count($cart); $c++)
        { 
            $a .= $cart[$c]->res_qty_id.",";
        }
         $selected_resources = rtrim($a,',');
        
      
       $resources = DB::select("SELECT * FROM `booked_resources` WHERE `checkout` >= '".$check_in."'  AND `checkout` <= '".$check_out."' ");
       $b = '';
         for ($res=0; $res <count($resources); $res++)
         { 
          $b .= $resources[$res]->resource_quantity_id.",";
         }
       $booked_resources = rtrim($b,',');


      if(empty($selected_resources)){
        $selected_resources_condition = 0;
      }
      else{
        $selected_resources_condition = $selected_resources;
      }

      if(empty($booked_resources)){
        $booked_resources_condition = 0;
      }
      else{
        $booked_resources_condition = $booked_resources;
      }


      $check_cart = DB::select(
          "select `resource_quantities`.`uid` as uidd, `resource_quantities`.`id` as `uidIDD` 
          from `resource_quantities`  
          where `resource_quantities`.`resource_id` = ".$request->res_id."
          AND `resource_quantities`.`id` NOT IN (".$selected_resources_condition.") 
          AND `resource_quantities`.`id` NOT IN (".$booked_resources_condition.")
          GROUP BY `resource_quantities`.`resource_id` ");


      if (!empty($check_cart)) {

       foreach ($check_cart as $check) {
                    $qty_id =  $check->uidIDD;
                    $uid    =  $check->uidd;
                  }

          $data = array(
                        'device_id'     => $device_id,
                        'res_id'        => $res_id,
                        'depot_id'      => $depot_id,
                        'agent_id'      => $agent_id,
                        'res_name'      => $res_name,
                        'depot_name'    => $depot_name,   
                        'price'         => $price,
                        'date_check_in' => $check_in,
                        'date_check_out'=> $check_out,
                        'res_qty_id'    =>  $qty_id,
                        'uid'           =>  $uid,

                );

         Cart::create($data);
        return response()->json(['code' => 200, 'msg' => 'Resource has Been Addeed To Card'], 200);
      }else{
      return response()->json(['code' => 100, 'msg' => 'Resources Is Not Available'], 200);
      }
          

    }

   public function get_cart_data(){

        $input = Input::all();
        $device_id = Input::get('device_id');
        $data=Common::cartdata($device_id);
            if(count($data) > 0){
                
            return response()->json(['code' => 200, 'data'=>$data], 200);
        }
        else{
            return response()->json(['code' => 100, 'data'=>'Cart Is Empty'], 200);
        }
   }

 
  public function booking_order(){

       
    $input = Input::all();
    $device_id = Input::get('device_id');
    $add_res = Input::get('add_res');
    $customer_id = Input::get('customer_id');
    $total_amount    = Input::get('total_amount');
    $status    = Input::get('status');
    $cop_code    = Input::get('coupon_code');
    $source    = Input::get('source');
    $check_date;


    $customer_row =  Customer::where('id',$customer_id)->first();
    if ($customer_row->status == 1) {

        if($cop_code)
        {
           $coupon_row =  Coupon::where('cop_code',$cop_code)->first();
           if (empty($coupon_row)) {
                return response()->json(['code' => 100, 'data'=>'Your Coupon Code Is Not Exsit'], 200);
           }
           else{
             $limit =  $coupon_row->cop_limit;
             $validity = $coupon_row->validity;
             $current_date = date('Y-m-d');

               if(!empty($validity)){
                  if($current_date <= $validity){
                    
                     $check_date = true;
                   }else{
                
                     $check_date = false;
                   } 
               }else{

                    $check_date = true;
               }
           }
          
        }
        else
        {
          $coupon_row = true;
          $limit = 1;
          $check_date = true;
          
        }
  
          if($coupon_row)
          {

            if ( $limit > 0 && $check_date ) {    

                $data=Common::cartdata($device_id);
                $count =  count($data);            

                    $reg = new Order();
                    $reg->customer_id = $customer_id;
                    $reg->total_amount = $total_amount;
                    $reg->status  = $status;
                    $reg->source = $source;
                    $reg->payment_status = 1;
                    $reg->reservation_status = 1;
                    $reg->order_status =2;

                    // $reg->cop_code = $copen;

                    if($reg->save()){

                        $order_id =  $reg->id;
                        $customer_id = $reg->customer_id;

                         if ($count > 0) {

                              for($i=0;$i<$count;$i++){
                                  $id = $data[$i]->id;
                                  $device_id = $data[$i]->device_id;
                                  $res_id = $data[$i]->res_id;
                                  $res_name = $data[$i]->res_name;
                                  $depot_id = $data[$i]->depot_id;
                                  $agent_id = $data[$i]->agent_id;
                                  $depot_name = $data[$i]->depot_name;
                                  $res_qty_id = $data[$i]->res_qty_id;
                                  $uid = $data[$i]->uid;
                                  $date_check_in = $data[$i]->date_check_in;
                                  $date_check_out = $data[$i]->date_check_out;

                                  $detailReg = new OrderDetail();
                                  $detailReg->order_id = $order_id;
                                  $detailReg->device_id = $device_id;
                                  $detailReg->res_id = $res_id;
                                  $detailReg->res_name = $res_name;
                                  $detailReg->depot_id = $depot_id;
                                  $detailReg->agent_id = $agent_id;
                                  $detailReg->depot_name = $depot_name;
                                  $detailReg->res_qty_id = $res_qty_id;
                                  $detailReg->uid = $uid;
                                  
                                  
                                    // for updating days
                                    $check_in = date("Y-m-d", strtotime($date_check_in));
                                	$check_out = date("Y-m-d", strtotime($date_check_out));
                                
                                    $start_date = new Carbon($check_in);
                                	$end_date = new Carbon($check_out);
                                	$days = ($start_date->diff($end_date)->days < 1) ? '0' : $start_date->diffInDays($end_date);

                                    $data = array('select_days'   => $days + 1);
                                    Order::where('id',$order_id)->update($data);

                                  if($detailReg->save()){
                                      // ResourceQuantity::where('id', $res_qty_id)
                                      //                  ->update(['availibility_status' => '0']);
                                      $booked = new BookedResources();
                                      $booked->order_id = $order_id;
                                      $booked->resource_quantity_id = $res_qty_id;
                                      $booked->checkin = $date_check_in;
                                      $booked->checkout = $date_check_out;
                                      $booked->save();

                                      Cart::where('id',$id)->delete();
                                    }

                                } // for loop close

                          }else{
                            $depot_id    = Input::get('depot_id');
                            $depot_name  = Input::get('depot_name');
                            $detailReg = new OrderDetail();
                            $detailReg->order_id   = $order_id;
                            $detailReg->depot_id   = $depot_id;
                            $detailReg->depot_name = $depot_name;
                            $detailReg->save();
                          }

                          $add_res = Input::get('add_res');
                          for ($i=0; $i < count($add_res); $i++) { 

                                 $add_res_id = $add_res[$i]['0'];
                                 $quantity = $add_res[$i]['1'];
                                 if(isset($add_res[$i]['2'])){
                                  $note = $add_res[$i]['2'];
                                  }else{
                                    $note="";
                                  }


                                  $addit_row =  AdditionalResource::where('id',$add_res[$i]['0'])->first();
                                  $agent_id = $addit_row->agent_id;
                                   
                                 $ordaddreg = new OrderAdditResource();
                                 $ordaddreg->order_id = $order_id;
                                 $ordaddreg->agent_id = $agent_id;
                                 $ordaddreg->add_res_id = $add_res_id;
                                 $ordaddreg->quantity = $quantity;
                                 $ordaddreg->note = $note;
                                 $ordaddreg->save();
                         }

                       // *******************Start Order Mail Code**********************

                        $customer_data = Customer::where('id',$customer_id)->first();
                        $order_itt = Order::where('id',$order_id)->first();
                        $order_detail = OrderDetail::where('order_id', $order_id)->get();
                        $agents_array = $order_detail->pluck('agent_id')->toArray();
                        $uniqe_ar = array_unique($agents_array);
                        $booked_res = BookedResources::where('order_id',$order_id)->first();
                        
                        $order_additional_detail = OrderAdditResource::where('order_id', $order_id)->get();

                        $depo = DB::table('order_details as OD')
                                ->select("D.name")
                                ->join('depots as D', 'D.id','=', 'OD.depot_id')
                                ->where('OD.order_id', $order_id)
                                ->first();

                        $uniqeMsg = "";
                        $everyOneMsg = "Your Order ID is ".$order_id."\n".
                                       "Customer Name ".$customer_data->name."\n".
                                       "Customer Email ".$customer_data->email."\n".
                                       // "Customer Country ".$customer_data->cus_country."\n".
                                       "Customer Postal Code ".$customer_data->cus_postal_code."\n".
                                       "Customer Address ".$customer_data->address."\n".
                                       "Customer Phone ".$customer_data->phone."\n".
                                       "Date ".$order_itt->created_at."\n".
                                       "Depot Name ".$depo->name."\n";


                        if ($count>0) {

                            foreach ($uniqe_ar as $agent) {
                              $agent_data = User::find($agent);
                              $agent_order_detail = OrderDetail::where([['order_id', $order_id],['agent_id',$agent]])->get();
                                
                                $everyOneMsg = "Dear ".$agent_data->name." <br/>
                                        A new reservation has been entered.<br/><br/>
                                        Best regards,<br/>
                                        AstutoCC<br/><br/>
                                            <b>Reservation Information:</b><br/>
                                            <ul>
                                                <li><b>ReservationID:</b> ".$order_id." </li>
                                                <li><b>Resource:</b> "; 
                                                foreach($order_detail as $order_resource){
                                             $everyOneMsg.=$order_resource->res_name.",";
                                                }
                                $everyOneMsg.="</li>
                                                <li><b>Number of resources:</b> ".count($order_detail)." </li>
                                                <li><b>Additional Resource:</b></li>";

                                                foreach($order_additional_detail as $additional_detail){
                                                    $addit_row =  AdditionalResource::where('id',$additional_detail->add_res_id)->first();
                                                    $everyOneMsg.=$addit_row->add_res_name.",";
                                             
                                                }
                                $everyOneMsg.="</li>
                                                <li><b>Number of Additinal Resources:</b> ".count($order_additional_detail)." </li>
                                                <li><b>Duration:</b> ".$booked_res->checkin." - ".$booked_res->checkout."</li>
                                                <li><b>Created:</b> ".$order_itt->created_at." </li>
                                                <li><b>Status:</b> New </li>
                                                <li><b>Price:</b> ".$order_itt->total_amount." </li>
                                            </ul>
                                            <b>Customer Information:</b><br/>
                                            <ul>
                                                <li><b>UserID:</b> ".$customer_data->id."  </li>
                                                <li><b>Name:</b> ".$customer_data->name."  </li>
                                                <li><b>Email:</b> ".$customer_data->email."  </li>
                                                <li><b>Postal Code:</b> ".$customer_data->cus_postal_code."  </li>
                                                <li><b>Address:</b> ".$customer_data->address."  </li>
                                                <li><b>Phone:</b> ".$customer_data->phone."  </li>
                                            </ul>
                                            <b>Delivery Information:</b><br/>
                                            <ul>
                                                <li><b>Delivery Location Name:</b> ".Input::get('hotal_name')."  </li>
                                                <li><b>Delivery Address:</b> ".Input::get('hotal_adress')."  </li>
                                            </ul>
                                            <b>Shopping cart Items:</b><br/>
                                            <table>
                                            <tr>
                                            <th width='100px'>ReservationID</th>
                                            <th width='30%'>Recource</th>
                                            <th width='25%'>Duration</th>
                                            <th width='100px'>Status</th>
                                            <th width='100px'>Price</th>
                                            </tr>
                                            <tr>
                                            <td>".$order_id."</td>
                                            <td>";
                                            foreach($order_detail as $order_resource){
                                     $everyOneMsg.= $order_resource->res_name."<br/>";              
                                            }
                                            
                                     $everyOneMsg.= "</td>
                                            <td>".$booked_res->checkin." - ".$booked_res->checkout."</td>
                                            <td>New</td>
                                            <td>".$order_itt->total_amount."</td>
                                            </tr>
                                            <tr>
                                            <td></td>
                                            <td>Quantity: ".count($order_detail)."</td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            </tr>
                                            </table>";
                                            
                                // for ($i=0; $i < count($agent_order_detail); $i++) { 
                                //   $reso_id    =  $agent_order_detail[$i]->res_id; 
                                //   $res_name   = $agent_order_detail[$i]->res_name;
                                //   $uid        = $agent_order_detail[$i]->uid;

                                //   $uniqeMsg.= "Resource Name ".$res_name."\n";
                                //   $uniqeMsg.= "UID ".$uid."\n";

                                //   $res_var_val = ResourceVariation::where('res_id', $reso_id)->get();
                                //     for ($j=0; $j < count($res_var_val); $j++) { 
                                //       $valueID =  $res_var_val[$j]->var_value_id;
                                //       $varValue = VariationValue::where('id', $valueID)->first();
                                //       $v_value = $varValue->v_value;
                                //       $uniqeMsg.= "V Value ".$v_value."\n";
                                //     }
                                // }


                                  // $uniqeMsg.= "Amount ".$order_row->total_amount."\n";
                                  // $msg.= "Transaction Id ".$reg->transaction_id."\n";
                                  // $msg.= "Payment Gateway  ".$reg->payment_gateway."\n";

                              // *************End Order Mail Code*********************
                                  

                              $findstatus =$reg->status;
                              if ($findstatus == 2 ||  $findstatus == 3) {
                                  $regshipOrder =  new OrderShipingAdress();

                                  $regshipOrder->order_id = $order_id;
                                  $regshipOrder->hotal_name = Input::get('hotal_name');
                                  $regshipOrder->hotal_adress = Input::get('hotal_adress');
                                  $regshipOrder->reg_guest_name = Input::get('reg_guest_name');
                                  $regshipOrder->hotal_booking_no = Input::get('hotal_booking_no');
                                  $regshipOrder->check_in_date = Input::get('check_in_date');
                                  $regshipOrder->check_out_date = Input::get('check_out_date');
                                  $regshipOrder->lat = Input::get('lat');
                                  $regshipOrder->long = Input::get('long');
                                  $regshipOrder->shipping_charges = Input::get('shipping_charges');
                                  $regshipOrder->delivery_notes = Input::get('delivery_notes');
                                  $regshipOrder->save();


                                  /********start Order Shipping Mail code*************/
                                  $addMsg = "";
                                //   $o_ship_adres = OrderShipingAdress::where('order_id',$order_id)->first();

                                //   $addMsg = "Hotal Booking No ".$o_ship_adres->hotal_booking_no."\n".
                                //   "Hotal Name ".$o_ship_adres->hotal_name."\n".
                                //   "Hotal Adress ".$o_ship_adres->hotal_adress."\n".
                                //   "Reg Guest Name ".$o_ship_adres->reg_guest_name."\n".
                                //   "Shipping Charges ".$o_ship_adres->shipping_charges."\n";
                                  // $total_charges = $o_ship_adres->shipping_charges + $order_row->total_amount;
                                  // $addMsg.= "Total Charges ".$total_charges."\n";

                                  /********* End Order Shipping mail code*****************/
                               }

                                if (empty($addMsg)) {
                                  $finalMsg = $everyOneMsg.$uniqeMsg;
                                }else{
                                  $finalMsg = $everyOneMsg.$uniqeMsg.$addMsg; 
                                }

                                $to_email = $agent_data->email;
                                $subject = "New Booking for Astuto CC";
                                
                                $headers = "MIME-Version: 1.0" . "\r\n";
                                $headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";
                                $headers .= 'Reply-To:directeur@gsastuto.com' . "\r\n" ;
                                
                                
                                mail($to_email,$subject,$finalMsg, $headers);
                                $uniqeMsg = "";

                            } // end foreach
                                
                                $agent_data = User::find($uniqe_ar[0]);
                                $cus = Customer::where('id', $customer_id)->first();
                                $customer_email =  $cus->email;
                                $booked_res = BookedResources::where('order_id',$order_id)->first();
                                $depot_array = $order_detail->pluck('depot_id')->toArray();
                                $encrypted = Crypt::encryptString($depot_array[0]);
                                $link_url = url('/')."/map_link/".$encrypted;

                                $cus_msg= "Dear ".$cus->name."<br/>";
                                $cus_msg.= "We have received your reservation for the rental Resource starting from ".$booked_res->checkin." and finishing on "
                                .$booked_res->checkout.". <br/> Your reservation will be confirmed upon receipt of payment. <br/>";
                                $cus_msg.= "Pickup or delivery of the rental item(s) will be based on your delivery selection in the reservation. <br/>";
                                $cus_msg.= "If you have any questions or require additional assistance regarding this reservation please don't hesitate to contact us anytime! <br/><br/>";
                                $cus_msg.= "Best regards, <br/>"; 
                                $cus_msg.= "AstutoCC<br/><br/>"; 
                                $cus_msg.="<b>Reservation Information:</b><br/>
                                            <ul>
                                                <li><b>ReservationID:</b> ".$order_id." </li>
                                                <li><b>Resource:</b> "; 
                                                foreach($order_detail as $order_resource){
                                             $cus_msg.=$order_resource->res_name.",";
                                                }
                                $cus_msg.="</li>
                                                <li><b>Number of resources:</b> ".count($order_detail)." </li>
                                                <li><b>Additional Resource:</b></li>";

                                                foreach($order_additional_detail as $additional_detail){
                                                    
                                                    $addit_row =  AdditionalResource::where('id',$additional_detail->add_res_id)->first();
                                                    $cus_msg.=$addit_row->add_res_name.",";
                                             
                                                }
                                $cus_msg.="</li>
                                                <li><b>Number of Additinal Resources:</b> ".count($order_additional_detail)." </li>
                                                <li><b>Duration:</b> ".$booked_res->checkin." - ".$booked_res->checkout."</li>
                                                <li><b>Created:</b> ".$order_itt->created_at." </li>
                                                <li><b>Status:</b> New </li>
                                                <li><b>Price:</b> ".$order_itt->total_amount." </li>
                                                <li><b>Map Link:</b> ".$link_url." </li>
                                            </ul>
                                            <b>Delivery Information:</b><br/>
                                            <ul>
                                                <li><b>Delivery Location Name:</b> ".Input::get('hotal_name')."  </li>
                                                <li><b>Delivery Address:</b> ".Input::get('hotal_adress')."  </li>
                                            </ul>
                                            <b>Shopping cart Items:</b><br/>
                                            <table>
                                            <tr>
                                            <th width='100px'>ReservationID</th>
                                            <th width='30%'>Recource</th>
                                            <th width='25%'>Duration</th>
                                            <th width='100px'>Status</th>
                                            <th width='100px'>Price</th>
                                            </tr>
                                            <tr>
                                            <td>".$order_id."</td>
                                            <td>";
                                            foreach($order_detail as $order_resource){
                                     $cus_msg.= $order_resource->res_name."<br/>";              
                                            }
                                            
                                     $cus_msg.= "</td>
                                            <td>".$booked_res->checkin." - ".$booked_res->checkout."</td>
                                            <td>New</td>
                                            <td>".$order_itt->total_amount."</td>
                                            </tr>
                                            <tr>
                                            <td></td>
                                            <td>Quantity: ".count($order_detail)."</td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            </tr>
                                            </table>
                                    ";
                                
                                $cust_subject = "Order for Astuto CC";
                                // print_r($cus_msg);die;
                                
                                $headers = "MIME-Version: 1.0" . "\r\n";
                                $headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";
                                $headers .= 'Reply-To:'.$agent_data->email. "\r\n";

                                mail($customer_email,$cust_subject,$cus_msg, $headers);

                        }else{

                          $addit_detail = OrderAdditResource::where('order_id', $order_id)->get();
                          $agents_array = $addit_detail->pluck('agent_id')->toArray();
                          $agent_uniqe = array_unique($agents_array);

                          foreach ($agent_uniqe as $agent) {
                            $agent_data = User::find($agent);
                            $addit_order_detail = OrderAdditResource::where([['order_id', $order_id],['agent_id',$agent]])->get();
                            
                            $everyOneMsg = "Dear ".$agent_data->name." <br/>
                                        A new reservation has been entered.<br/><br/>
                                        Best regards,<br/>
                                        AstutoCC<br/><br/>
                                            <b>Reservation Information:</b><br/>
                                            <ul>
                                                <li><b>ReservationID:</b> ".$order_id." </li>";               
                            for ($i=0; $i < count($addit_order_detail); $i++) { 

                              $add_res_id    =  $addit_order_detail[$i]->add_res_id;  
                            //   $quantity    =  $addit_order_detail[$i]->quantity;  
                            //   $note    =  $addit_order_detail[$i]->note;
                              $addit_row = AdditionalResource::where('id', $add_res_id)->first();

                              $everyOneMsg.= "<li><b>Additional Resource:</b> ".$addit_row->add_res_name.",";
                            //   $uniqeMsg.= "Additional Resource Qty ".$quantity."\n";
                            //   $uniqeMsg.= "Additional Resource Note ".$note."\n";
                              

                            //   $add_var_val = AttitionalResourceVariation::where('add_res_id', $add_res_id)->get();
                            //     for ($j=0; $j < count($add_var_val); $j++) { 
                            //       $valueID =  $add_var_val[$j]->var_value_id;
                            //       $varValue = VariationValue::where('id', $valueID)->first();
                            //       $v_value = $varValue->v_value;
                            //       $uniqeMsg.= "V Value ".$v_value."\n";
                            //     }
                            }
                            
                            $everyOneMsg.="</li>
                                            <li><b>Number of Rescources:</b> ".count($addit_detail)." </li>
                                            <li><b>Created:</b> ".$order_itt->created_at." </li>
                                            <li><b>Status:</b> New </li>
                                            <li><b>Price:</b> ".$order_itt->total_amount." </li>
                                            </ul>
                            ";
                            
                             // ************End Order Mail Code*********

                              $findstatus =$reg->status;
                              if ($findstatus == 2 ||  $findstatus == 3) {
                                  $regshipOrder =  new OrderShipingAdress();

                                  $regshipOrder->order_id = $order_id;
                                  $regshipOrder->hotal_name = Input::get('hotal_name');
                                  $regshipOrder->hotal_adress = Input::get('hotal_adress');
                                  $regshipOrder->reg_guest_name = Input::get('reg_guest_name');
                                  $regshipOrder->hotal_booking_no = Input::get('hotal_booking_no');
                                  $regshipOrder->check_in_date = Input::get('check_in_date');
                                  $regshipOrder->check_out_date = Input::get('check_out_date');
                                  $regshipOrder->lat = Input::get('lat');
                                  $regshipOrder->long = Input::get('long');
                                  $regshipOrder->shipping_charges = Input::get('shipping_charges');
                                  $regshipOrder->delivery_notes = Input::get('delivery_notes');
                                  $regshipOrder->save();


                                  /********start Order Shipping Mail code*************/
                                  $addMsg = "";
                                //   $o_ship_adres = OrderShipingAdress::where('order_id',$order_id)->first();

                                //   $addMsg = "Hotal Booking No ".$o_ship_adres->hotal_booking_no."\n".
                                //   "Hotal Name ".$o_ship_adres->hotal_name."\n".
                                //   "Hotal Adress ".$o_ship_adres->hotal_adress."\n".
                                //   "Reg Guest Name ".$o_ship_adres->reg_guest_name."\n".
                                //   "Shipping Charges ".$o_ship_adres->shipping_charges."\n";
                                  // $total_charges = $o_ship_adres->shipping_charges + $order_row->total_amount;
                                  // $addMsg.= "Total Charges ".$total_charges."\n";

                                  /********* End Order Shipping mail code*****************/
                               }
                            
                            $customerInfoMsg="<b>Customer Information:</b><br/>
                                            <ul>
                                                <li><b>UserID:</b> ".$customer_data->id."  </li>
                                                <li><b>Name:</b> ".$customer_data->name."  </li>
                                                <li><b>Email:</b> ".$customer_data->email."  </li>
                                                <li><b>Postal Code:</b> ".$customer_data->cus_postal_code."  </li>
                                                <li><b>Address:</b> ".$customer_data->address."  </li>
                                                <li><b>Phone:</b> ".$customer_data->phone."  </li>
                                            </ul>
                                            <b>Delivery Information:</b><br/>
                                            <ul>
                                                <li><b>Delivery Location Name:</b> ".Input::get('hotal_name')."  </li>
                                                <li><b>Delivery Address:</b> ".Input::get('hotal_adress')."  </li>
                                            </ul>
                                            <b>Shopping cart Items:</b><br/>
                                            <table>
                                            <tr>
                                            <th width='100px'>ReservationID</th>
                                            <th width='30%'>Recource</th>
                                            <th width='100px'>Status</th>
                                            <th width='100px'>Price</th>
                                            </tr>
                                            <tr>
                                            <td>".$order_id."</td>
                                            <td>";
                                            for ($i=0; $i < count($addit_order_detail); $i++) { 
                                                $add_res_id    =  $addit_order_detail[$i]->add_res_id; 
                                                $addit_row = AdditionalResource::where('id', $add_res_id)->first();
                                    $customerInfoMsg.= $addit_row->add_res_name."<br/>";
                                            }
                                            
                                     $customerInfoMsg.= "</td>
                                            <td>New</td>
                                            <td>".$order_itt->total_amount."</td>
                                            </tr>
                                            <tr>
                                            <td></td>
                                            <td>Quantity: ".count($addit_detail)."</td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            </tr>
                                            </table>";
                                            
                            if (empty($addMsg)) {
                            $finalMsg = $everyOneMsg.$customerInfoMsg;
                            }else{
                            $finalMsg = $everyOneMsg.$customerInfoMsg.$addMsg; 
                            }

                            $to_email = $agent_data->email;
                            $subject = "New Booking for Astuto CC";
                            
                            $headers = "MIME-Version: 1.0" . "\r\n";
                            $headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";
                            $headers .= 'Reply-To:directeur@gsastuto.com' . "\r\n" ;
                            
                                
                            mail($to_email,$subject,$finalMsg, $headers);
                            $uniqeMsg = "";

                          } //endforeach  for agent_uniqe include else part

                          return response()->json(['code' => 200, 
                                                   'data' => $order_id,
                                                    'msg' => 'successfully Order Only Additional Resource Detail'
                                                   ], 200);
                        } // end elseif 


                                return response()->json(['code' => 200, 
                                                   'data' => $order_id,
                                                    'msg' => 'successfully Order Detail'
                                                   ], 200);


                    } // reg->save if close

            }else{
              DB::table('carts')->where('device_id', $device_id)->delete();
              return response()->json(['code' => 100, 'data'=>'Your Coupon Code Is Not Valid'], 200);
            }

          } //copon_row if Close

    }else{
     DB::table('carts')->where('device_id', $device_id)->delete();
     return response()->json(['code' => 100, 
                                          'msg' => 'Order Is Cancelled Customer is Blocked'
                                         ], 200);
  }

}
   
   

    public function saveTransaction(){
        $input = Input::all();
        $order_id = Input::get('order_id');
        $transaction_id = Input::get('transaction_id');
        $payment_gateway = Input::get('payment_gateway');
        $cop_code = Input::get('cop_code');
        $cop_discount = Input::get('cop_discount');
        $reservation_status = Input::get('reservation_status');
        $payment_status = Input::get('payment_status');


         if($cop_code){
           $coupon_row =  Coupon::where('cop_code',$cop_code)->first();
           $limit =  $coupon_row->cop_limit;
           if($limit > 0){
                 $less_limit = $limit-1;
                 $data = array('cop_limit'   => $less_limit);
                Coupon::where('id', $coupon_row->id)->update($data);
              }   
        }

             $data = array(
                 'transaction_id' => $transaction_id,
                 'payment_gateway'=> $payment_gateway,
                 'cop_code'       => $cop_code,
                 'cop_discount'   => $cop_discount,
                 'reservation_status'   => $reservation_status,
                 'payment_status'   => $payment_status,
             );

                 $updatetransaction =  Order::where('id', $order_id)->update($data);

                if($updatetransaction){

                   $order_row   =  Order::find($order_id);
                   $customer_id =  $order_row->customer_id;
                   $total_amount =  $order_row->total_amount;
                   $cus = Customer::where('id', $customer_id)->first();
                   $customer_email =  $cus->email;
                //   $customer_email =  "hasanikram777@gmail.com";
                   
                   $get_order_detail   =  OrderDetail::where('order_id', $order_id)->get();
                   $get_duration = DB::table('booked_resources')->where('order_id',$order_id)->first();
                   
                   $cus_msg = "Dear ". $cus->name."<br/>";      
                   $cus_msg.= "Your Payment of " .$total_amount. " is received, and your Order#"
                              .$order_id. " is now confirmed.<br/>";
                   $cus_msg.= "Thank you for your service!<br/>AstutoCC<br/><br/>";
                   
                   $cus_msg.= "
                            <html>
                            <head><meta http-equiv=Content-Type content=text/html; charset=utf-8>
                            <title>HTML email</title>
                            </head>
                            <body>
                            <table>
                            <tr>
                            <th width='100px'>ReservationID</th>
                            <th width='30%'>Recource</th>
                            <th width='25%'>Duration</th>
                            <th width='100px'>Status</th>
                            <th width='100px'>Price</th>
                            </tr>";
                            
                            if($order_row->order_status == 0){
                                $order_status = "New";
                            }
                     $cus_msg.= "<tr>
                            <td>".$order_row->id."</td>
                            <td>";
                            foreach($get_order_detail as $order_detail){
                     $cus_msg.= $order_detail->res_name."<br/>";              
                            }
                            
                     $cus_msg.= "</td>
                            <td>".$get_duration->checkin." - ".$get_duration->checkout."</td>
                            <td>".$order_status."</td>
                            <td>".$order_row->total_amount."</td>
                            </tr>
                            <tr>
                            <td></td>
                            <td>Quantity: ".count($get_order_detail)."</td>
                            <td></td>
                            <td></td>
                            <td></td>
                            </tr>
                            ";
                            
                     $cus_msg.= "</table>
                            </body>
                            </html>
                            ";
                   
                   // Always set content-type when sending HTML email
                    $headers = 'MIME-Version: 1.0' . "\r\n";
                    $headers .= 'Content-Type: text/html; charset=ISO-8859-1' . "\r\n";
                    $headers .= "From: hasanikram777@gmail.com"."\r\n";
                    $headers .= 'Reply-To:agentemail@agentemail.com' . "\r\n" ;
                    
                    
                    $cust_subject = "Order Payemnt for Astuto CC";
                    mail($customer_email,$cust_subject,$cus_msg, $headers);

                  return response()->json(['code' => 200, 'data'=>'Transacion is save'], 200);
                }
                else{
                  return response()->json(['code' => 100, 'data'=>'Order Id Is not exist'], 200);
                }

       


  }
    
       public function city(){
          $input = Input::all();
          $country_id = Input::get('country_id');
        
          $listofcity = Common::city($country_id);
          if($listofcity){
              return response()->json(['code' => 200, 'data'=>$listofcity], 200);
            }
            else{
              return response()->json(['code' => 100, 'data'=>'No Data Found'], 200);
            }
        }


        public function remove_cart(Request $request){

        $device_id =  $request->device_id;  
        $delete =DB::table('carts')->where('device_id', $device_id)->delete();
        if($delete>0){
         return response()->json(['code' => 200, 'data'=>'Cart is Deleted'], 200);
        
        }else{
          return response()->json(['code' => 100, 'data'=>'No Device ID Found'], 200);
        }
      }

        public function remove_cart_row(Request $request){
         $id =  $request->id;
         $device_id =  $request->device_id;
         $delete = DB::table('carts')->where([['device_id', $device_id],['id',$id]])->delete();
          if($delete>0){
             return response()->json(['code' => 200, 'data'=>'Cart Item is Deleted'], 200);
            
          }else{
               return response()->json(['code' => 100, 'data'=>'Particulary ID Not Found'], 200);
         }
        
        }



    public function coupon(Request $request){

          $cop_code =  $request->coupon_code;
          $coupon_row =  Coupon::where('cop_code',$cop_code)->select('cop_title','cop_code','discount_bit','discount','cop_limit','validity')->first();


          $customer_id =  $request->customer_id;
          $use_coupon  = Order::where([['customer_id',$customer_id],['cop_code',$cop_code]])->get();
           
            if($coupon_row){

              if (count($use_coupon) < 1) {              

                $limit =  $coupon_row->cop_limit;
                $validity = $coupon_row->validity;
                $current_date = date('Y-m-d');

                 if(!empty($validity)){
                    if($current_date <= $validity){
                      
                       $check_date = true;
                     }else{
                  
                       $check_date = false;
                     } 
                 }else{

                      $check_date = true;
                 }

                  if ( $limit > 0 && $check_date ){
                     return response()->json(['code' => 200, 'data'=>$coupon_row], 200);
                  }else{
                    return response()->json(['code' => 100, 'data'=>'Your Coupon Code Is Not Valid'], 200);
                  }

              }else{
               return response()->json(['code' => 100, 'data'=>'Your Coupon Code Is Already Use'], 200);
              } 

            }else{
               return response()->json(['code' => 100, 'data'=>'Your Coupon Code Is Not Exsit'], 200);
            }
        }



    public function app_setting(){

         $price_km =  PriceKm::find('1');
         
         $PriceKm = $price_km->price_km;
         $tax     = $price_km->tax;
         $range_km     = $price_km->range_km;
         $remote_delivery_charges     = $price_km->remote_delivery_charges;

          if($price_km){
            return response()->json(['code' => 200, 'PriceKm'=>$PriceKm ,'tax'=> $tax ,
              'range_km'=> $range_km, 'remote_delivery_charges' => $remote_delivery_charges ], 200);
          }
          else{
            return response()->json(['code' => 100, 'data'=>'No Data Found'], 200);
          }
        }


    public function get_data_by_email(Request $request){

      $email=$request->email;
      $finaldata = array();

      $data=DB::table('customers')->where('email',$email)->first();
     if($data){
      $cus_country=DB::table('countries')->where('id',$data->cus_country)->first();
      $cus_city=DB::table('cities')->where('id',$data->cus_city)->first();
      $city=DB::table('cities')->where('id',$data->city)->first();
      $country=DB::table('countries')->where('id',$data->country)->first();
      
      $finaldata['id'] = $data->id;
      $finaldata['name'] = $data->name;
      $finaldata['email'] = $data->email;
      $finaldata['phone'] = $data->phone;
      $finaldata['cus_address'] = $data->address;
      $finaldata['cus_city_id'] = $data->cus_city;
      $finaldata['cus_city'] = $cus_city->city_name;
      $finaldata['cus_country_id'] = $data->cus_country;
      $finaldata['cus_country'] = $cus_country->country_name;
      $finaldata['cus_postal_code'] = $data->cus_postal_code;
      $finaldata['hotel_postal_code'] = $data->hotel_postal_code;
      $finaldata['hotal_name'] = $data->hotal_name;
      $finaldata['location_phone'] = $data->location_phone;
      $finaldata['hotel_address'] = $data->hotel_address;
      $finaldata['hotal_city_id'] =  $data->city;
      $finaldata['hotal_city'] = $city->city_name;
      $finaldata['hotal_country_id'] =$data->country;
      $finaldata['hotal_country'] = $country->country_name;
      $finaldata['notes'] = $data->notes;
      $finaldata['status'] = $data->status;
    return response()->json(['code' => 200, 'data'=>$finaldata]);
          
      }else{
        return response()->json(['code' => 210, 'data'=>'No Data Found']);
    }
    }      

       

    public function cancel_reservation(Request $request){
        $order_id=$request->order_id;
        
        $order=DB::table('orders')->where('id',$order_id)->first();
        if(!is_null($order)){
        DB::table('booked_resources')->where('id',$order_id)->delete();
        DB::table('orders')->where('id',$order_id)->delete();
        DB::table('order_addit_resources')->where('order_id',$order_id)->delete();
        DB::table('order_details')->where('order_id',$order_id)->delete();
        DB::table('order_shiping_adresses')->where('order_id',$order_id)->delete();
        DB::table('order_variations')->where('order_id',$order_id)->delete();
        $customer=DB::table('customers')->where('id',$order->customer_id)->first();
        $email=$customer->email;
        
        $to = $email;
		    $subject = "Cancellation Email to send to Customer ";

		   $message = "
        <html>
        <head>
        
        <title>HTML email</title>
        <link rel=stylesheet href=https://maxcdn.bootstrapcdn.com/bootstrap/4.3.1/css/bootstrap.min.css>
        </head>
        <body>
        <h3>Your Order is  Cancelled Successfully!</h3>
        
        <p>Dear <strong>".$customer->name.",</strong></p>
        <p>Your reservation no <strong>".$order->id."</strong> has been cancelled. If you wish to make another reservation, please repeat the selection and reservation process with a payment.

        If you have any questions or need assistance in your reservation, do not hesitate to contact us at <agent email>

        Thank you for visiting AstutoCC</p>
                </body>
                </html>
                ";

		// Always set content-type when sending HTML email
		$headers = "MIME-Version: 1.0" . "\r\n";
		$headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";

		// More headers
		$headers .= 'From: muhammad.zaid@appcrates.com' . "\r\n";
		$headers .= 'Cc: rana.mehmood@appcrates.com' . "\r\n";
        $headers .= 'Reply-To:agentemail@agentemail.com' . "\r\n" ;

		mail($to, $subject, $message, $headers);
        return response()->json(['code' => 200, 'data'=>'Cancel Reservation Successfully']);
        }
        return response()->json(['code' => 200, 'data'=>'No Order Exist']);
    }
   
   
   

     function cancel_reservation_cron(){


      $date = new DateTime();
      $date->modify('-1 hours');
      $formatted_date = $date->format('Y-m-d H:i:s');



     $getorder = Order::where(
      [['created_at', '<', $formatted_date],['payment_status', '=', 1]]
     )->get();

     $count =  count($getorder); 

      if($count > 0){

        for($i=0;$i<$count;$i++){

         $order_id = $getorder[$i]->id;
         $order_status = $getorder[$i]->order_status;
         $customer_id = $getorder[$i]->customer_id;

         BookedResources::where('order_id',$order_id)->delete();

         $data = array(
          'order_status'   => 4,
          'payment_status' => 1,
          'reservation_status' => 1
         );
         Order::where('id', $order_id)->update($data);


          // **************** MAIL CODE **********************

         $cus_data = Customer::where('id', $customer_id)->first();
          
         $to = $cus_data->email; 
         $subject = "Cancellation Email to send to Customer ";

         $message = "
          <html>
          <head>
          <title>HTML email</title>
          <link rel=stylesheet href=https://maxcdn.bootstrapcdn.com/bootstrap/4.3.1/css/bootstrap.min.css>
          </head>
          <body>
          <h3>Your Order is  Cancelled!</h3>
          
          <p>Dear <strong>".$cus_data->name.",</strong></p>
          <p>Your reservation no <strong>".$order_id ."</strong> has been cancelled due to Payment. If you wish to make another reservation, please repeat the selection and reservation process with a payment.

          If you have any questions or need assistance in your reservation, do not hesitate to contact us at <agent email>

          Thank you for visiting AstutoCC</p>
                  </body>
                  </html>
                  ";

          // Always set content-type when sending HTML email
          $headers = "MIME-Version: 1.0" . "\r\n";
          $headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";

          // More headers
          $headers .= 'From: muhammad.zaid@appcrates.com' . "\r\n";
          $headers .= 'Cc: rana.mehmood@appcrates.com' . "\r\n";
          $headers .= 'Reply-To:agentemail@agentemail.com' . "\r\n" ;

           mail($to, $subject, $message, $headers);
        }

        return response()->json(['code' => 200, 'data'=>'Cancel Reservation Successfully']); 

      }else{

        return response()->json(['code' => 200, 'data'=>'No Reservation Exist without Payment']);

      }

    }
    
    
    
      public function customer_info_update(){

        $users_detail = new Customer();

        $name = Input::get('name');
        $email = Input::get('email');
        $phone= Input::get('phone');
        $address= Input::get('address');
        $cus_city= Input::get('cus_city');
        $cus_country= Input::get('cus_country');
        $postal_code= Input::get('postal_code');
        $hotal_name= Input::get('hotal_name');
        $hotel_address= Input::get('hotel_address');
        $country= Input::get('country');
        $city= Input::get('city');
        $location_phone= Input::get('location_phone');
        $hotel_postal_code= Input::get('hotel_postal_code');
        if(Input::get('notes') != null){
        $notes= Input::get('notes');
        }else{
            $notes="";
        }

        /////////// CUSTOMER COUNTRY //////////////
        $check_customer_country = DB::table('countries')->where('country_name', $cus_country)->first();
        if($check_customer_country){
          $cus_country = $check_customer_country->id;
        }
        else{
          $create_city = DB::table('countries')->insertGetId(['country_name' => $cus_country, 'created_at' => Carbon::now(), 'updated_at' => Carbon::now()]);
          $cus_country = $create_city;
        }

        /////////// HOTEL COUNTRY //////////////
        $check_hotel_country = DB::table('countries')->where('country_name', $country)->first();
        if($check_hotel_country){
          $country = $check_hotel_country->id;
        }
        else{
          $create_country = DB::table('countries')->insertGetId(['country_name' => $country, 'created_at' => Carbon::now(), 'updated_at' => Carbon::now()]);
          $country = $create_country;
        }

        /////////// CUSTOMER CITY //////////////
        $check_customer_city = DB::table('cities')->where('city_name', $cus_city)->first();
        if($check_customer_city){
          $cus_city = $check_customer_city->id;
        }
        else{
          $create_city = DB::table('cities')->insertGetId(['city_name' => $cus_city, 'created_at' => Carbon::now(), 'updated_at' => Carbon::now(), 'country_id' => $cus_country]);
          $cus_city = $create_city;
        }

        /////////// HOTEL CITY //////////////
        $check_hotel_city = DB::table('cities')->where('city_name', $city)->first();
        if($check_hotel_city){
          $city = $check_hotel_city->id;
        }
        else{
          $create_city = DB::table('cities')->insertGetId(['city_name' => $city, 'created_at' => Carbon::now(), 'updated_at' => Carbon::now(),  'country_id' => $country]);
          $city = $create_city;
        }

        // print_r($cus_country." ".$country." ".$cus_city." ".$city);
        // die;        

        $users_detail = $users_detail->get_user_info($email);

        $data = array(
           'name'           => $name,
           'phone'          => $phone,
           'address'        => $address,
           'cus_city'       => $cus_city,
           'cus_country'    => $cus_country,
           'cus_postal_code'=> $postal_code,
           'hotel_address'  => $hotel_address,
           'hotal_name'     => $hotal_name,
           'country'        => $country,
           'city'           => $city,
           'location_phone' => $location_phone,
           'notes'          => $notes,
           'hotel_postal_code' => $hotel_postal_code,
       );

       if($users_detail){

          $result = Customer::where('email', $email)->update($data);
          $response = array('code' => 200,
                          'msg' => 'Customer successfully Updated',
                          'customer_id' => $users_detail
                          );

       }else{
          
          $data['email'] = $email;

          $result = Customer::create($data);
          $response = array('code' => 200,
                      'msg' => 'Customer successfully created',
                      'customer' => $result
                      );

       }
       echo json_encode($response);
    }
   
  public function search_address(Request $request){
      $cutomer_array=array();
      $customers=Customer::where('address','LIKE','%'.$request->address.'%')->groupBy('address')->get();
    //   return $customers;
    if(count($customers)>0){
        // return 'asd';
      foreach($customers as $customer){
          $country=DB::table('countries')->select('country_name')->where('id',$customer->cus_country)->first();
        //   return $country;
          $city=DB::table('cities')->select('city_name')->where('id',$customer->cus_city)->first();
          $customer_array[]=array(
              'address'     => $customer->address,
              'hotel_name'     => $customer->hotal_name,
              'postal_code' => $customer->cus_postal_code,
              'hotel_postal_code' => $customer->hotel_postal_code,
              'country'     => $country->country_name,
              'city'        => $city->city_name,
              );
      }
      return response()->json(['code' => 200, 'data'=>$customer_array]); 
    }
    else{
        $cutomer_array=array();
        $customers=Customer::where('hotel_address','LIKE','%'.$request->address.'%')->get();
         if(count($customers)>0){
      foreach($customers as $customer){
            $country=DB::table('countries')->select('country_name')->where('id',$customer->country)->first();
            $city=DB::table('cities')->select('city_name')->where('id',$customer->city)->first();
          $customer_array[]=array(
              'address'     => $customer->hotel_address,
              'hotel_name'     => $customer->hotal_name,
              'postal_code' => $customer->cus_postal_code,
              'hotel_postal_code' => $customer->hotel_postal_code,
              'country'     => $country->country_name,
              'city'        => $city->city_name,
              );
      }
      return response()->json(['code' => 200, 'data'=>$customer_array]); 
    }
    else{
        return response()->json(['code' => 201, 'data'=>'No data Found']);
    }
     
  }
      
  }
   
  
    public function payment_stripe(Request $request){
        
        // Stripe::setApiKey('sk_live_Hrj9hP5NZ0wcLbLeyePpfoTf');
        Stripe::setApiKey('sk_test_TNxzm82yDrtTFfAl55yklT10');
        
        $stripe_token = $request->stripe_token;
        $order_id = $request->order_id;
        
        $order_row = Order::find($order_id);
        $customer_row =  Customer::where('id',$order_row->customer_id)->first();
    
        $customer = StripeCustomer::create(array(
            'email'   => $customer_row->email,
            'source'  => $stripe_token
        ));
        

        $price_km =  PriceKm::find('1');
        $get_tax_percentage = $price_km->tax/100;
        
        
        if($order_row->transaction_id == ""){
            $order_tax = $order_row->total_amount*$get_tax_percentage;
            
            $order_shipping_address = DB::table('order_shiping_adresses')->where('order_id',$order_id)->first();
            if(count($order_shipping_address) > 0){
                $total_amount = $order_row->total_amount+$order_tax+$order_shipping_address->shipping_charges+$order_shipping_address->remote_delivery_charges;
            }
            else{
                $total_amount = $order_row->total_amount+$order_tax;
            }
            
            try{
                $charge = Charge::create(array(
                    'customer' => $customer->id,
                    'amount'   => $total_amount,
                    'currency' => 'jpy'
                ));
            } catch (\Stripe\Error\Card $e) {
                return response()->json(['code' => 201, 'data'=> $e->getMessage()]);
            } catch (\Stripe\Error\InvalidRequest $e) {
                return response()->json(['code' => 201, 'data'=> $e->getMessage()]);
            } catch (\Stripe\Error\Authentication $e) {
                return response()->json(['code' => 201, 'data'=> $e->getMessage()]);
            } catch (\Stripe\Error\ApiConnection $e) {
                return response()->json(['code' => 201, 'data'=> $e->getMessage()]);
            } catch (\Stripe\Error\Base $e) {
                return response()->json(['code' => 201, 'data'=> $e->getMessage()]);
            } catch (Exception $e) {
                return response()->json(['code' => 201, 'data'=> $e->getMessage()]);
            }
            
            if(count($charge) > 0){
                
               $updateStripeTransaction = Order::where('id', $order_id)->update(['transaction_id' => $charge->balance_transaction, 'payment_gateway' => 'stripe', 'payment_status' => 2, 'reservation_status' => 2]);
               
                if($updateStripeTransaction){

                  $customer_email =  $customer_row->email;
                //   $customer_email =  "muhammad.zaid@appcrates.com";
                   
                   $get_order_detail   =  OrderDetail::where('order_id', $order_id)->get();
                   $agents_array = $get_order_detail->pluck('agent_id')->toArray();
                   $uniqe_ar = array_unique($agents_array);
                   $agent_data = User::find($uniqe_ar[0]);
                   $get_duration = DB::table('booked_resources')->where('order_id',$order_id)->first();
                   
                   $cus_msg = "Dear ". $customer_row->name."<br/>";      
                   $cus_msg.= "Your Payment of " .$total_amount. " is received, and your Order#"
                              .$order_id. " is now confirmed.<br/>";
                   $cus_msg.= "Thank you for your service!<br/>AstutoCC<br/><br/>";
                   
                   $cus_msg.= "
                            <html>
                            <head>
                            <title>HTML email</title>
                            </head>
                            <body>
                            <table>
                            <tr>
                            <th width='100px'>ReservationID</th>
                            <th width='30%'>Recource</th>
                            <th width='25%'>Duration</th>
                            <th width='100px'>Status</th>
                            <th width='100px'>Price</th>
                            </tr>";
                            
                            if($order_row->order_status == 2){
                                $order_status = "New";
                            }
                     $cus_msg.= "<tr>
                            <td>".$order_row->id."</td>
                            <td>";
                            foreach($get_order_detail as $order_detail){
                     $cus_msg.= $order_detail->res_name."<br/>";              
                            }
                            
                     $cus_msg.= "</td>
                            <td>".$get_duration->checkin." - ".$get_duration->checkout."</td>
                            <td>".$order_status."</td>
                            <td>".$order_row->total_amount."</td>
                            </tr>
                            <tr>
                            <td></td>
                            <td>Quantity: ".count($get_order_detail)."</td>
                            <td></td>
                            <td></td>
                            <td></td>
                            </tr>
                            ";
                            
                     $cus_msg.= "</table>
                            </body>
                            </html>
                            ";
                   
                   // Always set content-type when sending HTML email
                    $headers = 'MIME-Version: 1.0' . "\r\n";
                    $headers .= 'Content-Type: text/html; charset=ISO-8859-1' . "\r\n";
                    $headers .= "From: hasanikram777@gmail.com"."\r\n";
                    $headers .= 'Reply-To:'.$agent_data->email. "\r\n" ;
                    
                    $cust_subject = "Order Payemnt for Astuto CC";
                    mail($customer_email,$cust_subject,$cus_msg, $headers);

                    return response()->json(['code' => 200, 'data'=>'Payment ('.(int)$total_amount.') is paid successfully.']);
                }
               
                
            }
            else{
                return response()->json(['code' => 201, 'data'=>'Error in payment']);
            }
        }
        else{
            return response()->json(['code' => 201, 'data'=>'Order is already paid.']);
        }
    }
   
}



