<?php

namespace App\Http\Controllers\Admin;

use App\User;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

use App\Resources;
use App\Variation;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use yajra\Datatables\Datatables;
use View;
use DB;

class ResourceController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    { 
        
        return view('admin.resources.index');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $id = Auth::user()->id;
        $currentUser = User::find($id);
        
        $preloaded_data = Resources::get_preloaded_data('create');
        return View('admin.resources.create', compact('preloaded_data', 'currentUser'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
         $validatedAtribute = $request->validate([
            'attr_values' => 'required',
         ]);
         
        $input = $request->all();
        $input = Resources::fileManipulation($input); // file manipulation
        $resource = Resources::create($input);
        Resources::resourceQuantityUidsManipulation($input, $resource); // sync resource quantities
        Resources::resourceAttributesManipulation($input, $resource); // sync resource attributes
        Resources::resourceImagesManipulation($input, $resource); // sync resource slide images
        Session::flash('message', 'Resource has been successfully created. Then Compalsary Set Resource Price');
        // return redirect('/resources');
        return redirect('/setprice/'.$resource->id);
    }

    /**
     * Display the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        // $res_quantity=DB::table('resource_quantity')->where('resource_id',$id)->count();
        // return $res_quantity;
        
        $agentId = Auth::user()->id;
        $currentUser = User::find($agentId);
        $resource = Resources::findOrFail($id);
        $preloaded_data = Resources::get_preloaded_data('edit');
        return View('admin.resources.edit', compact('preloaded_data', 'resource', 'currentUser'))->with('id',$id);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $resource = Resources::findOrFail($id);
        $input = $request->all();
        $input = Resources::fileManipulation($input); // file manipulation
        Resources::resourceQuantityUidsManipulation($input, $resource); // sync resource quantities
        Resources::resourceAttributesManipulation($input, $resource); // sync resource attributes
        Resources::resourceImagesManipulation($input, $resource); // sync resource slide images
        $resource->fill($input)->save();
        DB::table('resources')->where('id',$id)->update(['res_quantity'=>$request->res_quantity]);
        Session::flash('flash_message', 'Resource has been successfully updated.');
        return redirect('/resources');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $resource = Resources::findOrFail($id);
        $resource->delete();
        Session::flash('success', 'Resource has been successfully deleted.');
        return redirect()->back();
    }

    public function datatable(Request $request)
    {
        
        $agentId = Auth::user()->id;
        $currentUser = User::find($agentId);
        $type = $currentUser->type;
        if($type == 1){
            return Datatables::of(Resources::select('resources.id as id', 'res_id', 'res_type', 'res_name', 'res_depot', 'res_agent', 'res_details', 'res_img', 'res_quantity', 'resources.created_at as created_at' , 'created_by' )
                ->orderBy('created_at', 'DESC')
            )
                ->addColumn('check', '<input type="checkbox" class="checkboxes" name="ids[]" value="{{ $id }}" />', 0)
                ->editColumn('created_at', function ($resource) {
                    return date('M j, Y', strtotime($resource->created_at));
                })
                ->editColumn('created_by', function ($resource) {
                    return $resource->created_by;
                })
                ->addColumn('actions', function ($resource) {
                    return View::make('admin.resources.dataTablesActions._resources', ['resource' => $resource])->render();
                })
                ->rawColumns(['check', 'actions'])
                ->make(true);
        }else{
            return Datatables::of(Resources::select('resources.id as id', 'res_id', 'res_type', 'res_name', 'res_depot', 'res_agent', 'res_details', 'res_img', 'res_quantity', 'resources.created_at as created_at' )
                ->orWhere('res_agent' , $agentId)
                ->orderBy('created_at', 'DESC')
                ->get()
            )
                ->addColumn('check', '<input type="checkbox" class="checkboxes" name="ids[]" value="{{ $id }}" />', 0)
                ->editColumn('created_at', function ($resource) {
                    return date('M j, Y', strtotime($resource->created_at));
                })
                ->editColumn('created_by', function ($resource) {
                    return $resource->created_by;
                })
                ->addColumn('actions', function ($resource) {
                    return View::make('admin.resources.dataTablesActions._resources', ['resource' => $resource])->render();
                })
                ->rawColumns(['check', 'actions'])
                ->make(true);
        }

    }

    // public function addQuantity(Request $request)
    // {
    //     // $id=$_GET['id'];
    //     $input = $request->all();
    //     $quantity_uids = '';
    //     $quantity=$input['quantity']-$input['quantitys'];
    //     for ($x = 1; $x <= $quantity; $x++) {
    //         $u_id = Resources::genRandomId();
    //         $call_count = mt_rand(1000000, 9999999);
    //         $quantity_uids .= View::make('admin.resources.partials._quantity', ['u_id' => $u_id, 'call_count' => $call_count, 'count' => $x + $input['quantitys']])->render();
            
            
    //     }
        
    //     return json_encode($quantity_uids);
    // }
    public function addQuantity(Request $request)
    {
        
        $input = $request->all();
        if($input['check']=='create'){
        $quantity_uids = '';
        for ($x = 0; $x < $input['quantity']; $x++) {
            $u_id = Resources::genRandomId();
            $call_count = mt_rand(1000000, 9999999);
            $quantity_uids .= View::make('admin.resources.partials._quantity', ['u_id' => $u_id, 'call_count' => $call_count, 'count' => $x + 1])->render();
        }
        }
        if($input['check']=='edit'){
            // $id=$_GET['id'];
            $quantity_uids = '';
            $quantity=$input['quantity']-$input['quantitys'];
        for ($x = 1; $x <= $quantity; $x++) {
            $u_id = Resources::genRandomId();
            $call_count = mt_rand(1000000, 9999999);
            $quantity_uids .= View::make('admin.resources.partials._quantity', ['u_id' => $u_id, 'call_count' => $call_count, 'count' => $x + $input['quantitys']])->render();
            
        }
        }
        return json_encode($quantity_uids);
    }
    

    public function getAttributes(Request $request)
    {
        $input = $request->all();
        $attribute = Variation::find($input['selected_attribute']);
        if ($attribute && $attribute->values) {
            $values = $attribute->values->pluck('v_value', 'id')->toArray();
            $call_count = mt_rand(1000000, 9999999);
            $attribute_values_view = View::make('admin.resources.partials._attribute', ['values' => $values, 'attribute' => $attribute, 'removeable' => true, 'call_count' => $call_count, 'resources_variations' => null])->render();
            return json_encode($attribute_values_view);
        }
    }
}
