<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;
class Depot extends Model
{
    protected $table = 'depots';
    protected $fillable = ['name', 'lat', 'long', 'agent_id','created_by'];

    // public static function get_records()
    // {

    // 	  return DB::table('depots')
    //         ->join('users', 'depots.agent_id', '=', 'users.id')            
    //         ->select('users.name as agent_name','depots.*') 
    //         ->where('depots.status','1')
    //         ->get();
    // }

    public static function get_records()
    {

          return DB::table('depots')           
            ->select('depots.*')
            ->where('depots.status','1')
            ->get();
    }

    public static function get_agent_records($id)
    {

        return DB::table('depots as d')
            ->join('depot_with_agents as da', 'da.depot_id', '=', 'd.id')
            ->join('users', 'da.agent_id', '=', 'users.id')  
            ->select('users.name','d.*') 
            ->where('d.status','1')
            ->where('da.agent_id',$id)
            ->get();

        // return DB::table('depot_with_agents as da')
        //     ->join('users', 'da.agent_id', '=', 'users.id')           
        //     ->select('users.name') 
        //     ->where('da.agent_id',$id)
        //     ->get();
    }
}
