<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;
use DateTime;

class CrownCart extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'cart:deleted';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Delete Cart Rows ';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
    
      $date = new DateTime();
      $date->modify('-1 hours');
      $formatted_date = $date->format('Y-m-d H:i:s');
      DB::table('carts')->where('created_at', '<',$formatted_date)->delete();
      $this->info('Cart data is Deleted Previous Hours!');

    }
}
