<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Order;
use App\Customer;
use App\BookedResources;
use DateTime;

class CancelOrder extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'order:cancel';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Order Cancel For Due To Payment';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {

      $date = new DateTime();
      $date->modify('-1 hours');
      $formatted_date = $date->format('Y-m-d H:i:s');



     $getorder = Order::where(
      [['created_at', '<', $formatted_date],['payment_status', '=', 1]]
     )->get();

     $count =  count($getorder); 

      if($count > 0){

        for($i=0;$i<$count;$i++){

         $order_id = $getorder[$i]->id;
         $order_status = $getorder[$i]->order_status;
         $customer_id = $getorder[$i]->customer_id;

         BookedResources::where('order_id',$order_id)->delete();

         $data = array(
          'order_status'   => 4,
          'payment_status' => 3
         );
         Order::where('id', $order_id)->update($data);


          // **************** MAIL CODE **********************

         $cus_data = Customer::where('id', $customer_id)->first();
          
         $to = $cus_data->email; 
         $subject = "Cancellation Email to send to Customer ";

         $message = "
          <html>
          <head>
          <title>HTML email</title>
          <link rel=stylesheet href=https://maxcdn.bootstrapcdn.com/bootstrap/4.3.1/css/bootstrap.min.css>
          </head>
          <body>
          <h3>Your Order is  Cancelled!</h3>
          
          <p>Dear <strong>".$cus_data->name.",</strong></p>
          <p>Your reservation no <strong>".$order_id ."</strong> has been cancelled due to Payment. If you wish to make another reservation, please repeat the selection and reservation process with a payment.

          If you have any questions or need assistance in your reservation, do not hesitate to contact us at <agent email>

          Thank you for visiting AstutoCC</p>
                  </body>
                  </html>
                  ";

          // Always set content-type when sending HTML email
          $headers = "MIME-Version: 1.0" . "\r\n";
          $headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";

          // More headers
          $headers .= 'From: muhammad.zaid@appcrates.com' . "\r\n";
          $headers .= 'Cc: rana.mehmood@appcrates.com' . "\r\n";

           mail($to, $subject, $message, $headers);
        }

         $this->info('Cancel Reservation Successfully Due To Payment!');


      }else{

        $this->info('No Reservation Exist without Payment!');

      }

    }
}
