<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;
class Common extends Model
{
     public static function price_insert_data($data_array,$table_name)
    {
        return DB::table($table_name)->insertGetId($data_array);
    }



    public static function insert_data($data_array,$table_name)
    {
        return DB::table($table_name)->insertGetId($data_array);
       // return DB::table($table_name)->insert($data_array);
    }


    public static function countries(){

        return DB::table('countries')->SELECT('*')->orderBy('country_name', 'ASC')->get();

    }

    public static function getvalue($id){
    
    return DB::table('resources')
         ->join('resource_types', 'resources.res_type', '=', 'resource_types.id')
         ->SELECT ('resources.res_id','resources.res_name','resources.res_details',
                   'resources.res_img','resources.created_by','resource_types.type_id',
                   'resource_types.name','resource_types.description')
         ->where('resources.id', '=', $id)
         ->first();
        
    }
     
    public static function getvalueimage($id){
               return DB::TABLE('resource_images')
                    ->SELECT('image')
                    ->WHERE('resource_images.resource_id','=', $id)
                    ->get();
    }

    public static function resource_variation($id){

 return DB::Table('variation_values')
->join('resource_variation', 'resource_variation.var_value_id','=','variation_values.id')
       ->join('variation','variation.id', '=', 'variation_values.variation_id'  )
       ->SELECT('variation_values.id as Variation Value Id','variation_values.v_value',
        'variation.id as Variation Id','variation.name')
       ->WHERE('resource_variation.res_id', '=', $id)
       ->get();



    }
     


    // public static function get_depots($lat,$long)
    // {
    // 	return DB::select('SELECT id,name,(6371 * acos(cos( radians( '.$lat.' ) ) * cos( radians( `lat` ) ) * cos(radians( `long` ) - radians( '.$long.' )) + sin(radians('.$lat.')) * sin(radians(`lat`)))) `distance`,lat,`long`,total_bicycle,depo_image 
    //         from depots where status=1  having distance < 200 ');
    // }
    
     public static function get_depots($lat,$long)
    {
    	return DB::select('SELECT id,name,(6371 * acos(cos( radians( '.$lat.' ) ) * cos( radians( `lat` ) ) * cos(radians( `long` ) - radians( '.$long.' )) + sin(radians('.$lat.')) * sin(radians(`lat`)))) `distance`,lat,`long`,depo_image 
            from depots where status=1  having distance < 200 ');
    }

    public static function search_data($select,$where,$table)
    {
      return DB::table($table)->select($select)->WhereRaw($where)->get();
    }


    public static function get_additResource($id){
    return DB::table('additional_resources as addres')
         ->SELECT ('addres.id','addres.add_res_id','addres.add_res_name','addres.add_res_description',
          'addres.add_res_image','addres.quatity_selectable','addres.notes_req')
         ->where('addres.depot_id', '=', $id)
         ->get();  


    }

    public static function get_addit_pricing($addpricing){
               return DB::TABLE('additional_res_pricings')
                    ->SELECT('type','rate')
                    ->WHERE('add_res_id','=', $addpricing)
                    ->first();
    }



      public static function get_pricing($pricingdata){
               return DB::TABLE('resource_prices')
                    ->SELECT('id','type','basic_rate')
                    ->WHERE('resource_id','=', $pricingdata)
                    ->get();
    }


      public static function rules_prize($add_rules){
               return DB::TABLE('resource_price_rules')
                    ->SELECT('id','limit','price')
                    ->WHERE('resource_price_id','=', $add_rules)
                    ->orderBy('limit', 'ASC')
                    ->get();
    }



    // public static function reso_quantity_UID($where){
    //    return DB::Table('resources1 as res')
    //    ->join('resource_quantities as resqty','resqty.resource_id', '=', 'res.id')
    //    ->join('resource_types as restyp','restyp.id', '=', 'res.res_type')
    //    ->SELECT('res.id','res.res_name','res.res_details','res.res_img',
    //      'restyp.id as ID','restyp.type_id','restyp.name as type_name',
    //     'resqty.id as uidID','resqty.uid')
    //    ->groupBy('resqty.resource_id')
    //    ->WhereRaw($where)
    //    ->get();

        
    // }

    public static function cartdata($device_id){
       return DB::TABLE('carts')
                    ->SELECT('id','device_id','res_id','agent_id','res_name','depot_id','depot_name','res_qty_id','uid','price','date_check_in','date_check_out')
                    ->WHERE('carts.device_id','=', $device_id)
                    ->get();
    }


    public static function city($country_id){
            return DB::table('cities')->SELECT('id','city_name')->where('country_id','=',$country_id)->     orderBy('city_name', 'ASC')
                    ->get();

              }


      public static function newpassword($id,$data_array,$table_name)
    {
        return DB::table($table_name)->where('id', $id)->update($data_array);
    }





}
