<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;


class AdditionalResource extends Model
{
    public function variations()
    {
        return $this->hasMany(AttitionalResourceVariation::class, 'add_res_id', 'id');
    }


       public static function get_preloaded_data($source){
    	$data = [];
         if($source == 'create'){
             $data['add_res_id'] = AdditionalResource::genRandomId();    
        }
             $data['depots'] = DB::table('depots')->get();
    	     $data['variations'] = DB::table('variation')->WhereRaw('status=1 AND (assosiate_with=2 OR assosiate_with=3)')->get();
    	     $data['resource_types'] = DB::table('resource_types')->get();
    	     $data['resource_types'] = DB::table('resource_types')->get();
    	     $data['resources'] = DB::table('resources')->get();
    	     $data['variation_values'] = DB::table('variation_values')->get();
        return $data;
    }



        public static function genRandomId()
    {
      $existed_random_ids = AdditionalResource::select('add_res_id')->where('add_res_id','<>','')->pluck('add_res_id')->toArray();
      return AdditionalResource::genRandomIdString($existed_random_ids);
    }

    public static function genRandomIdString($existed_random_ids)
    {
      $idStr = str_pad(mt_rand(000000000, 999999999), 5, "0", STR_PAD_LEFT);
      if(in_array($idStr, $existed_random_ids))
      {
        return AdditionalResource::genRandomIdString($existed_random_ids);
      }else{
        return $idStr;
      }
    }

}
