<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\FirebaseController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});


Route::get('/getAccessToken', [FirebaseController::class, 'getAccessToken']);
Route::get('/sendMobPushNotification', [FirebaseController::class, 'sendMobPushNotification']);

Route::get('/users', [FirebaseController::class, 'index']);
Route::post('/users/create', [FirebaseController::class, 'create']);
Route::get('/users/show/{id}', [FirebaseController::class, 'show']);
Route::post('/users/update/{id}', [FirebaseController::class, 'update']);
Route::get('/users/delete/{id}', [FirebaseController::class, 'delete']);
