<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Kreait\Firebase\Factory;
use Firebase\JWT\JWT;
use Illuminate\Support\Facades\Http;



class FirebaseController extends Controller
{
    protected $database;

    public function __construct()
    {
        // Initialize Firebase
        $firebase = (new Factory)
            ->withServiceAccount(base_path(env('FIREBASE_CREDENTIALS')))
            ->withDatabaseUri(env('FIREBASE_DATABASE_URL'));

        $this->database = $firebase->createDatabase();
    }

    // Read Data
    public function index()
    {
        $reference = $this->database->getReference('users');
        $data = $reference->getValue();

        return response()->json($data);
    }

    // Create Data
    public function create(Request $request)
    {
        $data = [
            'name' => $request->input('name'),
            'email' => $request->input('email'),
        ];

        $this->database->getReference('users')->push($data);

        return response()->json(['message' => 'Data created successfully']);
    }

    // Show Data
    public function show($id)
    {
        $data = $this->database->getReference('users/' . $id)->getValue();

        return response()->json($data);
    }

    // Update Data
    public function update(Request $request, $id)
    {
        $data = [
            'name' => $request->input('name'),
            'email' => $request->input('email'),
        ];

        $this->database->getReference('users/' . $id)->update($data);

        return response()->json(['message' => 'Data updated successfully']);
    }

    // Delete Data
    public function delete($id)
    {
        $this->database->getReference('users/' . $id)->remove();

        return response()->json(['message' => 'Data deleted successfully']);
    }


    public function getAccessToken()
    {
        $privateKey = "-----BEGIN PRIVATE KEY-----\nMIIEvQIBADANBgkqhkiG9w0BAQEFAASCBKcwggSjAgEAAoIBAQDZNZf6b+6Sh9Hi\nxPm6EpxR8Gw0bGivPYrGjhpgF4jSZspfTKIhTQ2ycQECrCC4xewKXd0KnhNJ/RBn\ni0/1CnL4lbASYBWZ2iCmjnX08mTU69V2SiU+VSK2FUWvvflR4HLgiM4d+Mc2dOAA\nDsnWa900WDMCGobzt8HGaEN2PW0xA+63z04IrcsikQ2BS+I8rM+eRkF7w4E4cimu\nrg++j5BG58bIBTSa7chlZQsRJkpas7UJUwsUIArUFsMGSmL32lMXFo5CneHFoDGF\n8f9mXDOfFaZxgxSaxkJU7dJSGmY2V6rKuq4j5laV0Kr5ib1p7SJTEv0C377JsfM0\ncXMP+ovNAgMBAAECggEANfakrWmFog3wTSCW0m2xPII4v8V3NKJbifzf/KOcMHmt\nKYQGe7ODBaQhliJhdsZlYCX1tp+TNzySCMeJs91Gtw+pUMdiVnjkx7x4/cQC3QtC\nW0MMgbHxD7+1MnZGLNtQbwxN+RBHnfXneNwztPvTVx/afFlO0doDYGGi8QtNx3E3\nXENTXLS5iWlUvxCJKwwlJJzMckhASd0LKEnuAojX4iNLLxJ/hZLqs5RnoL2dSNzl\nUA2lTt6fC0KfjnxpqhRDq3APTCF5j1sO0o8duTTng70bBF4lbXKkH2J0HwOMi31Y\nnTH9eXOXNZo3JNzU0XpMB7fhyF2P380HTY9z6lqvQQKBgQDgkO0T43SwySiRwUBz\nnGnkhDtmleT0yEnoFRZdZbNvztUPKryjB2FdnhEPkWkQJI2l1H+DMM0FEw3XOSx2\n+L6sJOq+rCtEMHcgOpuhnWl2PR6mkE9bh89TYUPbAntewf3ZwRYYuqt3gxsI9+ZI\nQbCkwTgskrv6cCmD2B6b3jY95QKBgQD3nQvN6Jgg0y8Xpu5HOySB30141UFHgdcc\nMKQU5A6PLJWzFJf9x7XLn7Bh7mijS7e2o+CvaD8mbZVALypPIyVfcWesDQyMJg2E\nrMHf/y6qAIExGcEzX4CkJFU6PGm8SGQxKKud8Q8WpoN/HbhPq0DWd3keu+8vlv7H\njofVwDz3yQKBgAyfmPQZQSH+7MzktB7LmBhEZqJpoqkv6Remt88gPGn4knl7yYbQ\nj2SX0hWx8tn5dAzyWQii4aN7YrfKevllGjLLEHcPbo8yuj+Ri9YV5yvCW8q5KfzX\nMYxaV1okVZMKDJ8E/5z8QU9Ci26BoOxG5Qsd4W6AARke3PaQW4gfgaURAoGAFeUS\nHSP7B7QEzv+YxD2rjbxUGmIpAoytm7WFXL+JtglIN2yTwAH/xkCZlR9Cq2XPmdvF\ny1zZcKlx8Bn7kMHX1Seu9hy1RlM7EMdB4W+sDaY7xj6zwbopItp/msWqx9ZS3bHt\n8upU3jjdGclj+c93zT8FO718eeXNI5Ir2q/D9FkCgYEAucQFunlEB7ZQcbtKiG5x\nuYtMw1PiMYLRmDn3wFK95KiIAJVy9hTNKhdk7WpVnWnYljVoyzqKH9CgdJ/QFmeV\n+DSsHAhTZQ5gHah6czv0mFfzuiw0rsNkC0fUuckusmPZTUlBjROlTf47ckeuxFpo\n4aGheEznt07suswW82tGmII=\n-----END PRIVATE KEY-----\n";
        $client_email = "firebase-adminsdk-w9t5i@pocket-cellar-41a23.iam.gserviceaccount.com";
        $token_uri = "https://oauth2.googleapis.com/token";

        $token = [
            'iss' => $client_email,
            'scope' => 'https://www.googleapis.com/auth/firebase.messaging',
            'aud' => $token_uri,
            //Token to be expired after 1 hour
            'exp' => time() + (60 * 60),
            'iat' => time()
        ];

        $jwt =  JWT::encode($token, $privateKey, 'RS256');

        $response = Http::post($token_uri, [
            'grant_type' => 'urn:ietf:params:oauth:grant-type:jwt-bearer',
            'assertion' => $jwt
        ]);

        $jsonObj = $response->json();

        return $jsonObj['access_token'];
    }


    // public function sendMobPushNotification($deviceToken, $title, $body)
    public function sendMobPushNotification()
    {
        $deviceToken = "c8DLrqtDSY2qOS1aUP3QmM:APA91bFX5bRs_Z6eNlEVZ-Fgsux9SeNH91oLDT-wAIl0EzGmBPaXFMVbp-uzAV6pjO4iqDHDjs-cbd-gvRl3BYu1FBEmPzyCnJgjWeDdOlgspnrZD-J1uxOuJZHEzDWCtgCRLwS7A4kY";
        $title = "bilal";
        $body = "testing";

        $serverKey = env('FIREBASE_SERVER_KEY');
        $accessToken = $this->getAccessToken();

        $url = 'https://fcm.googleapis.com/v1/projects/pocket-cellar-41a23/messages:send';

        $dataPayload = [
            'screen_name' => 'notification',
        ];

        $payload = [
            'message' => [
                'token' => $deviceToken,
                'data' => [
                    'body' => $body,
                    'title' => $title,
                    'dataPayload' => json_encode($dataPayload),
                ],
            ],
        ];

        $response = Http::withHeaders([
            // 'Authorization' => 'key=' . $serverKey,
            'Authorization' => 'Bearer ' . $accessToken,
            'Content-Type' => 'application/json',
        ])->post($url, $payload);

        return $response;
        if ($response->successful()) {
            return $response;
        } else {
            return false;
        }
    }
}
