<aside class="main-sidebar sidebar-dark-primary elevation-4">
    <a href="<?php echo e(route('home')); ?>" class="brand-link">
        <img src="<?php echo e(asset('assets/dist/img/AdminLTELogo.png')); ?>" alt="AdminLTE Logo"
            class="brand-image img-circle elevation-3" style="opacity: .8">
        <span class="brand-text font-weight-light">AdminLTE 3</span>
    </a>
    
    <div class="sidebar">
        <div class="user-panel mt-3 pb-3 mb-3 d-flex">
            <div class="image">
                <?php if($avatar): ?>
                    <img src="<?php echo e(asset('storage/' . $avatar)); ?>" style="height: 35px; width: 35px"
                        class="img-circle elevation-2" alt="User Image">
                <?php else: ?>
                    <img src="<?php echo e(getGravatar(Auth::user()->email)); ?>" class="img-circle elevation-2" alt="User Image">
                <?php endif; ?>
            </div>

            <div class="info">
                <a href="#" class="d-block">Alexander Pierce</a>
            </div>
        </div>
        <div class="form-inline mt-2">
            <div class="input-group" data-widget="sidebar-search">
                <input class="form-control form-control-sidebar" type="search" placeholder="Search"
                    aria-label="Search">
                <div class="input-group-append">
                    <button class="btn btn-sidebar"><i class="fas fa-search fa-fw"></i></button>
                </div>
            </div>
        </div>
        <?php if(auth()->user()->type == 'bss'): ?>
            <nav class="mt-2">
                <ul class="nav nav-pills nav-sidebar flex-column" data-widget="treeview" role="menu"
                    data-accordion="false">
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view_dashboard')): ?>
                        <li class="nav-item" data-toggle="tooltip" title="Dashboard">
                            <a href="<?php echo e(route('home')); ?>" class="nav-link <?php if(request()->routeIs('home')): ?> active <?php endif; ?>">
                                <i class="nav-icon fas fa-tachometer-alt"></i>
                                <p>Dashboard</p>
                            </a>
                        </li>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('manage_bss_settings')): ?>
                        <li class="nav-item" data-toggle="tooltip" title="Teachers">
                            <a href="<?php echo e(route('bss.teachers.index')); ?>"
                                class="nav-link <?php if(request()->routeIs('bss.teacher*')): ?> active <?php endif; ?>">
                                <i class="nav-icon fas fa-chalkboard-teacher"></i>
                                <p>Teachers</p>
                            </a>
                        </li>
                        <li class="nav-item" data-toggle="tooltip" title="Students">
                            <a href="<?php echo e(route('bss.students.index')); ?>"
                                class="nav-link <?php if(request()->routeIs('bss.students*')): ?> active <?php endif; ?>">
                                <i class="nav-icon fas fa-graduation-cap"></i>

                                <p>Students</p>
                            </a>
                        </li>
                        <li class="nav-item" data-toggle="tooltip" title="Shared Files With Office">
                            <a href="<?php echo e(route('bss.shared.files')); ?>"
                                class="nav-link <?php if(request()->routeIs('bss.shared.files*')): ?> active <?php endif; ?>">
                                <i class="nav-icon fas fa-file"></i>
                                <p>Share Files With Office</p>
                            </a>
                        </li>
                    <?php endif; ?>
                    <li class="nav-item" data-toggle="tooltip" title="Logout Now">
                        <a href="<?php echo e(route('logout')); ?>"
                            onclick="event.preventDefault(); document.getElementsByClassName('logout-form')[0].submit();"
                            class="nav-link">
                            <i class="nav-icon fas fa-sign-out-alt"></i>
                            <p>Logout Now</p>
                        </a>
                    </li>
                </ul>
            </nav>
        <?php else: ?>
            <nav class="mt-2">
                <ul class="nav nav-pills nav-sidebar flex-column" data-widget="treeview" role="menu"
                    data-accordion="false">
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view_dashboard')): ?>
                        <li class="nav-item" data-toggle="tooltip" title="Dashboard">
                            <a href="<?php echo e(route('home')); ?>" class="nav-link <?php if(request()->routeIs('home')): ?> active <?php endif; ?>">
                                <i class="nav-icon fas fa-tachometer-alt"></i>
                                <p>Dashboard</p>
                            </a>
                        </li>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['view_registrations', 'add_registrations', 'edit_registrations', 'delete_registrations'])): ?>
                        <li class="nav-item" data-toggle="tooltip" title="Registration">
                            <a href="<?php echo e(route('registrations.index')); ?>"
                                class="nav-link <?php if(request()->routeIs('registrations*')): ?> active <?php endif; ?>">
                                <i class="nav-icon fas fa-registered"></i>
                                <p>Registrations</p>
                            </a>
                        </li>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['view_pdc_registration', 'add_pdc_registration', 'edit_pdc_registration',
                        'delete_pdc_registration'])): ?>
                        <li class="nav-item" data-toggle="tooltip" title="Personality Development Course Registrations">
                            <a href="<?php echo e(route('pdcr.index')); ?>"
                                class="nav-link <?php if(request()->routeIs('pdcr*')): ?> active <?php endif; ?>">
                                <i class="nav-icon fas fa-graduation-cap"></i>
                                <p>PDC Registrations
                                </p>
                            </a>
                        </li>
                    <?php endif; ?>

                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['roles_and_permissions', 'manage_general_settings'])): ?>
                        <li
                            class="nav-item <?php echo e(Request::routeIs('settings.generalsettings') || Request::routeIs('setting.roles') ? 'menu-is-opening menu-open' : ''); ?>">
                            <a href="#" class="nav-link">
                                <i class="nav-icon fas fa-cog"></i>
                                <p>
                                    Settings
                                    <i class="right fas fa-angle-left"></i>
                                </p>
                            </a>
                            <ul class="nav nav-treeview"
                                style="display: <?php echo e(Request::routeIs('settings.generalsettings') || Request::routeIs('setting.roles') ? 'block' : 'none'); ?>;">
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('manage_general_settings')): ?>
                                    <li class="nav-item" data-toggle="tooltip" title="General Settings">
                                        <a href="<?php echo e(route('settings.generalsettings')); ?>"
                                            class="nav-link <?php echo e(Request::routeIs('settings.generalsettings') ? 'active' : ''); ?>">
                                            <i class="far fa-circle nav-icon"></i>
                                            <p>General Settings</p>
                                        </a>
                                    </li>
                                <?php endif; ?>
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('roles_and_permissions')): ?>
                                    <li class="nav-item" data-toggle="tooltip" title="Roles">
                                        <a href="<?php echo e(route('setting.roles')); ?>"
                                            class="nav-link <?php echo e(Request::routeIs('setting.roles') ? 'active' : ''); ?>">
                                            <i class="far fa-circle nav-icon"></i>
                                            <p>Roles</p>
                                        </a>
                                    </li>
                                <?php endif; ?>
                            </ul>
                        </li>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['view_users', 'add_users', 'edit_users', 'delete_users'])): ?>
                        <li class="nav-item" data-toggle="tooltip" title="Manage Users">
                            <a href="<?php echo e(route('users.index')); ?>"
                                class="nav-link <?php if(request()->routeIs('users*')): ?> active <?php endif; ?>">
                                <i class="nav-icon fas fa-users"></i>
                                <p>Users
                                </p>
                            </a>
                        </li>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['view_bss', 'add_bss', 'edit_bss', 'delete_bss', 'view_bss_teachers', 'edit_bss_teachers',
                        'delete_bss_teachers', 'view_bss_teacher_attendences', 'bss_teachers_attendence_report',
                        'add_bss_teacher_attendence', 'view_bss_students', 'edit_bss_students', 'delete_bss_students',
                        'view_bss_student_attendences', 'bss_students_attendence_report', 'add_bss_student_attendence'])): ?>
                        <li class="nav-item" data-toggle="tooltip" title="Bal Sewa Samaj (BSS)">
                            <a href="<?php echo e(route('bss')); ?>"
                                class="nav-link <?php echo e(request()->routeIs('bss') || request()->routeIs('bss.*') ? 'active' : ''); ?>">
                                <i class="nav-icon fas fa-users"></i>
                                <p>Manage BSS <i class="right fas fa-angle-left"></i></p>
                            </a>
                            <ul class="nav nav-treeview"
                                style="display: <?php echo e(request()->routeIs('bss.*') || request()->routeIs('bss') ? 'block' : 'none'); ?>;">
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view_bss')): ?>
                                    <li class="nav-item">
                                        <a href="<?php echo e(route('bss')); ?>"
                                            class="nav-link <?php echo e(request()->routeIs('bss') ? 'active' : ''); ?>">
                                            <i class="far fa-circle nav-icon"></i>
                                            <p>Manage BSS</p>
                                        </a>
                                    </li>
                                <?php endif; ?>
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view_bss_teachers')): ?>
                                    <li class="nav-item">
                                        <a href="<?php echo e(route('bss.teachers.index')); ?>"
                                            class="nav-link <?php echo e(request()->routeIs('bss.teachers.*') ? 'active' : ''); ?>">
                                            <i class="far fa-circle nav-icon"></i>
                                            <p>BSS Teachers</p>
                                        </a>
                                    </li>
                                <?php endif; ?>
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view_bss_students')): ?>
                                    <li class="nav-item">
                                        <a href="<?php echo e(route('bss.students.index')); ?>"
                                            class="nav-link <?php echo e(request()->routeIs('bss.students.*') ? 'active' : ''); ?>">
                                            <i class="far fa-circle nav-icon"></i>
                                            <p>BSS Students</p>
                                        </a>
                                    </li>
                                <?php endif; ?>
                            </ul>
                        </li>
                    <?php endif; ?>

                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['view_files', 'delete_files'])): ?>
                        <li class="nav-item" data-toggle="tooltip" title="Shared Files With Office">
                            <a href="<?php echo e(route('shared.files.index')); ?>"
                                class="nav-link <?php if(request()->routeIs('shared.files.index*')): ?> active <?php endif; ?>">
                                <i class="nav-icon fas fa-file"></i>
                                <p>Shared Files With Office</p>
                            </a>
                        </li>
                    <?php endif; ?>
                    <li class="nav-item" data-toggle="tooltip" title="Logout Now">
                        <a href="<?php echo e(route('logout')); ?>"
                            onclick="event.preventDefault(); document.getElementsByClassName('logout-form')[0].submit();"
                            class="nav-link">
                            <i class="nav-icon fas fa-sign-out-alt"></i>
                            <p>Logout Now</p>
                        </a>
                    </li>
                </ul>
            </nav>
        <?php endif; ?>
    </div>
</aside>
<?php /**PATH C:\laragon\www\ngo_app_sj\resources\views/partials/sidebar.blade.php ENDPATH**/ ?>