<?php $__env->startSection('page_title', 'Dashboard'); ?>
<?php $__env->startSection('content'); ?>
    <!-- Main content -->
    <section class="content">
        <div class="container-fluid">
            <?php if(auth()->user()->type == 'bss'): ?>
                <div class="col-lg-3 col-6">
                    <!-- small box -->
                    <div class="small-box bg-danger">
                        <div class="inner">
                            <h4><?php echo e($bsscount ?? 'N/A'); ?></h4>
                            <p>Total BSS Registered</p>
                        </div>
                        <div class="icon">
                            <i class="ion ion-pie-graph"></i>
                        </div>
                        <a href="#" class="small-box-footer">More info <i class="fas fa-arrow-circle-right"></i></a>
                    </div>
                </div>
            <?php else: ?>
                <!-- Small boxes (Stat box) -->
                <div class="row">
                    <div class="col-lg-3 col-6">
                        <!-- small box -->
                        <div class="small-box bg-info">
                            <div class="inner">
                                <h4><?php echo e($usercount); ?></h4>

                                <p>Total Members</p>
                            </div>
                            <div class="icon">
                                <i class="ion ion-bag"></i>
                            </div>
                            <a href="#" class="small-box-footer">More info <i
                                    class="fas fa-arrow-circle-right"></i></a>
                        </div>
                    </div>
                    <!-- ./col -->
                    <div class="col-lg-3 col-6">
                        <!-- small box -->
                        <div class="small-box bg-success">
                            <div class="inner">
                                <h4><?php echo e($userlast->name ?? 'N/A'); ?></h4>

                                <p>New Registered Member</p>
                            </div>
                            <div class="icon">
                                <i class="ion ion-stats-bars"></i>
                            </div>
                            <a href="#" class="small-box-footer">More info <i
                                    class="fas fa-arrow-circle-right"></i></a>
                        </div>
                    </div>
                    <!-- ./col -->
                    <div class="col-lg-3 col-6">
                        <!-- small box -->
                        <div class="small-box bg-warning">
                            <div class="inner">
                                <h4><?php echo e($pdccount); ?></h4>

                                <p>Total PDC Member</p>
                            </div>
                            <div class="icon">
                                <i class="ion ion-person-add"></i>
                            </div>
                            <a href="#" class="small-box-footer">More info <i
                                    class="fas fa-arrow-circle-right"></i></a>
                        </div>
                    </div>
                    <!-- ./col -->
                    <div class="col-lg-3 col-6">
                        <!-- small box -->
                        <div class="small-box bg-danger">
                            <div class="inner">
                                <h4><?php echo e($pdclast->name ?? 'N/A'); ?></h4>
                                <p>New PDC Added Member</p>
                            </div>
                            <div class="icon">
                                <i class="ion ion-pie-graph"></i>
                            </div>
                            <a href="#" class="small-box-footer">More info <i
                                    class="fas fa-arrow-circle-right"></i></a>
                        </div>
                    </div>

                    <div class="col-lg-12">
                        <div class="card">
                            <div class="card-header d-flex align-items-center">
                                <div class="col-md-3">
                                    <h3 class="card-title">Recent PDC Registration</h3>
                                </div>
                                <div class="col-md-9 text-right">
                                    <form action="<?php echo e(route('home')); ?>" method="GET">
                                        <div class="row">
                                            <div class="col-md-4">
                                                <input type="date" id="fromDate" name="fromDate" class="form-control"
                                                    placeholder="From Date" value="<?php echo e(request('fromDate')); ?>">
                                            </div>
                                            <div class="col-md-4">
                                                <input type="date" id="toDate" value="<?php echo e(request('toDate')); ?>"
                                                    name="toDate" class="form-control" placeholder="To Date">
                                            </div>
                                            <div class="col-md-4">
                                                <button type="submit" id="searchBtn"
                                                    class="btn btn-primary btn-sm">Search</button>
                                                <a href="<?php echo e(route('home')); ?>" class="btn btn-secondary btn-sm">Cancel</a>
                                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('export_pdc_dashboard')): ?>
                                                    <a href="<?php echo e(route('exportCSV', ['fromDate' => request('fromDate'), 'toDate' => request('toDate')])); ?>"
                                                        class="btn btn-info btn-sm" id="exportcsv">Export CSV</a>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                            <div class="card-body">
                                <table id="pdcTable" class="table table-bordered table-striped">
                                    <thead>
                                        <tr>
                                            <th>Registration</th>
                                            <th>Name</th>
                                            <th>Email</th>
                                            <th>Phone No</th>
                                            <th>Added By</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__currentLoopData = $pdcregistration; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pdcreg): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td><?php echo e($pdcreg->reg_no); ?></td>
                                                <td><?php echo e($pdcreg->name); ?></td>
                                                <td><?php echo e($pdcreg->email); ?></td>
                                                <td><?php echo e($pdcreg->mobile_number); ?></td>
                                                <td><?php echo e($pdcreg->added_by); ?></td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>

                    <!-- DataTables Script -->


                    <!-- /.row -->

                </div><!-- /.container-fluid -->
            <?php endif; ?>
    </section>
    <!-- /.content -->
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <script>
        $(document).ready(function() {
            // Initialize DataTable with export buttons
            var table = $('#pdcTable').DataTable({
                dom: 'Bfrtip',
                buttons: [{
                    extend: 'csvHtml5',
                    text: 'Export CSV',
                    title: 'PDC_Registration_Data'
                }]
            });
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\ngo_app_sj\resources\views/dashboard.blade.php ENDPATH**/ ?>