<?php $__env->startSection('page_title', 'Attendance Report'); ?>

<?php $__env->startSection('content'); ?>
    <div class="container">
        <div class="card shadow-sm">
            <div class="card-header d-flex align-items-center">
                <div class="col-md-3">
                    <h3 class="card-title mr-auto">Student Attendance Report</h3>
                </div>
                <div class="col-md-6">
                    <!-- Date filter form -->
                    <div class="d-flex gap-3">
                        <form action="" method="GET" class="d-flex">
                            <div class="input-group input-group-sm mr-2">
                                <input type="date" name="date_from" value="<?php echo e(request('date_from')); ?>"
                                    class="form-control" />
                                <input type="date" name="date_to" value="<?php echo e(request('date_to')); ?>"
                                    class="form-control" />
                                <select name="search" class="form-control">
                                    <option value="">Select Status</option>
                                    <option value="absent" <?php echo e(request('search') == 'absent' ? 'selected' : ''); ?>>Absent
                                    </option>
                                    <option value="present" <?php echo e(request('search') == 'present' ? 'selected' : ''); ?>>Present
                                    </option>
                                    <option value="busy" <?php echo e(request('search') == 'busy' ? 'selected' : ''); ?>>Busy</option>
                                </select>
                            </div>
                            <button type="submit" class="btn btn-primary btn-sm">Filter</button>
                        </form>
                    </div>
                </div>

                <div class="col-md-3">
                    <div class="d-flex justify-content-end gap-1">
                        <button type="button" class="btn btn-primary btn-sm"
                            onclick="document.getElementById('export_CSV_FORM').submit();">Export CSV</button>
                        <a href="<?php echo e(route('bss.students.index')); ?>" class="btn btn-warning btn-sm ml-1">Go Back</a>
                    </div>
                </div>
            </div>
            <form action="<?php echo e(route('bss.all.students.report.exportCSV')); ?>" id="export_CSV_FORM" style="display: none">
                <div class="input-group input-group-sm mr-2">
                    <input type="date" name="date_from" value="<?php echo e(request('date_from')); ?>" class="form-control" />
                    <input type="date" name="date_to" value="<?php echo e(request('date_to')); ?>" class="form-control" />
                    <input type="text" name="search" placeholder="Search Attendance Status"
                        value="<?php echo e(request('search')); ?>" class="form-control" />
                </div>
            </form>

            <form action="<?php echo e(route('bss.students.attendence.store')); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <div class="card-body">
                    <div >
                        <h6><span>Records Found:</span><?php echo e($attendances->total()); ?></h6>
                    </div>
                    <div class="table-responsive">
                        <table class="table table-bordered">
                            <thead>
                                <tr>
                                    <th>Teacher Name</th>
                                    <th>Attendance Status</th>
                                    <th>Review</th>
                                    <th>Date</th>
                                    <th>Day</th>
                                </tr>
                            </thead>
                            <tbody>
                                
                                <?php $__empty_1 = true; $__currentLoopData = $attendances; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $attendance): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td><?php echo e($attendance->student->name); ?></td>
                                        <td>
                                            <?php if($attendance->attendance_status): ?>
                                                <?php echo e(ucfirst($attendance->attendance_status)); ?>

                                            <?php else: ?>
                                                <span class="text-muted">No Status</span>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <?php echo e($attendance->review ?? 'No review provided'); ?>

                                        </td>
                                        <td><?php echo e($attendance->created_at->format('Y-m-d')); ?></td>
                                        <td><?php echo e($attendance->created_at->format('l')); ?></td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td colspan="5" class="text-center">No records found</td>
                                    </tr>
                                    
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </form>

            <!-- Pagination Links -->
            <div class="card-footer">
                <div class="d-flex justify-content-between">
                    <div></div>
                    <div>
                        <?php echo e($attendances->appends($_GET)->links()); ?>

                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\ngo_app_sj\resources\views/admin/bss/student/attendence/all_student_report.blade.php ENDPATH**/ ?>