<?php $__env->startSection('page_title', 'Teacher Attendance'); ?>

<?php $__env->startSection('content'); ?>
    <div class="container">
        <div class="card shadow-sm">
            <div class="card-header d-flex align-items-center">
                <h3 class="card-title mr-auto">Teacher Attendance</h3>
                <div>
                    <a href="<?php echo e(route('bss.teachers.index')); ?>" class="btn btn-warning btn-sm float-end">Go Back</a>
                </div>
            </div>

            <?php if($errors->any()): ?>
                <div class="alert alert-danger">
                    <ul>
                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><?php echo e($error); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            <?php endif; ?>

            <form action="<?php echo e(route('bss.teachers.attendence.store')); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered">
                            <thead>
                                <tr>
                                    <th>Teacher Name</th>
                                    <th>Attendance</th>
                                    <th>Review</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $teachers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $teacher): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <?php
                                        $attendance = $teacher->teacher_attandances->first();
                                    ?>
                                    <tr>
                                        <td>
                                            <?php echo e($teacher->name); ?>

                                            <input type="hidden" name="teacher_id[]" value="<?php echo e($teacher->id); ?>">
                                        </td>
                                        <td>
                                            <div class="d-flex align-items-center" style="gap: 5px;">
                                                <input type="radio" id="present-<?php echo e($teacher->id); ?>"
                                                    name="attendance[<?php echo e($teacher->id); ?>]" value="present"
                                                    <?php echo e(($attendance && $attendance->attendance_status === 'present') ?  'checked' : ''); ?>>
                                                <label for="present-<?php echo e($teacher->id); ?>">Present</label>

                                                <input type="radio" id="absent-<?php echo e($teacher->id); ?>"
                                                    name="attendance[<?php echo e($teacher->id); ?>]" value="absent"
                                                    <?php echo e($attendance && $attendance->attendance_status === 'absent' ? 'checked' : ''); ?>>
                                                <label for="absent-<?php echo e($teacher->id); ?>">Absent</label>

                                                <input type="radio" id="busy-<?php echo e($teacher->id); ?>"
                                                    name="attendance[<?php echo e($teacher->id); ?>]" value="busy"
                                                    <?php echo e($attendance && $attendance->attendance_status === 'busy' ? 'checked' : ''); ?>>
                                                <label for="busy-<?php echo e($teacher->id); ?>">Busy</label>
                                            </div>
                                        </td>

                                        <td>
                                            <textarea name="review[<?php echo e($teacher->id); ?>]" class="form-control" placeholder="Enter Review" rows="1"><?php echo e($attendance->review ?? ''); ?></textarea>
                                        </td>
                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td colspan="5" class="text-center">No records found</td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
                <div class="card-footer">
                    <div class="d-flex justify-content-end gap-1">
                        <a href="<?php echo e(route('bss.teachers.index')); ?>" class="btn btn-secondary btn-sm mr-1">Cancel</a>
                        <button type="submit" class="btn btn-primary btn-sm">Save Attendance</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\ngo_app_sj\resources\views/admin/bss/teacher/attendence/index.blade.php ENDPATH**/ ?>